class lTree {
  constructor() {
    this.camel = null;
    this.container = null;
  }

  setProps(newProps) {
    Object.assign(this, newProps);
  }

  getProp(prop) {
    return this[prop];
  }

  init(params) {
    this.setProps(params);
    this.render();
  }

  render() {
    const camel = this.camel;
    const $container = this.container;
    let id = 0;
    const cmpTreeData = camel.transformToTree();
    if ($container) {
      $container.treeview({
        data: cmpTreeData,
        levels: 2,
        selectedBackColor: "#f5f5f5",
        selectedColor: "#666",
      });

      // 默认展开树节点
      $container.treeview("expandNode", [id, { levels: 2, silent: true }]);
      this.bindEvent($container);
    }
    //console.log(cmpTreeData);
  }
  bindEvent(element) {
    const $elem = $(element);

    $elem.on("nodeSelected", function (event, data) {
      console.log("nodeSelected", data);
    });

    $elem.off("mousedown").on("mousedown", function (e) {
      // 添加元素到画布上
      console.log("mousedown", e.target);
    });

    $elem.on("mouseup", function (e) {
      // 重置画布上的元素
      console.log("mouseUp", e.target);
    });
  }
}
export default lTree;
