import { Api, Helper } from "../utility";
class PropsPanel {
  constructor() {
    this.container = null;
    this.camel = null;
    this.camelContext = null;
    this.api = new Api();
    this.helper = new Helper();
    this.rendering = false;
    this.propsDesc = []; //[{propName:'NAME',propType:'TEXT'...}]
    this.panel = document.getElementById("propsBoard");
    this.initComponent = null; // 用户对比uri的属性值
  }

  setProps(newProps) {
    Object.assign(this, newProps);
  }

  getProp(prop) {
    return this[prop];
  }

  init(params) {
    this.setProps(params);
    this.render();
  }

  bindEvent() {
    const camel = this.camel;
    const $container = $(this.container);
    const currToEdit = camel.getCurrToEdit();
    const that = this;

    $container.off("input change").on("input change", (e) => {
      const target = $(e.target);
      const key = target.attr("id");
      let prop = {};
      prop[key] = target.val();
      console.log(key, prop);
      if (currToEdit == null || currToEdit.scope == 'relation') {
        this.camelContext.setProps(prop);
      } else {
        currToEdit.setProps(prop);
        if (currToEdit.hasUri) {
          // 更新uri
          let uriValue = currToEdit.updateUri(this.initComponent, prop);
          currToEdit.setProps({ uri: uriValue });
          // 改变输入框的值
          document.getElementById("uri").value = uriValue;
        }
      }
      camel.repaint();
    });
  }

  unbindEvent() {
    this.initComponent = null;
    this.panel.removeEventListener("change", this.changeEvent, false);
  }

  async render() {
    let that = this;
    const camel = this.camel;
    const $container = $(this.container);
    const api = this.api;
    const helper = this.helper;

    let $html = "";

    if (camel) {
      const currToEdit = camel.getCurrToEdit();
      if (currToEdit == null || currToEdit.scope == 'relation') {
        // camelcontext模板
        $.when(
          api.getTemplete("editCamel-tmpl").done((tml) => {
            let camelData = {
              allowUseOriginalMessage: this.camelContext.allowUseOriginalMessage,
              delayer: this.camelContext.delayer,
              depends_on: this.camelContext.depends_on,
              errorHandlerRef: this.camelContext.errorHandlerRef,
              handleFault: this.camelContext.handleFault,
              name: this.camelContext.name,
              logExhaustedMessageBody: this.camelContext.logExhaustedMessageBody,
              loadTypeConverters: this.camelContext.loadTypeConverters,
              logExhaustedMessageBody: this.camelContext.logExhaustedMessageBody,
              logMask: this.camelContext.logMask,
              managementNamePattern: this.camelContext.managementNamePattern,
              registerEndpointIdsFromRoute: this.camelContext.registerEndpointIdsFromRoute,
              runtimeEndpointRegistryEnabled: this.camelContext.runtimeEndpointRegistryEnabled,
              shutdownEager: this.camelContext.shutdownEager,
              shutdownRoute: this.camelContext.shutdownRoute,
              shutdownRunningTask: this.camelContext.shutdownRunningTask,
              streamCache: this.camelContext.streamCache,
              threadNamepattern: this.camelContext.threadNamepattern,
              trace: this.camelContext.trace,
              typeConverterExists: this.camelContext.typeConverterExists,
              typeConverterExistsLoggingLevel: this.camelContext.typeConverterExistsLoggingLevel,
              typeConverterStatisticsEnabled: this.camelContext.typeConverterStatisticsEnabled,
              usebreadcrumb: this.camelContext.usebreadcrumb,
              useDataType: this.camelContext.useDataType,
            };
            $html = helper.handleTemplete(tml, camelData, "editCamel-tmpl");
            $container.html($html);
          })
        );
        // 更新camelcontext模板
        this.bindEvent();
      } else {
        this.propsDesc = currToEdit.getPropsDesc();
        this.initComponent = helper.handleInitData(currToEdit.scope);

        const destinationTypeOption = [
          { label: "", value: "" },
          { label: "队列", value: "queue" },
          { label: "主题", value: "topic" },
          { label: "临时队列", value: "temp-queue" },
          { label: "临时话题", value: "temp-topic" },
        ];
        const jmsMessageTypeOption = [
          { label: "", value: "" },
          { label: "字节", value: "bytes" },
          { label: "图", value: "map" },
          { label: "对象", value: "object" },
          { label: "流", value: "stream" },
          { label: "文本", value: "text" },
        ];
        const acknowledgementModeNameOption = [
          { label: "", value: "" },
          { label: "会话时段", value: "SESSION_TRANSACTED" },
          { label: "客户确认", value: "CLIENT_ACKNOWLEDGE" },
          { label: "自动确认", value: "AUTO_ACKNOWLEDGE" },
          { label: "允许副本的确认模式", value: "DUPS_OK_ACKNOWLEDGE" },
        ];
        const cacheLevelNameOption = [
          { label: "", value: "" },
          { label: "自动缓存", value: "CACHE_AUTO" },
          { label: "缓存连接", value: "CACHE_CONNECTION" },
          { label: "缓存消费", value: "CACHE_CONSUMER" },
          { label: "暂无缓存", value: "CACHE_NONE" },
          { label: "缓存会话", value: "CACHE_SESSION" },
        ];
        const consumerTypeOption = [
          { label: "", value: "" },
          { label: "简单", value: "Simple" },
          { label: "默认", value: "Default" },
          { label: "定制", value: "Custom" },
        ];
        const defaultTaskExecutorTypeOption = [
          { label: "", value: "" },
          { label: "线程池", value: "Threadpool" },
          { label: "简单同步", value: "Simpleasync" },
        ];

        const exchangePatternOption = [
          { label: "", value: "" },
          { label: "仅进入", value: "InOnly" },
          { label: "强制进入", value: "RobustInOnly" },
          { label: "进出", value: "InOut" },
          { label: "可选输出中", value: "InOptionalOut" },
          { label: "仅出", value: "OutOnly" },
          { label: "强制进出", value: "RobustInOutOnly" },
          { label: "出入", value: "OutIn" },
          { label: "出可选进", value: "OutOptionalIn" },
        ];

        const deliveryModeOption = [
          { label: "", value: "" },
          { label: "1", value: "1" },
          { label: "2", value: "2" },
        ];
        const priorityOption = [
          { label: "", value: "" },
          { label: "1", value: "1" },
          { label: "2", value: "2" },
          { label: "3", value: "3" },
          { label: "4", value: "4" },
          { label: "5", value: "5" },
          { label: "6", value: "6" },
          { label: "7", value: "7" },
          { label: "8", value: "8" },
          { label: "9", value: "9" },
        ];

        const replyToOverrideOption = [
          { label: "", value: "" },
          { label: "临时", value: "Temporary" },
          { label: "共享", value: "Shared" },
          { label: "私有", value: "Exclusives" },
        ];

        const errorHandlerLoggingLevelOption = [
          { label: "", value: "" },
          { label: "跟踪", value: "TRACE" },
          { label: "调试", value: "DEBUG" },
          { label: "信息", value: "INFO" },
          { label: "警告", value: "WARN" },
          { label: "错误", value: "ERROR" },
          { label: "离开", value: "OFF" },
        ];

        const initialDelayOption = [
          { label: "", value: "" },
          { label: "none", value: "none" },
          { label: "spring", value: "spring" },
          { label: "quartz2", value: "quartz2" },
        ];

        const timeUnitOption = [
          { label: "", value: "" },
          { label: "纳秒", value: "NANOSECONDS" },
          { label: "微秒", value: "MICROSECONDS" },
          { label: "秒", value: "SECONDS" },
          { label: "分钟", value: "MINUTES" },
          { label: "小时", value: "HOURS" },
          { label: "天", value: "DAYS" },
        ];

        const bindingStyleOption = [
          { label: "", value: "" },
          { label: "简单消费者", value: "SimpleConsumer" },
          { label: "默认", value: "Default" },
          { label: "顾客", value: "Custom" },
        ];

        const ationOption = [
          { label: "", value: "" },
          { label: "开始", value: "start" },
          { label: "停止", value: "stop" },
          { label: "暂停", value: "suspend" },
          { label: "恢复", value: "resume" },
          { label: "重新开始", value: "restart" },
          { label: "状态", value: "status" },
          { label: "统计资料", value: "stats" },
        ];

        const dataFormatOption = [
          { label: "", value: "" },
          { label: "播放量", value: "PLAYLOAD" },
          { label: "RAW", value: "RAW" },
          { label: "信息", value: "MESSAGE" },
          { label: "cxf信息", value: "CXF_MESSAGE" },
          { label: "POJO", value: "POJO" },
        ];

        const commandOption = [
          { label: "", value: "command" },
          { label: "route", value: "route" },
          { label: "languange", value: "languange" },
        ];
        const languangeOption = [
          { label: "", value: "language" },
          { label: "bean", value: "bean" },
          { label: "constant", value: "constant" },
          { label: "el", value: "el" },
          { label: "exchangeProperty", value: "exchangeProperty" },
          { label: "file", value: "file" },
          { label: "groovy", value: "groovy" },
          { label: "header", value: "header" },
          { label: "jsonpath", value: "jsonpath" },
          { label: "jxpath", value: "jxpath" },
          { label: "mvel", value: "mvel" },
          { label: "ognl", value: "ognl" },
          { label: "ref", value: "ref" },
          { label: "simple", value: "simple" },
        ];
        const readLockOption = [
          { label: "", value: "" },
          { label: "none", value: "none" },
          { label: "markerFile", value: "markerFile" },
          { label: "fileLock", value: "fileLock" },
          { label: "rename", value: "rename" },
          { label: "changed", value: "changed" },
          { label: "idempotent", value: "idempotent" },
          { label: "idempotent-change", value: "idempotent-change" },
          { label: "idempotent-rename", value: "idempotent-rename" },
        ];

        const outputTypeOption = [
          { label: "", value: "" },
          { label: "SelectOne", value: "SelectOne" },
          { label: "SelectList", value: "SelectList" },
          { label: "StreanList", value: "StreanList" },
        ];

        const fileExistOption = [
          { label: "", value: "" },
          { label: "Override", value: "Override" },
          { label: "Append", value: "Append" },
          { label: "Fail", value: "Fail" },
          { label: "Ignore", value: "Ignore" },
          { label: "Move", value: "Move" },
          { label: "TryRename", value: "TryRename" },
        ];
        const qualityOfServiceOption = [
          { label: "", value: "" },
          { label: "AtMostOnce", value: "AtMostOnce" },
          { label: "AtLeastOnce", value: "AtLeastOnce" },
          { label: "ExactlyOnce", value: "ExactlyOnce" },
        ];
        const willRetainOption = [
          { label: "", value: "" },
          { label: "AT_MOST_ONCE", value: "AT_MOST_ONCE" },
          { label: "AT_LEAST_ONCE", value: "AT_LEAST_ONCE" },
          { label: "EXACTLY_ONCE", value: "EXACTLY_ONCE" },
        ];
        const textlineDelimiterOption = [{ label: "", value: "" }];
        const delimiterOption = [
          { label: "", value: "" },
          { label: "LINE", value: "LINE" },
          { label: "NULL", value: "NULL" },
        ];
        const protocolOption = [
          { label: "", value: "" },
          { label: "tcp", value: "tcp" },
          { label: "udp", value: "udp" },
        ];

        const restletMethodOption = [
          { label: "", value: "" },
          { label: "ALL", value: "ALL" },
          { label: "CONNECT", value: "CONNECT" },
          { label: "DELETE", value: "DELETE" },
          { label: "GET", value: "GET" },
          { label: "HEAD", value: "HEAD" },
          { label: "OPTIONS", value: "OPTIONS" },
          { label: "PATCH", value: "PATCH" },
          { label: "POST", value: "POST" },
          { label: "PUT", value: "PUT" },
          { label: "TRACE", value: "TRACE" },
        ];
        const waitForTaskToCompleteOption = [
          { label: "", value: "" },
          { label: "Never", value: "Never" },
          { label: "ifReplyExpected", value: "ifReplyExpected" },
          { label: "Always", value: "Always" },
        ];

        const strictHostKeyCheckingOption = [
          { label: "no", value: "no" },
          { label: "yes", value: "yes" },
        ];

        const snmpVersionOption = [{ label: "", value: "" }];
        const typeOption = [{ label: "", value: "" }];
        const servletNameOption = [{ label: "", value: "" }];
        const securityLevelOption = [{ label: "", value: "" }];
        const resultsFormatOption = [{ label: "", value: "" }];
        const contentTypeOption = [{ label: "", value: "" }];
        const formatOption = [{ label: "", value: "" }];
        const notFoundBehaviourOption = [{ label: "", value: "" }];
        const notifyForOperationsOption = [{ label: "", value: "" }];
        const outputOption = [{ label: "", value: "" }];
        const saxonOption = [{ label: "", value: "" }];
        const operationNameOption = [{ label: "", value: "" }];
        const expressionOption = [
          { label: "constant", value: "constant" },
          { label: "el", value: "el" },
          { label: "exchangeProperty", value: "exchangeProperty" },
          { label: "groovy", value: "groovy" },
          { label: "header", value: "header" },
          { label: "javaScript", value: "javaScript" },
          { label: "jsonpath", value: "jsonpath" },
          { label: "jxpath", value: "jxpath" },
          { label: "language", value: "language" },
          { label: "method", value: "method" },
          { label: "mvel", value: "mvel" },
          { label: "ognl", value: "ognl" },
          { label: "php", value: "php" },
          { label: "python", value: "python" },
          { label: "ref", value: "ref" },
          { label: "ruby", value: "ruby" },
          { label: "simple", value: "simple" },
          { label: "spel", value: "spel" },
          { label: "sql", value: "sql" },
          { label: "terser", value: "terser" },
          { label: "tokenize", value: "tokenize" },
          { label: "xpath", value: "xpath" },
          { label: "xquery", value: "xquery" },
          { label: "xtokenize", value: "xtokenize" },
          { label: "vtdxml", value: "vtdxml" },
        ];
        const operationOption = [
          { label: "", value: "" },
          { label: "Get", value: "Get" },
          { label: "GetAndRemove", value: "GetAndRemove" },
          { label: "POP", value: "POP" },
          { label: "Push", value: "Push" },
          { label: "Set", value: "Set" },
        ];

        const completionModeOption = [
          { label: "AUTO", value: "AUTO" },
          { label: "MANUAL", value: "MANUAL" },
        ];
        const propagationOption = [
          { label: "", value: "" },
          { label: "MANDATORY", value: "MANDATORY" },
          { label: "NEVER", value: "NEVER" },
          { label: "NOT_SUPPORTED", value: "NOT_SUPPORTED" },
          { label: "REQUIRED", value: "REQUIRED" },
          { label: "REQUIRES_NEW", value: "REQUIRES_NEW" },
          { label: "SUPPORTS", value: "SUPPORTS" },
        ];
        const patternOption = [{ label: "", value: "" }];
        const modeOption = [{ label: "", value: "" }];
        const retryWhileOption = [{ label: "", value: "" }];
        const unitsOption = [{ label: "", value: "" }];
        const rejectedPolicyOption = [{ label: "", value: "" }];

        if (this.rendering == false) {
          this.rendering = true;
          // 清空上一次的值
          this.panel.innerHTML = "";
          // 最外侧div
          let div = document.createElement("DIV");
          div.setAttribute("class", "panel panel-info h100");
          // 上方标题
          let baseTitle = document.createElement("DIV");
          let basetxt = document.createTextNode(currToEdit.scope);
          baseTitle.setAttribute("class", "panel-heading");
          baseTitle.appendChild(basetxt);
          div.appendChild(baseTitle);

          // 左侧的tab标签
          let lDiv = document.createElement("UL");
          lDiv.setAttribute("class", "col-xs-2 lTab nav nav-tabs nav-pills");

          // 右侧tab
          let rDiv = document.createElement("DIV");
          rDiv.setAttribute("class", "rTab tab-content col-xs-22");

          // 右侧高级嵌套的tab和内容
          let rDivTab = document.createElement("UL");
          rDivTab.setAttribute("class", "nav nav-tabs");
          let rDivTabContent = document.createElement("DIV");
          rDivTabContent.setAttribute("class", "rTabContent tab-content");

          for (let propPart in this.propsDesc) {
            switch (propPart) {
              case "details":
                // 左侧tab标签
                let detailTitle = document.createElement("LI");
                detailTitle.setAttribute("class", "active w100 tc");
                let aDetail = document.createElement("A");
                let atxt = document.createTextNode("详情");
                aDetail.setAttribute("href", "#details");
                aDetail.setAttribute("data-toggle", "tab");
                aDetail.appendChild(atxt);
                detailTitle.appendChild(aDetail);
                lDiv.appendChild(detailTitle);

                // 右侧属性面板的值
                let firstCon = document.createElement("DIV");

                for (let i = 0; i < that.propsDesc[propPart].length; i++) {
                  let propName = that.propsDesc[propPart][i];
                  let chinaName = null;
                  let span = document.createElement("p");
                  let html = "";
                  switch (propName) {
                    case "afterUri":
                      chinaName = "在Uri之后";
                      html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                      break;
                    case "afterFinallyUri":
                      chinaName = "在FinalUri之后";
                      html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                      break;
                    case "aggregateControllerRef":
                      chinaName = "聚合控制器参考";
                      html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                      break;
                    case "aggregateOnException":
                      chinaName = "异常汇总";
                      html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                      break;
                    case "aggregationRepositoryRef":
                      chinaName = "聚合存储库参考";
                      html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                      break;
                    case "allowCoreThreadTimeOut":
                      chinaName = "允许核心线程超时";
                      html += `<label class="w80">${chinaName}</label>`;
                      if (currToEdit[propName] == true) {
                        html += `<input name='${propName}' type='checkbox' checked/>`;
                      } else {
                        html += `<input name='${propName}' type='checkbox' />`;
                      }
                      break;
                    case "allowOptimisedComponents":
                      chinaName = "允许优化组件";
                      html += `<label class="w80">${chinaName}</label>`;
                      if (currToEdit[propName] == true) {
                        html += `<input name='${propName}' type='checkbox' checked/>`;
                      } else {
                        html += `<input name='${propName}' type='checkbox' />`;
                      }
                      break;
                    case "asyncDelayed":
                      chinaName = "异步延迟";
                      html += `<label class="w80">${chinaName}</label>`;
                      if (currToEdit[propName] == true) {
                        html += `<input name='${propName}' type='checkbox' checked/>`;
                      } else {
                        html += `<input name='${propName}' type='checkbox' />`;
                      }
                      break;
                    case "autoStartup":
                      chinaName = "自动登录";
                      html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                      break;
                    case "beanType":
                      chinaName = "公共类";
                      html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                      break;
                    case "beforeUri":
                      chinaName = "在Uri之前";
                      html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                      break;
                    case "body":
                      chinaName = "身体";
                      html += `<label class="w80">${chinaName}</label><select name='${propName}' class="form-control w400 inlineBlock">`;
                      expressionOption.forEach((el) => {
                        if (el.value == currToEdit[propName]) {
                          html += `<option value='${el.value}' selected>${el.label}</option>`;
                        } else {
                          html += `<option value='${el.value}'>${el.label}</option>`;
                        }
                      });
                      break;
                    case "cache":
                      chinaName = "内存";
                      html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                      break;
                    case "cacheSize":
                      chinaName = "内存大小";
                      html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" type="number" id='${propName}' value='${currToEdit[propName]}'>`;
                      break;
                    case "callerRunsWhenRejected":
                      chinaName = "呼叫者被拒绝时运行";
                      html += `<label class="w80">${chinaName}</label>`;
                      if (currToEdit[propName] == true) {
                        html += `<input name='${propName}' type='checkbox' checked/>`;
                      } else {
                        html += `<input name='${propName}' type='checkbox' />`;
                      }
                      break;
                    case "charset":
                      chinaName = "字符集";
                      html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                      break;
                    case "closeCorrelationKeyOnCompletion":
                      chinaName = "close完成时的相关键";
                      html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                      break;
                    case "comparatorRef":
                      chinaName = "比较器Ref";
                      html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                      break;
                    case "completeAllOnStop":
                      chinaName = "完成所有停止";
                      html += `<label class="w80">${chinaName}</label>`;
                      if (currToEdit[propName] == true) {
                        html += `<input name='${propName}' type='checkbox' checked/>`;
                      } else {
                        html += `<input name='${propName}' type='checkbox' />`;
                      }
                      break;
                    case "completionEager":
                      chinaName = "渴望完成";
                      html += `<label class="w80">${chinaName}</label>`;
                      if (currToEdit[propName] == true) {
                        html += `<input name='${propName}' type='checkbox' checked/>`;
                      } else {
                        html += `<input name='${propName}' type='checkbox' />`;
                      }
                      break;
                    case "completionFromBatchConsumer":
                      chinaName = "来自批处理用户的完成";
                      html += `<label class="w80">${chinaName}</label>`;
                      if (currToEdit[propName] == true) {
                        html += `<input name='${propName}' type='checkbox' checked/>`;
                      } else {
                        html += `<input name='${propName}' type='checkbox' />`;
                      }
                      break;
                    case "completionInterval":
                      chinaName = "完成时间间隔";
                      html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" type="number" id='${propName}' value='${currToEdit[propName]}'>`;
                      break;
                    case "completionMode":
                      chinaName = "完成时间间隔";
                      html += `<label class="w80">${chinaName}</label><select name='${propName}' class="form-control w400 inlineBlock">`;
                      completionModeOption.forEach((el) => {
                        if (el.value == currToEdit[propName]) {
                          html += `<option value='${el.value}' selected>${el.label}</option>`;
                        } else {
                          html += `<option value='${el.value}'>${el.label}</option>`;
                        }
                      });
                      break;
                    case "completionOnNewCorrelationGroup":
                      chinaName = "新关联组的完成";
                      html += `<label class="w80">${chinaName}</label>`;
                      if (currToEdit[propName] == true) {
                        html += `<input name='${propName}' type='checkbox' checked/>`;
                      } else {
                        html += `<input name='${propName}' type='checkbox' />`;
                      }
                      break;
                    case "completionSize":
                      chinaName = "完成大小";
                      html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" type="number" id='${propName}' value='${currToEdit[propName]}'>`;
                      break;
                    case "completionPredicate":
                      chinaName = "完成谓词";
                      html += `<label class="w80">${chinaName}</label><select name='${propName}' class="form-control w400 inlineBlock">`;
                      expressionOption.forEach((el) => {
                        if (el.value == currToEdit[propName]) {
                          html += `<option value='${el.value}' selected>${el.label}</option>`;
                        } else {
                          html += `<option value='${el.value}'>${el.label}</option>`;
                        }
                      });
                      break;
                    case "completionTimeout":
                      chinaName = "完成超时";
                      html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" type="number" id='${propName}' value='${currToEdit[propName]}'>`;
                      break;
                    case "continued":
                      chinaName = "继续";
                      html += `<label class="w80">${chinaName}</label><select name='${propName}' class="form-control w400 inlineBlock">`;
                      expressionOption.forEach((el) => {
                        if (el.value == currToEdit[propName]) {
                          html += `<option value='${el.value}' selected>${el.label}</option>`;
                        } else {
                          html += `<option value='${el.value}'>${el.label}</option>`;
                        }
                      });
                      break;
                    case "correlationExpression":
                      chinaName = "相关表达式";
                      html += `<label class="w80">${chinaName}</label><select name='${propName}' class="form-control w400 inlineBlock">`;
                      expressionOption.forEach((el) => {
                        if (el.value == currToEdit[propName]) {
                          html += `<option value='${el.value}' selected>${el.label}</option>`;
                        } else {
                          html += `<option value='${el.value}'>${el.label}</option>`;
                        }
                      });
                      break;
                    case "copy":
                      chinaName = "复制";
                      html += `<label class="w80">${chinaName}</label>`;
                      if (currToEdit[propName] == true) {
                        html += `<input name='${propName}' type='checkbox' checked/>`;
                      } else {
                        html += `<input name='${propName}' type='checkbox' />`;
                      }
                      break;
                    case "dataFormatType":
                      chinaName = "数据格式类型";
                      html += `<label class="w80">${chinaName}</label><select name='${propName}' class="form-control w400 inlineBlock">`;
                      expressionOption.forEach((el) => {
                        if (el.value == currToEdit[propName]) {
                          html += `<option value='${el.value}' selected>${el.label}</option>`;
                        } else {
                          html += `<option value='${el.value}'>${el.label}</option>`;
                        }
                      });
                      break;
                    case "delayer":
                      chinaName = "延迟器";
                      html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                      break;
                    case "delimiter":
                      chinaName = "定界符";
                      html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                      break;
                    case "description":
                      chinaName = "描述";
                      html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                      break;
                    case "discardOnCompletionTimeout":
                      chinaName = "完成时丢弃超时";
                      html += `<label class="w80">${chinaName}</label>`;
                      if (currToEdit[propName] == true) {
                        html += `<input name='${propName}' type='checkbox' checked/>`;
                      } else {
                        html += `<input name='${propName}' type='checkbox' />`;
                      }
                      break;
                    case "doWhile":
                      chinaName = "同时";
                      html += `<label class="w80">${chinaName}</label>`;
                      if (currToEdit[propName] == true) {
                        html += `<input name='${propName}' type='checkbox' checked/>`;
                      } else {
                        html += `<input name='${propName}' type='checkbox' />`;
                      }
                      break;
                    case "dynamicUri":
                      chinaName = "动态Uri";
                      html += `<label class="w80">${chinaName}</label>`;
                      if (currToEdit[propName] == true) {
                        html += `<input name='${propName}' type='checkbox' checked/>`;
                      } else {
                        html += `<input name='${propName}' type='checkbox' />`;
                      }
                      break;
                    case "eager":
                      chinaName = "渴望";
                      html += `<label class="w80">${chinaName}</label>`;
                      if (currToEdit[propName] == true) {
                        html += `<input name='${propName}' type='checkbox' checked/>`;
                      } else {
                        html += `<input name='${propName}' type='checkbox' />`;
                      }
                      break;
                    case "eagerCheckCompletion":
                      chinaName = "渴望检查完成";
                      html += `<label class="w80">${chinaName}</label>`;
                      if (currToEdit[propName] == true) {
                        html += `<input name='${propName}' type='checkbox' checked/>`;
                      } else {
                        html += `<input name='${propName}' type='checkbox' />`;
                      }
                      break;
                    case "exception":
                      chinaName = "例外";
                      html += `<label class="w80">${chinaName}</label><textarea class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                      break;
                    case "exceptionType":
                      chinaName = "异常类型";
                      html += `<label class="w80">${chinaName}</label><textarea class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                      break;
                    case "expression":
                      chinaName = "表达式";
                      html += `<label class="w80">${chinaName}</label><select name='${propName}' class="form-control w400 inlineBlock">`;
                      expressionOption.forEach((el) => {
                        if (el.value == currToEdit[propName]) {
                          html += `<option value='${el.value}' selected>${el.label}</option>`;
                        } else {
                          html += `<option value='${el.value}'>${el.label}</option>`;
                        }
                      });
                      break;
                    case "errorHandlerRef":
                      chinaName = "错误处理程序参考";
                      html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                      break;
                    case "executorServiceRef":
                      chinaName = "执行人服务编号";
                      html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                      break;
                    case "excludePattern":
                      chinaName = "排除模式";
                      html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                      break;
                    case "fallbackViaNetwork":
                      chinaName = "通过网络回退";
                      html += `<label class="w80">${chinaName}</label>`;
                      if (currToEdit[propName] == true) {
                        html += `<input name='${propName}' type='checkbox' checked/>`;
                      } else {
                        html += `<input name='${propName}' type='checkbox' />`;
                      }
                      break;
                    case "filter":
                      chinaName = "过滤";
                      html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                      break;
                    case "forceCompletionOnStop":
                      chinaName = "停止时强制完成";
                      html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                      break;
                    case "group":
                      chinaName = "团体";
                      html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                      break;
                    case "groupExchanges":
                      chinaName = "团体交流";
                      html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                      break;
                    case "handled":
                      chinaName = "处理";
                      html += `<label class="w80">${chinaName}</label><select name='${propName}' class="form-control w400 inlineBlock">`;
                      expressionOption.forEach((el) => {
                        if (el.value == currToEdit[propName]) {
                          html += `<option value='${el.value}' selected>${el.label}</option>`;
                        } else {
                          html += `<option value='${el.value}'>${el.label}</option>`;
                        }
                      });
                      break;
                    case "headerName":
                      chinaName = "标头名称";
                      html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                      break;
                    case "hystrixConfigurationRef":
                      chinaName = "hystrix配置参考";
                      html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                      break;
                    case "id":
                      chinaName = "ID";
                      html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                      break;
                    case "inheritErrorHandler":
                      chinaName = "继承错误处理程序";
                      html += `<label class="w80">${chinaName}</label>`;
                      if (currToEdit[propName] == true) {
                        html += `<input name='${propName}' type='checkbox' checked/>`;
                      } else {
                        html += `<input name='${propName}' type='checkbox' />`;
                      }
                      break;
                    case "ignoreInvalidEndpoint":
                      chinaName = "忽略无效的端点";
                      html += `<label class="w80">${chinaName}</label>`;
                      if (currToEdit[propName] == true) {
                        html += `<input name='${propName}' type='checkbox' checked/>`;
                      } else {
                        html += `<input name='${propName}' type='checkbox' />`;
                      }
                      break;
                    case "ignoreInvalidEndpoints":
                      chinaName = "忽略无效的端点";
                      html += `<label class="w80">${chinaName}</label>`;
                      if (currToEdit[propName] == true) {
                        html += `<input name='${propName}' type='checkbox' checked/>`;
                      } else {
                        html += `<input name='${propName}' type='checkbox' />`;
                      }
                      break;
                    case "ignoreInvalidCorrelationKeys":
                      chinaName = "忽略无效的关联密钥";
                      html += `<label class="w80">${chinaName}</label>`;
                      if (currToEdit[propName] == true) {
                        html += `<input name='${propName}' type='checkbox' checked/>`;
                      } else {
                        html += `<input name='${propName}' type='checkbox' />`;
                      }
                      break;
                    case "keepAliveTime":
                      chinaName = "保持时间";
                      html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" type="number" id='${propName}' value='${currToEdit[propName]}'>`;
                      break;
                    case "key":
                      chinaName = "键";
                      html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                      break;
                    case "logMask":
                      chinaName = "日志掩码";
                      html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                      break;
                    case "logName":
                      chinaName = "日志名称";
                      html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                      break;
                    case "loggerRef":
                      chinaName = "记录器参考";
                      html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                      break;
                    case "loggingLevel":
                      chinaName = "日志级别";
                      html += `<label class="w80">${chinaName}</label><select name='${propName}' class="form-control w400 inlineBlock">`;
                      errorHandlerLoggingLevelOption.forEach((el) => {
                        if (el.value == currToEdit[propName]) {
                          html += `<option value='${el.value}' selected>${el.label}</option>`;
                        } else {
                          html += `<option value='${el.value}'>${el.label}</option>`;
                        }
                      });
                      break;
                    case "marker":
                      chinaName = "记号";
                      html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                      break;
                    case "markRollbackOnly":
                      chinaName = "标记仅回滚";
                      html += `<label class="w80">${chinaName}</label>`;
                      if (currToEdit[propName] == true) {
                        html += `<input name='${propName}' type='checkbox' checked/>`;
                      } else {
                        html += `<input name='${propName}' type='checkbox' />`;
                      }
                      break;
                    case "markRollbackOnlyLast":
                      chinaName = "标记仅回滚最后一次";
                      html += `<label class="w80">${chinaName}</label>`;
                      if (currToEdit[propName] == true) {
                        html += `<input name='${propName}' type='checkbox' checked/>`;
                      } else {
                        html += `<input name='${propName}' type='checkbox' />`;
                      }
                      break;
                    case "maxPoolSize":
                      chinaName = "最大池大小";
                      html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" type="number" id='${propName}' value='${currToEdit[propName]}'>`;
                      break;
                    case "maxQueueSize":
                      chinaName = "最大队列大小";
                      html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" type="number" id='${propName}' value='${currToEdit[propName]}'>`;
                      break;
                    case "method":
                      chinaName = "方法";
                      html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                      break;
                    case "message":
                      chinaName = "消息";
                      html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                      break;
                    case "messageFrequency":
                      chinaName = "讯息频率";
                      html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                      break;
                    case "messageIdRepositoryRef":
                      chinaName = "消息ID存储库参考";
                      html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                      break;
                    case "messageHistory":
                      chinaName = "讯息记录";
                      html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                      break;
                    case "mode":
                      chinaName = "模式";
                      html += `<label class="w80">${chinaName}</label><select name='${propName}' class="form-control w400 inlineBlock">`;
                      modeOption.forEach((el) => {
                        if (el.value == currToEdit[propName]) {
                          html += `<option value='${el.value}' selected>${el.label}</option>`;
                        } else {
                          html += `<option value='${el.value}'>${el.label}</option>`;
                        }
                      });
                      break;
                    case "multiParameterArray":
                      chinaName = "多参数数组";
                      html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                      break;
                    case "onCompleteOnly":
                      chinaName = "仅在完成时";
                      html += `<label class="w80">${chinaName}</label>`;
                      if (currToEdit[propName] == true) {
                        html += `<input name='${propName}' type='checkbox' checked/>`;
                      } else {
                        html += `<input name='${propName}' type='checkbox' />`;
                      }
                      break;
                    case "onExceptionOccurredRef":
                      chinaName = "关于发生异常引用";
                      html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                      break;
                    case "onFailureOnly":
                      chinaName = "仅在失败时";
                      html += `<label class="w80">${chinaName}</label>`;
                      if (currToEdit[propName] == true) {
                        html += `<input name='${propName}' type='checkbox' checked/>`;
                      } else {
                        html += `<input name='${propName}' type='checkbox' />`;
                      }
                      break;
                    case "onRedeliveryRef":
                      chinaName = "在重新交付参考上";
                      html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                      break;
                    case "onPrepareRef":
                      chinaName = "关于准备参考";
                      html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                      break;
                    case "operation":
                      chinaName = "作业";
                      html += `<label class="w80">${chinaName}</label><select name='${propName}' class="form-control w400 inlineBlock">`;
                      operationOption.forEach((el) => {
                        if (el.value == currToEdit[propName]) {
                          html += `<option value='${el.value}' selected>${el.label}</option>`;
                        } else {
                          html += `<option value='${el.value}'>${el.label}</option>`;
                        }
                      });
                      break;
                    case "optimisticLocking":
                      chinaName = "乐观锁定";
                      html += `<label class="w80">${chinaName}</label>`;
                      if (currToEdit[propName] == true) {
                        html += `<input name='${propName}' type='checkbox' checked/>`;
                      } else {
                        html += `<input name='${propName}' type='checkbox' />`;
                      }
                      break;
                    case "pattern":
                      chinaName = "图案";
                      html += `<label class="w80">${chinaName}</label><select name='${propName}' class="form-control w400 inlineBlock">`;
                      patternOption.forEach((el) => {
                        if (el.value == currToEdit[propName]) {
                          html += `<option value='${el.value}' selected>${el.label}</option>`;
                        } else {
                          html += `<option value='${el.value}'>${el.label}</option>`;
                        }
                      });
                      break;
                    case "parallelAggregate":
                      chinaName = "并行聚合";
                      html += `<label class="w80">${chinaName}</label>`;
                      if (currToEdit[propName] == true) {
                        html += `<input name='${propName}' type='checkbox' checked/>`;
                      } else {
                        html += `<input name='${propName}' type='checkbox' />`;
                      }
                      break;
                    case "parallelProcessing":
                      chinaName = "并行处理";
                      html += `<label class="w80">${chinaName}</label>`;
                      if (currToEdit[propName] == true) {
                        html += `<input name='${propName}' type='checkbox' checked/>`;
                      } else {
                        html += `<input name='${propName}' type='checkbox' />`;
                      }
                      break;
                    case "poolSize":
                      chinaName = "池大小";
                      html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" type="number" id='${propName}' value='${currToEdit[propName]}'>`;
                      break;
                    case "processorRef":
                      chinaName = "处理器参考";
                      html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                      break;
                    case "propagation":
                      chinaName = "传播";
                      html += `<label class="w80">${chinaName}</label><select name='${propName}' class="form-control w400 inlineBlock">`;
                      propagationOption.forEach((el) => {
                        if (el.value == currToEdit[propName]) {
                          html += `<option value='${el.value}' selected>${el.label}</option>`;
                        } else {
                          html += `<option value='${el.value}'>${el.label}</option>`;
                        }
                      });
                      break;
                    case "propertyName":
                      chinaName = "物业名称";
                      html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                      break;
                    case "ref":
                      chinaName = "Ref";
                      html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                      break;
                    case "redeliveryPolicyRef":
                      chinaName = "重新交付政策参考";
                      html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                      break;
                    case "rejectedPolicy":
                      chinaName = "被拒绝的政策";
                      html += `<label class="w80">${chinaName}</label><select name='${propName}' class="form-control w400 inlineBlock">`;
                      rejectedPolicyOption.forEach((el) => {
                        if (el.value == currToEdit[propName]) {
                          html += `<option value='${el.value}' selected>${el.label}</option>`;
                        } else {
                          html += `<option value='${el.value}'>${el.label}</option>`;
                        }
                      });
                      break;
                    case "ref_deprecated":
                      chinaName = "Ref(已弃用)";
                      html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                      break;
                    case "removeOnFailure":
                      chinaName = "失败时删除";
                      html += `<label class="w80">${chinaName}</label>`;
                      if (currToEdit[propName] == true) {
                        html += `<input name='${propName}' type='checkbox' checked/>`;
                      } else {
                        html += `<input name='${propName}' type='checkbox' />`;
                      }
                      break;
                    case "retryWhile":
                      chinaName = "重试";
                      html += `<label class="w80">${chinaName}</label><select name='${propName}' class="form-control w400 inlineBlock">`;
                      retryWhileOption.forEach((el) => {
                        if (el.value == currToEdit[propName]) {
                          html += `<option value='${el.value}' selected>${el.label}</option>`;
                        } else {
                          html += `<option value='${el.value}'>${el.label}</option>`;
                        }
                      });
                      break;
                    case "routePolicyRef":
                      chinaName = "路由策略参考";
                      html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                      break;
                    case "samplePeriod":
                      chinaName = "采样期";
                      html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                      break;
                    case "shareUnitOfWork":
                      chinaName = "共享工作单元";
                      html += `<label class="w80">${chinaName}</label>`;
                      if (currToEdit[propName] == true) {
                        html += `<input name='${propName}' type='checkbox' checked/>`;
                      } else {
                        html += `<input name='${propName}' type='checkbox' />`;
                      }
                      break;
                    case "shutdownRoute":
                      chinaName = "关机路线";
                      html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                      break;
                    case "shutdownRunningTask":
                      chinaName = "关机运行任务";
                      html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                      break;
                    case "skipDuplicate":
                      chinaName = "跳过重复";
                      html += `<label class="w80">${chinaName}</label>`;
                      if (currToEdit[propName] == true) {
                        html += `<input name='${propName}' type='checkbox' checked/>`;
                      } else {
                        html += `<input name='${propName}' type='checkbox' />`;
                      }
                      break;
                    case "skipSendToOriginalEndpoint":
                      chinaName = "跳过发送到原始端点";
                      html += `<label class="w80">${chinaName}</label>`;
                      if (currToEdit[propName] == true) {
                        html += `<input name='${propName}' type='checkbox' checked/>`;
                      } else {
                        html += `<input name='${propName}' type='checkbox' />`;
                      }
                      break;
                    case "startupOrder":
                      chinaName = "启动顺序";
                      html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                      break;
                    case "stopOnAggregateException":
                      chinaName = "在发生聚合异常时停止";
                      html += `<label class="w80">${chinaName}</label>`;
                      if (currToEdit[propName] == true) {
                        html += `<input name='${propName}' type='checkbox' checked/>`;
                      } else {
                        html += `<input name='${propName}' type='checkbox' />`;
                      }
                      break;
                    case "stopOnException":
                      chinaName = "异常停止";
                      html += `<label class="w80">${chinaName}</label>`;
                      if (currToEdit[propName] == true) {
                        html += `<input name='${propName}' type='checkbox' checked/>`;
                      } else {
                        html += `<input name='${propName}' type='checkbox' />`;
                      }
                      break;
                    case "strategyMethodAllowNull":
                      chinaName = "策略方法允许为空";
                      html += `<label class="w80">${chinaName}</label>`;
                      if (currToEdit[propName] == true) {
                        html += `<input name='${propName}' type='checkbox' checked/>`;
                      } else {
                        html += `<input name='${propName}' type='checkbox' />`;
                      }
                      break;
                    case "strategyMethodName":
                      chinaName = "策略方法名称";
                      html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                      break;
                    case "strategyRef":
                      chinaName = "策略参考";
                      html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                      break;
                    case "streamCache":
                      chinaName = "流缓存";
                      html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                      break;
                    case "streaming":
                      chinaName = "流媒体";
                      html += `<label class="w80">${chinaName}</label>`;
                      if (currToEdit[propName] == true) {
                        html += `<input name='${propName}' type='checkbox' checked/>`;
                      } else {
                        html += `<input name='${propName}' type='checkbox' />`;
                      }
                      break;
                    case "threadName":
                      chinaName = "线程名";
                      html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                      break;
                    case "timeout":
                      chinaName = "暂停";
                      html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" type="number" id='${propName}' value='${currToEdit[propName]}'>`;
                      break;
                    case "timeoutCheckerExecutorServiceRef":
                      chinaName = "超时检查器执行器服务参考";
                      html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                      break;
                    case "timeoutInMilliseconds":
                      chinaName = "超时(以毫秒为单位)";
                      html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                      break;
                    case "timeUnit":
                      chinaName = "时间单位";
                      html += `<label class="w80">${chinaName}</label><select name='${propName}' class="form-control w400 inlineBlock">`;
                      timeUnitOption.forEach((el) => {
                        if (el.value == currToEdit[propName]) {
                          html += `<option value='${el.value}' selected>${el.label}</option>`;
                        } else {
                          html += `<option value='${el.value}'>${el.label}</option>`;
                        }
                      });
                      break;
                    case "trace":
                      chinaName = "痕迹";
                      html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                      break;
                    case "type":
                      chinaName = "类型";
                      html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                      break;
                    case "units":
                      chinaName = "单位";
                      html += `<label class="w80">${chinaName}</label><select name='${propName}' class="form-control w400 inlineBlock">`;
                      unitsOption.forEach((el) => {
                        if (el.value == currToEdit[propName]) {
                          html += `<option value='${el.value}' selected>${el.label}</option>`;
                        } else {
                          html += `<option value='${el.value}'>${el.label}</option>`;
                        }
                      });
                      break;
                    case "uri":
                      chinaName = "URI";
                      html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                      break;
                    case "uri分隔符":
                      chinaName = "URI";
                      html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                      break;
                    case "useOriginalMessage":
                      chinaName = "使用原始消息";
                      html += `<label class="w80">${chinaName}</label>`;
                      if (currToEdit[propName] == true) {
                        html += `<input name='${propName}' type='checkbox' checked/>`;
                      } else {
                        html += `<input name='${propName}' type='checkbox' />`;
                      }
                      break;
                    default:
                      break;
                  }
                  span.innerHTML = html;
                  firstCon.appendChild(span);
                }

                // 将细节内容添加到rdiv中
                firstCon.setAttribute("id", "details");
                firstCon.setAttribute("class", "tab-pane pt10 active");
                rDiv.appendChild(firstCon);
                break;
              case "documentation":
                let documentationTitle = document.createElement("LI");
                documentationTitle.setAttribute("class", "w100 tc");
                let aDocumentation = document.createElement("A");
                let atxt2 = document.createTextNode("描述");
                aDocumentation.setAttribute("href", "#documentation");
                aDocumentation.setAttribute("data-toggle", "tab");
                aDocumentation.appendChild(atxt2);
                documentationTitle.appendChild(aDocumentation);
                lDiv.appendChild(documentationTitle);

                // 右侧属性面板的值
                let secondCon = document.createElement("DIV");
                secondCon.innerHTML = that.propsDesc[propPart];
                secondCon.setAttribute("id", "documentation");
                secondCon.setAttribute("class", "tab-pane");
                rDiv.appendChild(secondCon);
                break;
              case "advanced":
                let advance = that.creatTab("advancedTitle", "advanced", "advanced_txt", "高级", "advanced");
                advance.setAttribute("class", "w100 tc");
                lDiv.appendChild(advance);

                // 右侧属性面板的值
                let thirdCon = that.createTabContent("thirdCon", "advanced", "tab-pane");

                for (let advancedItem in that.propsDesc[propPart]) {
                  switch (advancedItem) {
                    case "security":
                      let sec = that.creatTab("secTitle", "security", "sec_txt", "安全", "security");
                      rDivTab.appendChild(sec);

                      // 右侧属性面板的值
                      let secCon = that.createTabContent("secCon", "security", "tab-pane pt10");

                      for (let i = 0; i < that.propsDesc[propPart][advancedItem].length; i++) {
                        let propName = that.propsDesc[propPart][advancedItem][i];
                        let chinaName = null;
                        let p = document.createElement("p");
                        let html = "";
                        switch (propName) {
                          case "account":
                            chinaName = "账户";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "autoStartTls":
                            chinaName = "自动启动";
                            html += `<label class="w80">${chinaName}</label>`;
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          case "authenticationPassphrase":
                            chinaName = "认证密码";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "authenticationProtocol":
                            chinaName = "身份验证协议";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "ciphers":
                            chinaName = "密码";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "disableSecureDataChannelDefaults":
                            chinaName = "禁用安全数据通道默认值";
                            html += `<label class="w80">${chinaName}</label>`;
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          case "dummyTrustManager":
                            chinaName = "虚拟信托管理";
                            html += `<label class="w80">${chinaName}</label>`;
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          case "enabledProtocols":
                            chinaName = "启用的协议";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "execPbsz":
                            chinaName = "高管Pbsz";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" type="number" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "execProt":
                            chinaName = "执行Prot";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "ftpClientKeyStoreParameters":
                            chinaName = "ftp客户端密钥存储参数";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "ftpClientTrustStoreParameters":
                            chinaName = "ftp客户端信任库参数";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "isImplicit":
                            chinaName = "是否隐式";
                            html += `<label class="w80">${chinaName}</label>`;
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          case "keyPair":
                            chinaName = "密钥对";
                            html += `<label class="w80">${chinaName}</label><input name='${propName}' type='file' checked/>`;
                            break;
                          case "keyStoreFile":
                            chinaName = "密钥存储文件";
                            html += `<label class="w80">${chinaName}</label><input name='${propName}' type='file' checked/>`;
                            break;
                          case "keyStoreFormat":
                            chinaName = "密钥库格式";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "keyStoreResource":
                            chinaName = "密钥库资源";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "knownHosts":
                            chinaName = "已知主机";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "knownHostsFile":
                            chinaName = "已知主机文件";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "knownHostsUri":
                            chinaName = "已知主机Uri";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "needClientAuth":
                            chinaName = "需要客户端验证";
                            html += `<label class="w80">${chinaName}</label>`;
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          case "passphrase":
                            chinaName = "密码短语";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "password":
                            chinaName = "密码";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "preferredAuthentications":
                            chinaName = "首选身份验证";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "privacyPassphrase":
                            chinaName = "隐私密码";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "privacyProtocol":
                            chinaName = "隐私协议";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "privateKey":
                            chinaName = "私钥";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "privateKeyFile":
                            chinaName = "私钥文件";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "privateKeyPassphrase":
                            chinaName = "私钥密码";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "privateKeyUri":
                            chinaName = "私钥Uri";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "securityConfiguration":
                            chinaName = "安全配置";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "securityLevel":
                            chinaName = "安全级别";
                            html += `<label class="w80">${chinaName}</label><select name='${propName}' class="form-control w400 inlineBlock">`;
                            securityLevelOption.forEach((el) => {
                              if (el.value == currToEdit[propName]) {
                                html += `<option value='${el.value}' selected>${el.label}</option>`;
                              } else {
                                html += `<option value='${el.value}'>${el.label}</option>`;
                              }
                            });
                            break;
                          case "securityName":
                            chinaName = "证券名称";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "securityOptions":
                            chinaName = "安全选项";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "securityProvider":
                            chinaName = "安全提供者";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "securityProtocol":
                            chinaName = "安全协议";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "ssl":
                            chinaName = "ssl";
                            html += `<label class="w80">${chinaName}</label>`;
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          case "sslClientCertHeaders":
                            chinaName = "ssl客户端证书标题";
                            html += `<label class="w80">${chinaName}</label>`;
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          case "sslContextParameters":
                            chinaName = "ssl上下文参数";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "sslHandler":
                            chinaName = "ssl处理程序";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "strictHostKeyChecking":
                            chinaName = "严格的主机密钥检查";
                            html += `<label class="w80">${chinaName}</label><select name='${propName}' class="form-control w400 inlineBlock">`;
                            strictHostKeyCheckingOption.forEach((el) => {
                              if (el.value == currToEdit[propName]) {
                                html += `<option value='${el.value}' selected>${el.label}</option>`;
                              } else {
                                html += `<option value='${el.value}'>${el.label}</option>`;
                              }
                            });
                            break;
                          case "trustStoreFile":
                            chinaName = "信任存储文件";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" type="file" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "trustStoreResource":
                            chinaName = "信任商店资源";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "useUserKnownHostsFile":
                            chinaName = "使用用户已知的主机文件";
                            html += `<label class="w80">${chinaName}</label>`;
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          case "username":
                            chinaName = "用户名";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          default:
                            break;
                        }
                        p.innerHTML = html;
                        secCon.appendChild(p);
                      }

                      rDivTabContent.appendChild(secCon);
                      break;

                    case "logging":
                      let logTitle = document.createElement("LI");
                      logTitle.setAttribute("class", "tc");
                      let log = document.createElement("A");
                      let log_txt = document.createTextNode("注销");
                      log.setAttribute("href", "#logging");
                      log.setAttribute("data-toggle", "tab");
                      log.appendChild(log_txt);
                      logTitle.appendChild(log);
                      rDivTab.appendChild(logTitle);

                      // 右侧属性面板的值
                      let logCon = document.createElement("DIV");
                      // 将细节内容添加下方面板
                      logCon.setAttribute("id", "logging");
                      logCon.setAttribute("class", "tab-pane pt10");

                      for (let i = 0; i < that.propsDesc[propPart][advancedItem].length; i++) {
                        let propName = that.propsDesc[propPart][advancedItem][i];
                        let chinaName = null;
                        let p = document.createElement("p");
                        let html = "";
                        switch (propName) {
                          case "errorHandlerLogStackTrace":
                            chinaName = "错误处理程序日志堆栈跟踪";
                            html += `<label class="w80">${chinaName}</label>`;
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          case "errorHandlerLoggingLevel":
                            chinaName = "错误处理程序日志记录级别";
                            html += `<label class="w80">${chinaName}</label><select name='${propName}' class="form-control w400 inlineBlock">`;
                            errorHandlerLoggingLevelOption.forEach((el) => {
                              if (el.value == currToEdit[propName]) {
                                html += `<option value='${el.value}' selected>${el.label}</option>`;
                              } else {
                                html += `<option value='${el.value}'>${el.label}</option>`;
                              }
                            });
                            break;
                          case "loggingFeatureEnabled":
                            chinaName = "记录功能已启用";
                            html += `<label class="w80">${chinaName}</label><select name='${propName}' class="form-control w400 inlineBlock">`;
                            errorHandlerLoggingLevelOption.forEach((el) => {
                              if (el.value == currToEdit[propName]) {
                                html += `<option value='${el.value}' selected>${el.label}</option>`;
                              } else {
                                html += `<option value='${el.value}'>${el.label}</option>`;
                              }
                            });
                            break;
                          case "skipFaultLogging":
                            chinaName = "跳过故障记录";
                            html += `<label class="w80">${chinaName}</label><select name='${propName}' class="form-control w400 inlineBlock">`;
                            errorHandlerLoggingLevelOption.forEach((el) => {
                              if (el.value == currToEdit[propName]) {
                                html += `<option value='${el.value}' selected>${el.label}</option>`;
                              } else {
                                html += `<option value='${el.value}'>${el.label}</option>`;
                              }
                            });
                            break;
                          case "loggingSizeLimit":
                            chinaName = "日志记录大小限制";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" type="number" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          default:
                            break;
                        }
                        p.innerHTML = html;
                        logCon.appendChild(p);
                      }

                      rDivTabContent.appendChild(logCon);
                      break;

                    case "transaction":
                      let traTitle = document.createElement("LI");
                      traTitle.setAttribute("class", "tc");
                      let tra = document.createElement("A");
                      let tra_txt = document.createTextNode("业务");
                      tra.setAttribute("href", "#transaction");
                      tra.setAttribute("data-toggle", "tab");
                      tra.appendChild(tra_txt);
                      traTitle.appendChild(tra);
                      rDivTab.appendChild(traTitle);

                      // 右侧属性面板的值
                      let traCon = document.createElement("DIV");
                      // 将细节内容添加下方面板
                      traCon.setAttribute("id", "transaction");
                      traCon.setAttribute("class", "tab-pane pt10");

                      for (let i = 0; i < that.propsDesc[propPart][advancedItem].length; i++) {
                        let propName = that.propsDesc[propPart][advancedItem][i];
                        let chinaName = null;
                        let p = document.createElement("p");
                        let html = "";
                        switch (propName) {
                          case "transacted":
                            chinaName = "交易";
                            html += `<label class="w80">${chinaName}</label>`;
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          default:
                            break;
                        }
                        p.innerHTML = html;
                        traCon.appendChild(p);
                      }

                      rDivTabContent.appendChild(traCon);
                      break;
                    case "transaction_advanced":
                      let tra_ATitle = document.createElement("LI");
                      tra_ATitle.setAttribute("class", "tc");
                      let tra_A = document.createElement("A");
                      let tra_Atxt = document.createTextNode("高级业务");
                      tra_A.setAttribute("href", "#transaction_advanced");
                      tra_A.setAttribute("data-toggle", "tab");
                      tra_A.appendChild(tra_Atxt);
                      tra_ATitle.appendChild(tra_A);
                      rDivTab.appendChild(tra_ATitle);

                      // 右侧属性面板的值
                      let tra_ACon = document.createElement("DIV");
                      // 将细节内容添加下方面板
                      tra_ACon.setAttribute("id", "transaction_advanced");
                      tra_ACon.setAttribute("class", "tab-pane pt10");

                      for (let i = 0; i < that.propsDesc[propPart][advancedItem].length; i++) {
                        let propName = that.propsDesc[propPart][advancedItem][i];
                        let chinaName = null;
                        let p = document.createElement("p");
                        let html = "";
                        switch (propName) {
                          case "lazyCreateTransactionManager":
                            chinaName = "懒创建事务管理器";
                            html += `<label class="w80">${chinaName}</label>`;
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          case "transactionManager":
                            chinaName = "交易经理";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "transactionName":
                            chinaName = "交易名称";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "transactionTimeout":
                            chinaName = "交易超时";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" type="number" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          default:
                            break;
                        }
                        p.innerHTML = html;
                        tra_ACon.appendChild(p);
                      }

                      rDivTabContent.appendChild(tra_ACon);
                      break;

                    case "service":
                      let ser = that.creatTab("serTitle", "ser", "ser_txt", "服务", "service");
                      rDivTab.appendChild(ser);

                      // 右侧属性面板的值
                      let serCon = that.createTabContent("serCon", "service", "tab-pane pt10");

                      for (let i = 0; i < that.propsDesc[propPart][advancedItem].length; i++) {
                        let propName = that.propsDesc[propPart][advancedItem][i];
                        let chinaName = null;
                        let p = document.createElement("p");
                        let html = "";
                        switch (propName) {
                          case "bindingId":
                            chinaName = "绑定ID";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "portName":
                            chinaName = "端口名称";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "publishedEndpointUrl":
                            chinaName = "已发布的端点网址";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "serviceClass":
                            chinaName = "服务等级";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "serviceName":
                            chinaName = "服务名称";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "wsdlURL":
                            chinaName = "wsdl地址";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          default:
                            break;
                        }
                        p.innerHTML = html;
                        serCon.appendChild(p);
                      }

                      rDivTabContent.appendChild(serCon);
                      break;

                    case "consumer_advanced":
                      let con_a = that.creatTab("con_aTitle", "consumer_advanced", "con_atxt", "消费者高级", "consumer_advanced");
                      rDivTab.appendChild(con_a);

                      // 右侧属性面板的值
                      let con_aCon = document.createElement("DIV");
                      // 将细节内容添加下方面板
                      con_aCon.setAttribute("id", "consumer_advanced");
                      con_aCon.setAttribute("class", "tab-pane pt10");

                      for (let i = 0; i < that.propsDesc[propPart][advancedItem].length; i++) {
                        let propName = that.propsDesc[propPart][advancedItem][i];
                        let chinaName = null;
                        let p = document.createElement("p");
                        let html = "";
                        switch (propName) {
                          case "acceptMessagesWhileStopping":
                            chinaName = "停止时接受消息";
                            html += `<label class="w80">${chinaName}</label>`;
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          case "allowReplyManagerQuickStop":
                            chinaName = "允许回复管理器快速停止";
                            html += `<label class="w80">${chinaName}</label>`;
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          case "attachmentMultipartBinding":
                            chinaName = "附件多部分绑定";
                            html += `<label class="w80">${chinaName}</label>`;
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          case "backlog":
                            chinaName = "待办事项";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "bossCount":
                            chinaName = "bossCount";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "bossPool":
                            chinaName = "bossPool";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "channelGroup":
                            chinaName = "频道组";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "chunkedMaxContentLength":
                            chinaName = "分块的最大内容长度";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" type="number" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "compression":
                            chinaName = "压缩";
                            html += `<label class="w80">${chinaName}</label>`;
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          case "consumerType":
                            chinaName = "消费者类型";
                            html += `<label class="w80">${chinaName}</label><select name='${propName}' class="form-control w400 inlineBlock">`;
                            consumerTypeOption.forEach((el) => {
                              if (el.value == currToEdit[propName]) {
                                html += `<option value='${el.value}' selected>${el.label}</option>`;
                              } else {
                                html += `<option value='${el.value}'>${el.label}</option>`;
                              }
                            });
                            break;
                          case "defaultTaskExecutorType":
                            chinaName = "默认任务执行器类型";
                            html += `<label class="w80">${chinaName}</label><select name='${propName}' class="form-control w400 inlineBlock">`;
                            defaultTaskExecutorTypeOption.forEach((el) => {
                              if (el.value == currToEdit[propName]) {
                                html += `<option value='${el.value}' selected>${el.label}</option>`;
                              } else {
                                html += `<option value='${el.value}'>${el.label}</option>`;
                              }
                            });
                            break;
                          case "defaultTaskExecutorType":
                            chinaName = "断开无回复";
                            html += `<label class="w80">${chinaName}</label>`;
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          case "disableStreamCache":
                            chinaName = "禁用流缓存";
                            html += `<label class="w80">${chinaName}</label>`;
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          case "disconnectOnNoReply":
                            chinaName = "断开时无回复";
                            html += `<label class="w80">${chinaName}</label>`;
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          case "directoryMustExist":
                            chinaName = "目录必须存在";
                            html += `<label class="w80">${chinaName}</label>`;
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          case "download":
                            chinaName = "下载";
                            html += `<label class="w80">${chinaName}</label>`;
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          case "eagerCheckContentAvailable":
                            chinaName = "渴望检查内容";
                            html += `<label class="w80">${chinaName}</label>`;
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          case "eagerLoadingOfProperties":
                            chinaName = "预加载属性";
                            html += `<label class="w80">${chinaName}</label>`;
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          case "exceptionHandler":
                            chinaName = "异常处理程序";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "exposeListenerSession":
                            chinaName = "暴露侦听器会话";
                            html += `<label class="w80">${chinaName}</label>`;
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          case "exchangePattern":
                            chinaName = "交换方式";
                            html += `<label class="w80">${chinaName}</label><select name='${propName}' class="form-control w400 inlineBlock">`;
                            exchangePatternOption.forEach((el) => {
                              if (el.value == currToEdit[propName]) {
                                html += `<option value='${el.value}' selected>${el.label}</option>`;
                              } else {
                                html += `<option value='${el.value}'>${el.label}</option>`;
                              }
                            });
                            break;
                          case "fetchSize":
                            chinaName = "fetchSize";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "folderName":
                            chinaName = "文件夹名称";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "fileNameExtWhitelist":
                            chinaName = "文件名Ext白名单";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "limitConcurrentConsumers":
                            chinaName = "限制并发消费者";
                            html += `<label class="w80">${chinaName}</label>`;
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          case "httpMethodRestrict":
                            chinaName = "http方法限制";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "ignoreFileNotFoundOrPermissionError":
                            chinaName = "忽略文件未找到或权限错误";
                            html += `<label class="w80">${chinaName}</label>`;
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          case "inProgressRepository":
                            chinaName = "进行中的资料库";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "localWorkDirectory":
                            chinaName = "本地工作目录";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "mailUidGenerator":
                            chinaName = "邮件Uid生成器";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "mapHeaders":
                            chinaName = "地图标题";
                            html += `<label class="w80">${chinaName}</label>`;
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          case "mapMailMessage":
                            chinaName = "地图邮件";
                            html += `<label class="w80">${chinaName}</label>`;
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          case "maxChannelMemorySize":
                            chinaName = "最大通道内存大小";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" type="number" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "maxHeaderSize":
                            chinaName = "最大标题大小";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" type="number" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "maxTotalMemorySize":
                            chinaName = "最大总内存大小";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" type="number" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "multipleConsumers":
                            chinaName = "多个消费者";
                            html += `<label class="w80">${chinaName}</label>`;
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          case "nettyServerBootstrapFactory":
                            chinaName = "netty服务器引导工厂";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "nettySharedHttpServer":
                            chinaName = "netty共享Http服务器";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "networkInterface":
                            chinaName = "网络接口";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "noReplyLogLevel":
                            chinaName = "没有回复日志级别";
                            html += `<label class="w80">${chinaName}</label><select name='${propName}' class="form-control w400 inlineBlock">`;
                            errorHandlerLoggingLevelOption.forEach((el) => {
                              if (el.value == currToEdit[propName]) {
                                html += `<option value='${el.value}' selected>${el.label}</option>`;
                              } else {
                                html += `<option value='${el.value}'>${el.label}</option>`;
                              }
                            });
                            break;
                          case "onCompletionExceptionHandler":
                            chinaName = "关于完成异常处理程序";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "optionsEnabled":
                            chinaName = "选项已启用";
                            html += `<label class="w80">${chinaName}</label>`;
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          case "orderedThreadPoolExecutor":
                            chinaName = "订购的线程池执行器";
                            html += `<label class="w80">${chinaName}</label>`;
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          case "postProcessAction":
                            chinaName = "后处理行动";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "pollStrategy":
                            chinaName = "投票策略";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "pollTimeout":
                            chinaName = "轮询超时";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" type="number" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "processStrategy":
                            chinaName = "过程策略";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "processingStrategy":
                            chinaName = "处理策略";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "purgeWhenStopping":
                            chinaName = "允许回复相同目的地";
                            html += `<label class="w80">${chinaName}</label>`;
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          case "replyToSameDestinationAllowed":
                            chinaName = "允许回复相同目的地";
                            html += `<label class="w80">${chinaName}</label>`;
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          case "restletUriPatterns":
                            chinaName = "restletUri模式";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "serviceBeans":
                            chinaName = "serviceBeans";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "serverClosedChannelExceptionCaughtLogLevel":
                            chinaName = "服务器关闭通道异常捕获日志级别";
                            html += `<label class="w80">${chinaName}</label><select name='${propName}' class="form-control w400 inlineBlock">`;
                            errorHandlerLoggingLevelOption.forEach((el) => {
                              if (el.value == currToEdit[propName]) {
                                html += `<option value='${el.value}' selected>${el.label}</option>`;
                              } else {
                                html += `<option value='${el.value}'>${el.label}</option>`;
                              }
                            });
                            break;
                          case "serverExceptionCaughtLogLevel":
                            chinaName = "服务器异常捕获的日志级别";
                            html += `<label class="w80">${chinaName}</label><select name='${propName}' class="form-control w400 inlineBlock">`;
                            errorHandlerLoggingLevelOption.forEach((el) => {
                              if (el.value == currToEdit[propName]) {
                                html += `<option value='${el.value}' selected>${el.label}</option>`;
                              } else {
                                html += `<option value='${el.value}'>${el.label}</option>`;
                              }
                            });
                            break;
                          case "serverPipelineFactory":
                            chinaName = "任务执行器";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "startingDirectoryMustExist":
                            chinaName = "启动目录必须存在";
                            html += `<label class="w80">${chinaName}</label>`;
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          case "taskExecutor":
                            chinaName = "任务执行器";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "traceEnabled":
                            chinaName = "启用跟踪";
                            html += `<label class="w80">${chinaName}</label>`;
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          case "urlDecodeHeaders":
                            chinaName = "网址解码标头";
                            html += `<label class="w80">${chinaName}</label>`;
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          case "useList":
                            chinaName = "使用清单";
                            html += `<label class="w80">${chinaName}</label>`;
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          case "usingExecutorService":
                            chinaName = "使用执行器服务";
                            html += `<label class="w80">${chinaName}</label>`;
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          case "workerCount":
                            chinaName = "工人数";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" type="number" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "workerPool":
                            chinaName = "工人池";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          default:
                            break;
                        }
                        p.innerHTML = html;
                        con_aCon.appendChild(p);
                      }

                      rDivTabContent.appendChild(con_aCon);
                      break;

                    case "path":
                      let apTitle = document.createElement("LI");
                      apTitle.setAttribute("class", "tc active");
                      let ap = document.createElement("A");
                      let aptxt = document.createTextNode("路径");
                      ap.setAttribute("href", "#path");
                      ap.setAttribute("data-toggle", "tab");
                      ap.appendChild(aptxt);
                      apTitle.appendChild(ap);
                      rDivTab.appendChild(apTitle);

                      // 右侧属性面板的值
                      let pathCon = document.createElement("DIV");
                      // 将细节内容添加下方面板
                      pathCon.setAttribute("id", "path");
                      pathCon.setAttribute("class", "tab-pane active pt10");

                      for (let i = 0; i < that.propsDesc[propPart][advancedItem].length; i++) {
                        let propName = that.propsDesc[propPart][advancedItem][i];
                        let chinaName = null;
                        let p = document.createElement("p");
                        let html = "";
                        switch (propName) {
                          case "address":
                            chinaName = "地址";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "beanId":
                            chinaName = "bean Id";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "command":
                            chinaName = "命令";
                            html += `<label class="w80">${chinaName}</label><select name='${propName}' class="form-control w400 inlineBlock">`;
                            commandOption.forEach((el) => {
                              if (el.value == currToEdit[propName]) {
                                html += `<option value='${el.value}' selected>${el.label}</option>`;
                              } else {
                                html += `<option value='${el.value}'>${el.label}</option>`;
                              }
                            });
                            html += `</select>`;
                            break;
                          case "contextPath":
                            chinaName = "上下文路径";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "dataSourceName":
                            chinaName = "数据源名称";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "destinationName":
                            chinaName = "目的地名称";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;

                          case "destinationType":
                            chinaName = "目的地类型";
                            html += `<label class="w80">${chinaName}</label><select name='${propName}' class="form-control w400 inlineBlock">`;
                            destinationTypeOption.forEach((el) => {
                              if (el.value == currToEdit[propName]) {
                                html += `<option value='${el.value}' selected>${el.label}</option>`;
                              } else {
                                html += `<option value='${el.value}'>${el.label}</option>`;
                              }
                            });
                            html += `</select>`;
                            break;
                          case "directoryName":
                            chinaName = "目录名";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "feedUri":
                            chinaName = "feedUri";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "host":
                            chinaName = "主机";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;

                          case "language":
                            chinaName = "语言";
                            html += `<label class="w80">${chinaName}</label><select name='${propName}' class="form-control w400 inlineBlock">`;
                            languangeOption.forEach((el) => {
                              if (el.value == currToEdit[propName]) {
                                html += `<option value='${el.value}' selected>${el.label}</option>`;
                              } else {
                                html += `<option value='${el.value}'>${el.label}</option>`;
                              }
                            });
                            html += `</select>`;
                            break;
                          case "name":
                            chinaName = "名称";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "operationName":
                            chinaName = "名称";
                            html += `<label class="w80">${chinaName}</label><select name='${propName}' class="form-control w400 inlineBlock">`;
                            operationNameOption.forEach((el) => {
                              if (el.value == currToEdit[propName]) {
                                html += `<option value='${el.value}' selected>${el.label}</option>`;
                              } else {
                                html += `<option value='${el.value}'>${el.label}</option>`;
                              }
                            });
                            break;
                          case "port":
                            chinaName = "端口";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "protocol":
                            chinaName = "协议";
                            html += `<label class="w80">${chinaName}</label><select name='${propName}' class="form-control w400 inlineBlock">`;
                            protocolOption.forEach((el) => {
                              if (el.value == currToEdit[propName]) {
                                html += `<option value='${el.value}' selected>${el.label}</option>`;
                              } else {
                                html += `<option value='${el.value}'>${el.label}</option>`;
                              }
                            });
                            break;
                          case "resourceUri":
                            chinaName = "资源Uri";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "timerName":
                            chinaName = "计时器名称";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "topicName":
                            chinaName = "主题名称";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "groupName":
                            chinaName = "组名";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "query":
                            chinaName = "询问";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "url":
                            chinaName = "网址";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "uriPattern":
                            chinaName = "uri模式";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          default:
                            break;
                        }
                        p.innerHTML = html;
                        pathCon.appendChild(p);
                      }

                      rDivTabContent.appendChild(pathCon);

                      break;

                    case "producer":
                      let producer = that.creatTab("proTitle", "producer", "producer_txt", "生产者", "producer");
                      rDivTab.appendChild(producer);

                      // 右侧属性面板的值
                      let proCon = that.createTabContent("proCon", "producer", "tab-pane pt10");

                      for (let i = 0; i < that.propsDesc[propPart][advancedItem].length; i++) {
                        let propName = that.propsDesc[propPart][advancedItem][i];
                        let chinaName = null;
                        let p = document.createElement("p");
                        let html = "";
                        switch (propName) {
                          case "action":
                            chinaName = "动作";
                            html += `<label class="w80">${chinaName}</label><select name='${propName}' class="form-control w400 inlineBlock">`;
                            ationOption.forEach((el) => {
                              if (el.value == currToEdit[propName]) {
                                html += `<option value='${el.value}' selected>${el.label}</option>`;
                              } else {
                                html += `<option value='${el.value}'>${el.label}</option>`;
                              }
                            });

                            break;
                          case "allowNamedParameters":
                            chinaName = "允许命名参数";
                            html += `<label class="w80">${chinaName}</label>`;
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          case "allowStAX":
                            chinaName = "允许StAX";
                            html += `<label class="w80">${chinaName}</label>`;
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          case "async":
                            chinaName = "异步";
                            html += `<label class="w80">${chinaName}</label>`;
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          case "batch":
                            chinaName = "批";
                            html += `<label class="w80">${chinaName}</label>`;
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          case "bcc":
                            chinaName = "密件抄送";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "block":
                            chinaName = "堵塞";
                            html += `<label class="w80">${chinaName}</label>`;
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          case "blockWhenFull":
                            chinaName = "满时阻止";
                            html += `<label class="w80">${chinaName}</label>`;
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          case "binary":
                            chinaName = "二进制";
                            html += `<label class="w80">${chinaName}</label>`;
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          case "cacheScript":
                            chinaName = "缓存脚本";
                            html += `<label class="w80">${chinaName}</label>`;
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          case "cc":
                            chinaName = "抄送";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "contentCache":
                            chinaName = "内容缓存";
                            html += `<label class="w80">${chinaName}</label>`;
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          case "connectTimeout":
                            chinaName = "连接超时";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" type="number" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "cookieHandler":
                            chinaName = "Cookie处理程序";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "defaultOperationName":
                            chinaName = "默认操作名称";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "defaultOperationNamespace":
                            chinaName = "默认操作命名空间";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "deleteOutputFile":
                            chinaName = "删除输出文件";
                            html += `<label class="w80">${chinaName}</label><select name='${propName}' class="form-control w400 inlineBlock">`;
                            deliveryModeOption.forEach((el) => {
                              if (el.value == currToEdit[propName]) {
                                html += `<option value='${el.value}' selected>${el.label}</option>`;
                              } else {
                                html += `<option value='${el.value}'>${el.label}</option>`;
                              }
                            });
                            break;
                          case "deliveryMode":
                            chinaName = "投放方式";
                            html += `<label class="w80">${chinaName}</label><select name='${propName}' class="form-control w400 inlineBlock">`;
                            deliveryModeOption.forEach((el) => {
                              if (el.value == currToEdit[propName]) {
                                html += `<option value='${el.value}' selected>${el.label}</option>`;
                              } else {
                                html += `<option value='${el.value}'>${el.label}</option>`;
                              }
                            });
                            break;
                          case "deliveryPersistent":
                            chinaName = "持续交付";
                            html += `<label class="w80">${chinaName}</label>`;
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          case "discardIfNoConsumers":
                            chinaName = "如果没有消费者则丢弃";
                            html += `<label class="w80">${chinaName}</label>`;
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          case "encoding":
                            chinaName = "编码方式";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "explicitQosEnabled":
                            chinaName = "显式启用Qos";
                            html += `<label class="w80">${chinaName}</label>`;
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          case "failIfNoConsumers":
                            chinaName = "failIfNoConsumers";
                            html += `<label class="w80">${chinaName}</label>`;
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          case "failOnNullBody":
                            chinaName = "在空体上失败";
                            html += `<label class="w80">${chinaName}</label>`;
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          case "flatten":
                            chinaName = "展平";
                            html += `<label class="w80">${chinaName}</label>`;
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          case "flatternMap":
                            chinaName = "flatternMap";
                            html += `<label class="w80">${chinaName}</label>`;
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          case "fileExist":
                            chinaName = "文件存在";
                            html += `<label class="w80">${chinaName}</label><select name='${propName}' class="form-control w400 inlineBlock">`;
                            fileExistOption.forEach((el) => {
                              if (el.value == currToEdit[propName]) {
                                html += `<option value='${el.value}' selected>${el.label}</option>`;
                              } else {
                                html += `<option value='${el.value}'>${el.label}</option>`;
                              }
                            });
                            break;
                          case "formatDateHeadersToIso8601":
                            chinaName = "将日期标题格式设置为Iso8601";
                            html += `<label class="w80">${chinaName}</label>`;
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          case "from":
                            chinaName = "从";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "hostnameVerifier":
                            chinaName = "主机名验证者";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "jailStartingDirectory":
                            chinaName = "jail启动目录";
                            html += `<label class="w80">${chinaName}</label>`;
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          case "json":
                            chinaName = "json";
                            html += `<label class="w80">${chinaName}</label>`;
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          case "jsonAsMap":
                            chinaName = "jsonAsMap";
                            html += `<label class="w80">${chinaName}</label>`;
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          case "loggingLevel":
                            chinaName = "日志级别";
                            html += `<label class="w80">${chinaName}</label><select name='${propName}' class="form-control w400 inlineBlock">`;
                            errorHandlerLoggingLevelOption.forEach((el) => {
                              if (el.value == currToEdit[propName]) {
                                html += `<option value='${el.value}' selected>${el.label}</option>`;
                              } else {
                                html += `<option value='${el.value}'>${el.label}</option>`;
                              }
                            });
                            break;
                          case "moveExisting":
                            chinaName = "移动现有";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "noop":
                            chinaName = "noop";
                            html += `<label class="w80">${chinaName}</label>`;
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          case "offerTimeout":
                            chinaName = "报价超时";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" type="number" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "output":
                            chinaName = "输出";
                            html += `<label class="w80">${chinaName}</label><select name='${propName}' class="form-control w400 inlineBlock">`;
                            outputOption.forEach((el) => {
                              if (el.value == currToEdit[propName]) {
                                html += `<option value='${el.value}' selected>${el.label}</option>`;
                              } else {
                                html += `<option value='${el.value}'>${el.label}</option>`;
                              }
                            });
                            break;
                          case "outputClass":
                            chinaName = "输出类别";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "outputType":
                            chinaName = "输出类型";
                            html += `<label class="w80">${chinaName}</label><select name='${propName}' class="form-control w400 inlineBlock">`;
                            outputTypeOption.forEach((el) => {
                              if (el.value == currToEdit[propName]) {
                                html += `<option value='${el.value}' selected>${el.label}</option>`;
                              } else {
                                html += `<option value='${el.value}'>${el.label}</option>`;
                              }
                            });
                            break;
                          case "password":
                            chinaName = "密码";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "parameters":
                            chinaName = "参数";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "preserveMessageQos":
                            chinaName = "保留消息质量";
                            html += `<label class="w80">${chinaName}</label>`;
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          case "priority":
                            chinaName = "投放方式";
                            html += `<label class="w80">${chinaName}</label><select name='${propName}' class="form-control w400 inlineBlock">`;
                            priorityOption.forEach((el) => {
                              if (el.value == currToEdit[propName]) {
                                html += `<option value='${el.value}' selected>${el.label}</option>`;
                              } else {
                                html += `<option value='${el.value}'>${el.label}</option>`;
                              }
                            });
                            break;
                          case "readSize":
                            chinaName = "读取大小";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" type="number" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "replyToConcurrentConsumers":
                            chinaName = "回复给并发消费者";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" type="number" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "replyTo":
                            chinaName = "回复";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "replyToMaxConcurrentConsumers":
                            chinaName = "回复给最大同时消费者";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" type="number" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "replyToOnTimeoutMaxConcurrentConsumers":
                            chinaName = "回复给最大同时消费者";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" type="number" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "replyToOverride":
                            chinaName = "回复给最大同时消费者";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "replyToType":
                            chinaName = "回复类型";
                            html += `<label class="w80">${chinaName}</label><select name='${propName}' class="form-control w400 inlineBlock">`;
                            replyToOverrideOption.forEach((el) => {
                              if (el.value == currToEdit[propName]) {
                                html += `<option value='${el.value}' selected>${el.label}</option>`;
                              } else {
                                html += `<option value='${el.value}'>${el.label}</option>`;
                              }
                            });
                            break;
                          case "resetAutoCommit":
                            chinaName = "重置自动提交";
                            html += `<label class="w80">${chinaName}</label>`;
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          case "restartDelay":
                            chinaName = "重新启动延迟";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" type="number" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "requestTimeout":
                            chinaName = "请求超时";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" type="number" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "routeId":
                            chinaName = "路由ID";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "script":
                            chinaName = "脚本";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "subject":
                            chinaName = "主题";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "tempFileName":
                            chinaName = "临时文件名称";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "tempPrefix":
                            chinaName = "临时前缀";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "transform":
                            chinaName = "转换";
                            html += `<label class="w80">${chinaName}</label>`;
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          case "transacted":
                            chinaName = "交易的";
                            html += `<label class="w80">${chinaName}</label>`;
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          case "timeout":
                            chinaName = "超时";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" type="number" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "timeToLive":
                            chinaName = "生存时间";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" type="number" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "throwExceptionOnFailure":
                            chinaName = "失败时抛出异常";
                            html += `<label class="w80">${chinaName}</label>`;
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          case "transformerCacheSize":
                            chinaName = "变压器缓存大小";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" type="number" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "to":
                            chinaName = "到";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" type="number" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "saxon":
                            chinaName = "ssl上下文参数";
                            html += `<label class="w80">${chinaName}</label><select name='${propName}' class="form-control w400 inlineBlock">`;
                            saxonOption.forEach((el) => {
                              if (el.value == currToEdit[propName]) {
                                html += `<option value='${el.value}' selected>${el.label}</option>`;
                              } else {
                                html += `<option value='${el.value}'>${el.label}</option>`;
                              }
                            });
                            break;
                          case "sslContextParameters":
                            chinaName = "ssl上下文参数";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "wrapped":
                            chinaName = "包裹";
                            html += `<label class="w80">${chinaName}</label>`;
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          case "useMessageBodyForSql":
                            chinaName = "对SQL使用消息正文";
                            html += `<label class="w80">${chinaName}</label>`;
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          case "username":
                            chinaName = "用户名";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "useGetBytesForBlob":
                            chinaName = "使用为Blob获取字节";
                            html += `<label class="w80">${chinaName}</label>`;
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          case "useHeadersAsParameters":
                            chinaName = "使用标题作为参数";
                            html += `<label class="w80">${chinaName}</label>`;
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          case "useJDBC4ColumnNameAndLabelSemantics":
                            chinaName = "使用JDBC4列名和标签语义";
                            html += `<label class="w80">${chinaName}</label>`;
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          case "waitForTaskToComplete":
                            chinaName = "等待任务完成";
                            html += `<label class="w80">${chinaName}</label><select name='${propName}' class="form-control w400 inlineBlock">`;
                            waitForTaskToCompleteOption.forEach((el) => {
                              if (el.value == currToEdit[propName]) {
                                html += `<option value='${el.value}' selected>${el.label}</option>`;
                              } else {
                                html += `<option value='${el.value}'>${el.label}</option>`;
                              }
                            });
                            break;
                          default:
                            break;
                        }
                        p.innerHTML = html;
                        proCon.appendChild(p);
                      }

                      rDivTabContent.appendChild(proCon);
                      break;

                    case "scheduler":
                      let sch = that.creatTab("schTitle", "sch", "sch_txt", "调度器", "scheduler");
                      rDivTab.appendChild(sch);

                      // 右侧属性面板的值
                      let schCon = that.createTabContent("schCon", "scheduler", "tab-pane pt10");

                      for (let i = 0; i < that.propsDesc[propPart][advancedItem].length; i++) {
                        let propName = that.propsDesc[propPart][advancedItem][i];
                        let chinaName = null;
                        let p = document.createElement("p");
                        let html = "";
                        switch (propName) {
                          case "autoStartScheduler":
                            chinaName = "自动启动计划程序";
                            html += `<label class="w80">${chinaName}</label>`;
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          case "backoffErrorThreshold":
                            chinaName = "退避错误阈值";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" type="number" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "backoffIdleThreshold":
                            chinaName = "退出空闲阈值";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" type="number" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "backoffMultiplier":
                            chinaName = "退避乘数";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" type="number" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "delay":
                            chinaName = "延迟";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" type="number" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "fireNow":
                            chinaName = "fireNow";
                            html += `<label class="w80">${chinaName}</label>`;
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          case "initialDelay":
                            chinaName = "延迟";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" type="number" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "greedy":
                            chinaName = "贪婪的";
                            html += `<label class="w80">${chinaName}</label>`;
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          case "scheduledExecutorService":
                            chinaName = "定期执行人服务";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "schedulerProperties":
                            chinaName = "调度程序属性";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;

                          case "scheduler":
                            chinaName = "调度器";
                            html += `<label class="w80">${chinaName}</label><select name='${propName}' class="form-control w400 inlineBlock">`;
                            initialDelayOption.forEach((el) => {
                              if (el.value == currToEdit[propName]) {
                                html += `<option value='${el.value}' selected>${el.label}</option>`;
                              } else {
                                html += `<option value='${el.value}'>${el.label}</option>`;
                              }
                            });
                            break;
                          case "startScheduler":
                            chinaName = "启动调度程序";
                            html += `<label class="w80">${chinaName}</label>`;
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          case "startDelayedSeconds":
                            chinaName = "开始延迟秒";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "runLoggingLevel":
                            chinaName = "运行日志记录级别";
                            html += `<label class="w80">${chinaName}</label><select name='${propName}' class="form-control w400 inlineBlock">`;
                            errorHandlerLoggingLevelOption.forEach((el) => {
                              if (el.value == currToEdit[propName]) {
                                html += `<option value='${el.value}' selected>${el.label}</option>`;
                              } else {
                                html += `<option value='${el.value}'>${el.label}</option>`;
                              }
                            });
                            break;

                          case "timeUnit":
                            chinaName = "时间单位";
                            html += `<label class="w80">${chinaName}</label><select name='${propName}' class="form-control w400 inlineBlock">`;
                            timeUnitOption.forEach((el) => {
                              if (el.value == currToEdit[propName]) {
                                html += `<option value='${el.value}' selected>${el.label}</option>`;
                              } else {
                                html += `<option value='${el.value}'>${el.label}</option>`;
                              }
                            });
                            break;
                          case "triggerStartDelay":
                            chinaName = "触发启动延迟";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" type="number" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "useFixedDelay":
                            chinaName = "使用固定延迟";
                            html += `<label class="w80">${chinaName}</label>`;
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          default:
                            break;
                        }
                        p.innerHTML = html;
                        schCon.appendChild(p);
                      }

                      rDivTabContent.appendChild(schCon);
                      break;

                    case "lock":
                      let lock = that.creatTab("lockTitle", "lock", "lock_txt", "锁", "lock");
                      rDivTab.appendChild(lock);

                      // 右侧属性面板的值
                      let lockCon = that.createTabContent("lockCon", "lock", "tab-pane pt10");

                      for (let i = 0; i < that.propsDesc[propPart][advancedItem].length; i++) {
                        let propName = that.propsDesc[propPart][advancedItem][i];
                        let chinaName = null;
                        let p = document.createElement("p");
                        let html = "";
                        switch (propName) {
                          case "exclusiveReadLockStrategy":
                            chinaName = "独特读锁策略";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "readLock":
                            chinaName = "读锁";
                            html += `<label class="w80">${chinaName}</label><select name='${propName}' class="form-control w400 inlineBlock">`;
                            readLockOption.forEach((el) => {
                              if (el.value == currToEdit[propName]) {
                                html += `<option value='${el.value}' selected>${el.label}</option>`;
                              } else {
                                html += `<option value='${el.value}'>${el.label}</option>`;
                              }
                            });
                            break;
                          case "readLockCheckInterval":
                            chinaName = "读取锁定检查间隔";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" type="number" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "readLockDeleteOrphanLockFiles":
                            chinaName = "readLockDeleteOrphanLockFiles";
                            html += `<label class="w80">${chinaName}</label>`;
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          case "readLockIdempotentReleaseAsync":
                            chinaName = "读取锁定幂等释放异步";
                            html += `<label class="w80">${chinaName}</label>`;
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          case "readLockIdempotentReleaseAsyncPoolSize":
                            chinaName = "读取锁定幂等释放异步池大小";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" type="number" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "readLockIdempotentReleaseDelay":
                            chinaName = "读取锁定幂等释放延迟";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" type="number" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "readLockIdempotentReleaseExecutorService":
                            chinaName = "阅读锁幂等释放执行器服务";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" type="number" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "readLockLoggingLevel":
                            chinaName = "阅读锁定日志记录级别";
                            html += `<label class="w80">${chinaName}</label><select name='${propName}' class="form-control w400 inlineBlock">`;
                            errorHandlerLoggingLevelOption.forEach((el) => {
                              if (el.value == currToEdit[propName]) {
                                html += `<option value='${el.value}' selected>${el.label}</option>`;
                              } else {
                                html += `<option value='${el.value}'>${el.label}</option>`;
                              }
                            });
                            break;
                          case "readLockMarkerFile":
                            chinaName = "读取锁定标记文件";
                            html += `<label class="w80">${chinaName}</label>`;
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          case "readLockMinAge":
                            chinaName = "readLockMinAge";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" type="number" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "readLockMinLength":
                            chinaName = "读取锁定最小长度";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" type="number" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "readLockRemoveOnCommit":
                            chinaName = "读取锁定提交时删除";
                            html += `<label class="w80">${chinaName}</label>`;
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          case "readLockRemoveOnRollback":
                            chinaName = "阅读锁定回滚删除";
                            html += `<label class="w80">${chinaName}</label>`;
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          case "readLockTimeout":
                            chinaName = "读取锁定超时时间";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" type="number" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          default:
                            break;
                        }
                        p.innerHTML = html;
                        lockCon.appendChild(p);
                      }

                      rDivTabContent.appendChild(lockCon);
                      break;

                    case "common_advanced":
                      let common_A = that.creatTab("common_ATitle", "common_A", "common_Atxt", "进阶", "common_A");
                      rDivTab.appendChild(common_A);

                      // 右侧属性面板的值
                      let common_ACon = that.createTabContent("common_ACon", "common_A", "tab-pane pt10");

                      for (let i = 0; i < that.propsDesc[propPart][advancedItem].length; i++) {
                        let propName = that.propsDesc[propPart][advancedItem][i];
                        let chinaName = null;
                        let p = document.createElement("p");
                        let html = "";
                        switch (propName) {
                          case "fastExistsCheck":
                            chinaName = "快速检查";
                            html += `<label class="w80">${chinaName}</label>`;
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          default:
                            break;
                        }
                        p.innerHTML = html;
                        common_ACon.appendChild(p);
                      }

                      rDivTabContent.appendChild(common_ACon);
                      break;

                    case "sort":
                      let sort = that.creatTab("sortTitle", "sort", "sort_txt", "分类", "sort");
                      rDivTab.appendChild(sort);

                      // 右侧属性面板的值
                      let sortCon = document.createElement("DIV");
                      // 将细节内容添加下方面板
                      sortCon.setAttribute("id", "sort");
                      sortCon.setAttribute("class", "tab-pane pt10");

                      for (let i = 0; i < that.propsDesc[propPart][advancedItem].length; i++) {
                        let propName = that.propsDesc[propPart][advancedItem][i];
                        let chinaName = null;
                        let p = document.createElement("p");
                        let html = "";
                        switch (propName) {
                          case "shuffle":
                            chinaName = "拖曳";
                            html += `<label class="w80">${chinaName}</label>`;
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          case "sortBy":
                            chinaName = "排序方式";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "sorter":
                            chinaName = "分选机";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "sortTeam":
                            chinaName = "排序团队";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          default:
                            break;
                        }
                        p.innerHTML = html;
                        sortCon.appendChild(p);
                      }

                      rDivTabContent.appendChild(sortCon);
                      break;

                    case "common":
                      let com = that.creatTab("comTitle", "common", "comtxt", "公共", "common");
                      rDivTab.appendChild(com);

                      // 右侧属性面板的值
                      let comCon = that.createTabContent("comCon", "common", "tab-pane pt10");

                      for (let j = 0; j < that.propsDesc[propPart][advancedItem].length; j++) {
                        let propName = that.propsDesc[propPart][advancedItem][j];
                        let chinaName = null;
                        let p = document.createElement("p");
                        let html = "";
                        switch (propName) {
                          case "allowNamedParameters":
                            chinaName = "允许命名参数";
                            html += `<label class="w80">${chinaName}</label>`;
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          case "allowStAX":
                            chinaName = "允许StAX";
                            html += `<label class="w80">${chinaName}</label>`;
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          case "apexMethod":
                            chinaName = "顶点法";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "apexQueryParams":
                            chinaName = "顶点查询参数";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "apexUrl":
                            chinaName = "顶点网址";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "apiVersion":
                            chinaName = "api版本";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "backoffIncrement":
                            chinaName = "退避增量";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "batchId":
                            chinaName = "批次编号";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "blockingExecutor":
                            chinaName = "阻塞执行器";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "binary":
                            chinaName = "二进制";
                            html += `<label class="w80">${chinaName}</label>`;
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          case "bridgeEndpoint":
                            chinaName = "桥接端点";
                            html += `<label class="w80">${chinaName}</label>`;
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          case "byDefaultRetain":
                            chinaName = "默认情况下保留";
                            html += `<label class="w80">${chinaName}</label>`;
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          case "charset":
                            chinaName = "字符集";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "channelProperties":
                            chinaName = "频道属性";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "cleanSession":
                            chinaName = "清除session";
                            html += `<label class="w80">${chinaName}</label>`;
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          case "clientId":
                            chinaName = "客户端id";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "clientHttp":
                            chinaName = "客户端http";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "connectionFactory":
                            chinaName = "连接工厂";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "connectAttemptsMax":
                            chinaName = "连接最大尝试次数";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" type="number" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "connectWaitInSeconds":
                            chinaName = "连接等待秒";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" type="number" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "contentType":
                            chinaName = "内容类型";
                            html += `<label class="w80">${chinaName}</label><select name='${propName}' class="form-control w400 inlineBlock">`;
                            contentTypeOption.forEach((el) => {
                              if (el.value == currToEdit[propName]) {
                                html += `<option value='${el.value}' selected>${el.label}</option>`;
                              } else {
                                html += `<option value='${el.value}'>${el.label}</option>`;
                              }
                            });
                            break;
                          case "dataFormat":
                            chinaName = "数据格式";
                            html += `<label class="w80">${chinaName}</label><select name='${propName}' class="form-control w400 inlineBlock">`;
                            dataFormatOption.forEach((el) => {
                              if (el.value == currToEdit[propName]) {
                                html += `<option value='${el.value}' selected>${el.label}</option>`;
                              } else {
                                html += `<option value='${el.value}'>${el.label}</option>`;
                              }
                            });
                            break;
                          case "dataSource":
                            chinaName = "数据源";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "dataSourceRef":
                            chinaName = "数据源参考";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "defaultReplayId":
                            chinaName = "默认重播ID";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" type="number" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "disableReplyTo":
                            chinaName = "禁用回复";
                            html += `<label class="w80">${chinaName}</label>`;
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          case "disconnect":
                            chinaName = "断开";
                            html += `<label class="w80">${chinaName}</label>`;
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          case "disconnectWaitInSeconds":
                            chinaName = "断开等待秒";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" type="number" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "dispatchQueue":
                            chinaName = "分派队列";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "doneFileName":
                            chinaName = "下载文件名";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "durableSubscriptionName":
                            chinaName = "消息持久化";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "fileName":
                            chinaName = "文件名";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "features":
                            chinaName = "特征";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "format":
                            chinaName = "格式";
                            html += `<label class="w80">${chinaName}</label><select name='${propName}' class="form-control w400 inlineBlock">`;
                            formatOption.forEach((el) => {
                              if (el.value == currToEdit[propName]) {
                                html += `<option value='${el.value}' selected>${el.label}</option>`;
                              } else {
                                html += `<option value='${el.value}'>${el.label}</option>`;
                              }
                            });
                            break;
                          case "headerName":
                            chinaName = "标头名称";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "host":
                            chinaName = "host";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "includeDetails":
                            chinaName = "包括详细信息";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "initialReplayIdMap":
                            chinaName = "初始重播ID映射";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "instanceId":
                            chinaName = "实例ID";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "jmsMessageType":
                            chinaName = "JMS消息类型";
                            html += `<label class="w80">${chinaName}</label><select name='${propName}' class="form-control w400 inlineBlock">`;
                            jmsMessageTypeOption.forEach((el) => {
                              if (el.value == currToEdit[propName]) {
                                html += `<option value='${el.value}' selected>${el.label}</option>`;
                              } else {
                                html += `<option value='${el.value}'>${el.label}</option>`;
                              }
                            });
                            break;
                          case "jobId":
                            chinaName = "工作编号";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" type="number" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "jschLoggingLevel":
                            chinaName = "jsch记录级别";
                            html += `<label class="w80">${chinaName}</label><select name='${propName}' class="form-control w400 inlineBlock">`;
                            errorHandlerLoggingLevelOption.forEach((el) => {
                              if (el.value == currToEdit[propName]) {
                                html += `<option value='${el.value}' selected>${el.label}</option>`;
                              } else {
                                html += `<option value='${el.value}'>${el.label}</option>`;
                              }
                            });
                            break;
                          case "keepAlive":
                            chinaName = "keepAlive";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "limit":
                            chinaName = "限制";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" type="number" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "localAddress":
                            chinaName = "本地地址";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "loggingFeatureEnabled":
                            chinaName = "启用日志记录功能";
                            html += `<label class="w80">${chinaName}</label>`;
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          case "loggingSizeLimit":
                            chinaName = "日志记录大小限制";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" type="number" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "maxBackoff":
                            chinaName = "最大退避";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" type="number" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "maxReadRate":
                            chinaName = "最大读取率";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" type="number" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "maxWriteRate":
                            chinaName = "最大写入率";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" type="number" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "minaLogger":
                            chinaName = "minaLogger";
                            html += `<label class="w80">${chinaName}</label>`;
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          case "modelRef":
                            chinaName = "型号参考";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "mqttQosPropertyName":
                            chinaName = "mqttQos属性名称";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "mqttRetainPropertyName":
                            chinaName = "mqtt保留属性名称";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "mqttTopicPropertyName":
                            chinaName = "mqtt主题属性名称";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "namespacePrefixes":
                            chinaName = "命名空间前缀";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "notFoundBehaviour":
                            chinaName = "找不到行为";
                            html += `<label class="w80">${chinaName}</label><select name='${propName}' class="form-control w400 inlineBlock">`;
                            notFoundBehaviourOption.forEach((el) => {
                              if (el.value == currToEdit[propName]) {
                                html += `<option value='${el.value}' selected>${el.label}</option>`;
                              } else {
                                html += `<option value='${el.value}'>${el.label}</option>`;
                              }
                            });
                            break;
                          case "notifyForFields":
                            chinaName = "通知栏位";
                            html += `<label class="w80">${chinaName}</label><select name='${propName}' class="form-control w400 inlineBlock">`;
                            notifyForFieldsOption.forEach((el) => {
                              if (el.value == currToEdit[propName]) {
                                html += `<option value='${el.value}' selected>${el.label}</option>`;
                              } else {
                                html += `<option value='${el.value}'>${el.label}</option>`;
                              }
                            });
                            break;
                          case "notifyForOperationCreate":
                            chinaName = "通知操作创建";
                            html += `<label class="w80">${chinaName}</label>`;
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          case "notifyForOperationDelete":
                            chinaName = "通知操作删除";
                            html += `<label class="w80">${chinaName}</label>`;
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          case "notifyForOperationUndelete":
                            chinaName = "通知操作取消删除";
                            html += `<label class="w80">${chinaName}</label>`;
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          case "notifyForOperationUpdate":
                            chinaName = "通知操作更新";
                            html += `<label class="w80">${chinaName}</label>`;
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          case "notifyForOperations":
                            chinaName = "通知操作";
                            html += `<label class="w80">${chinaName}</label><select name='${propName}' class="form-control w400 inlineBlock">`;
                            notifyForOperationsOption.forEach((el) => {
                              if (el.value == currToEdit[propName]) {
                                html += `<option value='${el.value}' selected>${el.label}</option>`;
                              } else {
                                html += `<option value='${el.value}'>${el.label}</option>`;
                              }
                            });
                            break;
                          case "objectMapper":
                            chinaName = "对象映射器";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "outputClass":
                            chinaName = "输出类别";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "outputHeader":
                            chinaName = "输出标题";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "outputType":
                            chinaName = "输出类型";
                            html += `<label class="w80">${chinaName}</label><select name='${propName}' class="form-control w400 inlineBlock">`;
                            outputTypeOption.forEach((el) => {
                              if (el.value == currToEdit[propName]) {
                                html += `<option value='${el.value}' selected>${el.label}</option>`;
                              } else {
                                html += `<option value='${el.value}'>${el.label}</option>`;
                              }
                            });
                            break;
                          case "passiveMode":
                            chinaName = "被动模式";
                            html += `<label class="w80">${chinaName}</label>`;
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          case "providers":
                            chinaName = "提供者";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "publishTopicName":
                            chinaName = "发布主题名称";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "qualityOfService":
                            chinaName = "服务质量";
                            html += `<label class="w80">${chinaName}</label><select name='${propName}' class="form-control w400 inlineBlock">`;
                            qualityOfServiceOption.forEach((el) => {
                              if (el.value == currToEdit[propName]) {
                                html += `<option value='${el.value}' selected>${el.label}</option>`;
                              } else {
                                html += `<option value='${el.value}'>${el.label}</option>`;
                              }
                            });
                            break;
                          case "sync":
                            chinaName = "同步";
                            html += `<label class="w80">${chinaName}</label>`;
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          case "rawPayload":
                            chinaName = "原始有效载荷";
                            html += `<label class="w80">${chinaName}</label>`;
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          case "receiveBufferSize":
                            chinaName = "接收缓冲区大小";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" type="number" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "reconnectAttemptsMax":
                            chinaName = "重新连接最大尝试次数";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" type="number" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "reconnectBackOffMultiplier":
                            chinaName = "重新连接退避倍增器";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" type="number" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "reconnectDelay":
                            chinaName = "重新连接延迟";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" type="number" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "reconnectDelayMax":
                            chinaName = "重新连接最大延迟";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" type="number" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "reportId":
                            chinaName = "报告编号";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "resourceClasses":
                            chinaName = "资源类别";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "restletMethod":
                            chinaName = "座标法";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "resultType":
                            chinaName = "结果类型";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "resultsFormat":
                            chinaName = "结果格式";
                            html += `<label class="w80">${chinaName}</label><select name='${propName}' class="form-control w400 inlineBlock">`;
                            resultsFormatOption.forEach((el) => {
                              if (el.value == currToEdit[propName]) {
                                html += `<option value='${el.value}' selected>${el.label}</option>`;
                              } else {
                                html += `<option value='${el.value}'>${el.label}</option>`;
                              }
                            });
                            break;
                          case "reuseAddress":
                            chinaName = "重用地址";
                            html += `<label class="w80">${chinaName}</label>`;
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          case "reuseChannel":
                            chinaName = "重用频道";
                            html += `<label class="w80">${chinaName}</label>`;
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          case "schemaLocations":
                            chinaName = "模式位置";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "sendBufferSize":
                            chinaName = "发送缓冲区大小";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" type="number" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "sendWaitInSeconds":
                            chinaName = "发送等待秒数";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" type="number" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "separator":
                            chinaName = "分隔器";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "size":
                            chinaName = "大小";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" type="number" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "skipFaultLogging":
                            chinaName = "跳过故障记录";
                            html += `<label class="w80">${chinaName}</label>`;
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          case "sObjectBlobFieldName":
                            chinaName = "s对象Blob字段名称";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "sObjectClass":
                            chinaName = "对象类";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "sObjectFields":
                            chinaName = "对象字段";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "sObjectId":
                            chinaName = "对象Id";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "sObjectIdName":
                            chinaName = "对象ID名称";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "sObjectIdValue":
                            chinaName = "对象ID值";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "sObjectName":
                            chinaName = "对象搜索";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "sObjectSearch":
                            chinaName = "对象名称";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "sObjectQuery":
                            chinaName = "对象查询";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "serializeNulls":
                            chinaName = "序列化Null";
                            html += `<label class="w80">${chinaName}</label>`;
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          case "stripsAllWhiteSpace":
                            chinaName = "去除所有空白";
                            html += `<label class="w80">${chinaName}</label>`;
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          case "sslContext":
                            chinaName = "ssl上下文";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "subscribeTopicName":
                            chinaName = "订阅主题名称";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "subscribeTopicNames":
                            chinaName = "订阅主题的名称";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "tcpNoDelay":
                            chinaName = "tcp无延迟";
                            html += `<label class="w80">${chinaName}</label>`;
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          case "testConnectionOnStartup":
                            chinaName = "在启动时测试连接";
                            html += `<label class="w80">${chinaName}</label>`;
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          case "trafficClass":
                            chinaName = "交通等级";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" type="number" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "transferLoggingIntervalSeconds":
                            chinaName = "传输日志记录间隔秒";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" type="number" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "transferLoggingLevel":
                            chinaName = "传输记录级别";
                            html += `<label class="w80">${chinaName}</label><select name='${propName}' class="form-control w400 inlineBlock">`;
                            errorHandlerLoggingLevelOption.forEach((el) => {
                              if (el.value == currToEdit[propName]) {
                                html += `<option value='${el.value}' selected>${el.label}</option>`;
                              } else {
                                html += `<option value='${el.value}'>${el.label}</option>`;
                              }
                            });
                            break;
                          case "transferLoggingVerbose":
                            chinaName = "传输日志记录详细";
                            html += `<label class="w80">${chinaName}</label>`;
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          case "timeout":
                            chinaName = "暂停";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" type="number" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "updateTopic":
                            chinaName = "更新主题";
                            html += `<label class="w80">${chinaName}</label>`;
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          case "version":
                            chinaName = "版本";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "willMessage":
                            chinaName = "willMessage";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "willQos":
                            chinaName = "willQos";
                            html += `<label class="w80">${chinaName}</label><select name='${propName}' class="form-control w400 inlineBlock">`;
                            qualityOfServiceOption.forEach((el) => {
                              if (el.value == currToEdit[propName]) {
                                html += `<option value='${el.value}' selected>${el.label}</option>`;
                              } else {
                                html += `<option value='${el.value}'>${el.label}</option>`;
                              }
                            });
                            break;
                          case "willRetain":
                            chinaName = "willRetain";
                            html += `<label class="w80">${chinaName}</label><select name='${propName}' class="form-control w400 inlineBlock">`;
                            willRetainOption.forEach((el) => {
                              if (el.value == currToEdit[propName]) {
                                html += `<option value='${el.value}' selected>${el.label}</option>`;
                              } else {
                                html += `<option value='${el.value}'>${el.label}</option>`;
                              }
                            });
                            break;
                          case "willTopic":
                            chinaName = "willTopic";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "writeTimeout":
                            chinaName = "写入超时";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" type="number" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          default:
                            break;
                        }
                        p.innerHTML = html;
                        comCon.appendChild(p);
                      }

                      rDivTabContent.appendChild(comCon);
                      break;

                    case "filter":
                      let filter = that.creatTab("filterTitle", "filter", "filter_txt", "过滤", "filter");
                      rDivTab.appendChild(filter);

                      // 右侧属性面板的值
                      let filterCon = that.createTabContent("filterCon", "filter", "tab-pane pt10");

                      for (let i = 0; i < that.propsDesc[propPart][advancedItem].length; i++) {
                        let propName = that.propsDesc[propPart][advancedItem][i];
                        let chinaName = null;
                        let p = document.createElement("p");
                        let html = "";
                        switch (propName) {
                          case "antExclude":
                            chinaName = "antExclude";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;

                          case "antFilterCaseSensitive":
                            chinaName = "蚂蚁过滤器区分大小写";
                            html += `<label class="w80">${chinaName}</label>`;
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          case "antInclude":
                            chinaName = "antInclude";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "eagerMaxMessagesPerPoll":
                            chinaName = "期望最大消息数";
                            html += `<label class="w80">${chinaName}</label>`;
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          case "exclude":
                            chinaName = "排除";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "filter":
                            chinaName = "过滤";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "filterDirectory":
                            chinaName = "过滤器目录";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "filterFile":
                            chinaName = "过滤文件";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;

                          case "idempotent":
                            chinaName = "幂";
                            html += `<label class="w80">${chinaName}</label>`;
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          case "idempotentKey":
                            chinaName = "幂等键";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "idempotentRepository":
                            chinaName = "幂等存储库";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "idempotentRepositoryRemoveOnCommit":
                            chinaName = "等幂存储库提交时删除";
                            html += `<label class="w80">${chinaName}</label>`;
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          case "include":
                            chinaName = "包括";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "maxDepth":
                            chinaName = "最大深度";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" type="number" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "maxMessagesPerPoll":
                            chinaName = "最大消息数";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" type="number" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "minDepth":
                            chinaName = "最小深度";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" type="number" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "move":
                            chinaName = "迁移";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "searchTerm":
                            chinaName = "搜索词";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          default:
                            break;
                        }
                        p.innerHTML = html;
                        filterCon.appendChild(p);
                      }

                      rDivTabContent.appendChild(filterCon);
                      break;

                    case "advanceds":
                      let AdTitle = document.createElement("LI");
                      AdTitle.setAttribute("class", "tc");
                      let ad = document.createElement("A");
                      let ad_txt = document.createTextNode("高级");
                      ad.setAttribute("href", "#advanceds");
                      ad.setAttribute("data-toggle", "tab");
                      ad.appendChild(ad_txt);
                      AdTitle.appendChild(ad);
                      rDivTab.appendChild(AdTitle);

                      // 右侧属性面板的值
                      let adCon = document.createElement("DIV");
                      // 将细节内容添加下方面板
                      adCon.setAttribute("id", "advanceds");
                      adCon.setAttribute("class", "tab-pane pt10");

                      for (let i = 0; i < that.propsDesc[propPart][advancedItem].length; i++) {
                        let propName = that.propsDesc[propPart][advancedItem][i];
                        let chinaName = null;
                        let p = document.createElement("p");
                        let html = "";
                        switch (propName) {
                          case "activePortRange":
                            chinaName = "活动端口范围";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "additionalJavaMailProperties":
                            chinaName = "其他JavaMail属性";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "allowStreaming":
                            chinaName = "允许流";
                            html += `<label class="w80">${chinaName}</label>`;
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          case "alwaysPopulateStatement":
                            chinaName = "始终填充语句";
                            html += `<label class="w80">${chinaName}</label>`;
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          case "alternativeBodyHeader":
                            chinaName = "替代正文标题";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "attachmentsContentTransferEncodingResolver":
                            chinaName = "附件内容传输编码解析器";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "autoCreate":
                            chinaName = "自动创建";
                            html += `<label class="w80">${chinaName}</label>`;
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          case "allowSerializedHeaders":
                            chinaName = "允许序列化标题";
                            html += `<label class="w80">${chinaName}</label>`;
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          case "asyncStartListener":
                            chinaName = "异步启动监听器";
                            html += `<label class="w80">${chinaName}</label>`;
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          case "asyncStopListener":
                            chinaName = "异步停止监听器";
                            html += `<label class="w80">${chinaName}</label>`;
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          case "beanRowMapper":
                            chinaName = "映射器";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "bindAddress":
                            chinaName = "绑定地址";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "binding":
                            chinaName = "捆绑";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "bootstrapConfiguration":
                            chinaName = "引导程序配置";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "bulkRequests":
                            chinaName = "大量请求";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "bufferSize":
                            chinaName = "总线";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" type="number" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "bus":
                            chinaName = "缓冲区大小";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "channelGroup":
                            chinaName = "频道组";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "compression":
                            chinaName = "压缩";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" type="number" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "configuration":
                            chinaName = "配置";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "configurationProperties":
                            chinaName = "配置属性";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "connectTimeout":
                            chinaName = "连接超时";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" type="number" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "connectionTimeout":
                            chinaName = "连接超时";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" type="number" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "continuationTimeout":
                            chinaName = "连续超时";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" type="number" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "contentType":
                            chinaName = "内容类型";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "contentTypeResolver":
                            chinaName = "内容类型解析器";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "converter":
                            chinaName = "转换器";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "customCalendar":
                            chinaName = "自定义日历";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "cxfBinding":
                            chinaName = "cxf绑定";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "cxfEndpointConfigurer":
                            chinaName = "cxf端点配置器";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "cxfRsEndpointConfigurer":
                            chinaName = "cxf Rs端点配置器";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "daemon":
                            chinaName = "守护程序";
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          case "debugMode":
                            chinaName = "调试模式";
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          case "defaultBus":
                            chinaName = "默认总线";
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          case "destinationResolver":
                            chinaName = "目标解析器";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "disableStreamCache":
                            chinaName = "禁用流缓存";
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          case "entityResolver":
                            chinaName = "实体解析器";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "errorHandler":
                            chinaName = "错误处理程序";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "errorListener":
                            chinaName = "错误监听器";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "exceptionListener":
                            chinaName = "异常监听器";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "ftpClient":
                            chinaName = "ftp客户端";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "ftpClient":
                            chinaName = "ftp客户端";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "ftpClientConfig":
                            chinaName = "ftp客户端配置";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "ftpClientParameters":
                            chinaName = "ftp客户端参数";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "headerFilterStrategy":
                            chinaName = "标头过滤器策略";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;

                          case "idleConsumerLimit":
                            chinaName = "闲置的消费者限制";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" type="number" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "idleTaskExecutionLimit":
                            chinaName = "空闲任务执行限制";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" type="number" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "ignoreUnsupportedCharset":
                            chinaName = "忽略不支持的字符集";
                            html += `<label class="w80">${chinaName}</label>`;
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          case "ignoreUriScheme":
                            chinaName = "忽略Uri计划";
                            html += `<label class="w80">${chinaName}</label>`;
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          case "includeAllJMSXProperties":
                            chinaName = "包括所有JMSX属性";
                            html += `<label class="w80">${chinaName}</label>`;
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          case "jmsKeyFormatStrategy":
                            chinaName = "jms密钥格式策略";

                            break;
                          case "jobParameters":
                            chinaName = "工作参数";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "mapJmsMessage":
                            chinaName = "映射Jms消息";
                            html += `<label class="w80">${chinaName}</label>`;
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          case "maximumReconnectAttempts":
                            chinaName = "最大重新连接尝试次数";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" type="number" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "maxMessagesPerTask":
                            chinaName = "每个任务的最大消息数";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" type="number" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "maximumPoolSize":
                            chinaName = "最大池大小";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" type="number" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;

                          case "messageConverter":
                            chinaName = "消息转换器";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "messageCreatedStrategy":
                            chinaName = "消息创建策略";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "messageIdEnabled":
                            chinaName = "消息ID已启用";
                            html += `<label class="w80">${chinaName}</label>`;
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          case "mergeProtocolHeaders":
                            chinaName = "合并协议头";
                            html += `<label class="w80">${chinaName}</label>`;
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          case "mtomEnabled":
                            chinaName = "已启用mtom";
                            html += `<label class="w80">${chinaName}</label>`;
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          case "messageListenerContainerFactory":
                            chinaName = "消息侦听器容器工厂";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "messageTimestampEnabled":
                            chinaName = "消息时间戳启用";
                            html += `<label class="w80">${chinaName}</label>`;
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          case "moduleURIResolver":
                            chinaName = "模块URI解析器";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "nativeTransport":
                            chinaName = "本地运输";
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          case "nettyHttpBinding":
                            chinaName = "netty Http绑定";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "orderedThreadPoolExecutor":
                            chinaName = "订购的线程池执行器";
                            html += `<label class="w80">${chinaName}</label>`;
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          case "options":
                            chinaName = "选项";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "parameters":
                            chinaName = "参数";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "performInvocation":
                            chinaName = "执行调用";
                            html += `<label class="w80">${chinaName}</label>`;
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          case "prefixJobNameWithEndpointId":
                            chinaName = "给作业名称加上EndpointId前缀";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "prepareStatementStrategy":
                            chinaName = "准备陈述策略";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "propagateContexts":
                            chinaName = "传播上下文";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "proxy":
                            chinaName = "代理";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "pubSubNoLocal":
                            chinaName = "pubSubNoLocal";
                            html += `<label class="w80">${chinaName}</label>`;
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          case "queue":
                            chinaName = "队列";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "receiveBufferSize":
                            chinaName = "接收缓冲区大小";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" type="number" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "receiveBufferSizePredictor":
                            chinaName = "接收缓冲区大小预测器";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" type="number" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "receiveTimeout":
                            chinaName = "接收超时";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" type="number" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "reconnectDelay":
                            chinaName = "重新连接延迟";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" type="number" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "recoveryInterval":
                            chinaName = "恢复间隔";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" type="number" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "resultHandlerFactory":
                            chinaName = "结果处理程序工厂";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "requestTimeoutCheckerInterval":
                            chinaName = "请求超时检查器间隔";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" type="number" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "parametersCount":
                            chinaName = "参数计数";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" type="number" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "placeholder":
                            chinaName = "占位符";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "prepareStatementStrategy":
                            chinaName = "准备陈述策略";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "properties":
                            chinaName = "特性";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "saxonConfiguration":
                            chinaName = "saxon配置";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "saxonExtensionFunctions":
                            chinaName = "撒克逊扩展功能";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "sendBufferSize":
                            chinaName = "发送缓冲区大小";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" type="number" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "serverAliveCountMax":
                            chinaName = "服务器活动计数最大值";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" type="number" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "serverAliveInterval":
                            chinaName = "服务器活动间隔";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" type="number" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "session":
                            chinaName = "会话";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "siteCommand":
                            chinaName = "site命令";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "skipPayloadMessagePartCheck":
                            chinaName = "跳过有效载荷消息零件检查";
                            html += `<label class="w80">${chinaName}</label>`;
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          case "soTimeout":
                            chinaName = "soTimeout";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" type="number" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "staticQueryContext":
                            chinaName = "静态查询上下文";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "stepwise":
                            chinaName = "stepwise";
                            html += `<label class="w80">${chinaName}</label>`;
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          case "synchronous":
                            chinaName = "同步";
                            html += `<label class="w80">${chinaName}</label>`;
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          case "templateOptions":
                            chinaName = "模板选项";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "throwExceptionOnConnectFailed":
                            chinaName = "在ConnectFailed上引发异常";
                            html += `<label class="w80">${chinaName}</label>`;
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          case "transferException":
                            chinaName = "转移异常";
                            html += `<label class="w80">${chinaName}</label>`;
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          case "transferExchange":
                            chinaName = "转移交易所";
                            html += `<label class="w80">${chinaName}</label>`;
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          case "transferFault":
                            chinaName = "转移故障";
                            html += `<label class="w80">${chinaName}</label>`;
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          case "transformerFactory":
                            chinaName = "变压器厂";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "transformerFactoryClass":
                            chinaName = "变压器厂级";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "time":
                            chinaName = "次";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "timer":
                            chinaName = "计时器";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "timeout":
                            chinaName = "暂停";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" type="number" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "triggerParameters":
                            chinaName = "触发参数";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "usePlaceholder":
                            chinaName = "使用占位符";
                            html += `<label class="w80">${chinaName}</label>`;
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          case "udpByteArrayCodec":
                            chinaName = "udp字节数组编解码器";
                            html += `<label class="w80">${chinaName}</label>`;
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          case "uriResolver":
                            chinaName = "uri解析器";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "usingFixedCamelContextName":
                            chinaName = "使用固定的骆驼上下文名称";
                            html += `<label class="w80">${chinaName}</label>`;
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          case "useMessageIDAsCorrelationID":
                            chinaName = "使用消息ID作为关联ID";
                            html += `<label class="w80">${chinaName}</label>`;
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          case "useInlineAttachments":
                            chinaName = "使用内联附件";
                            html += `<label class="w80">${chinaName}</label>`;
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          case "workerCount":
                            chinaName = "工人数";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" type="number" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "workerGroup":
                            chinaName = "工人组";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" type="number" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "waitForProvisionCorrelationToBeUpdatedCounter":
                            chinaName = "等待供应相关性更新计数器";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" type="number" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "waitForProvisionCorrelationToBeUpdatedThreadSleepingTime":
                            chinaName = "等待供应相关性更新线程休眠时间";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" type="number" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          default:
                            break;
                        }
                        p.innerHTML = html;
                        adCon.appendChild(p);
                      }

                      rDivTabContent.appendChild(adCon);
                      break;

                    case "producer_advanced":
                      let pro_ATitle = document.createElement("LI");
                      pro_ATitle.setAttribute("class", "tc");
                      let pro_A = document.createElement("A");
                      let pro_Atxt = document.createTextNode("生产者高级");
                      pro_A.setAttribute("href", "#producer_advanced");
                      pro_A.setAttribute("data-toggle", "tab");
                      pro_A.appendChild(pro_Atxt);
                      pro_ATitle.appendChild(pro_A);
                      rDivTab.appendChild(pro_ATitle);

                      // 右侧属性面板的值
                      let pro_ACon = document.createElement("DIV");
                      // 将细节内容添加下方面板
                      pro_ACon.setAttribute("id", "producer_advanced");
                      pro_ACon.setAttribute("class", "tab-pane pt10");

                      for (let i = 0; i < that.propsDesc[propPart][advancedItem].length; i++) {
                        let propName = that.propsDesc[propPart][advancedItem][i];
                        let chinaName = null;
                        let p = document.createElement("p");
                        let html = "";
                        switch (propName) {
                          case "allowAdditionalHeaders":
                            chinaName = "允许其他标题";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "allowNullBody":
                            chinaName = "允许空体";
                            html += `<label class="w80">${chinaName}</label>`;
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          case "alwaysCopyMessage":
                            chinaName = "复制消息";
                            html += `<label class="w80">${chinaName}</label>`;
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          case "cachedAddress":
                            chinaName = "缓存的地址";
                            html += `<label class="w80">${chinaName}</label>`;
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          case "chmod":
                            chinaName = "chmod";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "clientPipelineFactory":
                            chinaName = "客户管道厂";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "correlationProperty":
                            chinaName = "相关性";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "disableTimeToLive":
                            chinaName = "禁用生存时间";
                            html += `<label class="w80">${chinaName}</label>`;
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          case "disconnectOnBatchComplete":
                            chinaName = "批量完成时断开连接";
                            html += `<label class="w80">${chinaName}</label>`;
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          case "eagerDeleteTargetFile":
                            chinaName = "删除目标文件";
                            html += `<label class="w80">${chinaName}</label>`;
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          case "forceSendOriginalMessage":
                            chinaName = "强制发送原始消息";
                            html += `<label class="w80">${chinaName}</label>`;
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          case "headerFilterStrategy":
                            chinaName = "标头过滤器策略";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "httpClientAPI":
                            chinaName = "http客户端API";
                            html += `<label class="w80">${chinaName}</label>`;
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          case "includeSentJMSMessageID":
                            chinaName = "包括已发送的JMS消息ID";
                            html += `<label class="w80">${chinaName}</label>`;
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          case "ignoreDeleteMethodMessageBody":
                            chinaName = "忽略删除方法消息正文";
                            html += `<label class="w80">${chinaName}</label>`;
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          case "javaMailSender":
                            chinaName = "javaMail发件人";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "keepLastModified":
                            chinaName = "保持上次修改时间";
                            html += `<label class="w80">${chinaName}</label>`;
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          case "lazyChannelCreation":
                            chinaName = "惰性频道创建";
                            html += `<label class="w80">${chinaName}</label>`;
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          case "lazySessionCreation":
                            chinaName = "懒会话创建";
                            html += `<label class="w80">${chinaName}</label>`;
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          case "maxClientCacheSize":
                            chinaName = "最大客户端缓存大小";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" type="number" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "moveExistingFileStrategy":
                            chinaName = "移动现有文件策略";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "okStatusCodeRange":
                            chinaName = "ok状态码范围";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "producerPoolEnabled":
                            chinaName = "生产者池已启用";
                            html += `<label class="w80">${chinaName}</label>`;
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          case "producerPoolMaxActive":
                            chinaName = "生产者Pool Max Active";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" type="number" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "producerPoolMaxIdle":
                            chinaName = "生产者池最大空闲";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" type="number" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "producerPoolMinEvictableIdle":
                            chinaName = "生产者池最小驱逐空间";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" type="number" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "producerPoolMinIdle":
                            chinaName = "生产者池最小空间";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" type="number" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;

                          case "replyToCacheLevelName":
                            chinaName = "回复缓存级别名称";
                            html += `<label class="w80">${chinaName}</label><select name='${propName}' class="form-control w400 inlineBlock">`;
                            cacheLevelNameOption.forEach((el) => {
                              if (el.value == currToEdit[propName]) {
                                html += `<option value='${el.value}' selected>${el.label}</option>`;
                              } else {
                                html += `<option value='${el.value}'>${el.label}</option>`;
                              }
                            });
                            break;
                          case "replyToDestinationSelectorName":
                            chinaName = "回复目的地选择器名称";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "sendNoop":
                            chinaName = "发送Noop";
                            html += `<label class="w80">${chinaName}</label>`;
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          case "streamMessageTypeEnabled":
                            chinaName = "流消息类型已启用";
                            html += `<label class="w80">${chinaName}</label>`;
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          case "useChannelBuffer":
                            chinaName = "使用通道缓冲区";
                            html += `<label class="w80">${chinaName}</label>`;
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          case "udpConnectionlessSending":
                            chinaName = "udp无连接发送";
                            html += `<label class="w80">${chinaName}</label>`;
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          case "useRelativePath":
                            chinaName = "使用相对路径";
                            html += `<label class="w80">${chinaName}</label>`;
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          default:
                            break;
                        }
                        p.innerHTML = html;
                        pro_ACon.appendChild(p);
                      }

                      rDivTabContent.appendChild(pro_ACon);
                      break;

                    case "codec":
                      let codec = that.creatTab("codecTitle", "codec", "codec_txt", "编解码器", "codec");
                      rDivTab.appendChild(codec);

                      // 右侧属性面板的值
                      let codecCon = that.createTabContent("codecCon", "codec", "tab-pane pt10");

                      for (let i = 0; i < that.propsDesc[propPart][advancedItem].length; i++) {
                        let propName = that.propsDesc[propPart][advancedItem][i];
                        let chinaName = null;
                        let p = document.createElement("p");
                        let html = "";
                        switch (propName) {
                          case "allowDefaultCodec":
                            chinaName = "允许默认编解码器";
                            html += `<label class="w80">${chinaName}</label>`;
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          case "autoAppendDelimiter":
                            chinaName = "自动追加定界符";
                            html += `<label class="w80">${chinaName}</label>`;
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          case "codec":
                            chinaName = "编解码器";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "decoder":
                            chinaName = "解码器";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "decoderMaxLineLength":
                            chinaName = "解码器最大线长";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" type="number" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "decoders":
                            chinaName = "decoders";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "delimiter":
                            chinaName = "定界符";
                            html += `<label class="w80">${chinaName}</label><select name='${propName}' class="form-control w400 inlineBlock">`;
                            delimiterOption.forEach((el) => {
                              if (el.value == currToEdit[propName]) {
                                html += `<option value='${el.value}' selected>${el.label}</option>`;
                              } else {
                                html += `<option value='${el.value}'>${el.label}</option>`;
                              }
                            });
                            break;
                          case "encoder":
                            chinaName = "编码器";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "encoderMaxLineLength":
                            chinaName = "编码器最大线长";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "encoders":
                            chinaName = "encoders";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "encoding":
                            chinaName = "编码方式";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "textline":
                            chinaName = "文字行";
                            html += `<label class="w80">${chinaName}</label>`;
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          case "textlineDelimiter":
                            chinaName = "文本行定界符";
                            html += `<label class="w80">${chinaName}</label><select name='${propName}' class="form-control w400 inlineBlock">`;
                            textlineDelimiterOption.forEach((el) => {
                              if (el.value == currToEdit[propName]) {
                                html += `<option value='${el.value}' selected>${el.label}</option>`;
                              } else {
                                html += `<option value='${el.value}'>${el.label}</option>`;
                              }
                            });
                            break;
                          default:
                            break;
                        }
                        p.innerHTML = html;
                        codecCon.appendChild(p);
                      }

                      rDivTabContent.appendChild(codecCon);
                      break;

                    case "consumer":
                      let consum = that.creatTab("conTitle", "consumer", "consumer_txt", "消费者", "consumer");
                      rDivTab.appendChild(consum);

                      // 右侧属性面板的值
                      let conCon = that.createTabContent("conCon", "consumer", "tab-pane pt10");

                      for (let i = 0; i < that.propsDesc[propPart][advancedItem].length; i++) {
                        let propName = that.propsDesc[propPart][advancedItem][i];
                        let chinaName = null;
                        let p = document.createElement("p");
                        let html = "";
                        switch (propName) {
                          case "acknowledgementModeName":
                            chinaName = "确认模式名称";
                            html += `<label class="w80">${chinaName}</label><select name='${propName}' class="form-control w400 inlineBlock">`;
                            acknowledgementModeNameOption.forEach((el) => {
                              if (el.value == currToEdit[propName]) {
                                html += `<option value='${el.value}' selected>${el.label}</option>`;
                              } else {
                                html += `<option value='${el.value}'>${el.label}</option>`;
                              }
                            });
                            break;
                          case "async":
                            chinaName = "异步";
                            html += `<label class="w80">${chinaName}</label>`;
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          case "asyncConsumer":
                            chinaName = "异步消费";
                            html += `<label class="w80">${chinaName}</label>`;
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          case "autoStartup":
                            chinaName = "自动启动";
                            html += `<label class="w80">${chinaName}</label>`;
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          case "bindingStyle":
                            chinaName = "装订风格";
                            html += `<label class="w80">${chinaName}</label><select name='${propName}' class="form-control w400 inlineBlock">`;
                            bindingStyleOption.forEach((el) => {
                              if (el.value == currToEdit[propName]) {
                                html += `<option value='${el.value}' selected>${el.label}</option>`;
                              } else {
                                html += `<option value='${el.value}'>${el.label}</option>`;
                              }
                            });
                          case "breakBatchOnConsumeFail":
                            chinaName = "消耗失败时中断批处理";
                            html += `<label class="w80">${chinaName}</label>`;
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          case "bridgeErrorHandler":
                            chinaName = "桥接错误处理程序";
                            html += `<label class="w80">${chinaName}</label>`;
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          case "broadcast":
                            chinaName = "播送";
                            html += `<label class="w80">${chinaName}</label>`;
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          case "cacheLevel":
                            chinaName = "缓存级别";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" type="number" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "cacheLevelName":
                            chinaName = "缓存级别名称";
                            html += `<label class="w80">${chinaName}</label><select name='${propName}' class="form-control w400 inlineBlock">`;
                            cacheLevelNameOption.forEach((el) => {
                              if (el.value == currToEdit[propName]) {
                                html += `<option value='${el.value}' selected>${el.label}</option>`;
                              } else {
                                html += `<option value='${el.value}'>${el.label}</option>`;
                              }
                            });
                            break;
                          case "chunked":
                            chinaName = "大块";
                            html += `<label class="w80">${chinaName}</label>`;
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          case "clientMode":
                            chinaName = "客户端模式";
                            html += `<label class="w80">${chinaName}</label>`;
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          case "closeFolder":
                            chinaName = "关闭资料夹";
                            html += `<label class="w80">${chinaName}</label>`;
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          case "concurrentConsumers":
                            chinaName = "并发消费";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" type="number" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "copyTo":
                            chinaName = "移动到";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "cron":
                            chinaName = "计划任务";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "delay":
                            chinaName = "延迟";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" type="number" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "delete":
                            chinaName = "删除";
                            html += `<label class="w80">${chinaName}</label>`;
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          case "deleteJob":
                            chinaName = "deleteJob";
                            html += `<label class="w80">${chinaName}</label>`;
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          case "disconnect":
                            chinaName = "断开";
                            html += `<label class="w80">${chinaName}</label>`;
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          case "enableViewMessages":
                            chinaName = "启用查看消息";
                            html += `<label class="w80">${chinaName}</label>`;
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          case "expectedUpdateCount":
                            chinaName = "预期更新计数";
                            html += `<label class="w80">${chinaName}</label>`;
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          case "feedHeader":
                            chinaName = "供应总管";
                            html += `<label class="w80">${chinaName}</label>`;
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          case "filter":
                            chinaName = "过滤";
                            html += `<label class="w80">${chinaName}</label>`;
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          case "fireNow":
                            chinaName = "立刻工作";
                            html += `<label class="w80">${chinaName}</label>`;
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          case "fixedRate":
                            chinaName = "固定利率";
                            html += `<label class="w80">${chinaName}</label>`;
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          case "handleFailedMessage":
                            chinaName = "处理失败的消息";
                            html += `<label class="w80">${chinaName}</label>`;
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          case "httpMethodRestrict":
                            chinaName = "http方法限制";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "moveFailed":
                            chinaName = "移动失败";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "matchOnUriPrefix":
                            chinaName = "在Uri前缀上匹配";
                            html += `<label class="w80">${chinaName}</label>`;
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          case "maxConcurrentConsumers":
                            chinaName = "最大同时消费";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" type="number" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "maxMessagesPerPoll":
                            chinaName = "每个轮询最大邮件数";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" type="number" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "mimeDecodeHeaders":
                            chinaName = "mimeDecodeHeaders";
                            html += `<label class="w80">${chinaName}</label>`;
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          case "noop":
                            chinaName = "noop";
                            html += `<label class="w80">${chinaName}</label>`;
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          case "lastUpdate":
                            chinaName = "最近更新";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "oids":
                            chinaName = "oids";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "onConsume":
                            chinaName = "在消费上";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "onConsumeBatchComplete":
                            chinaName = "消费批次完成";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "onConsumeFailed":
                            chinaName = "消耗失败";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "pauseJob":
                            chinaName = "停止工作";
                            html += `<label class="w80">${chinaName}</label>`;
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          case "peek":
                            chinaName = "窥视";
                            html += `<label class="w80">${chinaName}</label>`;
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          case "period":
                            chinaName = "周期";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" type="number" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "preMove":
                            chinaName = "移动前";
                            html += `<label class="w80">${chinaName}</label>`;
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          case "preSort":
                            chinaName = "预排序";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "protocol":
                            chinaName = "协议";
                            html += `<label class="w80">${chinaName}</label><select name='${propName}' class="form-control w400 inlineBlock">`;
                            protocolOption.forEach((el) => {
                              if (el.value == currToEdit[propName]) {
                                html += `<option value='${el.value}' selected>${el.label}</option>`;
                              } else {
                                html += `<option value='${el.value}'>${el.label}</option>`;
                              }
                            });
                            break;
                          case "publishedEndpointUrl":
                            chinaName = "已发布的端点网址";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "reconnect":
                            chinaName = "重新连接";
                            html += `<label class="w80">${chinaName}</label>`;
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          case "reconnectInterval":
                            chinaName = "重新连接间隔";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" type="number" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "recoverableJob":
                            chinaName = "可恢复的工作";
                            html += `<label class="w80">${chinaName}</label>`;
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          case "recursive":
                            chinaName = "递归的";
                            html += `<label class="w80">${chinaName}</label>`;
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          case "repeatCount":
                            chinaName = "重复计数";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" type="number" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "replayId":
                            chinaName = "replayId";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" type="number" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "responseBufferSize":
                            chinaName = "响应缓冲区大小";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" type="number" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "restletMethods":
                            chinaName = "Restlet方法";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "resumeDownload":
                            chinaName = "恢复下载";
                            html += `<label class="w80">${chinaName}</label>`;
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          case "replyTo":
                            chinaName = "回复";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "replyToDeliveryPersistent":
                            chinaName = "回复永久交付";
                            html += `<label class="w80">${chinaName}</label>`;
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          case "retries":
                            chinaName = "重试";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" type="number" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "routeEmptyResultSet":
                            chinaName = "路由空结果集";
                            html += `<label class="w80">${chinaName}</label>`;
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          case "selector":
                            chinaName = "选择器";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "send503whenSuspended":
                            chinaName = "暂停时发送503";
                            html += `<label class="w80">${chinaName}</label>`;
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          case "sendEmptyMessageWhenIdle":
                            chinaName = "空闲时发送空消息";
                            html += `<label class="w80">${chinaName}</label>`;
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          case "servletName":
                            chinaName = "servlet名称";
                            html += `<label class="w80">${chinaName}</label><select name='${propName}' class="form-control w400 inlineBlock">`;
                            servletNameOption.forEach((el) => {
                              if (el.value == currToEdit[propName]) {
                                html += `<option value='${el.value}' selected>${el.label}</option>`;
                              } else {
                                html += `<option value='${el.value}'>${el.label}</option>`;
                              }
                            });
                            break;
                          case "snmpCommunity":
                            chinaName = "snmp社区";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "snmpContextEngineId":
                            chinaName = "snmp上下文引擎ID";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "snmpContextEngineId":
                            chinaName = "snmp上下文引擎ID";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "snmpContextName":
                            chinaName = "snmp上下文名称";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "snmpVersion":
                            chinaName = "snmp版本";
                            html += `<label class="w80">${chinaName}</label><select name='${propName}' class="form-control w400 inlineBlock">`;
                            snmpVersionOption.forEach((el) => {
                              if (el.value == currToEdit[propName]) {
                                html += `<option value='${el.value}' selected>${el.label}</option>`;
                              } else {
                                html += `<option value='${el.value}'>${el.label}</option>`;
                              }
                            });
                            break;
                          case "startDelayedSeconds":
                            chinaName = "开始延迟秒";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" type="number" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "stateful":
                            chinaName = "有状态的";
                            html += `<label class="w80">${chinaName}</label>`;
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          case "streamDownload":
                            chinaName = "流下载";
                            html += `<label class="w80">${chinaName}</label>`;
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          case "subscriptionDurable":
                            chinaName = "持久订阅";
                            html += `<label class="w80">${chinaName}</label>`;
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          case "subscriptionName":
                            chinaName = "订阅名称";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "subscriptionShared":
                            chinaName = "订阅已共享";
                            html += `<label class="w80">${chinaName}</label>`;
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          case "sortEntries":
                            chinaName = "排序条目";
                            html += `<label class="w80">${chinaName}</label>`;
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          case "splitEntries":
                            chinaName = "分割条目";
                            html += `<label class="w80">${chinaName}</label>`;
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          case "skipFailedMessage":
                            chinaName = "跳过失败的消息";
                            html += `<label class="w80">${chinaName}</label>`;
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          case "transacted":
                            chinaName = "交易的";
                            html += `<label class="w80">${chinaName}</label>`;
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          case "transferException":
                            chinaName = "转移异常";
                            html += `<label class="w80">${chinaName}</label>`;
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          case "throttleEntries":
                            chinaName = "节流条目";
                            html += `<label class="w80">${chinaName}</label>`;
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          case "timeout":
                            chinaName = "暂停";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" type="number" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "treeList":
                            chinaName = "树列表";
                            html += `<label class="w80">${chinaName}</label>`;
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          case "type":
                            chinaName = "类型";
                            html += `<label class="w80">${chinaName}</label><select name='${propName}' class="form-control w400 inlineBlock">`;
                            typeOption.forEach((el) => {
                              if (el.value == currToEdit[propName]) {
                                html += `<option value='${el.value}' selected>${el.label}</option>`;
                              } else {
                                html += `<option value='${el.value}'>${el.label}</option>`;
                              }
                            });
                            break;
                          case "password":
                            chinaName = "密码";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;

                          case "unseen":
                            chinaName = "无形";
                            html += `<label class="w80">${chinaName}</label>`;
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          case "useIterator":
                            chinaName = "使用迭代器";
                            html += `<label class="w80">${chinaName}</label>`;
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          case "username":
                            chinaName = "用户名";
                            html += `<label class="w80">${chinaName}</label><input class="form-control w400 inlineBlock" id='${propName}' value='${currToEdit[propName]}'>`;
                            break;
                          case "usingFixedCamelContextName":
                            chinaName = "使用固定的骆驼上下文名称";
                            html += `<label class="w80">${chinaName}</label>`;
                            if (currToEdit[propName] == true) {
                              html += `<input name='${propName}' type='checkbox' checked/>`;
                            } else {
                              html += `<input name='${propName}' type='checkbox' />`;
                            }
                            break;
                          default:
                            break;
                        }
                        p.innerHTML = html;
                        conCon.appendChild(p);
                      }

                      rDivTabContent.appendChild(conCon);
                      break;

                    default:
                      break;
                  }
                }
                thirdCon.appendChild(rDivTab);
                thirdCon.appendChild(rDivTabContent);
                rDiv.appendChild(thirdCon);
                break;
              default:
                break;
            }
            // 主div添加左侧tab标签
            div.appendChild(lDiv);
            // 主div添加右侧的tab内容
            div.appendChild(rDiv);
          }
          this.panel.appendChild(div);
        }

        this.bindEvent();
        this.rendering = false;
      }
    }
  }

  creatTab(liName, a, textLabel, text, id) {
    liName = document.createElement("LI");
    liName.setAttribute("class", "tc");
    a = document.createElement("A");
    textLabel = document.createTextNode(text);
    a.setAttribute("href", "#" + id);
    a.setAttribute("data-toggle", "tab");
    a.appendChild(textLabel);
    liName.appendChild(a);
    return liName;
  }

  createTabContent(contentName, id, className) {
    contentName = document.createElement("DIV");
    // 将细节内容添加下方面板
    contentName.setAttribute("id", id);
    contentName.setAttribute("class", className);
    return contentName;
  }
}
export default PropsPanel;
