import { Api, XMLOperate, Helper } from "../utility";
// import Tree from './Tree';

class Modal {
  constructor(target, container, camel) {
    this.target = target;
    this.container = container;
    this.camel = camel;
    this.api = new Api();
    this.helper = new Helper();
  }

  setProps(newProps) {
    Object.assign(this, newProps);
  }

  getProp(prop) {
    return this[prop];
  }

  render() {
    const $container = $(this.container);
    const $target = $(this.target);
    const camel = this.camel;
    const api = this.api;
    const helper = this.helper;

    if (!$container || !$target || !camel) {
      throw new Error("container or target or camel lose");
    } else {
      if ($target.attr("id") == "showCode") {
        const xml = camel.toXML();

        api.getTemplete("showCodeModal-tmpl").done((tml) => {
          const $html = helper.handleTemplete(tml, { xml }, "showCodeModal-tmpl");
          $container.html($html);
        });
      } else if ($target.attr("data-id") == "showEditor") {
        $.when(api.getTemplete("editorModal-tmpl"), api.getJSON()).done((tml, data) => {
          const $html = helper.handleTemplete(tml[0], data[0], "editorModal-tmpl");
          $container.html($html);
        });
      }

      this.bindEvent();
    }
  }

  bindEvent() {
    const $container = $(this.container);
    // const tree = Tree.getInstance();
    const camel = this.camel;

    $container.off("click", "#xmlTextConfirm").on("click", "#xmlTextConfirm", function (e) {
      const xmlString = $container.find("#xmlCode").val();
      const parse = new DOMParser();
      const xmldoc = parse.parseFromString(xmlString, "text/xml");

      new XMLOperate(xmldoc, camel).parseXML();
      camel.paint();
      // tree.render();
    });
  }
}

export default Modal;
