import { Archor, Graphics, Resources, Sequence } from "../utility";
import { CamelElement, Relation } from "../element";
import {
  ActiveMQ,
  Atom,
  Bean,
  CXF,
  CXFRS,
  ControlBus,
  Direct,
  DirectVM,
  FTP,
  FTPS,
  File,
  Generic,
  IMAP,
  IMAPSecure,
  JDBC,
  JGroups,
  JMS,
  Language,
  Log,
  MQTT,
  MVEL,
  Mina2,
  Netty,
  NettyHTTP,
  Netty4,
  Netty4HTTP,
  POP3,
  POP3S,
  Process,
  Quartz,
  Quartz2,
  Restlet,
  RSS,
  SAPNetWeaver,
  Scheduler,
  SEDA,
  Servlet,
  SFTP,
  SMTP,
  SMTPS,
  SNMP,
  SQL,
  Timer,
  VM,
  XQuery,
  XSLT,
} from "../element/compontent";
import { Aggregate, Choice, ClaimCheck, Filter, IdempotentConsumer, Hystrix, LoadBalance, Multicast, Pipeline, RecipientList, Resequence, Route, RoutingSlip, Saga, Sort, Split, When, WireTap } from "../element/routing";
import { Delay, DoCatch, DoFinally, DoTry, Intercept, InterceptFrom, InterceptSendToEndpoint, Loop, OnCompletion, OnException, OnFallback, Rollback, Throttle, ThrowException, Transacted } from "../element/controlflow";
import {
  ConvertBodyTo,
  Enrich,
  InOnly,
  InOut,
  Marshal,
  PollEnrich,
  RemoveHeader,
  RemoveHeaders,
  RemoveProperties,
  RemoveProperty,
  SetBody,
  SetExchangePattern,
  SetFaultBody,
  SetHeader,
  SetOutHeader,
  SetProperty,
  Transform,
  Unmarshal,
} from "../element/transformation";
import { Aop, Policy, Sample, Stop, Threads, Validate } from "../element/miscellaneous";
import { FileManager } from "less";
class CamelPanel {
  constructor(canvas) {
    this.canvas = canvas;
    this.g = new Graphics(canvas.getContext("2d"));
    this.width = 1500; // canvas的宽度
    this.height = 1536;
    this._currToElem = null; // 当前选中的组件
    this.elem = null; //元素在未添加进区域的临时存放地
    this._elems = []; // 存在画布上的所有数组
    this._routeEle = null; // 其他元素将要存放在哪一个route中
    this._status = CamelPanel.ACTION_NORMAL; // 经过画布的状态【默认是鼠标方式】
    this.selectedArchor = null; //是否有被选中的锚点，用于移动时拖拽元素
    this.archor = new Archor(); // 锚点实例
    this.isAllowDraw = false; //画布绘图开关
  }

  paint() {
    const g = this.g;
    //清空画布
    g.save();
    g.setColor("#fff");
    g.fillRect(0, 0, this.width, this.height);
    // 画背景网格
    g.setColor(Resources.COLOR.lightGray);
    // 画纵向线
    for (let i = 0; i < this.width / 10; i++) {
      g.drawLine(i * 10, 0, i * 10, this.height);
    }
    // 画横向线
    for (let i = 0; i < this.width / 10; i++) {
      g.drawLine(0, i * 10, this.width, i * 10);
    }
    g.setColor(Resources.COLOR.grey);
    for (let i = 0; i < this.width / 50; i++) {
      g.drawLine(i * 50, 0, i * 50, this.height);
    }
    for (let i = 0; i < this.width / 50; i++) {
      g.drawLine(0, i * 50, this.width, i * 50);
    }
    g.restore();

    // todo 画元素【需要先画route，再画子元素才能使得子元素覆盖在上面】
    if (this._elems.length > 0) {
      // 先画route
      this._elems.filter((ele) => {
        if (ele instanceof Route) ele.paint(this.g);
      });
      // 再画其他元素(保持route在最下方)
      this._elems.filter((ele) => {
        if (!(ele instanceof Route)) ele.paint(this.g);
      });

      // 再画其他子元素
    }

    //绘制尚未放入区域的移动中的元素
    if (this.elem != null) {
      this.elem.paint(g);
    }
  }

  repaint() {
    this.paint();
  }

  init(params) {
    this.canvas.onmousemove = (e) => {
      this.handleMouseMove(e);
    };

    this.canvas.onmousedown = (e) => {
      this.handleMouseDown(e);
    };

    this.canvas.onmouseup = (e) => {
      this.handleMouseUp(e);
    };
    this.setProps(params);
    this.repaint();
  }

  setProps(newProps) {
    Object.assign(this, newProps);
  }

  handleMouseDown(e) {
    // 鼠标在画布的位置
    const x = e.offsetX,
      y = e.offsetY;

    // 开启绘画画布开关
    this.isAllowDraw = true;

    // 清空上一次选中的元素
    this.resetCurrToEdit();
    let em = this.chkSelectedElement(x, y);
    if (em != null) {
      // 设置抓取点
      if (em instanceof CamelElement) {
        em._handlePointX = x - em.x;
        em._handlePointY = y - em.y;
      }

      // 重新赋值给当前的锚点实例
      const params = { x: em.x, y: em.y, targetW: em.width, targetH: em.height };
      this.archor.setProps(params);
      // 锚点的坐标位置
      const archorPos = this.archor.getArchorPosition(x, y);
      if (em && archorPos) {
        this.selectedArchor = archorPos;
        em.setProps({ _handlePointX: x, _handlePointY: y });
        return false;
      }

      if (this._status == CamelPanel.ACTION_BREAK_LINE) {
        if (em instanceof Relation) {
          let relation = em;
          relation.setStartpoint(x, y);
        }
      } else if (this._status == CamelPanel.ACTION_REMOVE) {
        if (em instanceof Relation) {
          let r = em;
          this.deleteMSG = "相关流程已处理,不能删除!";
        }
        if (em instanceof CamelElement) {
          let nd = em;
          if (em.rid != null && nd._iscurrent) {
            this.deleteMSG = "当前节点在处理中,不能删除!";
          } else {
            let ems = this._elems;
            for (let i = 0; i < ems.length && this.deleteMSG == "null"; i++) {
              let elem = ems[i];
              if (elem instanceof Relation) {
                let rl = elem;
                if (((rl.startnodeid != null && rl.startnodeid == em.rid) || (rl.endnodeid != null && rl.endnodeid == em.rid)) && rl.ispassed) {
                  this.deleteMSG = "相关流程已处理,不能删除!";
                }
              }
            }
          }
        }
        if (this.deleteMSG == "null" || this.deleteMSG == null || this.deleteMSG == "") {
          this.removeElement(em);
        } else {
          alert(this.deleteMSG);
        }
      } else {
        if (this.elem instanceof Relation && em instanceof CamelElement) {
          let r = this.elem;
          if (r.getStartEle() == null && em != null) {
            r.setStartId(em);
            let node = em;
            let point = { x: node.x, y: node.y };
            r.addVector(point);
          }
        } else if (em instanceof Relation) {
          this.changestatus(CamelPanel.ACTION_BREAK_LINE);
          console.log("待处理");
        } else {
          // 用于元素拖拽
          console.log("暂未发现用处");
          // this._currToElem = em;
          // this._currToElem.moveTo(x, y);
        }
      }
    } else {
      // 关连线位置没有开始元素和结束元素链接【暂不处理，图标会显示禁止符号】
      console.log(e);
    }

    // 判断是否选中元素
    this._currToElem = this.chkSelectedElement(x, y) || this.elem; // 放下时又重新选中了这个元素

    // 如果抓住的是路由元素，需要给每一个路由子元素记录相对于路由元素的值
    if (this._currToElem && this._currToElem.scope == "route") {
      // 给当前路由添加四角锚点
      this._currToElem.setProps({ isOpenArchor: true });
      this._currToElem.childNode.map((item) => {
        item.setProps({ _offsetRoute: { x: item.x - this._currToElem.x, y: item.y - this._currToElem.y } });
      });
    }
    console.log("选中元素", this._currToElem);
  }
  handleMouseMove(e) {
    console.log(this._status);
    const x = e.offsetX,
      y = e.offsetY;

    // 如果状态不是删除就修改手势(不加判断删除不了元素)
    if (this._status != CamelPanel.ACTION_REMOVE) {
      let em = this.chkSelectedElement(x, y);
      if (em != null && this._status != CamelPanel.ACTION_REMOVE) {
        // 在元素范围内改变鼠标的状态
        this.changestatus(CamelPanel.ACTION_IN_ELEMENT);
      } else {
        this.changestatus(CamelPanel.ACTION_NORMAL);
      }
      // 获取当前鼠标相对于画布的位置
      if (!this.isAllowDraw) {
        // console.log(8888);
      } else {
        //允许绘画
        // console.log(666);
        // 拖拽未进入画布的元素
        if (this.elem != null) {
          this.elem.setProps({ x: x, y: y });
        } else {
          this.handleMouseDrag(e);
        }
      }

      this.repaint();
    }
  }
  handleMouseUp(e) {
    // 关闭画布绘画开关
    this.isAllowDraw = false;
    // 鼠标放开的时候锚点选中的开关清空
    this.selectedArchor = null;
    // 更新鼠标的坐标位置【要掉用camelElement中的方法改变坐标位置】
    const x = e.offsetX,
      y = e.offsetY;
    let em = this.chkSelectedElement(x, y);
    if (this.elem) {
      this._currToElem = this.elem;
      this._currToElem.moveTo(x, y); //当前选择元素设置x和y
      // 需要先判断直接放置的是否为路由还是其他元素
      if (this._currToElem && this._currToElem.scope == "route") {
        this._elems.push(this._currToElem);
      } else if (this.ckInRouteEle(x, y)) {
        this._elems.push(this._currToElem);
        // 将当前的元素放置到所在route范围中
        this._routeEle.childNode.push(this._currToElem);
        // 当前的元素父级是哪一个
        this._currToElem.parent = this._routeEle;
        // todo 当前元素的父级增大(需要判断当前元素的x+宽，y+高，必须要在父级路由里面)
        // this._routeEle.setProps({width: this._routeEle.width + 10, height: this._routeEle.height + this._currToElem.height})
      }

      if (this._currToElem != null && this._currToElem instanceof Relation && (em == null || em instanceof CamelElement)) {
        let r = this._currToElem;
        if (r.getEndEle() == null) {
          if (em != null) {
            let have = false;
            this._elems.forEach(function (val, ind) {
              if (val instanceof Relation) {
                if (val._startelemid == r._startelemid && val._endelemid == em.rid) {
                  haveNum = ind;
                  have = true;
                }
              }
            });
            if (have) {
              this._elems = this._removeElementFromArray(this._elems, r);
              alert("同方向关联线有且仅有一条");
            } else {
              r.setEndId(em);
              let node = em;

              let point = { x: node.x, y: node.y };
              r.addVector(point);
            }
          }
          console.log(3333);
          if (em == null) {
            // this._elems = this._removeElementFromArray(this._elems, r);
          }
        } else {
          console.log("2222");
        }
      }
    }
    // 元素添加到画布之后要清空未添加的元素[relation不属于选中的元素]
    this.elem = null;
    // this.resetCurrToEdit();【先注释，属性面板无法选中展示】
    this._routeEle = null;
    this.changestatus(CamelPanel.ACTION_NORMAL);
    // 重新渲染
    this.repaint();
    if (window.camelParams && window.camelParams.lTree) {
      window.camelParams.lTree.render();
      console.log("chongxinxuanran");
    }
    console.log(this._elems);
  }
  handleMouseDrag(e) {
    const x = e.offsetX,
      y = e.offsetY;
    console.log("drag");
    if (this.elem != null && this._status != CamelPanel.ACTION_BREAK_LINE && this.elem instanceof Relation) {
      // 从一个结点到另一个结点画流程的拖拉过程中
      if (this.elem.getEndEle() == null) {
        this.elem.moveTo(x, y);
      } else {
        console.log("待处理2");
      }
    } else if (this._currToElem != null && this._status != CamelPanel.ACTION_BREAK_LINE) {
      // 判断移动的是不是大的路由
      this.addElementToRoute();
      this._currToElem.moveTo(x, y);
    } else if (this._currToElem != null && this._currToElem instanceof Relation && this._status == CamelPanel.ACTION_BREAK_LINE) {
      console.log(9999);
    }
    this.repaint();
  }

  /**
   * 检查元素是否有关连线
   */
  checkHasRealtion() {
    var elems = this._elems;
    var relationCount = 0;
    var relation = [],
      node = [];

    if (elems.length > 0) {
      for (var i = 0; i < elems.length; i++) {
        if (elems[i] instanceof Relation) {
          relationCount++;
          relation.push(elems[i]);
        } else {
          node.push(elems[i]);
        }
      }

      for (var nl = 0; nl < node.length; nl++) {
        if (!node[nl].hasRelation(relation)) {
          return false;
        }
      }
      return true;
    }

    // alert("请创建节点元素！");
    return false;
  }

  /**
   * 将画布上的区域及元素转变为树结构，用以构建树形菜单
   * @return 返回树形格式的数据
   */
  transformToTree() {
    const elems = this._elems.filter((item) => item.scope == "route");

    let tree = [];
    let cmp = [];
    let camelTree = {
      text: "Camel Context",
      collapseIcon: "glyphicon glyphicon-plus",
      expandIcon: "glyphicon glyphicon-minus",
      nodes: [],
    };

    if (elems.length > 0) {
      for (let x = 0; x < elems.length; x++) {
        // 将元素转换为树
        cmp.push({
          text: "Route",
          collapseIcon: "glyphicon glyphicon-plus",
          expandIcon: "glyphicon glyphicon-minus",
          nodes: elems[x].getEleToTree(elems[x].childNode),
        });

        // 继续遍历route中的元素
      }
    }

    camelTree.nodes.push(...cmp);

    // for(let i = 0, len = chunk.length;i < len;i++) {
    // 	let data = chunk[i].getNodeConfigInfo();
    // 	reportMain.nodes.push(data);
    // }

    tree.push(camelTree);
    return tree;
  }

  /**
   * 改变鼠标状态
   *
   * @param status
   * @roseuid 3E0A6E1A0258
   */
  changestatus(status) {
    this._status = status;
    switch (this._status) {
      case CamelPanel.ACTION_NORMAL:
        this.canvas.style.cursor = "default";
        break;
      case CamelPanel.ACTION_IN_ELEMENT:
        this.canvas.style.cursor = "pointer";
        break;
      case CamelPanel.ACTION_BREAK_LINE:
        this.canvas.style.cursor = "pointer";
        break;
      case CamelPanel.ACTION_NOT_ALLOW:
        this.canvas.style.cursor = "not-allowed";
        break;
      case CamelPanel.ACTION_REMOVE:
        this.canvas.style.cursor = "pointer";
        break;
      case CamelPanel.ACTION_ARCHOR_UPPER_LEFT:
        this.canvas.style.cursor = "nw-resize";
        break;
      case CamelPanel.ACTION_ARCHOR_UPPER_RIGHT:
        this.canvas.style.cursor = "ne-resize";
        break;
      case CamelPanel.ACTION_ARCHOR_LOWER_LEFT:
        this.canvas.style.cursor = "sw-resize";
        break;
      case CamelPanel.ACTION_ARCHOR_LOWER_RIGHT:
        this.canvas.style.cursor = "se-resize";
        break;
      default:
        this.canvas.style.cursor = "initial";
    }
  }

  /**
   * 将元素添加到route中
   */
  addElementToRoute() {
    let currEle = this._currToElem;
    if (currEle.scope == "route") {
      // 计算当前元素左侧到route的距离
      currEle.childNode.map((item) => {
        if (!(item instanceof Relation)) {
          item.directTo(currEle.x + item._offsetRoute.x, currEle.y + item._offsetRoute.y);
          console.log("添加元素到路由上");
        }
      });
    } else {
      // 判断是不是移除自己父级的路由范围【移除就删除childnode】
      let cp = currEle.parent;
      if (currEle.x < cp.x || currEle.x > cp.x + cp.width - currEle.width || currEle.y < cp.y || currEle.y > cp.y + cp.height - currEle.height) {
        console.log("超出当前边界移除元素,且需要判断是否在另外的路由");
        // 当前元素显示错误的标志
        // 父元素移除当前的元素,当前元素移除父元素
        if (cp.childNode && cp.childNode.length > 0) {
          cp.childNode = this._removeElementFromArray(cp.childNode, currEle);
          currEle.parent = {};
        }
      } else {
        // 检查在那个元素里面[如果又route就不push]
        let em = this.ckInWhichRouter(currEle);
        // 判断em有值才进行添加
        if (em) {
          // 先判断是否已经有添加了元素避免重复添加
          const flag = this.arrayDuplication(em.childNode, currEle);
          // 给所在的父级路由的children添加当前元素，给当前元素的parent添加父级元素
          if (!flag) {
            em.childNode.push(currEle);
            currEle.parent = em;
          }
          console.log("检查在那个元素里面", em);
        }
      }
    }
  }

  /**
   * 数组去重(判断元素在数组中是否存在)
   * @param {需要判断有无重复元素的数组} arr
   * @param {当前元素} addEle
   */
  arrayDuplication(arr, addEle) {
    for (let a = 0; a < arr.length; a++) {
      if (arr[a].rid == addEle.rid) {
        return true;
      }
    }
    return false;
  }

  // 删除元素
  removeElement(emn) {
    let delArr = [];
    if (emn != null) {
      if (emn instanceof CamelElement) {
        let v = this._elems;
        for (let i = 0; i < v.length; i++) {
          let elem = v[i];
          if (elem instanceof Relation) {
            let r = elem;
            if ((r._startelemid != null && r._startelemid == emn.rid) || (r._endelemid != null && r._endelemid == emn.rid)) {
              this._elems = this._removeElementFromArray(this._elems, r);
            }
          }
        }
        // 移除路由及路由中的所有元素
        if (emn.scope == "route") {
          delArr.push(...emn.childNode);
          for (let j = 0; j < delArr.length; j++) {
            this._elems = this._removeElementFromArray(this._elems, delArr[j]);
            emn.childNode.splice(j, 1);
          }
        } else {
          // 当前元素的父级也需要移除当前元素
          let currParent = emn.parent.childNode;
          if (currParent && currParent.length > 0) {
            for (let k = 0; k < currParent.length; k++) {
              // 如果当前元素在当前元素的父级孩子中能找到，从当前元素的父级孩子中移除
              if (emn.rid == currParent[k].rid) {
                currParent.splice(k, 1);
              }
            }
          }
        }
        this._elems = this._removeElementFromArray(this._elems, emn);
      } else {
        this._elems = this._removeElementFromArray(this._elems, emn);
      }
    }
    this._currToElem = null;
  }

  _removeElementFromArray(array, element) {
    for (let i = 0; i < array.length; i++) {
      let em = array[i];
      if (em.rid != null && em.rid == element.rid) {
        return [...array.slice(0, i), ...array.slice(i + 1)];
      }
    }
  }
  // 删除未添加到画布的元素
  delElement() {
    this.elem = null;
    this.isAllowDraw = false;
  }

  // 添加组件到画布上
  addRoute() {
    let elem = new Route();
    elem.rid = Sequence.createId();
    this.elem = elem;
    this.isAllowDraw = true;
    this.changestatus(CamelPanel.ACTION_NORMAL);
  }
  // component
  addActiveMQ() {
    let elem = new ActiveMQ();
    elem.rid = Sequence.createId();
    this.elem = elem;
    this.isAllowDraw = true;
    this.changestatus(CamelPanel.ACTION_NORMAL);
  }
  addAtom() {
    let elem = new Atom();
    elem.rid = Sequence.createId();
    this.elem = elem;
    this.isAllowDraw = true;
    this.changestatus(CamelPanel.ACTION_NORMAL);
  }
  addBean() {
    let elem = new Bean();
    elem.rid = Sequence.createId();
    this.elem = elem;
    this.isAllowDraw = true;
    this.changestatus(CamelPanel.ACTION_NORMAL);
  }
  addCXF() {
    let elem = new CXF();
    elem.rid = Sequence.createId();
    this.elem = elem;
    this.isAllowDraw = true;
    this.changestatus(CamelPanel.ACTION_NORMAL);
  }
  addCXFRS() {
    let elem = new CXFRS();
    elem.rid = Sequence.createId();
    this.elem = elem;
    this.isAllowDraw = true;
    this.changestatus(CamelPanel.ACTION_NORMAL);
  }
  addControlBus() {
    let elem = new ControlBus();
    elem.rid = Sequence.createId();
    this.elem = elem;
    this.isAllowDraw = true;
    this.changestatus(CamelPanel.ACTION_NORMAL);
  }
  addDirect() {
    let elem = new Direct();
    elem.rid = Sequence.createId();
    this.elem = elem;
    this.isAllowDraw = true;
    this.changestatus(CamelPanel.ACTION_NORMAL);
  }
  addDirectVM() {
    let elem = new DirectVM();
    elem.rid = Sequence.createId();
    this.elem = elem;
    this.isAllowDraw = true;
    this.changestatus(CamelPanel.ACTION_NORMAL);
  }
  addFTP() {
    let elem = new FTP();
    elem.rid = Sequence.createId();
    this.elem = elem;
    this.isAllowDraw = true;
    this.changestatus(CamelPanel.ACTION_NORMAL);
  }
  addFTPS() {
    let elem = new FTPS();
    elem.rid = Sequence.createId();
    this.elem = elem;
    this.isAllowDraw = true;
    this.changestatus(CamelPanel.ACTION_NORMAL);
  }
  addFile() {
    let elem = new File();
    elem.rid = Sequence.createId();
    this.elem = elem;
    this.isAllowDraw = true;
    this.changestatus(CamelPanel.ACTION_NORMAL);
  }
  addGeneric() {
    let elem = new Generic();
    elem.rid = Sequence.createId();
    this.elem = elem;
    this.isAllowDraw = true;
    this.changestatus(CamelPanel.ACTION_NORMAL);
  }
  addIMAP() {
    let elem = new IMAP();
    elem.rid = Sequence.createId();
    this.elem = elem;
    this.isAllowDraw = true;
    this.changestatus(CamelPanel.ACTION_NORMAL);
  }
  addIMAPSecure() {
    let elem = new IMAPSecure();
    elem.rid = Sequence.createId();
    this.elem = elem;
    this.isAllowDraw = true;
    this.changestatus(CamelPanel.ACTION_NORMAL);
  }
  addJDBC() {
    let elem = new JDBC();
    elem.rid = Sequence.createId();
    this.elem = elem;
    this.isAllowDraw = true;
    this.changestatus(CamelPanel.ACTION_NORMAL);
  }
  addJGroups() {
    let elem = new JGroups();
    elem.rid = Sequence.createId();
    this.elem = elem;
    this.isAllowDraw = true;
    this.changestatus(CamelPanel.ACTION_NORMAL);
  }
  addJMS() {
    let elem = new JMS();
    elem.rid = Sequence.createId();
    this.elem = elem;
    this.isAllowDraw = true;
    this.changestatus(CamelPanel.ACTION_NORMAL);
  }
  addLanguage() {
    let elem = new Language();
    elem.rid = Sequence.createId();
    this.elem = elem;
    this.isAllowDraw = true;
    this.changestatus(CamelPanel.ACTION_NORMAL);
  }
  addLog() {
    let elem = new Log();
    elem.rid = Sequence.createId();
    this.elem = elem;
    this.isAllowDraw = true;
    this.changestatus(CamelPanel.ACTION_NORMAL);
  }
  addMQTT() {
    let elem = new MQTT();
    elem.rid = Sequence.createId();
    this.elem = elem;
    this.isAllowDraw = true;
    this.changestatus(CamelPanel.ACTION_NORMAL);
  }
  addMVEL() {
    let elem = new MVEL();
    elem.rid = Sequence.createId();
    this.elem = elem;
    this.isAllowDraw = true;
    this.changestatus(CamelPanel.ACTION_NORMAL);
  }
  addMina2() {
    let elem = new Mina2();
    elem.rid = Sequence.createId();
    this.elem = elem;
    this.isAllowDraw = true;
    this.changestatus(CamelPanel.ACTION_NORMAL);
  }
  addNetty() {
    let elem = new Netty();
    elem.rid = Sequence.createId();
    this.elem = elem;
    this.isAllowDraw = true;
    this.changestatus(CamelPanel.ACTION_NORMAL);
  }
  addNettyHTTP() {
    let elem = new NettyHTTP();
    elem.rid = Sequence.createId();
    this.elem = elem;
    this.isAllowDraw = true;
    this.changestatus(CamelPanel.ACTION_NORMAL);
  }
  addNetty4() {
    let elem = new Netty4();
    elem.rid = Sequence.createId();
    this.elem = elem;
    this.isAllowDraw = true;
    this.changestatus(CamelPanel.ACTION_NORMAL);
  }
  addNetty4HTTP() {
    let elem = new Netty4HTTP();
    elem.rid = Sequence.createId();
    this.elem = elem;
    this.isAllowDraw = true;
    this.changestatus(CamelPanel.ACTION_NORMAL);
  }
  addPOP3() {
    let elem = new POP3();
    elem.rid = Sequence.createId();
    this.elem = elem;
    this.isAllowDraw = true;
    this.changestatus(CamelPanel.ACTION_NORMAL);
  }
  addPOP3S() {
    let elem = new POP3S();
    elem.rid = Sequence.createId();
    this.elem = elem;
    this.isAllowDraw = true;
    this.changestatus(CamelPanel.ACTION_NORMAL);
  }
  addProcess() {
    let elem = new Process();
    elem.rid = Sequence.createId();
    this.elem = elem;
    this.isAllowDraw = true;
    this.changestatus(CamelPanel.ACTION_NORMAL);
  }
  addQuartz() {
    let elem = new Quartz();
    elem.rid = Sequence.createId();
    this.elem = elem;
    this.isAllowDraw = true;
    this.changestatus(CamelPanel.ACTION_NORMAL);
  }
  addQuartz2() {
    let elem = new Quartz2();
    elem.rid = Sequence.createId();
    this.elem = elem;
    this.isAllowDraw = true;
    this.changestatus(CamelPanel.ACTION_NORMAL);
  }
  addRestlet() {
    let elem = new Restlet();
    elem.rid = Sequence.createId();
    this.elem = elem;
    this.isAllowDraw = true;
    this.changestatus(CamelPanel.ACTION_NORMAL);
  }
  addRSS() {
    let elem = new RSS();
    elem.rid = Sequence.createId();
    this.elem = elem;
    this.isAllowDraw = true;
    this.changestatus(CamelPanel.ACTION_NORMAL);
  }
  addSAPNetWeaver() {
    let elem = new SAPNetWeaver();
    elem.rid = Sequence.createId();
    this.elem = elem;
    this.isAllowDraw = true;
    this.changestatus(CamelPanel.ACTION_NORMAL);
  }
  addSEDA() {
    let elem = new SEDA();
    elem.rid = Sequence.createId();
    this.elem = elem;
    this.isAllowDraw = true;
    this.changestatus(CamelPanel.ACTION_NORMAL);
  }
  addSFTP() {
    let elem = new SFTP();
    elem.rid = Sequence.createId();
    this.elem = elem;
    this.isAllowDraw = true;
    this.changestatus(CamelPanel.ACTION_NORMAL);
  }
  addSMTP() {
    let elem = new SMTP();
    elem.rid = Sequence.createId();
    this.elem = elem;
    this.isAllowDraw = true;
    this.changestatus(CamelPanel.ACTION_NORMAL);
  }
  addSMTPS() {
    let elem = new SMTPS();
    elem.rid = Sequence.createId();
    this.elem = elem;
    this.isAllowDraw = true;
    this.changestatus(CamelPanel.ACTION_NORMAL);
  }
  addSNMP() {
    let elem = new SNMP();
    elem.rid = Sequence.createId();
    this.elem = elem;
    this.isAllowDraw = true;
    this.changestatus(CamelPanel.ACTION_NORMAL);
  }
  addSQL() {
    let elem = new SQL();
    elem.rid = Sequence.createId();
    this.elem = elem;
    this.isAllowDraw = true;
    this.changestatus(CamelPanel.ACTION_NORMAL);
  }
  addSalesforce() {
    let elem = new Salesforce();
    elem.rid = Sequence.createId();
    this.elem = elem;
    this.isAllowDraw = true;
    this.changestatus(CamelPanel.ACTION_NORMAL);
  }
  addScheduler() {
    let elem = new Scheduler();
    elem.rid = Sequence.createId();
    this.elem = elem;
    this.isAllowDraw = true;
    this.changestatus(CamelPanel.ACTION_NORMAL);
  }
  addServlet() {
    let elem = new Servlet();
    elem.rid = Sequence.createId();
    this.elem = elem;
    this.isAllowDraw = true;
    this.changestatus(CamelPanel.ACTION_NORMAL);
  }
  addTimer() {
    let elem = new Timer();
    elem.rid = Sequence.createId();
    this.elem = elem;
    this.isAllowDraw = true;
    this.changestatus(CamelPanel.ACTION_NORMAL);
  }
  addVM() {
    let elem = new VM();
    elem.rid = Sequence.createId();
    this.elem = elem;
    this.isAllowDraw = true;
    this.changestatus(CamelPanel.ACTION_NORMAL);
  }
  addXQuery() {
    let elem = new XQuery();
    elem.rid = Sequence.createId();
    this.elem = elem;
    this.isAllowDraw = true;
    this.changestatus(CamelPanel.ACTION_NORMAL);
  }
  addXSLT() {
    let elem = new XSLT();
    elem.rid = Sequence.createId();
    this.elem = elem;
    this.isAllowDraw = true;
    this.changestatus(CamelPanel.ACTION_NORMAL);
  }
  // routing
  addAggregate() {
    let elem = new Aggregate();
    elem.rid = Sequence.createId();
    this.elem = elem;
    this.isAllowDraw = true;
    this.changestatus(CamelPanel.ACTION_NORMAL);
  }
  addChoice() {
    let elem = new Choice();
    elem.rid = Sequence.createId();
    this.elem = elem;
    this.isAllowDraw = true;
    this.changestatus(CamelPanel.ACTION_NORMAL);
  }
  addClaimCheck() {
    let elem = new ClaimCheck();
    elem.rid = Sequence.createId();
    this.elem = elem;
    this.isAllowDraw = true;
    this.changestatus(CamelPanel.ACTION_NORMAL);
  }
  addFilter() {
    let elem = new Filter();
    elem.rid = Sequence.createId();
    this.elem = elem;
    this.isAllowDraw = true;
    this.changestatus(CamelPanel.ACTION_NORMAL);
  }
  addHystrix() {
    let elem = new Hystrix();
    elem.rid = Sequence.createId();
    this.elem = elem;
    this.isAllowDraw = true;
    this.changestatus(CamelPanel.ACTION_NORMAL);
  }
  addIdempotentConsumer() {
    let elem = new IdempotentConsumer();
    elem.rid = Sequence.createId();
    this.elem = elem;
    this.isAllowDraw = true;
    this.changestatus(CamelPanel.ACTION_NORMAL);
  }
  addLoadBalance() {
    let elem = new LoadBalance();
    elem.rid = Sequence.createId();
    this.elem = elem;
    this.isAllowDraw = true;
    this.changestatus(CamelPanel.ACTION_NORMAL);
  }
  addMulticast() {
    let elem = new Multicast();
    elem.rid = Sequence.createId();
    this.elem = elem;
    this.isAllowDraw = true;
    this.changestatus(CamelPanel.ACTION_NORMAL);
  }
  addPipeline() {
    let elem = new Pipeline();
    elem.rid = Sequence.createId();
    this.elem = elem;
    this.isAllowDraw = true;
    this.changestatus(CamelPanel.ACTION_NORMAL);
  }
  addRecipientList() {
    let elem = new RecipientList();
    elem.rid = Sequence.createId();
    this.elem = elem;
    this.isAllowDraw = true;
    this.changestatus(CamelPanel.ACTION_NORMAL);
  }
  addResequence() {
    let elem = new Resequence();
    elem.rid = Sequence.createId();
    this.elem = elem;
    this.isAllowDraw = true;
    this.changestatus(CamelPanel.ACTION_NORMAL);
  }
  addRoutingSlip() {
    let elem = new RoutingSlip();
    elem.rid = Sequence.createId();
    this.elem = elem;
    this.isAllowDraw = true;
    this.changestatus(CamelPanel.ACTION_NORMAL);
  }
  addSaga() {
    let elem = new Saga();
    elem.rid = Sequence.createId();
    this.elem = elem;
    this.isAllowDraw = true;
    this.changestatus(CamelPanel.ACTION_NORMAL);
  }
  addSort() {
    let elem = new Sort();
    elem.rid = Sequence.createId();
    this.elem = elem;
    this.isAllowDraw = true;
    this.changestatus(CamelPanel.ACTION_NORMAL);
  }
  addSplit() {
    let elem = new Split();
    elem.rid = Sequence.createId();
    this.elem = elem;
    this.isAllowDraw = true;
    this.changestatus(CamelPanel.ACTION_NORMAL);
  }
  addWhen() {
    let elem = new When();
    elem.rid = Sequence.createId();
    this.elem = elem;
    this.isAllowDraw = true;
    this.changestatus(CamelPanel.ACTION_NORMAL);
  }
  addWireTap() {
    let elem = new WireTap();
    elem.rid = Sequence.createId();
    this.elem = elem;
    this.isAllowDraw = true;
    this.changestatus(CamelPanel.ACTION_NORMAL);
  }
  // controlflow
  addDelay() {
    let elem = new Delay();
    elem.rid = Sequence.createId();
    this.elem = elem;
    this.isAllowDraw = true;
    this.changestatus(CamelPanel.ACTION_NORMAL);
  }
  addDoCatch() {
    let elem = new DoCatch();
    elem.rid = Sequence.createId();
    this.elem = elem;
    this.isAllowDraw = true;
    this.changestatus(CamelPanel.ACTION_NORMAL);
  }
  addDoFinally() {
    let elem = new DoFinally();
    elem.rid = Sequence.createId();
    this.elem = elem;
    this.isAllowDraw = true;
    this.changestatus(CamelPanel.ACTION_NORMAL);
  }
  addDoTry() {
    let elem = new DoTry();
    elem.rid = Sequence.createId();
    this.elem = elem;
    this.isAllowDraw = true;
    this.changestatus(CamelPanel.ACTION_NORMAL);
  }
  addIntercept() {
    let elem = new Intercept();
    elem.rid = Sequence.createId();
    this.elem = elem;
    this.isAllowDraw = true;
    this.changestatus(CamelPanel.ACTION_NORMAL);
  }
  addInterceptFrom() {
    let elem = new InterceptFrom();
    elem.rid = Sequence.createId();
    this.elem = elem;
    this.isAllowDraw = true;
    this.changestatus(CamelPanel.ACTION_NORMAL);
  }
  addInterceptSendToEndpoint() {
    let elem = new InterceptSendToEndpoint();
    elem.rid = Sequence.createId();
    this.elem = elem;
    this.isAllowDraw = true;
    this.changestatus(CamelPanel.ACTION_NORMAL);
  }
  addLoop() {
    let elem = new Loop();
    elem.rid = Sequence.createId();
    this.elem = elem;
    this.isAllowDraw = true;
    this.changestatus(CamelPanel.ACTION_NORMAL);
  }
  addOnCompletion() {
    let elem = new OnCompletion();
    elem.rid = Sequence.createId();
    this.elem = elem;
    this.isAllowDraw = true;
    this.changestatus(CamelPanel.ACTION_NORMAL);
  }
  addOnException() {
    let elem = new OnException();
    elem.rid = Sequence.createId();
    this.elem = elem;
    this.isAllowDraw = true;
    this.changestatus(CamelPanel.ACTION_NORMAL);
  }
  addOnFallback() {
    let elem = new OnFallback();
    elem.rid = Sequence.createId();
    this.elem = elem;
    this.isAllowDraw = true;
    this.changestatus(CamelPanel.ACTION_NORMAL);
  }
  addRollback() {
    let elem = new Rollback();
    elem.rid = Sequence.createId();
    this.elem = elem;
    this.isAllowDraw = true;
    this.changestatus(CamelPanel.ACTION_NORMAL);
  }
  addThrottle() {
    let elem = new Throttle();
    elem.rid = Sequence.createId();
    this.elem = elem;
    this.isAllowDraw = true;
    this.changestatus(CamelPanel.ACTION_NORMAL);
  }
  addThrowException() {
    let elem = new ThrowException();
    elem.rid = Sequence.createId();
    this.elem = elem;
    this.isAllowDraw = true;
    this.changestatus(CamelPanel.ACTION_NORMAL);
  }
  addTransacted() {
    let elem = new Transacted();
    elem.rid = Sequence.createId();
    this.elem = elem;
    this.isAllowDraw = true;
    this.changestatus(CamelPanel.ACTION_NORMAL);
  }
  // transformation
  addConvertBodyTo() {
    let elem = new ConvertBodyTo();
    elem.rid = Sequence.createId();
    this.elem = elem;
    this.isAllowDraw = true;
    this.changestatus(CamelPanel.ACTION_NORMAL);
  }
  addEnrich() {
    let elem = new Enrich();
    elem.rid = Sequence.createId();
    this.elem = elem;
    this.isAllowDraw = true;
    this.changestatus(CamelPanel.ACTION_NORMAL);
  }
  addInOnly() {
    let elem = new InOnly();
    elem.rid = Sequence.createId();
    this.elem = elem;
    this.isAllowDraw = true;
    this.changestatus(CamelPanel.ACTION_NORMAL);
  }
  addInOut() {
    let elem = new InOut();
    elem.rid = Sequence.createId();
    this.elem = elem;
    this.isAllowDraw = true;
    this.changestatus(CamelPanel.ACTION_NORMAL);
  }
  addMarshal() {
    let elem = new Marshal();
    elem.rid = Sequence.createId();
    this.elem = elem;
    this.isAllowDraw = true;
    this.changestatus(CamelPanel.ACTION_NORMAL);
  }
  addPollEnrich() {
    let elem = new PollEnrich();
    elem.rid = Sequence.createId();
    this.elem = elem;
    this.isAllowDraw = true;
    this.changestatus(CamelPanel.ACTION_NORMAL);
  }
  addRemoveHeader() {
    let elem = new RemoveHeader();
    elem.rid = Sequence.createId();
    this.elem = elem;
    this.isAllowDraw = true;
    this.changestatus(CamelPanel.ACTION_NORMAL);
  }
  addRemoveHeaders() {
    let elem = new RemoveHeaders();
    elem.rid = Sequence.createId();
    this.elem = elem;
    this.isAllowDraw = true;
    this.changestatus(CamelPanel.ACTION_NORMAL);
  }
  addRemoveProperties() {
    let elem = new RemoveProperties();
    elem.rid = Sequence.createId();
    this.elem = elem;
    this.isAllowDraw = true;
    this.changestatus(CamelPanel.ACTION_NORMAL);
  }
  addRemoveProperty() {
    let elem = new RemoveProperty();
    elem.rid = Sequence.createId();
    this.elem = elem;
    this.isAllowDraw = true;
    this.changestatus(CamelPanel.ACTION_NORMAL);
  }
  addSetBody() {
    let elem = new SetBody();
    elem.rid = Sequence.createId();
    this.elem = elem;
    this.isAllowDraw = true;
    this.changestatus(CamelPanel.ACTION_NORMAL);
  }
  addSetExchangePattern() {
    let elem = new SetExchangePattern();
    elem.rid = Sequence.createId();
    this.elem = elem;
    this.isAllowDraw = true;
    this.changestatus(CamelPanel.ACTION_NORMAL);
  }
  addSetFaultBody() {
    let elem = new SetFaultBody();
    elem.rid = Sequence.createId();
    this.elem = elem;
    this.isAllowDraw = true;
    this.changestatus(CamelPanel.ACTION_NORMAL);
  }
  addSetHeader() {
    let elem = new SetHeader();
    elem.rid = Sequence.createId();
    this.elem = elem;
    this.isAllowDraw = true;
    this.changestatus(CamelPanel.ACTION_NORMAL);
  }
  addSetOutHeader() {
    let elem = new SetOutHeader();
    elem.rid = Sequence.createId();
    this.elem = elem;
    this.isAllowDraw = true;
    this.changestatus(CamelPanel.ACTION_NORMAL);
  }
  addSetProperty() {
    let elem = new SetProperty();
    elem.rid = Sequence.createId();
    this.elem = elem;
    this.isAllowDraw = true;
    this.changestatus(CamelPanel.ACTION_NORMAL);
  }
  addTransform() {
    let elem = new Transform();
    elem.rid = Sequence.createId();
    this.elem = elem;
    this.isAllowDraw = true;
    this.changestatus(CamelPanel.ACTION_NORMAL);
  }
  addUnmarshal() {
    let elem = new Unmarshal();
    elem.rid = Sequence.createId();
    this.elem = elem;
    this.isAllowDraw = true;
    this.changestatus(CamelPanel.ACTION_NORMAL);
  }
  // miscellaneous
  addAop() {
    let elem = new Aop();
    elem.rid = Sequence.createId();
    this.elem = elem;
    this.isAllowDraw = true;
    this.changestatus(CamelPanel.ACTION_NORMAL);
  }
  addPolicy() {
    let elem = new Policy();
    elem.rid = Sequence.createId();
    this.elem = elem;
    this.isAllowDraw = true;
    this.changestatus(CamelPanel.ACTION_NORMAL);
  }
  addSample() {
    let elem = new Sample();
    elem.rid = Sequence.createId();
    this.elem = elem;
    this.isAllowDraw = true;
    this.changestatus(CamelPanel.ACTION_NORMAL);
  }
  addStop() {
    let elem = new Stop();
    elem.rid = Sequence.createId();
    this.elem = elem;
    this.isAllowDraw = true;
    this.changestatus(CamelPanel.ACTION_NORMAL);
  }
  addThreads() {
    let elem = new Threads();
    elem.rid = Sequence.createId();
    this.elem = elem;
    this.isAllowDraw = true;
    this.changestatus(CamelPanel.ACTION_NORMAL);
  }
  addValidate() {
    let elem = new Validate();
    elem.rid = Sequence.createId();
    this.elem = elem;
    this.isAllowDraw = true;
    this.changestatus(CamelPanel.ACTION_NORMAL);
  }
  // 添加组件到画布上
  addRelation() {
    let elem = new Relation();
    elem.rid = Sequence.createId();
    this.elem = elem;
    this.isAllowDraw = true;
    this.changestatus(CamelPanel.ACTION_NORMAL);
  }

  // 删除元素
  remove() {
    this.changestatus(CamelPanel.ACTION_REMOVE);
  }

  // 转化xml
  toXML() {
    let str = '<?xml version="1.0" encoding="UTF-8"?>\n';
    str +=
      '<beans xmlns="http://www.springframework.org/schema/beans" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation=" http://www.springframework.org/schema/beans https://www.springframework.org/schema/beans/spring-beans.xsd http://camel.apache.org/schema/spring https://camel.apache.org/schema/spring/camel-spring.xsd">\n';
    if (this._elems) this.camelcontext.setPanelEle(this._elems);
    str += this.camelcontext.toXML();
    str += `</beans>\n`;
    return str;
  }

  // 解析xml
  XMLOperate(xml) {
    const parse = new DOMParser();
    const xmldoc = parse.parseFromString(xml, "text/xml");
    return xmldoc;
  }

  // 打开弹窗后需要根据数组自动生成连线【】
  addAutoLine(arr) {
    let currRel = {};
    let rels = [];
    for (let j = 0; j < arr.length; j++) {
      if (arr[j + 1]) {
        currRel = new Relation();
        currRel.setProps({
          _startEle: arr[j], // 关连线的开始节点
          _startelemid: arr[j].rid, // 开始元素id
          _endEle: arr[j + 1], // 关连线的结束节点
          _endelemid: arr[j + 1].rid, // 结束元素id
          vector: [
            { x: arr[j].x, y: arr[j].y },
            { x: arr[j + 1].x, y: arr[j + 1].y },
          ],
          _startpoint: { x: arr[j].x + arr[j].width / 2, y: arr[j].y + arr[j].height / 2 },
          _endpoint: { x: arr[j + 1].x + arr[j + 1].width / 2, y: arr[j + 1].y + arr[j + 1].height / 2 },
        });
        rels.push(currRel);
      }
    }
    return rels;
  }

  //获取当前正在编辑的区域或元素
  getCurrToEdit() {
    return this._currToElem || null;
  }
  //清空正在编辑的元素和区域
  resetCurrToEdit() {
    this._currToElem = null;
  }

  /**
   * @param x
   * @param y
   * @return cn.myapps.runtime.workflow.Element
   * @roseuid 3E0A6E1B00C9
   */
  chkSelectedElement(x, y) {
    const elems = this._elems;
    let arr = [];
    if (elems.length > 0) {
      for (let i = 0; i < elems.length; i++) {
        if (elems[i].isSelected(x, y)) {
          arr.push(elems[i]);
        }
      }
      if (arr.length > 1) return arr[1];
      else return arr[0] ? arr[0] : null;
    } else {
      return null;
    }
  }

  /**
   * 判断普通元素是否放置在路由元素里面
   */
  ckInRouteEle(x, y) {
    const elems = this._elems;
    for (let i = 0; i < elems.length; i++) {
      if (elems[i].scope == "route" && elems[i].x < x && elems[i].x + elems[i].width > x && elems[i].y < y && elems[i].y + elems[i].height > y) {
        this.ckInWhichRoute(elems[i]);
        return true;
      }
    }
    return false;
  }

  ckInWhichRoute(elem) {
    this._routeEle = elem;
  }

  ckInWhichRouter(elem) {
    const elems = this._elems;
    for (let i = 0; i < elems.length; i++) {
      let em = elems[i];
      if (elems[i].scope == "route" && elem.x > em.x && elem.x < em.x + em.width && elem.y > em.y && elem.y < em.y + em.height) return em;
    }
    return false;
  }
}

CamelPanel.ACTION_NORMAL = 0x00000000;
CamelPanel.ACTION_IN_ELEMENT = 0x00000001;
CamelPanel.ACTION_NOT_ALLOW = 0x00000002;
CamelPanel.ACTION_BREAK_LINE = 0x00000003;
CamelPanel.ACTION_REMOVE = 0x00000004;
CamelPanel.ACTION_ARCHOR_UPPER_LEFT = 0x00000005;
CamelPanel.ACTION_ARCHOR_UPPER_RIGHT = 0x00000006;
CamelPanel.ACTION_ARCHOR_LOWER_LEFT = 0x00000007;
CamelPanel.ACTION_ARCHOR_LOWER_RIGHT = 0x00000008;

export default CamelPanel;
