import { Route } from "../element";
class CamelContext {
  constructor() {
    this.id = "";
    this.name = "camel";
    this.autoStartup = "yes";
    this.allowUseOriginalMessage = "";
    this.beans = "";
    this.beansfactory = "";
    this.delayer = "";
    this.description = "";
    this.errorHandlerRef = "";
    this.group = "";
    this.handleFault = "";
    this.lazyLoadTypeConverters = "true";
    this.loadTypeConverters = "true";
    this.logExhaustedMessageBody = "";
    this.managementNamePattern = "";
    this.registerEndpointIdsFromRoute = "";
    this.runtimeEndpointRegistryEnabled = "";
    this.shutdownEager = "";
    this.shutdownRoute = "";
    this.logMask = "yes";
    this.shutdownRunningTask = "";
    this.streamCache = "";
    this.threadNamePattern = "";
    this.trace = "";
    this.typeConverterExists = "";
    this.typeConverterExistsLoggingLevel = "";
    this.typeConverterStatisticsEnabled = "";
    this.useBreadcrumb = "";
    this.useDataType = "";
    this.useMDCLogging = "";
    this._childNode = [];
    this.autoStartupOption = {
      true: true,
      false: false,
    };
  }
  toXML() {
    let str = `<camelContext id="${this.id}" name="${this.name}" xmlns="http://camel.apache.org/schema/spring"  autoStartup="${this.autoStartup}" allowUseOriginalMessage="${this.allowUseOriginalMessage}" beans="${this.beans}" beansfactory="${this.beansfactory}" delayer="${this.delayer}" description="${this.description}" errorHandlerRef="${this.errorHandlerRef}" group="${this.group}" handleFault="${this.handleFault}" lazyLoadTypeConverters="${this.lazyLoadTypeConverters}" loadTypeConverters="${this.loadTypeConverters}" logExhaustedMessageBody="${this.logExhaustedMessageBody}" managementNamePattern="${this.managementNamePattern}" registerEndpointIdsFromRoute="${this.registerEndpointIdsFromRoute}" runtimeEndpointRegistryEnabled="${this.runtimeEndpointRegistryEnabled}" shutdownEager="${this.shutdownEager}" shutdownRoute="${this.shutdownRoute}" logMask="${this.logMask}" shutdownRunningTask="${this.shutdownRunningTask}" streamCache="${this.streamCache}" threadNamePattern="${this.threadNamePattern}" trace="${this.trace}" typeConverterExists="${this.typeConverterExists}"  typeConverterExistsLoggingLevel="${this.typeConverterExistsLoggingLevel}" typeConverterStatisticsEnabled="${this.typeConverterStatisticsEnabled}" useBreadcrumb="${this.useBreadcrumb}" useDataType="${this.useDataType}" useMDCLogging="${this.useMDCLogging}">\n `;
    this._childNode.map((item) => {
      if (item instanceof Route) str += item.toXML();
    });
    str += "</camelContext>\n";
    return str;
  }

  parseXML(xmlNode, camel) {
    let props = {},
      _elems = [],
      _camelcontext = {};
    const traversalNode = (xmlNode) => {
      const { tagName } = xmlNode;

      switch (tagName) {
        case "camelContext":
          // 重置路由属性的值
          const cam = {
            id: xmlNode.getAttribute("id"),
            name: xmlNode.getAttribute("name"),
            autoStartup: xmlNode.getAttribute("autoStartup"),
            allowUseOriginalMessage: xmlNode.getAttribute("allowUseOriginalMessage"),
            beans: xmlNode.getAttribute("beans"),
            beansfactory: xmlNode.getAttribute("beansfactory"),
            delayer: xmlNode.getAttribute("delayer"),
            description: xmlNode.getAttribute("description"),
            errorHandlerRef: xmlNode.getAttribute("errorHandlerRef"),
            group: xmlNode.getAttribute("group"),
            handleFault: xmlNode.getAttribute("handleFault"),
            lazyLoadTypeConverters: xmlNode.getAttribute("lazyLoadTypeConverters"),
            loadTypeConverters: xmlNode.getAttribute("loadTypeConverters"),
            logExhaustedMessageBody: xmlNode.getAttribute("logExhaustedMessageBody"),
            managementNamePattern: xmlNode.getAttribute("managementNamePattern"),
            registerEndpointIdsFromRoute: xmlNode.getAttribute("registerEndpointIdsFromRoute"),
            runtimeEndpointRegistryEnabled: xmlNode.getAttribute("runtimeEndpointRegistryEnabled"),
            shutdownEager: xmlNode.getAttribute("shutdownEager"),
            shutdownRoute: xmlNode.getAttribute("shutdownRoute"),
            logMask: xmlNode.getAttribute("logMask"),
            shutdownRunningTask: xmlNode.getAttribute("shutdownRunningTask"),
            streamCache: xmlNode.getAttribute("streamCache"),
            threadNamePattern: xmlNode.getAttribute("threadNamePattern"),
            trace: xmlNode.getAttribute("trace"),
            typeConverterExists: xmlNode.getAttribute("typeConverterExists"),
            typeConverterExistsLoggingLevel: xmlNode.getAttribute("typeConverterExistsLoggingLevel"),
            typeConverterStatisticsEnabled: xmlNode.getAttribute("typeConverterStatisticsEnabled"),
            useBreadcrumb: xmlNode.getAttribute("useBreadcrumb"),
            useDataType: xmlNode.getAttribute("useDataType"),
            useMDCLogging: xmlNode.getAttribute("useMDCLogging"),
          };
          break;
        case "route":
          const t = new Route();
          const children = t.parseXML(xmlNode);
          // 将子孩子存放到自己的数组中
          if (children.length !== 0) t.childNode.push(...children);

          // 重置路由属性的值
          const obj = {
            x: parseInt(xmlNode.getAttribute("x")),
            y: parseInt(xmlNode.getAttribute("y")),
            id: xmlNode.getAttribute("id"),
            autoStartup: xmlNode.getAttribute("autoStartup"),
            delayer: xmlNode.getAttribute("delayer"),
            description: xmlNode.getAttribute("description"),
            errorHandlerRef: xmlNode.getAttribute("errorHandlerRef"),
            group: xmlNode.getAttribute("group"),
            name: xmlNode.getAttribute("name"),
            logMask: xmlNode.getAttribute("logMask"),
            messageHistory: xmlNode.getAttribute("messageHistory"),
            routePolicyRef: xmlNode.getAttribute("routePolicyRef"),
            shutdownRoute: xmlNode.getAttribute("shutdownRoute"),
            shutdownRunningTask: xmlNode.getAttribute("shutdownRunningTask"),
            startupOrder: xmlNode.getAttribute("startupOrder"),
            streamCache: xmlNode.getAttribute("streamCache"),
            trace: xmlNode.getAttribute("trace"),
          };
          t.setProps(obj);
          if (children.length == 0) _elems.push(t);
          else {
            // 这里需要children间接入连线
            _elems.push(t, ...children);
            if (children.length >= 2) {
              _elems.push(...camel.addAutoLine(children));
            }
          }

        default:
          break;
      }
    };

    if (xmlNode.hasChildNodes()) {
      for (let i = 0; i < xmlNode.children.length; i++) {
        traversalNode(xmlNode.children[i]);
      }

      // 自身的数值
      traversalNode(xmlNode);
    }

    this.setProps(props);

    return _elems;
  }
  // 获取属性面板的元素
  setPanelEle(elems) {
    this._childNode = elems;
  }
  // 通过拷贝重新赋值 遍历当前对象的所有属性值重新赋值
  setProps(prop) {
    Object.assign(this, prop);
  }

  getPropsDesc() {
    return {
      details: [
        "id",
        "name",
        "autoStartup",
        "allowUseOriginalMessage",
        "beans",
        "beansfactory",
        "delayer",
        "description",
        "errorHandlerRef",
        "group",
        "handleFault",
        "lazyLoadTypeConverters",
        "loadTypeConverters",
        "logExhaustedMessageBody",
        "managementNamePattern",
        "registerEndpointIdsFromRoute",
        "runtimeEndpointRegistryEnabled",
        "shutdownEager",
        "shutdownRoute",
        "logMask",
        "shutdownRunningTask",
        "streamCache",
        "threadNamePattern",
        "trace",
        "typeConverterExists",
        "typeConverterExistsLoggingLevel",
        "typeConverterStatisticsEnabled",
        "useBreadcrumb",
        "useDataType",
        "useMDCLogging",
      ],
    };
  }
}
export default CamelContext;
