import { CamelContext } from "../view";

class XMLOperate {
  constructor(xml, camel) {
    this.xml = xml;
    this.camel = camel;
  }

  parseXML() {
    const camel = this.camel;
    let allEle = [];
    const root = this.xml.children[0]; // 寻找camelcontext而不是最外层的beans
    const traversalNode = (xmlNode) => {
      const { tagName } = xmlNode;
      switch (tagName) {
        case "camelContext":
          const camelcontext = new CamelContext();
          allEle = camelcontext.parseXML(xmlNode, camel);
          const obj = {
            id: xmlNode.getAttribute("id"),
            name: xmlNode.getAttribute("name"),
            autoStartup: xmlNode.getAttribute("autoStartup"),
            allowUseOriginalMessage: xmlNode.getAttribute("allowUseOriginalMessage"),
            beans: xmlNode.getAttribute("beans"),
            beansfactory: xmlNode.getAttribute("beansfactory"),
            delayer: xmlNode.getAttribute("delayer"),
            description: xmlNode.getAttribute("description"),
            errorHandlerRef: xmlNode.getAttribute("errorHandlerRef"),
            group: xmlNode.getAttribute("group"),
            handleFault: xmlNode.getAttribute("handleFault"),
            lazyLoadTypeConverters: xmlNode.getAttribute("lazyLoadTypeConverters"),
            loadTypeConverters: xmlNode.getAttribute("loadTypeConverters"),
            logExhaustedMessageBody: xmlNode.getAttribute("logExhaustedMessageBody"),
            managementNamePattern: xmlNode.getAttribute("managementNamePattern"),
            registerEndpointIdsFromRoute: xmlNode.getAttribute("registerEndpointIdsFromRoute"),
            runtimeEndpointRegistryEnabled: xmlNode.getAttribute("runtimeEndpointRegistryEnabled"),
            shutdownEager: xmlNode.getAttribute("shutdownEager"),
            shutdownRoute: xmlNode.getAttribute("shutdownRoute"),
            logMask: xmlNode.getAttribute("logMask"),
            shutdownRunningTask: xmlNode.getAttribute("shutdownRunningTask"),
            streamCache: xmlNode.getAttribute("streamCache"),
            threadNamePattern: xmlNode.getAttribute("threadNamePattern"),
            trace: xmlNode.getAttribute("trace"),
            typeConverterExists: xmlNode.getAttribute("typeConverterExists"),
            typeConverterExistsLoggingLevel: xmlNode.getAttribute("typeConverterExistsLoggingLevel"),
            typeConverterStatisticsEnabled: xmlNode.getAttribute("typeConverterStatisticsEnabled"),
            useBreadcrumb: xmlNode.getAttribute("useBreadcrumb"),
            useDataType: xmlNode.getAttribute("useDataType"),
            useMDCLogging: xmlNode.getAttribute("useMDCLogging"),
          };
          camel.camelcontext.setProps(obj);
          break;
        default:
          break;
      }
    };

    if (root.hasChildNodes()) {
      for (let i = 0; i < root.children.length; i++) {
        traversalNode(root.children[i]);
      }
    }

    camel._elems = allEle;
    return allEle;
  }
}

export default XMLOperate;
