class Resources {
  loadImage(url) {
    return new Promise((resolve, reject) => {
      const img = new Image();
      img.onload = () => resolve(img);
      img.onerror = reject;
      img.src = url;
    });
  }

  onload(callback) {
    const pr = [];

    const source = {
      start: "./images/loop.png",
    };

    for (const key in source) {
      if (Object.prototype.hasOwnProperty.call(source, key)) {
        const url = source[key];
        const p = this.loadImage(url)
          .then((img) => {
            switch (key) {
              case "start":
                Resources.IMG_START_NODE = img;
                break;
              default:
                break;
            }
            return img;
          })
          .catch((err) => console.log(err));
        pr.push(p);
      }
    }

    Promise.all(pr).then(() => {
      callback();
    });
  }
}

Resources.IMG_START_NODE = null;

Resources.FONT_METRICS = {
  width: 12,
  height: 12,
  ascent: 1,
};

Resources.COLOR = {
  white: "rgb(255, 255, 255)",
  lightGray: "rgb(229, 229, 229)",
  grey: "#ccc",
  black: "rgb(0, 0, 0)",
  lightYellow: "#FFFFE1",
  blue: "blue",
};

export default Resources;
