import {
  ActiveMQ,
  Atom,
  Bean,
  CXF,
  CXFRS,
  ControlBus,
  Direct,
  DirectVM,
  FTP,
  FTPS,
  File,
  Generic,
  IMAP,
  IMAPSecure,
  JDBC,
  JGroups,
  JMS,
  Language,
  Log,
  MQTT,
  MVEL,
  Mina2,
  Netty,
  NettyHTTP,
  Netty4,
  Netty4HTTP,
  POP3,
  POP3S,
  Process,
  Quartz,
  Quartz2,
  Restlet,
  RSS,
  SAPNetWeaver,
  Scheduler,
  SEDA,
  Servlet,
  SFTP,
  SMTP,
  SMTPS,
  SNMP,
  SQL,
  Timer,
  VM,
  XQuery,
  XSLT,
} from "../element/compontent";
import { Aggregate, Choice, ClaimCheck, Filter, IdempotentConsumer, Hystrix, LoadBalance, Multicast, Pipeline, RecipientList, Resequence, RoutingSlip, Saga, Sort, Split, When, WireTap } from "../element/routing";
import { Delay, DoCatch, DoFinally, DoTry, Intercept, InterceptFrom, InterceptSendToEndpoint, Loop, OnCompletion, OnException, OnFallback, Rollback, Throttle, ThrowException, Transacted } from "../element/controlflow";
import {
  ConvertBodyTo,
  Enrich,
  InOnly,
  InOut,
  Marshal,
  PollEnrich,
  RemoveHeader,
  RemoveHeaders,
  RemoveProperties,
  RemoveProperty,
  SetBody,
  SetExchangePattern,
  SetFaultBody,
  SetHeader,
  SetOutHeader,
  SetProperty,
  Transform,
  Unmarshal,
} from "../element/transformation";
import { Aop, Policy, Sample, Stop, Threads, Validate } from "../element/miscellaneous";

class Helper {
  constructor() {
    this.templete = "";
  }

  /**
   * 处理请求后获取的模板
   * @param tml 需要处理的模板
   * @param data 需要填充进模板里的数据
   * @param tmlId 需要过滤掉的模板id，用于删除模板里不需要的标签
   * @return 返回处理完的模板html字符串
   */
  handleTemplete(tml, data, tmlId) {
    const $tml = $(tml)
      .filter("#" + tmlId)
      .html();
    const render = template.compile($tml);
    return render(data);
  }

  /**
   * 获取相同组件的原始数据(用于uri的比较)
   * @param {组件名称} name
   * @returns
   */
  handleInitData(name) {
    let initComponent = null;
    switch (name) {
      // component
      case "ActiveMQ":
        initComponent = new ActiveMQ();
        break;
      case "Atom":
        initComponent = new Atom();
        break;
      case "CXF":
        initComponent = new CXF();
        break;
      case "CXFRS":
        initComponent = new CXFRS();
        break;
      case "ControlBus":
        initComponent = new ControlBus();
        break;
      case "Direct":
        initComponent = new Direct();
        break;
      case "DirectVM":
        initComponent = new DirectVM();
        break;
      case "FTP":
        initComponent = new FTP();
        break;
      case "FTPS":
        initComponent = new FTPS();
        break;
      case "File":
        initComponent = new File();
        break;
      case "Generic":
        initComponent = new Generic();
        break;
      case "IMAP":
        initComponent = new IMAP();
        break;
      case "IMAPSecure":
        initComponent = new IMAPSecure();
        break;
      case "JDBC":
        initComponent = new JDBC();
        break;
      case "JGroups":
        initComponent = new JGroups();
        break;
      case "JMS":
        initComponent = new JMS();
        break;
      case "Language":
        initComponent = new Language();
        break;
      case "Log":
        initComponent = new Log();
        break;
      case "MQTT":
        initComponent = new MQTT();
        break;
      case "MVEL":
        initComponent = new MVEL();
        break;
      case "Mina2":
        initComponent = new Mina2();
        break;
      case "Netty":
        initComponent = new Netty();
        break;
      case "NettyHTTP":
        initComponent = new NettyHTTP();
        break;
      case "Netty4":
        initComponent = new Netty4();
        break;
      case "Netty4HTTP":
        initComponent = new Netty4HTTP();
        break;
      case "POP3":
        initComponent = new POP3();
        break;
      case "POP3S":
        initComponent = new POP3S();
        break;
      case "Process":
        initComponent = new Process();
        break;
      case "Quartz":
        initComponent = new Quartz();
        break;
      case "Quartz2":
        initComponent = new Quartz2();
        break;
      case "Restlet":
        initComponent = new Restlet();
        break;
      case "RSS":
        initComponent = new RSS();
        break;
      case "SAPNetWeaver":
        initComponent = new SAPNetWeaver();
        break;
      case "Scheduler":
        initComponent = new Scheduler();
        break;
      case "SEDA":
        initComponent = new SEDA();
        break;
      case "Servlet":
        initComponent = new Servlet();
        break;
      case "SFTP":
        initComponent = new SFTP();
        break;
      case "SMTP":
        initComponent = new SMTP();
        break;
      case "SMTPS":
        initComponent = new SMTPS();
        break;
      case "SNMP":
        initComponent = new SNMP();
        break;
      case "SQL":
        initComponent = new SQL();
        break;
      case "Timer":
        initComponent = new Timer();
        break;
      case "VM":
        initComponent = new VM();
        break;
      case "XQuery":
        initComponent = new XQuery();
        break;
      case "XSLT":
        initComponent = new XSLT();
        break;
      default:
        break;
    }
    return initComponent;
  }

  /**
   * 解析xml
   */
  parseNode(xmlNode, tagName, that) {
    let element = null,
      camelElement = {};
    switch (tagName) {
      // component
      case "ActiveMQ":
        element = new ActiveMQ();
        element.parseXML(xmlNode);
        camelElement = that.handleCamelElement(xmlNode, element.getPropsDesc());
        element.setProps(camelElement);
        break;
      case "Atom":
        element = new Atom();
        element.parseXML(xmlNode);
        camelElement = that.handleCamelElement(xmlNode, element.getPropsDesc());
        element.setProps(camelElement);
        break;
      case "Bean":
        element = new Bean();
        element.parseXML(xmlNode);
        camelElement = that.handleCamelElement(xmlNode, element.getPropsDesc());
        element.setProps(camelElement);
        break;
      case "CXF":
        element = new CXF();
        element.parseXML(xmlNode);
        camelElement = that.handleCamelElement(xmlNode, element.getPropsDesc());
        element.setProps(camelElement);
        break;
      case "CXFRS":
        element = new CXFRS();
        element.parseXML(xmlNode);
        camelElement = that.handleCamelElement(xmlNode, element.getPropsDesc());
        element.setProps(camelElement);
        break;
      case "ControlBus":
        element = new ControlBus();
        element.parseXML(xmlNode);
        camelElement = that.handleCamelElement(xmlNode, element.getPropsDesc());
        element.setProps(camelElement);
        break;
      case "Direct":
        element = new Direct();
        element.parseXML(xmlNode);
        camelElement = that.handleCamelElement(xmlNode, element.getPropsDesc());
        element.setProps(camelElement);
        break;
      case "DirectVM":
        element = new DirectVM();
        element.parseXML(xmlNode);
        camelElement = that.handleCamelElement(xmlNode, element.getPropsDesc());
        element.setProps(camelElement);
        break;
      case "FTP":
        element = new FTP();
        element.parseXML(xmlNode);
        camelElement = that.handleCamelElement(xmlNode, element.getPropsDesc());
        element.setProps(camelElement);
        break;
      case "FTPS":
        element = new FTPS();
        element.parseXML(xmlNode);
        camelElement = that.handleCamelElement(xmlNode, element.getPropsDesc());
        element.setProps(camelElement);
        break;
      case "File":
        element = new File();
        element.parseXML(xmlNode);
        camelElement = that.handleCamelElement(xmlNode, element.getPropsDesc());
        element.setProps(camelElement);
        break;
      case "Generic":
        element = new Generic();
        element.parseXML(xmlNode);
        camelElement = that.handleCamelElement(xmlNode, element.getPropsDesc());
        element.setProps(camelElement);
        break;
      case "IMAP":
        element = new IMAP();
        element.parseXML(xmlNode);
        camelElement = that.handleCamelElement(xmlNode, element.getPropsDesc());
        element.setProps(camelElement);
        break;
      case "IMAPSecure":
        element = new IMAPSecure();
        element.parseXML(xmlNode);
        camelElement = that.handleCamelElement(xmlNode, element.getPropsDesc());
        element.setProps(camelElement);
        break;
      case "JDBC":
        element = new JDBC();
        element.parseXML(xmlNode);
        camelElement = that.handleCamelElement(xmlNode, element.getPropsDesc());
        element.setProps(camelElement);
        break;
      case "JGroups":
        element = new JGroups();
        element.parseXML(xmlNode);
        camelElement = that.handleCamelElement(xmlNode, element.getPropsDesc());
        element.setProps(camelElement);
        break;
      case "JMS":
        element = new JMS();
        element.parseXML(xmlNode);
        camelElement = that.handleCamelElement(xmlNode, element.getPropsDesc());
        element.setProps(camelElement);
        break;
      case "Language":
        element = new Language();
        element.parseXML(xmlNode);
        camelElement = that.handleCamelElement(xmlNode, element.getPropsDesc());
        element.setProps(camelElement);
        break;
      case "Log":
        element = new Log();
        element.parseXML(xmlNode);
        camelElement = that.handleCamelElement(xmlNode, element.getPropsDesc());
        element.setProps(camelElement);
        break;
      case "MQTT":
        element = new MQTT();
        element.parseXML(xmlNode);
        camelElement = that.handleCamelElement(xmlNode, element.getPropsDesc());
        element.setProps(camelElement);
        break;
      case "MVEL":
        element = new MVEL();
        element.parseXML(xmlNode);
        camelElement = that.handleCamelElement(xmlNode, element.getPropsDesc());
        element.setProps(camelElement);
        break;
      case "Mina2":
        element = new Mina2();
        element.parseXML(xmlNode);
        camelElement = that.handleCamelElement(xmlNode, element.getPropsDesc());
        element.setProps(camelElement);
        break;
      case "Netty":
        element = new Netty();
        element.parseXML(xmlNode);
        camelElement = that.handleCamelElement(xmlNode, element.getPropsDesc());
        element.setProps(camelElement);
        break;
      case "NettyHTTP":
        element = new NettyHTTP();
        element.parseXML(xmlNode);
        camelElement = that.handleCamelElement(xmlNode, element.getPropsDesc());
        element.setProps(camelElement);
        break;
      case "Netty4":
        element = new Netty4();
        element.parseXML(xmlNode);
        camelElement = that.handleCamelElement(xmlNode, element.getPropsDesc());
        element.setProps(camelElement);
        break;
      case "Netty4HTTP":
        element = new Netty4HTTP();
        element.parseXML(xmlNode);
        camelElement = that.handleCamelElement(xmlNode, element.getPropsDesc());
        element.setProps(camelElement);
        break;
      case "POP3":
        element = new POP3();
        element.parseXML(xmlNode);
        camelElement = that.handleCamelElement(xmlNode, element.getPropsDesc());
        element.setProps(camelElement);
        break;
      case "POP3S":
        element = new POP3S();
        element.parseXML(xmlNode);
        camelElement = that.handleCamelElement(xmlNode, element.getPropsDesc());
        element.setProps(camelElement);
        break;
      case "Process":
        element = new Process();
        element.parseXML(xmlNode);
        camelElement = that.handleCamelElement(xmlNode, element.getPropsDesc());
        element.setProps(camelElement);
        break;
      case "Quartz":
        element = new Quartz();
        element.parseXML(xmlNode);
        camelElement = that.handleCamelElement(xmlNode, element.getPropsDesc());
        element.setProps(camelElement);
        break;
      case "Quartz2":
        element = new Quartz2();
        element.parseXML(xmlNode);
        camelElement = that.handleCamelElement(xmlNode, element.getPropsDesc());
        element.setProps(camelElement);
        break;
      case "Restlet":
        element = new Restlet();
        element.parseXML(xmlNode);
        camelElement = that.handleCamelElement(xmlNode, element.getPropsDesc());
        element.setProps(camelElement);
        break;
      case "RSS":
        element = new RSS();
        element.parseXML(xmlNode);
        camelElement = that.handleCamelElement(xmlNode, element.getPropsDesc());
        element.setProps(camelElement);
        break;
      case "SAPNetWeaver":
        element = new SAPNetWeaver();
        element.parseXML(xmlNode);
        camelElement = that.handleCamelElement(xmlNode, element.getPropsDesc());
        element.setProps(camelElement);
        break;
      case "Scheduler":
        element = new Scheduler();
        element.parseXML(xmlNode);
        camelElement = that.handleCamelElement(xmlNode, element.getPropsDesc());
        element.setProps(camelElement);
        break;
      case "SEDA":
        element = new SEDA();
        element.parseXML(xmlNode);
        camelElement = that.handleCamelElement(xmlNode, element.getPropsDesc());
        element.setProps(camelElement);
        break;
      case "Servlet":
        element = new Servlet();
        element.parseXML(xmlNode);
        camelElement = that.handleCamelElement(xmlNode, element.getPropsDesc());
        element.setProps(camelElement);
        break;
      case "SFTP":
        element = new SFTP();
        element.parseXML(xmlNode);
        camelElement = that.handleCamelElement(xmlNode, element.getPropsDesc());
        element.setProps(camelElement);
        break;
      case "SMTP":
        element = new SMTP();
        element.parseXML(xmlNode);
        camelElement = that.handleCamelElement(xmlNode, element.getPropsDesc());
        element.setProps(camelElement);
        break;
      case "SMTPS":
        element = new SMTPS();
        element.parseXML(xmlNode);
        camelElement = that.handleCamelElement(xmlNode, element.getPropsDesc());
        element.setProps(camelElement);
        break;
      case "SNMP":
        element = new SNMP();
        element.parseXML(xmlNode);
        camelElement = that.handleCamelElement(xmlNode, element.getPropsDesc());
        element.setProps(camelElement);
        break;
      case "SQL":
        element = new SQL();
        element.parseXML(xmlNode);
        camelElement = that.handleCamelElement(xmlNode, element.getPropsDesc());
        element.setProps(camelElement);
        break;
      case "Timer":
        element = new Timer();
        element.parseXML(xmlNode);
        camelElement = that.handleCamelElement(xmlNode, element.getPropsDesc());
        element.setProps(camelElement);
        break;
      case "VM":
        element = new VM();
        element.parseXML(xmlNode);
        camelElement = that.handleCamelElement(xmlNode, element.getPropsDesc());
        element.setProps(camelElement);
        break;
      case "XQuery":
        element = new XQuery();
        element.parseXML(xmlNode);
        camelElement = that.handleCamelElement(xmlNode, element.getPropsDesc());
        element.setProps(camelElement);
        break;
      case "XSLT":
        element = new XSLT();
        element.parseXML(xmlNode);
        camelElement = that.handleCamelElement(xmlNode, element.getPropsDesc());
        element.setProps(camelElement);
        break;
      // routing
      case "Aggregate":
        element = new Aggregate();
        element.parseXML(xmlNode);
        camelElement = that.handleCamelElement(xmlNode, element.getPropsDesc());
        element.setProps(camelElement);
        break;
      case "Choice":
        element = new Choice();
        element.parseXML(xmlNode);
        camelElement = that.handleCamelElement(xmlNode, element.getPropsDesc());
        element.setProps(camelElement);
        break;
      case "ClaimCheck":
        element = new ClaimCheck();
        element.parseXML(xmlNode);
        camelElement = that.handleCamelElement(xmlNode, element.getPropsDesc());
        element.setProps(camelElement);
        break;
      case "Filter":
        element = new Filter();
        element.parseXML(xmlNode);
        camelElement = that.handleCamelElement(xmlNode, element.getPropsDesc());
        element.setProps(camelElement);
        break;
      case "Hystrix":
        element = new Hystrix();
        element.parseXML(xmlNode);
        camelElement = that.handleCamelElement(xmlNode, element.getPropsDesc());
        element.setProps(camelElement);
        break;
      case "IdempotentConsumer":
        element = new IdempotentConsumer();
        element.parseXML(xmlNode);
        camelElement = that.handleCamelElement(xmlNode, element.getPropsDesc());
        element.setProps(camelElement);
        break;
      case "LoadBalance":
        element = new LoadBalance();
        element.parseXML(xmlNode);
        camelElement = that.handleCamelElement(xmlNode, element.getPropsDesc());
        element.setProps(camelElement);
        break;
      case "Multicast":
        element = new Multicast();
        element.parseXML(xmlNode);
        camelElement = that.handleCamelElement(xmlNode, element.getPropsDesc());
        element.setProps(camelElement);
        break;
      case "Pipeline":
        element = new Pipeline();
        element.parseXML(xmlNode);
        camelElement = that.handleCamelElement(xmlNode, element.getPropsDesc());
        element.setProps(camelElement);
        break;
      case "RecipientList":
        element = new RecipientList();
        element.parseXML(xmlNode);
        camelElement = that.handleCamelElement(xmlNode, element.getPropsDesc());
        element.setProps(camelElement);
        break;
      case "Resequence":
        element = new Resequence();
        element.parseXML(xmlNode);
        camelElement = that.handleCamelElement(xmlNode, element.getPropsDesc());
        element.setProps(camelElement);
        break;
      case "RoutingSlip":
        element = new RoutingSlip();
        element.parseXML(xmlNode);
        camelElement = that.handleCamelElement(xmlNode, element.getPropsDesc());
        element.setProps(camelElement);
        break;
      case "Saga":
        element = new Saga();
        element.parseXML(xmlNode);
        camelElement = that.handleCamelElement(xmlNode, element.getPropsDesc());
        element.setProps(camelElement);
        break;
      case "Sort":
        element = new Sort();
        element.parseXML(xmlNode);
        camelElement = that.handleCamelElement(xmlNode, element.getPropsDesc());
        element.setProps(camelElement);
        break;
      case "Split":
        element = new Split();
        element.parseXML(xmlNode);
        camelElement = that.handleCamelElement(xmlNode, element.getPropsDesc());
        element.setProps(camelElement);
        break;
      case "When":
        element = new When();
        element.parseXML(xmlNode);
        camelElement = that.handleCamelElement(xmlNode, element.getPropsDesc());
        element.setProps(camelElement);
        break;
      case "WireTap":
        element = new WireTap();
        element.parseXML(xmlNode);
        camelElement = that.handleCamelElement(xmlNode, element.getPropsDesc());
        element.setProps(camelElement);
        break;
      // transformation
      case "Delay":
        element = new Delay();
        element.parseXML(xmlNode);
        camelElement = that.handleCamelElement(xmlNode, element.getPropsDesc());
        element.setProps(camelElement);
        break;
      case "DoCatch":
        element = new DoCatch();
        element.parseXML(xmlNode);
        camelElement = that.handleCamelElement(xmlNode, element.getPropsDesc());
        element.setProps(camelElement);
        break;
      case "DoFinally":
        element = new DoFinally();
        element.parseXML(xmlNode);
        camelElement = that.handleCamelElement(xmlNode, element.getPropsDesc());
        element.setProps(camelElement);
        break;
      case "DoTry":
        element = new DoTry();
        element.parseXML(xmlNode);
        camelElement = that.handleCamelElement(xmlNode, element.getPropsDesc());
        element.setProps(camelElement);
        break;
      case "Intercept":
        element = new Intercept();
        element.parseXML(xmlNode);
        camelElement = that.handleCamelElement(xmlNode, element.getPropsDesc());
        element.setProps(camelElement);
        break;
      case "InterceptFrom":
        element = new InterceptFrom();
        element.parseXML(xmlNode);
        camelElement = that.handleCamelElement(xmlNode, element.getPropsDesc());
        element.setProps(camelElement);
        break;
      case "InterceptSendToEndpoint":
        element = new InterceptSendToEndpoint();
        element.parseXML(xmlNode);
        camelElement = that.handleCamelElement(xmlNode, element.getPropsDesc());
        element.setProps(camelElement);
        break;
      case "Loop":
        element = new Loop();
        element.parseXML(xmlNode);
        camelElement = that.handleCamelElement(xmlNode, element.getPropsDesc());
        element.setProps(camelElement);
        break;
      case "OnCompletion":
        element = new OnCompletion();
        element.parseXML(xmlNode);
        camelElement = that.handleCamelElement(xmlNode, element.getPropsDesc());
        element.setProps(camelElement);
        break;
      case "OnException":
        element = new OnException();
        element.parseXML(xmlNode);
        camelElement = that.handleCamelElement(xmlNode, element.getPropsDesc());
        element.setProps(camelElement);
        break;
      case "OnFallback":
        element = new OnFallback();
        element.parseXML(xmlNode);
        camelElement = that.handleCamelElement(xmlNode, element.getPropsDesc());
        element.setProps(camelElement);
        break;
      case "Rollback":
        element = new Rollback();
        element.parseXML(xmlNode);
        camelElement = that.handleCamelElement(xmlNode, element.getPropsDesc());
        element.setProps(camelElement);
        break;
      case "Throttle":
        element = new Throttle();
        element.parseXML(xmlNode);
        camelElement = that.handleCamelElement(xmlNode, element.getPropsDesc());
        element.setProps(camelElement);
        break;
      case "ThrowException":
        element = new ThrowException();
        element.parseXML(xmlNode);
        camelElement = that.handleCamelElement(xmlNode, element.getPropsDesc());
        element.setProps(camelElement);
        break;
      case "Transacted":
        element = new Transacted();
        element.parseXML(xmlNode);
        camelElement = that.handleCamelElement(xmlNode, element.getPropsDesc());
        element.setProps(camelElement);
        break;
      // transformation
      case "ConvertBodyTo":
        element = new ConvertBodyTo();
        element.parseXML(xmlNode);
        camelElement = that.handleCamelElement(xmlNode, element.getPropsDesc());
        element.setProps(camelElement);
        break;
      case "Enrich":
        element = new Enrich();
        element.parseXML(xmlNode);
        camelElement = that.handleCamelElement(xmlNode, element.getPropsDesc());
        element.setProps(camelElement);
        break;
      case "InOnly":
        element = new InOnly();
        element.parseXML(xmlNode);
        camelElement = that.handleCamelElement(xmlNode, element.getPropsDesc());
        element.setProps(camelElement);
        break;
      case "InOut":
        element = new InOut();
        element.parseXML(xmlNode);
        camelElement = that.handleCamelElement(xmlNode, element.getPropsDesc());
        element.setProps(camelElement);
        break;
      case "Marshal":
        element = new Marshal();
        element.parseXML(xmlNode);
        camelElement = that.handleCamelElement(xmlNode, element.getPropsDesc());
        element.setProps(camelElement);
        break;
      case "PollEnrich":
        element = new PollEnrich();
        element.parseXML(xmlNode);
        camelElement = that.handleCamelElement(xmlNode, element.getPropsDesc());
        element.setProps(camelElement);
        break;
      case "RemoveHeader":
        element = new RemoveHeader();
        element.parseXML(xmlNode);
        camelElement = that.handleCamelElement(xmlNode, element.getPropsDesc());
        element.setProps(camelElement);
        break;
      case "RemoveHeaders":
        element = new RemoveHeaders();
        element.parseXML(xmlNode);
        camelElement = that.handleCamelElement(xmlNode, element.getPropsDesc());
        element.setProps(camelElement);
        break;
      case "RemoveProperties":
        element = new RemoveProperties();
        element.parseXML(xmlNode);
        camelElement = that.handleCamelElement(xmlNode, element.getPropsDesc());
        element.setProps(camelElement);
        break;
      case "RemoveProperty":
        element = new RemoveProperty();
        element.parseXML(xmlNode);
        camelElement = that.handleCamelElement(xmlNode, element.getPropsDesc());
        element.setProps(camelElement);
        break;
      case "SetBody":
        element = new SetBody();
        element.parseXML(xmlNode);
        camelElement = that.handleCamelElement(xmlNode, element.getPropsDesc());
        element.setProps(camelElement);
        break;
      case "SetExchangePattern":
        element = new SetExchangePattern();
        element.parseXML(xmlNode);
        camelElement = that.handleCamelElement(xmlNode, element.getPropsDesc());
        element.setProps(camelElement);
        break;
      case "SetFaultBody":
        element = new SetFaultBody();
        element.parseXML(xmlNode);
        camelElement = that.handleCamelElement(xmlNode, element.getPropsDesc());
        element.setProps(camelElement);
        break;
      case "SetHeader":
        element = new SetHeader();
        element.parseXML(xmlNode);
        camelElement = that.handleCamelElement(xmlNode, element.getPropsDesc());
        element.setProps(camelElement);
        break;
      case "SetOutHeader":
        element = new SetOutHeader();
        element.parseXML(xmlNode);
        camelElement = that.handleCamelElement(xmlNode, element.getPropsDesc());
        element.setProps(camelElement);
        break;
      case "SetProperty":
        element = new SetProperty();
        element.parseXML(xmlNode);
        camelElement = that.handleCamelElement(xmlNode, element.getPropsDesc());
        element.setProps(camelElement);
        break;
      case "Transform":
        element = new Transform();
        element.parseXML(xmlNode);
        camelElement = that.handleCamelElement(xmlNode, element.getPropsDesc());
        element.setProps(camelElement);
        break;
      case "Unmarshal":
        element = new Unmarshal();
        element.parseXML(xmlNode);
        camelElement = that.handleCamelElement(xmlNode, element.getPropsDesc());
        element.setProps(camelElement);
        break;
      // miscellaneous
      case "Aop":
        element = new Aop();
        element.parseXML(xmlNode);
        camelElement = that.handleCamelElement(xmlNode, element.getPropsDesc());
        element.setProps(camelElement);
        break;
      case "Policy":
        element = new Policy();
        element.parseXML(xmlNode);
        camelElement = that.handleCamelElement(xmlNode, element.getPropsDesc());
        element.setProps(camelElement);
        break;
      case "Sample":
        element = new Sample();
        element.parseXML(xmlNode);
        camelElement = that.handleCamelElement(xmlNode, element.getPropsDesc());
        element.setProps(camelElement);
        break;
      case "Stop":
        element = new Stop();
        element.parseXML(xmlNode);
        camelElement = that.handleCamelElement(xmlNode, element.getPropsDesc());
        element.setProps(camelElement);
        break;
      case "Threads":
        element = new Threads();
        element.parseXML(xmlNode);
        camelElement = that.handleCamelElement(xmlNode, element.getPropsDesc());
        element.setProps(camelElement);
        break;
      case "Validate":
        element = new Validate();
        element.parseXML(xmlNode);
        camelElement = that.handleCamelElement(xmlNode, element.getPropsDesc());
        element.setProps(camelElement);
        break;
      default:
        break;
    }
    return element;
  }
}

export default Helper;
