class Archor {
  constructor() {
    this.x = 0;
    this.y = 0;
    this.targetW = 0;
    this.targetH = 0;
    this.openArchorPos = [
      { x: 0, y: 0 },
      { x: 1, y: 0 },
      { x: 1, y: 1 },
      { x: 0, y: 1 },
    ];
    this.radius = Archor.DEF_RADIUS;
    this.color = Archor.DEF_COLOR;
    this.borderColor = Archor.DEF_BORDER_COLOR;
  }

  getProp(prop) {
    return this[prop];
  }

  setProps(newProps) {
    Object.assign(this, newProps);
  }

  //画四个角的小圆
  paint(g) {
    for (let i = 0; i < this.openArchorPos.length; i++) {
      g.save();
      g.drawArc(this.x + this.targetW * this.openArchorPos[i].x, this.y + this.targetH * this.openArchorPos[i].y, this.radius, this.color, this.borderColor);
      g.restore();
    }
  }

  /**
   * 获取锚点的坐标
   * @param {*} x
   * @param {*} y
   * @returns
   */
  getArchorPosition(x, y) {
    const r = this.radius;
    if (this.openArchorPos.length > 0) {
      for (let i = 0; i < this.openArchorPos.length; i++) {
        const dx = this.x + this.targetW * this.openArchorPos[i].x - x;
        const dy = this.y + this.targetH * this.openArchorPos[i].y - y;

        if (dx * dx + dy * dy <= r * r) {
          return this.openArchorPos[i];
        }
      }
      return null;
    } else {
      return null;
    }
  }
}

Archor.DEF_RADIUS = 3;
Archor.DEF_COLOR = "#F0F0F0";
Archor.DEF_BORDER_COLOR = "#000000";

export default Archor;
