class Api {
  constructor() {
    // this.contextPath = contextPath;
  }

  /**
   * 获取模板
   * @param tmlName 需要请求的模板名称
   * @return 返回$.Deferred实例，用于后面调用done,fail方法
   */
  getTemplete(tmlName) {
    if (typeof tmlName == "string" && tmlName.indexOf(".html") == -1) {
      tmlName += ".html";
    }
    return $.ajax({
      async: true,
      type: "GET",
      url: "tpl/" + tmlName,
    });
  }

  /**
   * 获取json配置文件，主要是获取下拉列表的各项选择值
   * @return 返回ajax异步实例，用于后面调用done,fail方法
   */
  getJSON() {
    return $.ajax({
      async: true,
      type: "GET",
      url: "json/config.json",
      dataType: "json",
      contentType: "application/json",
    });
  }

  /**
	 * 获取对应的xml配置文件，用以反解析生成报表元素
	 * @return 返回xml字符串
	 */
	getXMLConf(contextPath, appId, eipId) {
		let xml = '';
		$.ajax({
			async: false,
			type: 'GET',
			url: `/${contextPath}/designtime/applications/${appId}/eips/${eipId}`,
			dataType: 'json'
		}).done((data) => {
			if(data.errcode == 0) {
				xml = data.data.xml;
			}
		});
		//console.log(xml)
		return xml;
	}
}
export default Api;
