import CamelElement from "../CamelElement";
import { Resources } from "../../utility";
class PollEnrich extends CamelElement {
  constructor() {
    super();
    this.scope = "PollEnrich";
    this.parent = "";
    this.inputid = ""; // 线的接入
    this.outputid = ""; // 线的出口
    this.id = "_pollEnrich";
    this.description = "";
    this.expression = "";
    this.aggregateOnException = false;
    this.cacheSize = "";
    this.ignoreInvalidEndpoint = false;
    this.strategyMethodAllowNull = false;
    this.strategyMethodName = "";
    this.strategyRef = "";
    this.timeout = -1;
  }

  paint(g) {
    if (this._img == null) {
      this._img = Resources.IMG_START_NODE;
    }

    g.save();
    this.color = "#cebee1";
    g.drawOvalBorder(this.x, this.y, this.width, this.height, 10, this.color);
    g.drawImage(this._img, this.x + 10, this.y + 5, this.icon_width / 2, this.icon_height / 2);
    g.setColor(Resources.COLOR.black);
    g.drawText("PollEnrich", this.x + this.width / 6, this.y + this.height / 1.5);
    g.restore();
  }

  toXML() {
    let str = "";
    str += `<pollEnrich id="${this.id}" x="${this.x}" y="${this.y}" scope="${this.scope}" description="${this.description}" expression="${this.expression}" aggregateOnException="${this.aggregateOnException}" cacheSize="${this.cacheSize}" ignoreInvalidEndpoint="${this.ignoreInvalidEndpoint}" strategyMethodAllowNull="${this.strategyMethodAllowNull}" strategyMethodName="${this.strategyMethodName}" strategyRef="${this.strategyRef}" timeout="${this.timeout}">\n <${this.expression}></${this.expression}>\n <description>${this.description}</description>\n </pollEnrich>\n`;

    return str;
  }

  parseXML(xmlNode) {}

  getPropsDesc() {
    return {
      details: ["id", "description", "expression", "aggregateOnException", "cacheSize", "ignoreInvalidEndpoint", "strategyMethodAllowNull", "strategyMethodName", "strategyRef", "timeout"],
    };
  }
}
export default PollEnrich;
