import CamelElement from "../CamelElement";
import { Resources } from "../../utility";
class InOnly extends CamelElement {
  constructor() {
    super();
    this.scope = "InOnly";
    this.parent = "";
    this.inputid = ""; // 线的接入
    this.outputid = ""; // 线的出口
    this.id = "_inOnly";
    this.description = "";
    this.uri = "";
    this.ref_deprecated = ""; // 已弃用(ref)
  }

  paint(g) {
    if (this._img == null) {
      this._img = Resources.IMG_START_NODE;
    }

    g.save();
    this.color = "#cebee1";
    g.drawOvalBorder(this.x, this.y, this.width, this.height, 10, this.color);
    g.drawImage(this._img, this.x + 10, this.y + 5, this.icon_width / 2, this.icon_height / 2);
    g.setColor(Resources.COLOR.black);
    g.drawText("InOnly" + this.id, this.x + this.width / 6, this.y + this.height / 1.5);
    g.restore();
  }

  toXML() {
    let str = "";
    str += `<inOnly id="${this.id}" x="${this.x}" y="${this.y}" scope="${this.scope}" description="${this.description}" uri="${this.uri}" ref="${this.ref_deprecated}">\n <description>${this.description}</description>\n </inOnly>\n`;
    return str;
  }

  parseXML(xmlNode) {}

  getPropsDesc() {
    return {
      details: ["id", "description", "uri", "ref_deprecated"],
    };
  }
}
export default InOnly;
