import CamelElement from "../CamelElement";
import { Resources } from "../../utility";
class Enrich extends CamelElement {
  constructor() {
    super();
    this.scope = "Enrich";
    this.parent = "";
    this.inputid = ""; // 线的接入
    this.outputid = ""; // 线的出口
    this.id = "_enrich";
    this.description = "";
    this.aggregateOnException = "";
    this.cacheSize = "";
    this.ignoreInvalidEndpoint = false;
    this.shareUnitOfWork = false;
    this.strategyMethodAllowNull = false;
    this.strategyMethodName = "";
    this.strategyRef = "";
    this.expression = "";
  }

  paint(g) {
    if (this._img == null) {
      this._img = Resources.IMG_START_NODE;
    }

    g.save();
    this.color = "#cebee1";
    g.drawOvalBorder(this.x, this.y, this.width, this.height, 10, this.color);
    g.drawImage(this._img, this.x + 10, this.y + 5, this.icon_width / 2, this.icon_height / 2);
    g.setColor(Resources.COLOR.black);
    g.drawText("Enrich" + this.id, this.x + this.width / 6, this.y + this.height / 1.5);
    g.restore();
  }

  toXML() {
    let str = "";
    str += `<enrich id="${this.id}" x="${this.x}" y="${this.y}" scope="${this.scope}" description="${this.description}" aggregateOnException="${this.aggregateOnException}" cacheSize="${this.cacheSize}" ignoreInvalidEndpoint="${this.ignoreInvalidEndpoint}" shareUnitOfWork="${this.shareUnitOfWork}" strategyMethodAllowNull="${this.strategyMethodAllowNull}" strategyMethodName="${this.strategyMethodName}" strategyRef="${this.strategyRef}" expression="${this.expression}">\n <description>${this.description}</description>\n </enrich>\n`;
    return str;
  }

  parseXML(xmlNode) {}

  getPropsDesc() {
    return {
      details: ["id", "description", "aggregateOnException", "cacheSize", "ignoreInvalidEndpoint", "shareUnitOfWork", "strategyMethodAllowNull", "strategyMethodName", "strategyRef", "expression"],
    };
  }
}
export default Enrich;
