import CamelElement from "../CamelElement";
import { Resources } from "../../utility";
class WireTap extends CamelElement {
  constructor() {
    super();
    this.scope = "WireTap";
    this.parent = "";
    this.inputid = ""; // 线的接入
    this.outputid = ""; // 线的出口
    this.id = "_wireTap";
    this.description = "";
    this.allowOptimisedComponents = true;
    this.body = "";
    this.cacheSize = "";
    this.copy = true;
    this.dynamicUri = true;
    this.executorServiceRef = "";
    this.ignoreInvalidEndpoint = false;
    this.onPrepareRef = "";
    this.pattern = "";
    this.processorRef = "";
    this.uri = "";
  }

  paint(g) {
    if (this._img == null) {
      this._img = Resources.IMG_START_NODE;
    }

    g.save();
    this.color = "#cebee1";
    g.drawOvalBorder(this.x, this.y, this.width, this.height, 10, this.color);
    g.drawImage(this._img, this.x + 10, this.y + 5, this.icon_width / 2, this.icon_height / 2);
    g.setColor(Resources.COLOR.black);
    g.drawText("WireTap" + this.id, this.x + this.width / 6, this.y + this.height / 1.5);
    g.restore();
  }

  toXML() {
    let str = "";
    str += `<wireTap id="${this.id}" x="${this.x}" y="${this.y}" scope="${this.scope}" description="${this.description}" allowOptimisedComponents="${this.allowOptimisedComponents}" cacheSize="${this.cacheSize}" copy="${this.copy}" dynamicUri="${this.dynamicUri}" executorServiceRef="${this.executorServiceRef}" ignoreInvalidEndpoint="${this.ignoreInvalidEndpoint}" onPrepareRef="${this.onPrepareRef}" pattern="${this.pattern}" processorRef="${this.processorRef}" uri="${this.uri}">\n <description>${this.description}</description>\n </wireTap>\n`;
    return str;
  }

  parseXML(xmlNode) {}

  getPropsDesc() {
    return {
      details: ["id", "description", "allowOptimisedComponents", "cacheSize", "copy", "dynamicUri", "executorServiceRef", "ignoreInvalidEndpoint", "onPrepareRef", "pattern", "processorRef", "uri"],
    };
  }
}
export default WireTap;
