import CamelElement from "../CamelElement";
import { Resources } from "../../utility";
class When extends CamelElement {
  constructor() {
    super();
    this.scope = "When";
    this.parent = "";
    this.inputid = ""; // 线的接入
    this.outputid = ""; // 线的出口
    this.id = "_when";
    this.description = "";
    this.expression = "";
  }

  paint(g) {
    if (this._img == null) {
      this._img = Resources.IMG_START_NODE;
    }

    g.save();
    this.color = "#cebee1";
    g.drawOvalBorder(this.x, this.y, this.width, this.height, 10, this.color);
    g.drawImage(this._img, this.x + 10, this.y + 5, this.icon_width / 2, this.icon_height / 2);
    g.setColor(Resources.COLOR.black);
    g.drawText("When" + this.id, this.x + this.width / 6, this.y + this.height / 1.5);
    g.restore();
  }

  toXML() {
    let str = "";
    str += `<when id="${this.id}" x="${this.x}" y="${this.y}" scope="${this.scope}" description="${this.description}">\n <${this.expression}></${this.expression}>\n <description>${this.description}</description>\n </when>\n`;
    return str;
  }

  parseXML(xmlNode) {}

  getPropsDesc() {
    return {
      details: ["id", "description", "expression"],
    };
  }
}
export default When;
