import CamelElement from "../CamelElement";
import { Resources, Helper } from "../../utility";
import Relation from "../Relation";
import Archor from "../../utility/Archor";
class Route extends CamelElement {
  constructor() {
    super();
    this.width = 250;
    this.height = 300;
    this.scope = "route";
    this.childNode = []; // 存放在route中的元素
    this.input = []; // 线的接入点
    this.output = []; // 线的出口点
    this.helper = new Helper();
    this.isOpenArchor = false; // 是否显示锚点
    this.autoStartup = "";
    this.delayer = "";
    this.description = "";
    this.errorHandlerRef = "";
    this.group = "";
    this.id = "_route";
    this.logMask = "";
    this.messageHistory = "";
    this.routePolicyRef = "";
    this.shutdownRoute = "";
    this.shutdownRunningTask = "";
    this.startupOrder = "";
    this.streamCache = "";
    this.trace = "";
  }
  paint(g) {
    g.save();
    g.drawOvalBorder(this.x, this.y, this.width, this.height, 15, "#e5f8ff");
    g.setColor(Resources.COLOR.black);
    g.setFont("20px sans-serif");
    g.drawString("Route", this.x + 20, this.y + 30);
    g.restore();
    // 画锚点
    // if (this.isOpenArchor) {
    //   const archor = new Archor();
    //   const openArchor = [
    //     { x: 0, y: 0 },
    //     { x: 1, y: 0 },
    //     { x: 1, y: 1 },
    //     { x: 0, y: 1 },
    //   ]; //以当前元素左上角为坐标系，得(0, 0)为左上角，依次类推
    //   const params = { x: this.x, y: this.y, targetW: this.width, targetH: this.height };

    //   archor.setProps(params);
    //   archor.paint(g);
    // }
  }
  getEleToTree(data) {
    let nodes = [];
    for (let i = 0; i < data.length; i++) {
      let fields = {
        text: data[i].scope,
        collapseIcon: "glyphicon glyphicon-plus",
        expandIcon: "glyphicon glyphicon-minus",
      };
      if (!(data[i] instanceof Relation)) nodes.push(fields);
    }
    return nodes;
  }
  // 重新设置宽高
  resetWH(w, h) {
    this.width = w;
    this.height = h;
  }

  toXML() {
    let str = `<route id="${this.id}" x="${this.x}" y="${this.y}" autoStartup="${this.autoStartup}" delayer="${this.delayer}" description="${this.description}" errorHandlerRef="${this.errorHandlerRef}" group="${this.group}"  logMask="${this.logMask}" messageHistory="${this.messageHistory}" routePolicyRef="${this.routePolicyRef}" shutdownRoute="${this.shutdownRoute}" startupOrder="${this.startupOrder}" streamCache="${this.streamCache}" trace="${this.trace}">\n`;

    let arr = this.childNode;
    let rels = [],
      elems = [],
      startEle = {};
    arr.map((item) => {
      if (item instanceof Relation) {
        rels.push(item);
      } else {
        if (item.outputid && !item.inputid) startEle = item;
        else elems.push(item);
      }
    });
    // 如果有连线就输出连线的内容，如果没有连线就直接输出现有的内容
    if (Object.keys(startEle).length != 0) {
      let { tempArr, tempArr2 } = this.transEle(startEle, rels, elems);
      tempArr.forEach((item) => (str += item.toXML()));
      if (tempArr2.length > 0) tempArr2.forEach((item2) => (str += item2.toXML())); //（在有连线数组中的无连线元素)
    } else {
      // 全部没有连线
      elems.map((item, index) => (str += item.toXML(index)));
    }

    str += "</route>\n";
    return str;
  }

  /**
   * 递归找到对应的数组[通过线来找对应的元素]
   * @param {开始元素} startEle
   * @param {线的数组} rels
   * @param {所有元素(除开始元素)} elms
   * @param {需要生成xml的数组} arr
   * @param {没有连线元素的xml} str
   */
  transEle(startEle, rels, elms, arr = []) {
    let selectRelation = {},
      relation = rels,
      elems = elms;
    arr.push(startEle);
    if (elems.length > 0) {
      // 元素还有但是没有连线
      if (relation.length > 0) {
        for (let i = 0; i < relation.length; i++) {
          if (relation[i]._startelemid == startEle.id) {
            selectRelation = relation[i];
            // 减去当前的线条
            relation.splice(i, 1);
            break;
          }
        }
        for (let j = 0; j < elems.length; j++) {
          if (elems[j].id == selectRelation._endelemid) {
            startEle = elems[j];
            elems.splice(j, 1);
            break;
          }
        }
        this.transEle(startEle, relation, elems, arr);
      }
    }
    return { tempArr: arr, tempArr2: elems };
  }

  parseXML(xmlNode) {
    let elem = [],
      camelEle = {},
      that = this;
    const traversalNode = (xmlNode) => {
      // 由于这里的from是根据谁先连线就谁是from来决定的，因此不能直接通过xmlNode来获取tagName
      const tagName = xmlNode.attributes["scope"].value;
      camelEle = this.helper.parseNode(xmlNode, tagName, that);
      elem.push(camelEle);
    };
    if (xmlNode.hasChildNodes()) {
      for (let i = 0; i < xmlNode.children.length; i++) {
        traversalNode(xmlNode.children[i]);
      }
    }

    return elem;
  }
  getPropsDesc() {
    return {
      details: ["autoStartup", "delayer", "description", "name", "errorHandlerRef", "group", "logMask", "messageHistory", "routePolicyRef", "shutdownRoute", "shutdownRunningTask", "startupOrder", "streamCache", "trace"],
      documentation: Route.documentation,
    };
  }
}

Route.documentation = `<div role="tabpanel" class="tab-pane" id="tab2">
<div class="section">
  <div class="titlepage">
    <div>
      <div>
        <h2 class="title" style="clear: both"><a name="routeIcon"></a>Route</h2>
      </div>
    </div>
  </div>
  <div class="toc">
    <p><b>Table of Contents</b></p>
    <dl>
      <dt><span class="section"><a>Usage</a></span></dt>
      <dt><span class="section"><a>Properties</a></span></dt>
    </dl>
  </div>
  <p>Contains all elements that make up an individual route in a routing context</p>
  <div class="section">
    <div class="titlepage">
      <div>
        <div>
          <h3 class="title"><a name="_usage_16"></a>Usage</h3>
        </div>
      </div>
    </div>
    <p>The Route pattern represents the <code class="literal">&lt;route/&gt;</code> element within the
      <code class="literal">&lt;camelContext/&gt;</code> element in a routing context file. You can insert
      multiple Route patterns inside the <code class="literal">&lt;camelContext/&gt;</code> element to build a
      multiple route project.
    </p>
    <p>All route-building patterns and components must be placed on the canvas within a Route
      node.</p>
  </div>
  <div class="section">
    <div class="titlepage">
      <div>
        <div>
          <h3 class="title"><a></a>Properties</h3>
        </div>
      </div>
    </div>
    <div class="table"><a name="RiderRouteRefTbl"></a>
      <p class="title"><b>Table&nbsp;54.&nbsp;Route Properties</b></p>
      <div class="table-contents">
        <table summary="Route Properties" border="1">
          <colgroup>
            <col width="50%" class="col_1">
            <col width="50%" class="col_2">
          </colgroup>
          <thead>
            <tr>
              <th align="left" valign="top">Name</th>
              <th align="left" valign="top">Description</th>
            </tr>
          </thead>
          <tbody>
            <tr>
              <td align="left" valign="top">
                <p><code class="literal">Auto Startup</code></p>
              </td>
              <td align="left" valign="top">
                <p>Specifies whether to start the route automatically when Camel
                  starts up. The default is <span class="emphasis"><em>true</em></span>.</p>
              </td>
            </tr>
            <tr>
              <td align="left" valign="top">
                <p><code class="literal">Delayer</code></p>
              </td>
              <td align="left" valign="top">
                <p>Specifies a delay, in milliseconds, that slows down message
                  processing. This is useful during debugging, making it easier to inspect
                  the logs while tracking messages. The default is
                  <span class="emphasis"><em>0</em></span>.
                </p>
              </td>
            </tr>
            <tr>
              <td align="left" valign="top">
                <p><code class="literal">Description</code></p>
              </td>
              <td align="left" valign="top">
                <p>Specifies a textual description for the route. This description is
                  included in the generated XML file, but it is informational only. It is
                  not used by Apache Camel.</p>
              </td>
            </tr>
            <tr>
              <td align="left" valign="top">
                <p><code class="literal">Error Handler Ref</code></p>
              </td>
              <td align="left" valign="top">
                <p>Specifies a reference to a bean that defines and applies an error
                  handler.</p>
              </td>
            </tr>
            <tr>
              <td align="left" valign="top">
                <p><code class="literal">Group</code></p>
              </td>
              <td align="left" valign="top">
                <p>Specifies the name of a group of which the route is a member. This
                  property is informational only. It is not used by Apache Camel.</p>
              </td>
            </tr>
            <tr>
              <td align="left" valign="top">
                <p><code class="literal">Handle Fault</code></p>
              </td>
              <td align="left" valign="top">
                <p>Specifies whether to convert fault messages into exceptions. Intended
                  for applications deployed into a JBI container, so the Camel error
                  handler can react to faults. The default is
                  <span class="emphasis"><em>false</em></span>.
                </p>
              </td>
            </tr>
            <tr>
              <td align="left" valign="top">
                <p><code class="literal">Id</code></p>
              </td>
              <td align="left" valign="top">
                <p>[<span class="strong"><strong>Required</strong></span>] Specifies a unique id for
                  the route. This id appears in the generated XML in Source view, on the
                  label of the route node on the canvas, and in log entries. The tooling
                  automatically generates and assigns a default Id, but you can change
                  it.</p>
              </td>
            </tr>
            <tr>
              <td align="left" valign="top">
                <p><code class="literal">Message History</code></p>
              </td>
              <td align="left" valign="top">
                <p>Specifies whether to enable/disable Message History. When enabled,
                  Apache Camel captures how the exchange is routed as an
                  <code class="literal">org.apache.camel.MessageHistory</code> entity that is
                  stored on the exchange. This information can be retrieved through Java
                  code or through the error handler exhausted exceptions logs. For
                  details, see <a class="link" href="https://camel.apache.org/message-history.html"
                    target="_top">Apache
                    Camel: Message History</a> The default is
                  <span class="emphasis"><em>true</em></span>.
                </p>
              </td>
            </tr>
            <tr>
              <td align="left" valign="top">
                <p><code class="literal">Route Policy Ref</code></p>
              </td>
              <td align="left" valign="top">
                <p>Specifies a reference to a bean that defines and applies a policy
                  that controls routes at runtime. The bean can implement any logic that
                  you want Apache Camel to invoke at route startup or at route shutdown.</p>
              </td>
            </tr>
            <tr>
              <td align="left" valign="top">
                <p><code class="literal">Shutdown Route</code></p>
              </td>
              <td align="left" valign="top">
                <p>Specifies how to gracefully shut down the route. The options are:</p>
                <div class="itemizedlist">
                  <ul class="itemizedlist" style="list-style-type: disc; ">
                    <li class="listitem"><span class="emphasis"><em>Default</em></span>&#8201;&#8212;&#8201;Shuts
                      the route down as soon as possible, but waits a
                      timeout period of 300 seconds for any inflight and
                      pending messages to complete. After the timeout period,
                      it forces the route and its services to shutdown
                      immediately.</li>
                    <li class="listitem"><span class="emphasis"><em>Defer</em></span>&#8201;&#8212;&#8201;For use
                      when an internal route depends on another. This option defers shutdown
                      until all inflight exchanges have completed, and allows
                      the route to remain active through the graceful shutdown
                      timeout period.</li>
                  </ul>
                </div>
              </td>
            </tr>
            <tr>
              <td align="left" valign="top">
                <p><code class="literal">Shutdown Running Task</code></p>
              </td>
              <td align="left" valign="top">
                <p>Specifies how to shut down a running task, and determines how a route consumer
                  behaves during
                  the shutdown. The options are:</p>
                <div class="itemizedlist">
                  <ul class="itemizedlist" style="list-style-type: disc; ">
                    <li class="listitem"><span class="emphasis"><em>Complete Current Task
                          Only</em></span>&#8201;&#8212;&#8201;[Default] The route
                      consumer
                      shut down as soon as the current, in-progress task
                      (message) has been completed.</li>
                    <li class="listitem"><span class="emphasis"><em>Complete All
                          Tasks</em></span>&#8201;&#8212;&#8201;For use with batch
                      consumers
                      that operate on many messages in batch. The route
                      consumer shuts down after all pending tasks (messages)
                      have been completed.</li>
                  </ul>
                </div>
              </td>
            </tr>
            <tr>
              <td align="left" valign="top">
                <p><code class="literal">Startup Order</code></p>
              </td>
              <td align="left" valign="top">
                <p>Configures the ordering of the routes being started.</p>
              </td>
            </tr>
            <tr>
              <td align="left" valign="top">
                <p><code class="literal">Stream Cache</code></p>
              </td>
              <td align="left" valign="top">
                <p>Specifies whether to cache streams that otherwise could not be
                  accessed multiple times. This is necessary for implementing redelivery
                  during error handling, which requires reading the stream multiple times.
                  The default is <span class="emphasis"><em>false</em></span>.</p>
              </td>
            </tr>
            <tr>
              <td align="left" valign="top">
                <p><code class="literal">Trace</code></p>
              </td>
              <td align="left" valign="top">
                <p>Specifies whether to trace the path of an exchange through a
                  particular route. The default is
                  <span class="emphasis"><em>false</em></span>.
                </p>
              </td>
            </tr>
          </tbody>
        </table>
      </div>
    </div><br class="table-break">
  </div>
</div>
</div>`;
export default Route;
