import CamelElement from "../CamelElement";
import { Resources } from "../../utility";
class Multicast extends CamelElement {
  constructor() {
    super();
    this.scope = "Multicast";
    this.parent = "";
    this.inputid = ""; // 线的接入
    this.outputid = ""; // 线的出口
    this.id = "_multicast";
    this.executorServiceRef = "";
    this.onPrepareRef = "";
    this.parallelAggregate = false;
    this.parallelProcessing = false;
    this.shareUnitOfWork = false;
    this.stopOnAggregateException = false;
    this.stopOnException = false;
    this.strategyMethodAllowNull = false;
    this.strategyMethodName = "";
    this.strategyRef = "";
    this.streaming = false;
    this.timeout = 0;
  }

  paint(g) {
    if (this._img == null) {
      this._img = Resources.IMG_START_NODE;
    }

    g.save();
    this.color = "#cebee1";
    g.drawOvalBorder(this.x, this.y, this.width, this.height, 10, this.color);
    g.drawImage(this._img, this.x + 10, this.y + 5, this.icon_width / 2, this.icon_height / 2);
    g.setColor(Resources.COLOR.black);
    g.drawText("LoadBalance" + this.id, this.x + this.width / 6, this.y + this.height / 1.5);
    g.restore();
  }

  toXML() {
    let str = "";
    str += `<Multicast id="${this.id}" x="${this.x}" y="${this.y}" scope="${this.scope}" executorServiceRef="${this.executorServiceRef}" onPrepareRef="${this.onPrepareRef}" parallelAggregate = "${this.parallelAggregate}" parallelProcessing="${this.parallelProcessing}" shareUnitOfWork="${this.shareUnitOfWork}" stopOnAggregateException = "${this.stopOnAggregateException}" stopOnException = "${this.stopOnException}" strategyMethodAllowNull = "${this.strategyMethodAllowNull}" strategyMethodName = "${this.strategyMethodName}" strategyRef = "${this.strategyRef}" streaming = "${this.streaming}" timeout = "${this.timeout}"
    >\n <description>${this.description}</description>\n </Multicast>\n`;
    return str;
  }

  parseXML(xmlNode) {}

  getPropsDesc() {
    return {
      details: [
        "id",
        "executorServiceRef",
        "onPrepareRef",
        "parallelAggregate",
        "parallelProcessing",
        "shareUnitOfWork",
        "stopOnAggregateException",
        "stopOnException",
        "strategyMethodAllowNull",
        "strategyMethodName",
        "strategyRef",
        "streaming",
        "timeout",
      ],
    };
  }
}
export default Multicast;
