import CamelElement from "../CamelElement";
import { Resources } from "../../utility";
class IdempotentConsumer extends CamelElement {
  constructor() {
    super();
    this.scope = "IdempotentConsumer";
    this.parent = "";
    this.inputid = ""; // 线的接入
    this.outputid = ""; // 线的出口
    this.expression = "";
    this.completionEager = false;
    this.eager = true;
    this.messageIdRepositoryRef = "";
    this.removeOnFailure = true;
    this.skipDuplicate = true;
    this.id = "_idempotentConsumer";
    this.description = "";
    this.expression = "";
  }

  paint(g) {
    if (this._img == null) {
      this._img = Resources.IMG_START_NODE;
    }

    g.save();
    this.color = "#cebee1";
    g.drawOvalBorder(this.x, this.y, this.width, this.height, 10, this.color);
    g.drawImage(this._img, this.x + 10, this.y + 5, this.icon_width / 2, this.icon_height / 2);
    g.setColor(Resources.COLOR.black);
    g.drawText("IdempotentConsumer" + this.id, this.x + this.width / 6, this.y + this.height / 1.5);
    g.restore();
  }

  toXML() {
    let str = "";
    str += `<idempotentConsumer id="${this.id}" x="${this.x}" y="${this.y}" scope="${this.scope}"  completionEager = "${this.completionEager}" eager = "${this.eager}" messageIdRepositoryRef = "${this.messageIdRepositoryRef}" removeOnFailure = "${this.removeOnFailure}" skipDuplicate = "${this.skipDuplicate}" id = "${this.id}" description = "${this.description}" expression = "${this.expression}">\n <${this.expression}></${this.expression}>\n <description>${this.description}</description>\n </idempotentConsumer>\n`;

    return str;
  }

  parseXML(xmlNode) {}

  getPropsDesc() {
    return {
      details: ["expression", "completionEager", "eager", "messageIdRepositoryRef", "removeOnFailure", "skipDuplicate", "id", "description", "expression"],
    };
  }
}
export default IdempotentConsumer;
