import CamelElement from "../CamelElement";
import { Resources } from "../../utility";
class Choice extends CamelElement {
  constructor() {
    super();
    this.scope = "Choice";
    this.parent = "";
    this.inputid = ""; // 线的接入
    this.outputid = ""; // 线的出口
    this.id = "_choice";
    this.description = "";
  }

  paint(g) {
    if (this._img == null) {
      this._img = Resources.IMG_START_NODE;
    }

    g.save();
    this.color = "#cebee1";
    g.drawOvalBorder(this.x, this.y, this.width, this.height, 10, this.color);
    g.drawImage(this._img, this.x + 10, this.y + 5, this.icon_width / 2, this.icon_height / 2);
    g.setColor(Resources.COLOR.black);
    g.drawText("Choice", this.x + this.width / 6, this.y + this.height / 1.5);
    g.restore();
  }

  toXML() {
    let str = "";
    str += `<choice id="${this.id}" x="${this.x}" y="${this.y}" scope="${this.scope}" description="${this.description}">\n <description>${this.description}</description>\n </choice>\n`;
    return str;
  }

  parseXML(xmlNode) {}

  getPropsDesc() {
    return {
      details: ["id", "description"],
    };
  }
}
export default Choice;
