import CamelElement from "../CamelElement";
import { Resources } from "../../utility";
class Aggregate extends CamelElement {
  constructor() {
    super();
    this.scope = "Aggregate";
    this.parent = "";
    this.inputid = ""; // 线的接入
    this.outputid = ""; // 线的出口
    this.correlationExpression = "";
    this.aggregateControllerRef = "";
    this.aggregationRepositoryRef = "";
    this.closeCorrelationKeyOnCompletion = "";
    this.completeAllOnStop = false;
    this.completionFromBatchConsumer = false;
    this.completionInterval = "";
    this.completionOnNewCorrelationGroup = false;
    this.completionPredicate = "";
    this.completionSize = "";
    this.completionTimeout = "";
    this.completionTimeoutCheckerInterval = 1000;
    this.discription = "";
    this.discardOnCompletionTimeout = false;
    this.eagerCheckCompletion = false;
    this.executorServiceRef = "";
    this.forceCompletionOnStop = false;
    this.groupExchanges = false;
    this.id = "_aggregate";
    this.ignoreInvalidCorrelationKeys = false;
    this.optimisticLocking = false;
    this.parallelProcessing = false;
    this.strategyMethodAllowNull = false;
    this.strategyMethodName = "";
    this.strategyRef = "";
    this.timeoutCheckerExecutorServiceRef = "";
    this.description = "";
  }

  paint(g) {
    if (this._img == null) {
      this._img = Resources.IMG_START_NODE;
    }

    g.save();
    this.color = "#cebee1";
    g.drawOvalBorder(this.x, this.y, this.width, this.height, 10, this.color);
    g.drawImage(this._img, this.x + 10, this.y + 5, this.icon_width / 2, this.icon_height / 2);
    g.setColor(Resources.COLOR.black);
    g.drawText(this.id, this.x + this.width / 6, this.y + this.height / 1.5);
    g.restore();
  }

  toXML() {
    let str = "";
    str += `<aggregate id="${this.id}" x="${this.x}" y="${this.y}" scope="${this.scope}"  aggregateControllerRef="${this.aggregateControllerRef}" aggregationRepositoryRef="${this.aggregationRepositoryRef}" closeCorrelationKeyOnCompletion="${this.closeCorrelationKeyOnCompletion}" completeAllOnStop="${this.completeAllOnStop}" completionFromBatchConsumer="${this.completionFromBatchConsumer}" completionInterval="${this.completionInterval}" completionOnNewCorrelationGroup="${this.completionOnNewCorrelationGroup}" completionSize="${this.completionSize}" completionTimeout="${this.completionTimeout}" completionTimeoutCheckerInterval="${this.completionTimeoutCheckerInterval}" discription="${this.discription}" discardOnCompletionTimeout="${this.discardOnCompletionTimeout}" eagerCheckCompletion="${this.eagerCheckCompletion}" executorServiceRef="${this.executorServiceRef}" forceCompletionOnStop="${this.forceCompletionOnStop}" groupExchanges="${this.groupExchanges}" ignoreInvalidCorrelationKeys="${this.ignoreInvalidCorrelationKeys}" optimisticLocking="${this.optimisticLocking}" parallelProcessing="${this.parallelProcessing}" strategyMethodAllowNull="${this.strategyMethodAllowNull}" strategyMethodName="${this.strategyMethodName}" strategyRef="${this.strategyRef}" timeoutCheckerExecutorServiceRef="${this.timeoutCheckerExecutorServiceRef}">\n <description>${this.description}</description>\n </aggregate>\n`;
    return str;
  }

  parseXML(xmlNode) {}

  getPropsDesc() {
    return {
      details: [
        "correlationExpression",
        "aggregateControllerRef",
        "aggregationRepositoryRef",
        "closeCorrelationKeyOnCompletion",
        "completeAllOnStop",
        "completionFromBatchConsumer",
        "completionInterval",
        "completionOnNewCorrelationGroup",
        "completionPredicate",
        "completionSize",
        "completionTimeout",
        "completionTimeoutCheckerInterval",
        "discription",
        "discardOnCompletionTimeout",
        "eagerCheckCompletion",
        "executorServiceRef",
        "forceCompletionOnStop",
        "groupExchanges",
        "ignoreInvalidCorrelationKeys",
        "optimisticLocking",
        "id",
        "parallelProcessing",
        "strategyMethodAllowNull",
        "strategyMethodName",
        "strategyRef",
        "timeoutCheckerExecutorServiceRef",
      ],
    };
  }
}
export default Aggregate;
