import CamelElement from "../CamelElement";
import { Resources } from "../../utility";
class Threads extends CamelElement {
  constructor() {
    super();
    this.scope = "Threads";
    this.parent = "";
    this.inputid = ""; // 线的接入
    this.outputid = ""; // 线的出口
    this.id = "_threads";
    this.description = "";
    this.allowCoreThreadTimeOut = "";
    this.callerRunsWhenRejected = "";
    this.executorServiceRef = "";
    this.keepAliveTime = "";
    this.maxPoolSize = "";
    this.maxQueueSize = "";
    this.poolSize = "";
    this.rejectedPolicy = "";
    this.threadName = "Threads";
    this.timeUnit = "";
  }

  paint(g) {
    if (this._img == null) {
      this._img = Resources.IMG_START_NODE;
    }

    g.save();
    this.color = "#cebee1";
    g.drawOvalBorder(this.x, this.y, this.width, this.height, 10, this.color);
    g.drawImage(this._img, this.x + 10, this.y + 5, this.icon_width / 2, this.icon_height / 2);
    g.setColor(Resources.COLOR.black);
    g.drawText("Threads" + this.id, this.x + this.width / 6, this.y + this.height / 1.5);
    g.restore();
  }

  toXML() {
    let str = "";
    str += `<threads id="${this.id}" x="${this.x}" y="${this.y}" scope="${this.scope}" description="${this.description}"allowCoreThreadTimeOut="${this.allowCoreThreadTimeOut}" callerRunsWhenRejected="${this.callerRunsWhenRejected}" executorServiceRef="${this.executorServiceRef}" keepAliveTime="${this.keepAliveTime}" maxPoolSize="${this.maxPoolSize}" maxQueueSize="${this.maxQueueSize}" poolSize="${this.poolSize}" rejectedPolicy="${this.rejectedPolicy}" threadName="${this.threadName}" timeUnit="${this.timeUnit}">\n <description>${this.description}</description>\n </threads>\n`;
    return str;
  }

  parseXML(xmlNode) {}

  getPropsDesc() {
    return {
      details: ["id", "description", "allowCoreThreadTimeOut", "callerRunsWhenRejected", "executorServiceRef", "keepAliveTime", "maxPoolSize", "maxQueueSize", "poolSize", "rejectedPolicy", "threadName", "timeUnit"],
    };
  }
}
export default Threads;
