import CamelElement from "../CamelElement";
import { Resources } from "../../utility";
class Throttle extends CamelElement {
  constructor() {
    super();
    this.scope = "Throttle";
    this.parent = "";
    this.inputid = ""; // 线的接入
    this.outputid = ""; // 线的出口
    this.id = "_throttle";
    this.expression = "";
    this.asyncDelayed = false;
    this.callerRunsWhenRejected = true;
    this.executorServiceRef = "";
    this.rejectExecution = false;
    this.timePeriodMillis = 1000;
  }

  paint(g) {
    if (this._img == null) {
      this._img = Resources.IMG_START_NODE;
    }

    g.save();
    this.color = "#cebee1";
    g.drawOvalBorder(this.x, this.y, this.width, this.height, 10, this.color);
    g.drawImage(this._img, this.x + 10, this.y + 5, this.icon_width / 2, this.icon_height / 2);
    g.setColor(Resources.COLOR.black);
    g.drawText("Throttle" + this.id, this.x + this.width / 6, this.y + this.height / 1.5);
    g.restore();
  }

  toXML() {
    let str = "";
    if (this.expression)
      str += `<throttle id="${this.id}" x="${this.x}" y="${this.y}" scope="${this.scope}" description="${this.description}" expression="${this.expression}" asyncDelayed="${this.asyncDelayed}" callerRunsWhenRejected="${this.callerRunsWhenRejected}" executorServiceRef="${this.executorServiceRef}" rejectExecution="${this.rejectExecution}" timePeriodMillis="${this.timePeriodMillis}">\n <${this.expression}></${this.expression}>\n <description>${this.description}</description>\n </throttle>\n`;
    else
      str += `<throttle id="${this.id}" x="${this.x}" y="${this.y}" scope="${this.scope}" description="${this.description}" expression="${this.expression}" asyncDelayed="${this.asyncDelayed}" callerRunsWhenRejected="${this.callerRunsWhenRejected}" executorServiceRef="${this.executorServiceRef}" rejectExecution="${this.rejectExecution}" timePeriodMillis="${this.timePeriodMillis}">\n <description>${this.description}</description>\n </throttle>\n`;
    return str;
  }

  parseXML(xmlNode) {}

  getPropsDesc() {
    return {
      details: ["id", "description", "expression", "asyncDelayed", "callerRunsWhenRejected", "executorServiceRef", "rejectExecution", "timePeriodMillis"],
    };
  }
}
export default Throttle;
