import CamelElement from "../CamelElement";
import { Resources } from "../../utility";
class OnException extends CamelElement {
  constructor() {
    super();
    this.scope = "OnException";
    this.parent = "";
    this.inputid = ""; // 线的接入
    this.outputid = ""; // 线的出口
    this.id = "_onException";
    this.description = "";
    this.exception = "";
    this.onExceptionOccurredRef = "";
    this.onRedeliveryRef = "";
    this.redeliveryPolicyRef = "";
    this.useOriginalMessage = "";
    this.retryWhile = "";
    this.handled = "";
    this.continued = "";
  }

  paint(g) {
    if (this._img == null) {
      this._img = Resources.IMG_START_NODE;
    }

    g.save();
    this.color = "#cebee1";
    g.drawOvalBorder(this.x, this.y, this.width, this.height, 10, this.color);
    g.drawImage(this._img, this.x + 10, this.y + 5, this.icon_width / 2, this.icon_height / 2);
    g.setColor(Resources.COLOR.black);
    g.drawText("OnException" + this.id, this.x + this.width / 6, this.y + this.height / 1.5);
    g.restore();
  }

  toXML() {
    let str = "";
    str += `<onException id="${this.id}" x="${this.x}" y="${this.y}" scope="${this.scope}" description="${this.description}" exception="${this.exception}" onExceptionOccurredRef="${this.onExceptionOccurredRef}" onRedeliveryRef="${this.onRedeliveryRef}" redeliveryPolicyRef="${this.redeliveryPolicyRef}" useOriginalMessage="${this.useOriginalMessage}" retryWhile="${this.retryWhile}" handled="${this.handled}" continued="${this.continued}">\n <retryWhile>${this.retryWhile}</retryWhile> \n <handled>${this.handled}</handled> \n <continued>${this.continued}</continued>\n <description>${this.description}</description>\n </onException>\n`;
    return str;
  }

  parseXML(xmlNode) {}

  getPropsDesc() {
    return {
      details: ["id", "description", "exception", "onExceptionOccurredRef", "onRedeliveryRef", "redeliveryPolicyRef", "useOriginalMessage", "retryWhile", "handled", "continued"],
    };
  }
}
export default OnException;
