import CamelElement from "../CamelElement";
import { Resources, StringUtil } from "../../utility";
class XSLT extends CamelElement {
  constructor() {
    super();
    this.scope = "XSLT";
    this.hasUri = true;
    this.parent = "";
    this.inputid = ""; // 线的接入
    this.outputid = ""; // 线的出口
    this.description = ""; // 描述
    this.id = "xslt"; // 名字
    this.ref_deprecated = ""; // 已弃用(ref)
    this.resourceUri = "resourceUri";
    this.uri = `xquery:${this.resourceUri}`; // uri
    this.allowStAX = true;
    this.contentCache = true;
    this.deleteOutputFile = false;
    this.failOnNullBody = true;
    this.output = "string";
    this.saxon = false;
    this.transformerCacheSize = 0;
    this.converter = "";
    this.entityResolver = "";
    this.errorListener = "";
    this.resultHandlerFactory = "";
    this.saxonConfiguration = "";
    this.saxonExtensionFunctions = "";
    this.synchronous = false;
    this.transformerFactory = "";
    this.transformerFactoryClass = "";
    this.uriResolver = "";
  }

  paint(g) {
    if (this._img == null) {
      this._img = Resources.IMG_START_NODE;
    }

    g.save();
    this.color = "#cebee1";
    g.drawOvalBorder(this.x, this.y, this.width, this.height, 10, this.color);
    g.drawImage(this._img, this.x + 10, this.y + 5, this.icon_width / 2, this.icon_height / 2);
    g.setColor(Resources.COLOR.black);
    g.drawText(this.uri, this.x + this.width / 6, this.y + this.height / 1.5);
    g.restore();
  }

  toXML(index) {
    let str = "";
    const uriValue = StringUtil.encodeHTML(this.uri);
    if ((this.outputid && !this.inputid) || index == 0) {
      str += `<from id="${this.id}" x="${this.x}" y="${this.y}" uri="${uriValue}"  ref="${this.ref_deprecated}" scope="${this.scope}">\n <description>${this.description}</description>\n </from>\n`;
    } else {
      str = `<to id="${this.id}" x="${this.x}" y="${this.y}" uri="${uriValue}"   ref="${this.ref_deprecated}" scope="${this.scope}">\n  <description>${this.description}</description>\n </to>\n`;
    }
    return str;
  }

  parseXML(xmlNode) {}

  getPropsDesc() {
    return {
      details: ["uri", "description", "id", "pattern", "ref_deprecated"],
      advanced: {
        path: ["resourceUri"],
        producer: ["allowStAX", "contentCache", "deleteOutputFile", "failOnNullBody", "output", "saxon", "transformerCacheSize"],
        advanceds: ["converter", "entityResolver", "errorListener", "resultHandlerFactory", "saxonConfiguration", "saxonExtensionFunctions", "synchronous", "transformerFactory", "transformerFactoryClass", "uriResolver"],
      },
      documentation: XSLT.documentation,
    };
  }
}
XSLT.documentation = ``;
export default XSLT;
