import CamelElement from "../CamelElement";
import { Resources, StringUtil } from "../../utility";
class XQuery extends CamelElement {
  constructor() {
    super();
    this.scope = "XQuery";
    this.hasUri = true;
    this.parent = "";
    this.inputid = ""; // 线的接入
    this.outputid = ""; // 线的出口
    this.description = ""; // 描述
    this.id = "xquery"; // 名字
    this.ref_deprecated = ""; // 已弃用(ref)
    this.resourceUri = "resourceUri";
    this.uri = `xquery:${this.resourceUri}`; // uri
    this.allowStAX = false;
    this.headerName = "";
    this.namespacePrefixes = "";
    this.resultType = "";
    this.resultsFormat = "DOM";
    this.stripsAllWhiteSpace = true;
    this.bridgeErrorHandler = false;
    this.sendEmptyMessageWhenIdle = false;
    this.exceptionHandler = "";
    this.exchangePattern = "";
    this.pollStrategy = "";
    this.configuration = "";
    this.configurationProperties = "";
    this.moduleURIResolver = "";
    this.parameters = "";
    this.properties = "";
    this.staticQueryContext = "";
    this.synchronous = false;
    this.backoffErrorThreshold = "";
    this.backoffIdleThreshold = "";
    this.backoffMultiplier = "";
    this.delay = 500;
    this.greedy = false;
    this.initialDelay = 1000;
    this.runLoggingLevel = "TRACE";
    this.scheduledExecutorService = "";
    this.scheduler = "none";
    this.schedulerProperties = "";
    this.startScheduler = true;
    this.timeUnit = "MILLISECONDS";
    this.useFixedDelay = true;
  }

  paint(g) {
    if (this._img == null) {
      this._img = Resources.IMG_START_NODE;
    }

    g.save();
    this.color = "#cebee1";
    g.drawOvalBorder(this.x, this.y, this.width, this.height, 10, this.color);
    g.drawImage(this._img, this.x + 10, this.y + 5, this.icon_width / 2, this.icon_height / 2);
    g.setColor(Resources.COLOR.black);
    g.drawText(this.uri, this.x + this.width / 6, this.y + this.height / 1.5);
    g.restore();
  }

  /**
   * 更新uri(一个冒号)
   * @param {原始的组件数据} intValue
   * @param {现在要更新的值} prop
   * @returns
   */
  updateUri(intValue, prop) {
    let tempArr = this.getPropsDesc().advanced["path"];
    return this.changeUri(intValue, this, prop, tempArr, 1);
  }

  toXML(index) {
    let str = "";
    const uriValue = StringUtil.encodeHTML(this.uri);
    if ((this.outputid && !this.inputid) || index == 0) {
      str += `<from id="${this.id}" x="${this.x}" y="${this.y}" uri="${uriValue}"  ref="${this.ref_deprecated}" scope="${this.scope}">\n <description>${this.description}</description>\n </from>\n`;
    } else {
      str = `<to id="${this.id}" x="${this.x}" y="${this.y}" uri="${uriValue}"   ref="${this.ref_deprecated}" scope="${this.scope}">\n  <description>${this.description}</description>\n </to>\n`;
    }
    return str;
  }

  parseXML(xmlNode) {}

  getPropsDesc() {
    return {
      details: ["uri", "description", "id", "pattern", "ref_deprecated"],
      advanced: {
        path: ["resourceUri"],
        common: ["allowStAX", "headerName", "namespacePrefixes", "resultType", "resultsFormat", "stripsAllWhiteSpace"],
        consumer: ["bridgeErrorHandler", "sendEmptyMessageWhenIdle"],
        consumer_advanced: ["exceptionHandler", "exchangePattern", "pollStrategy"],
        advanced: ["configuration", "configurationProperties", "moduleURIResolver", "parameters", "properties", "staticQueryContext", "synchronous"],
        scheduler: [
          "backoffErrorThreshold",
          "backoffIdleThreshold",
          "backoffMultiplier",
          "delay",
          "greedy",
          "initialDelay",
          "runLoggingLevel",
          "scheduledExecutorService",
          "scheduler",
          "schedulerProperties",
          "startScheduler",
          "timeUnit",
          "useFixedDelay",
        ],
      },
      documentation: XQuery.documentation,
    };
  }
}
XQuery.documentation = ``;
export default XQuery;
