import CamelElement from "../CamelElement";
import { Resources, StringUtil } from "../../utility";
class Servlet extends CamelElement {
  constructor() {
    super();
    this.scope = "Servlet";
    this.hasUri = true;
    this.parent = "";
    this.inputid = ""; // 线的接入
    this.outputid = ""; // 线的出口
    this.uri = "servlet:query"; // uri
    this.description = ""; // 描述
    this.id = "sql"; // 名字
    this.ref_deprecated = ""; // 已弃用(ref)
    this.contextPath = "";
    this.async = false;
    this.bridgeErrorHandler = false;
    this.chunked = true;
    this.httpMethodRestrict = "";
    this.matchOnUriPrefix = false;
    this.responseBufferSize = "";
    this.servletName = "CamelServlet";
    this.transferException = false;
    this.disableStreamCache = false;
    this.headerFilterStrategy = "";
    this.httpBinding = "";
    this.attachmentMultipartBinding = false;
    this.eagerCheckContentAvailable = false;
    this.exceptionHandler = "";
    this.exchangePattern = "";
    this.fileNameExtWhitelist = "";
    this.optionsEnabled = false;
    this.traceEnabled = false;
    this.mapHttpMessageBody = true;
    this.mapHttpMessageFormUrlEncodedBody = true;
    this.mapHttpMessageHeaders = true;
    this.synchronous = false;
  }

  paint(g) {
    if (this._img == null) {
      this._img = Resources.IMG_START_NODE;
    }

    g.save();
    this.color = "#cebee1";
    g.drawOvalBorder(this.x, this.y, this.width, this.height, 10, this.color);
    g.drawImage(this._img, this.x + 10, this.y + 5, this.icon_width / 2, this.icon_height / 2);
    g.setColor(Resources.COLOR.black);
    g.drawText(this.uri, this.x + this.width / 6, this.y + this.height / 1.5);
    g.restore();
  }

  /**
   * 更新uri(一个冒号)
   * @param {原始的组件数据} intValue
   * @param {现在要更新的值} prop
   * @returns
   */
  updateUri(intValue, prop) {
    let tempArr = this.getPropsDesc().advanced["path"];
    return this.changeUri(intValue, this, prop, tempArr, 1);
  }

  toXML(index) {
    let str = "";
    const uriValue = StringUtil.encodeHTML(this.uri);
    if ((this.outputid && !this.inputid) || index == 0) {
      str += `<from id="${this.id}" x="${this.x}" y="${this.y}" uri="${uriValue}"  ref="${this.ref_deprecated}" scope="${this.scope}">\n <description>${this.description}</description>\n </from>\n`;
    } else {
      str = `<to id="${this.id}" x="${this.x}" y="${this.y}" uri="${uriValue}"   ref="${this.ref_deprecated}" scope="${this.scope}">\n  <description>${this.description}</description>\n </to>\n`;
    }
    return str;
  }

  parseXML(xmlNode) {}

  getPropsDesc() {
    return {
      details: ["uri", "description", "id", "pattern", "ref_deprecated"],
      advanced: {
        path: ["contextPath"],
        consumer: ["async", "bridgeErrorHandler", "chunked", "httpMethodRestrict", "matchOnUriPrefix", "responseBufferSize", "servletName", "transferException"],
        common: ["disableStreamCache", "headerFilterStrategy"],
        common_advanced: ["httpBinding"],
        consumer_advanced: ["attachmentMultipartBinding", "eagerCheckContentAvailable", "exceptionHandler", "exchangePattern", "fileNameExtWhitelist", "optionsEnabled", "traceEnabled"],
        advanced: ["mapHttpMessageBody", "mapHttpMessageFormUrlEncodedBody", "mapHttpMessageHeaders", "synchronous"],
      },
      documentation: Servlet.documentation,
    };
  }
}
Servlet.documentation = ``;
export default Servlet;
