import CamelElement from "../CamelElement";
import { Resources, StringUtil } from "../../utility";
class Scheduler extends CamelElement {
  constructor() {
    super();
    this.scope = "Scheduler";
    this.hasUri = true;
    this.parent = "";
    this.inputid = ""; // 线的接入
    this.outputid = ""; // 线的出口
    this.uri = "scheduler:query"; // uri
    this.description = ""; // 描述
    this.id = "scheduler"; // 名字
    this.ref_deprecated = ""; // 已弃用(ref)
    this.name = "";
    this.bridgeErrorHandler = false;
    this.sendEmptyMessageWhenIdle = false;
    this.exceptionHandler = "";
    this.exchangePattern = "";
    this.pollStrategy = "";
    this.synchronous = false;
    this.backoffErrorThreshold = "";
    this.backoffIdleThreshold = "";
    this.backoffMultiplier = 1;
    this.delay = 500;
    this.greedy = false;
    this.initialDelay = 1000;
    this.runLoggingLevel = "TRACE";
    this.scheduledExecutorService = "";
    this.scheduler = "none";
    this.schedulerProperties = "";
    this.startScheduler = true;
    this.timeUnit = "MILLISECONDS";
    this.useFixedDelay = true;
  }

  paint(g) {
    if (this._img == null) {
      this._img = Resources.IMG_START_NODE;
    }

    g.save();
    this.color = "#cebee1";
    g.drawOvalBorder(this.x, this.y, this.width, this.height, 10, this.color);
    g.drawImage(this._img, this.x + 10, this.y + 5, this.icon_width / 2, this.icon_height / 2);
    g.setColor(Resources.COLOR.black);
    g.drawText(this.uri, this.x + this.width / 6, this.y + this.height / 1.5);
    g.restore();
  }

  toXML(index) {
    let str = "";
    const uriValue = StringUtil.encodeHTML(this.uri);
    if ((this.outputid && !this.inputid) || index == 0) {
      str += `<from id="${this.id}" x="${this.x}" y="${this.y}" uri="${uriValue}"  ref="${this.ref_deprecated}" scope="${this.scope}">\n <description>${this.description}</description>\n </from>\n`;
    } else {
      str = `<to id="${this.id}" x="${this.x}" y="${this.y}" uri="${uriValue}"   ref="${this.ref_deprecated}" scope="${this.scope}">\n  <description>${this.description}</description>\n </to>\n`;
    }
    return str;
  }

  parseXML(xmlNode) {}

  getPropsDesc() {
    return {
      details: ["uri", "description", "id", "pattern", "ref_deprecated"],
      advanced: {
        path: ["name"],
        consumer: ["bridgeErrorHandler", "sendEmptyMessageWhenIdle"],
        consumer_advanced: ["exceptionHandler", "exchangePattern", "pollStrategy"],
        advanceds: ["synchronous"],
        scheduler: [
          "backoffErrorThreshold",
          "backoffIdleThreshold",
          "backoffMultiplier",
          "delay",
          "greedy",
          "initialDelay",
          "runLoggingLevel",
          "scheduledExecutorService",
          "scheduler",
          "schedulerProperties",
          "startScheduler",
          "timeUnit",
          "useFixedDelay",
        ],
      },
      documentation: Scheduler.documentation,
    };
  }
}
Scheduler.documentation = ``;
export default Scheduler;
