import CamelElement from "../CamelElement";
import { Resources, StringUtil } from "../../utility";
class Salesforce extends CamelElement {
  constructor() {
    super();
    this.scope = "Salesforce";
    this.hasUri = true;
    this.parent = "";
    this.inputid = ""; // 线的接入
    this.outputid = ""; // 线的出口
    this.uri = "sql:query"; // uri
    this.description = ""; // 描述
    this.id = "sql"; // 名字
    this.pattern = "";
    this.ref_deprecated = ""; // 已弃用(ref)
    this.operationName = "operationName";
    this.topicName = "";
    this.bridgeErrorHandler = false;
    this.replayId = "";
    this.apexMethod = "";
    this.apexQueryParams = "";
    this.apexUrl = "";
    this.apiVersion = "";
    this.backoffIncrement = "";
    this.batchId = "";
    this.contentType = "";
    this.defaultReplayId = "";
    this.format = "";
    this.includeDetails = false;
    this.initialReplayIdMap = "";
    this.instanceId = "";
    this.jobId = "";
    this.limit = "";
    this.maxBackoff = "";
    this.notFoundBehaviour = "";
    this.notifyForFields = "";
    this.notifyForOperationCreate = false;
    this.notifyForOperationDelete = false;
    this.notifyForOperationUndelete = false;
    this.notifyForOperationUpdate = false;
    this.notifyForOperations = "";
    this.objectMapper = "";
    this.rawPayload = false;
    this.reportId = "";
    this.reportMetadata = "";
    this.resultId = "";
    this.sObjectBlobFieldName = "";
    this.sObjectClass = "";
    this.sObjectFields = "";
    this.sObjectId = "";
    this.sObjectIdName = "";
    this.sObjectIdValue = "";
    this.sObjectName = "";
    this.sObjectSearch = "";
    this.sObjectQuery = "";
    this.serializeNulls = false;
    this.updateTopic = false;
    this.exceptionHandler = "";
    this.exchangePattern = "";
    this.synchronous = false;
  }

  paint(g) {
    if (this._img == null) {
      this._img = Resources.IMG_START_NODE;
    }

    g.save();
    this.color = "#cebee1";
    g.drawOvalBorder(this.x, this.y, this.width, this.height, 10, this.color);
    g.drawImage(this._img, this.x + 10, this.y + 5, this.icon_width / 2, this.icon_height / 2);
    g.setColor(Resources.COLOR.black);
    g.drawText(this.uri, this.x + this.width / 6, this.y + this.height / 1.5);
    g.restore();
  }

  toXML(index) {
    let str = "";
    const uriValue = StringUtil.encodeHTML(this.uri);
    if ((this.outputid && !this.inputid) || index == 0) {
      str += `<from id="${this.id}" x="${this.x}" y="${this.y}" uri="${uriValue}"  ref="${this.ref_deprecated}" scope="${this.scope}">\n <description>${this.description}</description>\n </from>\n`;
    } else {
      str = `<to id="${this.id}" x="${this.x}" y="${this.y}" uri="${uriValue}"   ref="${this.ref_deprecated}" scope="${this.scope}">\n  <description>${this.description}</description>\n </to>\n`;
    }
    return str;
  }

  parseXML(xmlNode) {}

  getPropsDesc() {
    return {
      details: ["uri", "description", "id", "pattern", "ref_deprecated"],
      advanced: {
        path: ["operationName", "topicName"],
        consumer: ["bridgeErrorHandler", "replayId"],
        common: [
          "apexMethod",
          "apexQueryParams",
          "apexUrl",
          "apiVersion",
          "backoffIncrement",
          "batchId",
          "clientHttp",
          "contentType",
          "defaultReplayId",
          "format",
          "includeDetails",
          "initialReplayIdMap",
          "instanceId",
          "jobId",
          "limit",
          "maxBackoff",
          "notFoundBehaviour",
          "notifyForFields",
          "notifyForOperationCreate",
          "notifyForOperationDelete",
          "notifyForOperationUndelete",
          "notifyForOperationUpdate",
          "notifyForOperations",
          "objectMapper",
          "rawPayload",
          "reportId",
          "reportMetadata",
          "resultId",
          "sObjectBlobFieldName",
          "sObjectClass",
          "sObjectFields",
          "sObjectId",
          "sObjectIdName",
          "sObjectIdValue",
          "sObjectName",
          "sObjectSearch",
          "sObjectQuery",
          "serializeNulls",
          "updateTopic",
        ],
        consumer_advanced: ["exceptionHandler", "exchangePattern"],
        advanced: ["synchronous"],
      },
      documentation: Salesforce.documentation,
    };
  }
}
Salesforce.documentation = ``;
export default Salesforce;
