import CamelElement from "../CamelElement";
import { Resources, StringUtil } from "../../utility";
class SNMP extends CamelElement {
  constructor() {
    super();
    this.scope = "SNMP";
    this.hasUri = true;
    this.parent = "";
    this.inputid = ""; // 线的接入
    this.outputid = ""; // 线的出口
    this.description = ""; // 描述
    this.id = "snmp"; // 名字
    this.pattern = ""; //图案
    this.ref_deprecated = ""; // 已弃用(ref)
    this.host = "host";
    this.port = "port";
    this.uri = `snmp:${this.host}:${this.port}`; // uri
    this.bridgeErrorHandler = false;
    this.delay = 60000;
    this.oids = "";
    this.protocol = "udp";
    this.retries = 2;
    this.sendEmptyMessageWhenIdle = false;
    this.snmpCommunity = "public";
    this.snmpContextEngineId = "";
    this.snmpContextName = "";
    this.snmpVersion = "0";
    this.timeout = 1500;
    this.treeList = false;
    this.type = "";
    this.exceptionHandler = "";
    this.exchangePattern = "";
    this.pollStrategy = "";
    this.synchronous = false;
    this.backoffErrorThreshold = "";
    this.backoffIdleThreshold = "";
    this.backoffMultiplier = "";
    this.greedy = false;
    this.initialDelay = 1000;
    this.runLoggingLevel = "TRACE";
    this.scheduledExecutorService = "";
    this.scheduler = "none";
    this.schedulerProperties = "";
    this.startScheduler = true;
    this.timeUnit = "MILLISECONDS";
    this.useFixedDelay = true;
    this.authenticationPassphrase = "";
    this.authenticationProtocol = "";
    this.privacyPassphrase = "";
    this.privacyProtocol = "";
    this.securityLevel = 3;
    this.securityName = "";
  }

  paint(g) {
    if (this._img == null) {
      this._img = Resources.IMG_START_NODE;
    }

    g.save();
    this.color = "#cebee1";
    g.drawOvalBorder(this.x, this.y, this.width, this.height, 10, this.color);
    g.drawImage(this._img, this.x + 10, this.y + 5, this.icon_width / 2, this.icon_height / 2);
    g.setColor(Resources.COLOR.black);
    g.drawText(this.uri, this.x + this.width / 6, this.y + this.height / 1.5);
    g.restore();
  }

  /**
   * 更新uri(两个冒号)
   * @param {原始的组件数据} intValue
   * @param {现在要更新的值} prop
   * @returns
   */
  updateUri(intValue, prop) {
    let tempArr = this.getPropsDesc().advanced["path"];
    return this.changeUri(intValue, this, prop, tempArr, 2);
  }

  toXML(index) {
    let str = "";
    const uriValue = StringUtil.encodeHTML(this.uri);
    if ((this.outputid && !this.inputid) || index == 0) {
      str += `<from id="${this.id}" x="${this.x}" y="${this.y}" uri="${uriValue}"  ref="${this.ref_deprecated}" scope="${this.scope}">\n <description>${this.description}</description>\n </from>\n`;
    } else {
      str = `<to id="${this.id}" x="${this.x}" y="${this.y}" uri="${uriValue}"   ref="${this.ref_deprecated}" scope="${this.scope}">\n  <description>${this.description}</description>\n </to>\n`;
    }
    return str;
  }

  parseXML(xmlNode) {}

  getPropsDesc() {
    return {
      details: ["uri", "description", "id", "ref_deprecated"],
      advanced: {
        path: ["host", "port"],
        consumer: ["bridgeErrorHandler", "delay", "oids", "protocol", "retries", "sendEmptyMessageWhenIdle", "snmpCommunity", "snmpContextEngineId", "snmpContextName", "snmpVersion", "timeout", "treeList", "type"],
        consumer_advanced: ["exceptionHandler", "exchangePattern", "pollStrategy"],
        advanceds: ["synchronous"],
        scheduler: [
          "backoffErrorThreshold",
          "backoffIdleThreshold",
          "backoffMultiplier",
          "greedy",
          "initialDelay",
          "runLoggingLevel",
          "scheduledExecutorService",
          "scheduler",
          "schedulerProperties",
          "startScheduler",
          "timeUnit",
          "useFixedDelay",
        ],
        security: ["authenticationPassphrase", "authenticationProtocol", "privacyPassphrase", "privacyProtocol", "securityLevel", "securityName"],
      },
      documentation: SNMP.documentation,
    };
  }
}
SNMP.documentation = ``;
export default SNMP;
