import CamelElement from "../CamelElement";
import { Resources, StringUtil } from "../../utility";
class SFTP extends CamelElement {
  constructor() {
    super();
    this.scope = "SFTP";
    this.hasUri = true
    this.parent = "";
    this.inputid = ""; // 线的接入
    this.outputid = ""; // 线的出口
    this.description = ""; // 描述
    this.id = "sftp"; // 名字
    this.ref_deprecated = ""; // 已弃用(ref)
    this.host = "host";
    this.directoryName = "directoryName";
    this.port = "port";
    this.uri = `sftp:${this.host}:${this.port}/${this.directoryName}`; // uri
    this.charset = "";
    this.disconnect = false;
    this.doneFileName = "";
    this.fileName = "";
    this.jschLoggingLevel = "";
    this.separator = "UNIX";
    this.transferLoggingIntervalSeconds = 5;
    this.transferLoggingLevel = "DEBUG";
    this.transferLoggingVerbose = false;
    this.fastExistsCheck = false;
    this.bridgeErrorHandler = false;
    this.delete = false;
    this.moveFailed = "";
    this.noop = false;
    this.preMove = "";
    this.preSort = false;
    this.recursive = false;
    this.resumeDownload = false;
    this.sendEmptyMessageWhenIdle = false;
    this.streamDownload = false;
    this.directoryMustExist = false;
    this.download = false;
    this.exceptionHandler = "";
    this.exchangePattern = "";
    this.ignoreFileNotFoundOrPermissionError = false;
    this.onCompletionExceptionHandler = "";
    this.pollStrategy = "";
    this.processStrategy = "";
    this.startingDirectoryMustExist = false;
    this.useList = true;
    this.fileExist = "Override";
    this.flatten = false;
    this.jailStartingDirectory = true;
    this.moveExisting = "";
    this.tempFileName = "";
    this.tempPrefix = "";
    this.allowNullBody = false;
    this.chmod = "";
    this.disconnectOnBatchComplete = false;
    this.eagerDeleteTargetFile = true;
    this.keepLastModified = false;
    this.moveExistingFileStrategy = "";
    this.sendNoop = true;
    this.autoCreate = true;
    this.bindAddress = "";
    this.bufferSize = 131072;
    this.soTimeout = 300000;
    this.stepwise = true;
    this.synchronous = false;
    this.throwExceptionOnConnectFailed = false;
    this.timeout = 30000;
    this.antExclude = "";
    this.antFilterCaseSensitive = true;
    this.antInclude = "";
    this.eagerMaxMessagesPerPoll = true;
    this.exclude = "";
    this.filter = "";
    this.filterDirectory = "";
    this.filterFile = "";
    this.idempotent = false;
    this.idempotentKey = "";
    this.idempotentRepository = "";
    this.include = "";
    this.maxDepth = 2147483647;
    this.maxMessagesPerPoll = "";
    this.minDepth = "";
    this.move = "";
    this.exclusiveReadLockStrategy = "";
    this.readLock = "none";
    this.readLockCheckInterval = 1000;
    this.readLockDeleteOrphanLockFiles = true;
    this.backoffErrorThreshold = "";
    this.backoffIdleThreshold = "";
    this.backoffMultiplier = "";
    this.delay = 500;
    this.greedy = false;
    this.initialDelay = "";
    this.runLoggingLevel = "REACE";
    this.scheduledExecutorService = "";
    this.scheduler = "none";
    this.schedulerProperties = "";
    this.startScheduler = true;
    this.timeUnit = "MILLISECONDS";
    this.useFixedDelay = true;
    this.shuffle = false;
    this.sortBy = "";
    this.sorter = "";

    this.username = "";
  }

  paint(g) {
    if (this._img == null) {
      this._img = Resources.IMG_START_NODE;
    }

    g.save();
    this.color = "#cebee1";
    g.drawOvalBorder(this.x, this.y, this.width, this.height, 10, this.color);
    g.drawImage(this._img, this.x + 10, this.y + 5, this.icon_width / 2, this.icon_height / 2);
    g.setColor(Resources.COLOR.black);
    g.drawText(this.uri, this.x + this.width / 6, this.y + this.height / 1.5);
    g.restore();
  }

  toXML(index) {
     let str = "";
    const uriValue = StringUtil.encodeHTML(this.uri);
    if (this.outputid && !this.inputid || index == 0) {
      str += `<from id="${this.id}" x="${this.x}" y="${this.y}" uri="${uriValue}"  ref="${this.ref_deprecated}" scope="${this.scope}">\n <description>${this.description}</description>\n </from>\n`;
    } else {
      str = `<to id="${this.id}" x="${this.x}" y="${this.y}" uri="${uriValue}"   ref="${this.ref_deprecated}" scope="${this.scope}">\n  <description>${this.description}</description>\n </to>\n`;
    }
    return str;
  }

  parseXML(xmlNode) {
    
  }

  getPropsDesc() {
    return {
      details: ["uri", "description", "id", "pattern", "ref_deprecated"],
      advanced: {
        path: ["host", "directoryName", "port"],
        common: ["charset", "disconnect", "doneFileName", "fileName", "jschLoggingLevel", "separator"],
        common_advanced: ["fastExistsCheck"],
        consumer: ["bridgeErrorHandler", "delete", "moveFailed", "noop", "preMove", "preSort", "recursive", "resumeDownload", "sendEmptyMessageWhenIdle", "streamDownload"],
        consumer_advanced: [
          "directoryMustExist",
          "download",
          "exceptionHandler",
          "exchangePattern",
          "ignoreFileNotFoundOrPermissionError",
          "inProgressRepository",
          "localWorkDirectory",
          "onCompletionExceptionHandler",
          "pollStrategy",
          "processStrategy",
          "startingDirectoryMustExist",
          "useList",
        ],
        producer: ["fileExist", "flatten", "jailStartingDirectory", "moveExisting", "tempFileName", "tempPrefix"],
        producer_advanced: ["allowNullBody", "chmod", "disconnectOnBatchComplete", "eagerDeleteTargetFile", "keepLastModified", "moveExistingFileStrategy", "sendNoop"],
        advanceds: [
          "autoCreate",
          "bindAddress",
          "bufferSize",
          "bulkRequests",
          "compression",
          "connectTimeout",
          "maximumReconnectAttempts",
          "proxy",
          "reconnectDelay",
          "serverAliveCountMax",
          "serverAliveInterval",
          "soTimeout",
          "stepwise",
          "synchronous",
          "throwExceptionOnConnectFailed",
          "timeout",
        ],
        filter: [
          "antExclude",
          "antFilterCaseSensitive",
          "antInclude",
          "eagerMaxMessagesPerPoll",
          "exclude",
          "filter",
          "filterDirectory",
          "filterFile",
          "idempotent",
          "idempotentKey",
          "idempotentRepository",
          "include",
          "maxDepth",
          "maxMessagesPerPoll",
          "minDepth",
          "move",
        ],
        lock: [
          "exclusiveReadLockStrategy",
          "readLock",
          "readLockCheckInterval",
          "readLockDeleteOrphanLockFiles",
          "readLockIdempotentReleaseAsync",
          "readLockIdempotentReleaseAsyncPoolSize",
          "readLockIdempotentReleaseDelay",
          "readLockIdempotentReleaseExecutorService",
          "readLockLoggingLevel",
          "readLockMarkerFile",
          "readLockMinAge",
          "readLockMinLength",
          "readLockRemoveOnCommit",
          "readLockRemoveOnRollback",
          "readLockTimeout",
        ],
        scheduler: [
          "backoffErrorThreshold",
          "backoffIdleThreshold",
          "backoffMultiplier",
          "delay",
          "greedy",
          "initialDelay",
          "runLoggingLevel",
          "scheduledExecutorService",
          "scheduler",
          "schedulerProperties",
          "startScheduler",
          "timeUnit",
          "useFixedDelay",
        ],
        sort: ["shuffle", "sortBy", "sorter"],
        security: [
          "ciphers",
          "keyPair",
          "knownHosts",
          "knownHostsFile",
          "knownHostsUri",
          "password",
          "preferredAuthentications",
          "privateKey",
          "privateKeyFile",
          "privateKeyPassphrase",
          "privateKeyUri",
          "strictHostKeyChecking",
          "useUserKnownHostsFile",
          "username",
        ],
      },
      documentation: SFTP.documentation,
    };
  }
}
SFTP.documentation = ``;
export default SFTP;
