import CamelElement from "../CamelElement";
import { Resources, StringUtil } from "../../utility";
class SEDA extends CamelElement {
  constructor() {
    super();
    this.scope = "SEDA";
    this.hasUri = true
    this.parent = "";
    this.inputid = ""; // 线的接入
    this.outputid = ""; // 线的出口
    this.description = ""; // 描述
    this.id = "seda"; // 名字
    this.pattern = ""; //图案
    this.ref_deprecated = ""; // 已弃用(ref)
    this.name = "name";
    this.uri = `seda:${this.name}`; // uri
    this.size = 1000;
    this.bridgeErrorHandler = false;
    this.concurrentConsumers = 1;
    this.exceptionHandler = "";
    this.exchangePattern = "";
    this.limitConcurrentConsumers = true;
    this.multipleConsumers = false;
    this.pollTimeout = 1000;
    this.purgeWhenStopping = false;
    this.blockWhenFull = false;
    this.discardIfNoConsumers = false;
    this.failIfNoConsumers = false;
    this.offerTimeout = "";
    this.timeout = 30000;
    this.waitForTaskToComplete = "ifReplyExpected";
    this.queue = "";
    this.synchronous = false;
  }

  paint(g) {
    if (this._img == null) {
      this._img = Resources.IMG_START_NODE;
    }

    g.save();
    this.color = "#cebee1";
    g.drawOvalBorder(this.x, this.y, this.width, this.height, 10, this.color);
    g.drawImage(this._img, this.x + 10, this.y + 5, this.icon_width / 2, this.icon_height / 2);
    g.setColor(Resources.COLOR.black);
    g.drawText(this.uri, this.x + this.width / 6, this.y + this.height / 1.5);
    g.restore();
  }

  /**
   * 更新uri(一个冒号)
   * @param {原始的组件数据} intValue 
   * @param {现在要更新的值} prop 
   * @returns 
   */
   updateUri(intValue, prop) {
    let tempArr = this.getPropsDesc().advanced['path']
    return this.changeUri(intValue, this, prop, tempArr, 1);
  }

  toXML(index) {
     let str = "";
    const uriValue = StringUtil.encodeHTML(this.uri);
    if (this.outputid && !this.inputid || index == 0) {
      str += `<from id="${this.id}" x="${this.x}" y="${this.y}" uri="${uriValue}"  ref="${this.ref_deprecated}" scope="${this.scope}">\n <description>${this.description}</description>\n </from>\n`;
    } else {
      str = `<to id="${this.id}" x="${this.x}" y="${this.y}" uri="${uriValue}"   ref="${this.ref_deprecated}" scope="${this.scope}">\n  <description>${this.description}</description>\n </to>\n`;
    }
    return str;
  }

  parseXML(xmlNode) {
    
  }

  getPropsDesc() {
    return {
      details: ["uri", "description", "id", "pattern", "ref_deprecated"],
      advanced: {
        path: ["name"],
        common: ["size"],
        consumer: ["bridgeErrorHandler", "concurrentConsumers"],
        consumer_advanced: ["exceptionHandler", "exchangePattern", "limitConcurrentConsumers", "multipleConsumers", "pollTimeout", "purgeWhenStopping"],
        producer: ["blockWhenFull", "discardIfNoConsumers", "failIfNoConsumers", "offerTimeout", "timeout", "waitForTaskToComplete"],
        advanceds: ["queue", "synchronous"],
      },
      documentation: SEDA.documentation,
    };
  }
}
SEDA.documentation = ``;
export default SEDA;
