import CamelElement from "../CamelElement";
import { Resources, StringUtil } from "../../utility";
class Restlet extends CamelElement {
  constructor() {
    super();
    this.scope = "restlet";
    this.hasUri = true
    this.parent = "";
    this.inputid = ""; // 线的接入
    this.outputid = ""; // 线的出口
    this.description = ""; // 描述
    this.id = "restlet"; // 名字
    this.pattern = ""; //图案
    this.ref_deprecated = ""; // 已弃用(ref)
    this.host = "host";
    this.port = "port";
    this.protocol = "";
    this.uriPattern = "uriPattern";
    this.uri = `restlet:${this.protocol}:${this.host}:${this.port}/${this.uriPattern}`; // uri
    this.restletMethod = "GET";
    this.bridgeErrorHandler = false;
    this.restletMethods = "";
    this.disableStreamCache = false;
    this.exceptionHandler = "";
    this.exchangePattern = "";
    this.restletUriPatterns = "";
    this.connectTimeout = 30000;
    this.cookieHandler = "";
    this.socketTimeout = 30000;
    this.throwExceptionOnFailure = true;
    this.autoCloseStream = false;
    this.streamRepresentation = false;
    this.headerFilterStrategy = "";
    this.restletBinding = "";
    this.synchronous = false;
    this.restletRealm = "";
    this.sslContextParameters = "";
  }

  paint(g) {
    if (this._img == null) {
      this._img = Resources.IMG_START_NODE;
    }

    g.save();
    this.color = "#cebee1";
    g.drawOvalBorder(this.x, this.y, this.width, this.height, 10, this.color);
    g.drawImage(this._img, this.x + 10, this.y + 5, this.icon_width / 2, this.icon_height / 2);
    g.setColor(Resources.COLOR.black);
    g.drawText(this.uri, this.x + this.width / 6, this.y + this.height / 1.5);
    g.restore();
  }

  toXML(index) {
     let str = "";
    const uriValue = StringUtil.encodeHTML(this.uri);
    if (this.outputid && !this.inputid || index == 0) {
      str += `<from id="${this.id}" x="${this.x}" y="${this.y}" uri="${uriValue}"  ref="${this.ref_deprecated}" scope="${this.scope}">\n <description>${this.description}</description>\n </from>\n`;
    } else {
      str = `<to id="${this.id}" x="${this.x}" y="${this.y}" uri="${uriValue}"   ref="${this.ref_deprecated}" scope="${this.scope}">\n  <description>${this.description}</description>\n </to>\n`;
    }
    return str;
  }

  parseXML(xmlNode) {
   
  }

  getPropsDesc() {
    return {
      details: ["uri", "description", "id", "ref_deprecated"],
      advanced: {
        path: ["host", "port", "protocol", "uriPattern"],
        common: ["restletMethod"],
        consumer: ["bridgeErrorHandler", "restletMethods"],
        consumer_advanced: ["disableStreamCache", "exceptionHandler", "exchangePattern", "restletUriPatterns"],
        producer: ["connectTimeout", "cookieHandler", "socketTimeout", "throwExceptionOnFailure"],
        producer_advanced: ["autoCloseStream", "streamRepresentation"],
        advanceds: ["headerFilterStrategy", "restletBinding", "synchronous"],
        security: ["restletRealm", "sslContextParameters"],
      },
      documentation: Restlet.documentation,
    };
  }
}
Restlet.documentation = ``;
export default Restlet;
