import CamelElement from "../CamelElement";
import { Resources, StringUtil } from "../../utility";
class RSS extends CamelElement {
  constructor() {
    super();
    this.scope = "RSS";
    this.hasUri = true;
    this.parent = "";
    this.inputid = ""; // 线的接入
    this.outputid = ""; // 线的出口
    this.description = ""; // 描述
    this.id = "rss"; // 名字
    this.pattern = ""; //图案
    this.ref_deprecated = ""; // 已弃用(ref)
    this.feedUri = "feedUri";
    this.uri = `rss:${this.feedUri}`; // uri
    this.bridgeErrorHandler = false;
    this.feedHeader = true;
    this.filter = true;
    this.lastUpdate = "";
    this.password = "";
    this.sendEmptyMessageWhenIdle = false;
    this.sortEntries = false;
    this.splitEntries = true;
    this.throttleEntries = true;
    this.username = "";
    this.exceptionHandler = "";
    this.exchangePattern = "";
    this.pollStrategy = "";
    this.synchronous = false;
    this.backoffErrorThreshold = "";
    this.backoffIdleThreshold = "";
    this.backoffMultiplier = "";
    this.delay = 500;
    this.greedy = false;
    this.initialDelay = 1000;
    this.runLoggingLevel = "TRACE";
    this.scheduledExecutorService = "";
    this.scheduler = "none";
    this.schedulerProperties = "";
    this.startScheduler = true;
    this.timeUnit = "MILLISECONDS";
    this.useFixedDelay = true;
  }

  paint(g) {
    if (this._img == null) {
      this._img = Resources.IMG_START_NODE;
    }

    g.save();
    this.color = "#cebee1";
    g.drawOvalBorder(this.x, this.y, this.width, this.height, 10, this.color);
    g.drawImage(this._img, this.x + 10, this.y + 5, this.icon_width / 2, this.icon_height / 2);
    g.setColor(Resources.COLOR.black);
    g.drawText(this.uri, this.x + this.width / 6, this.y + this.height / 1.5);
    g.restore();
  }

  /**
   * 更新uri(一个冒号)
   * @param {原始的组件数据} intValue
   * @param {现在要更新的值} prop
   * @returns
   */
  updateUri(intValue, prop) {
    let tempArr = this.getPropsDesc().advanced["path"];
    return this.changeUri(intValue, this, prop, tempArr, 1);
  }

  toXML(index) {
    let str = "";
    const uriValue = StringUtil.encodeHTML(this.uri);
    if ((this.outputid && !this.inputid) || index == 0) {
      str += `<from id="${this.id}" x="${this.x}" y="${this.y}" uri="${uriValue}"  ref="${this.ref_deprecated}" scope="${this.scope}">\n <description>${this.description}</description>\n </from>\n`;
    } else {
      str = `<to id="${this.id}" x="${this.x}" y="${this.y}" uri="${uriValue}"   ref="${this.ref_deprecated}" scope="${this.scope}">\n  <description>${this.description}</description>\n </to>\n`;
    }
    return str;
  }

  parseXML(xmlNode) {}

  getPropsDesc() {
    return {
      details: ["uri", "description", "id", "ref_deprecated"],
      advanced: {
        path: ["feedUri"],
        consumer: ["bridgeErrorHandler", "feedHeader", "filter", "lastUpdate", "password", "sendEmptyMessageWhenIdle", "sortEntries", "splitEntries", "throttleEntries", "username"],
        consumer_advanced: ["exceptionHandler", "exchangePattern", "pollStrategy"],
        advanceds: ["synchronous"],
        scheduler: [
          "backoffErrorThreshold",
          "backoffIdleThreshold",
          "backoffMultiplier",
          "delay",
          "greedy",
          "initialDelay",
          "runLoggingLevel",
          "scheduledExecutorService",
          "scheduler",
          "schedulerProperties",
          "startScheduler",
          "timeUnit",
          "useFixedDelay",
        ],
      },
      documentation: RSS.documentation,
    };
  }
}
RSS.documentation = ``;
export default RSS;
