import CamelElement from "../CamelElement";
import { Resources, StringUtil } from "../../utility";
class Quartz2 extends CamelElement {
  constructor() {
    super();
    this.scope = "quartz2";
    this.hasUri = true
    this.parent = "";
    this.inputid = ""; // 线的接入
    this.outputid = ""; // 线的出口
    this.description = ""; // 描述
    this.id = "quartz2"; // 名字
    this.pattern = ""; //图案
    this.ref_deprecated = ""; // 已弃用(ref)
    this.triggerName = "triggerName";
    this.groupName = "groupName";
    this.uri = `quartz:${this.groupName}/${this.timerName}`; // uri
    this.bridgeErrorHandler = false;
    this.cron = "";
    this.deleteJob = true;
    this.fireNow = false;
    this.pauseJob = false;
    this.recoverableJob = false;
    this.stateful = false;
    this.exceptionHandler = "";
    this.exchangePattern = "";
    this.customCalendar = "";
    this.jobParameters = "";
    this.prefixJobNameWithEndpointId = false;
    this.synchronous = false;
    this.triggerParameters = "";
    this.usingFixedCamelContextName = false;
    this.autoStartScheduler = true;
    this.fireNow = false;
    this.startDelayedSeconds = "";
    this.triggerStartDelay = 500;
  }

  paint(g) {
    if (this._img == null) {
      this._img = Resources.IMG_START_NODE;
    }

    g.save();
    this.color = "#cebee1";
    g.drawOvalBorder(this.x, this.y, this.width, this.height, 10, this.color);
    g.drawImage(this._img, this.x + 10, this.y + 5, this.icon_width / 2, this.icon_height / 2);
    g.setColor(Resources.COLOR.black);
    g.drawText(this.uri, this.x + this.width / 6, this.y + this.height / 1.5);
    g.restore();
  }

  toXML(index) {
     let str = "";
    const uriValue = StringUtil.encodeHTML(this.uri);
    if (this.outputid && !this.inputid || index == 0) {
      str += `<from id="${this.id}" x="${this.x}" y="${this.y}" uri="${uriValue}"  ref="${this.ref_deprecated}" scope="${this.scope}">\n <description>${this.description}</description>\n </from>\n`;
    } else {
      str = `<to id="${this.id}" x="${this.x}" y="${this.y}" uri="${uriValue}"   ref="${this.ref_deprecated}" scope="${this.scope}">\n  <description>${this.description}</description>\n </to>\n`;
    }
    return str;
  }

  parseXML(xmlNode) {
    
  }

  getPropsDesc() {
    return {
      details: ["uri", "description", "id", "pattern", "ref_deprecated"],
      advanced: {
        path: ["triggerName", "groupName"],
        consumer: ["bridgeErrorHandler", "cron", "deleteJob", "durableJob", "pauseJob", "recoverableJob", "stateful"],
        consumer_advanced: ["exceptionHandler", "exchangePattern"],
        advanceds: ["customCalendar", "jobParameters", "prefixJobNameWithEndpointId", "synchronous", "triggerParameters", "usingFixedCamelContextName"],
        scheduler: ["autoStartScheduler", "fireNow", "startDelayedSeconds", "triggerStartDelay"],
      },
      documentation: Quartz2.documentation,
    };
  }
}
Quartz2.documentation = ``;
export default Quartz2;
