import CamelElement from "../CamelElement";
import { Resources, StringUtil } from "../../utility";
class Quartz extends CamelElement {
  constructor() {
    super();
    this.scope = "quartz";
    this.hasUri = true
    this.parent = "";
    this.inputid = ""; // 线的接入
    this.outputid = ""; // 线的出口
    this.description = ""; // 描述
    this.id = "quartz"; // 名字
    this.pattern = ""; //图案
    this.ref_deprecated = ""; // 已弃用(ref)
    this.timerName = "timerName";
    this.groupName = "groupName";
    this.uri = `quartz:${this.groupName}/${this.timerName}`; // uri
    this.bridgeErrorHandler = false;
    this.cron = "";
    this.deleteJob = true;
    this.fireNow = false;
    this.pauseJob = false;
    this.startDelayedSeconds = "";
    this.stateful = false;
    this.usingFixedCamelContextName = false;
    this.exceptionHandler = "";
    this.exchangePattern = "";
    this.jobParameters = "";
    this.synchronous = false;
    this.triggerParameters = "";
  }

  paint(g) {
    if (this._img == null) {
      this._img = Resources.IMG_START_NODE;
    }

    g.save();
    this.color = "#cebee1";
    g.drawOvalBorder(this.x, this.y, this.width, this.height, 10, this.color);
    g.drawImage(this._img, this.x + 10, this.y + 5, this.icon_width / 2, this.icon_height / 2);
    g.setColor(Resources.COLOR.black);
    g.drawText(this.uri, this.x + this.width / 6, this.y + this.height / 1.5);
    g.restore();
  }

  toXML(index) {
     let str = "";
    const uriValue = StringUtil.encodeHTML(this.uri);
    if (this.outputid && !this.inputid || index == 0) {
      str += `<from id="${this.id}" x="${this.x}" y="${this.y}" uri="${uriValue}"  ref="${this.ref_deprecated}" scope="${this.scope}">\n <description>${this.description}</description>\n </from>\n`;
    } else {
      str = `<to id="${this.id}" x="${this.x}" y="${this.y}" uri="${uriValue}"   ref="${this.ref_deprecated}" scope="${this.scope}">\n  <description>${this.description}</description>\n </to>\n`;
    }
    return str;
  }

  parseXML(xmlNode) {
    
  }

  getPropsDesc() {
    return {
      details: ["uri", "description", "id", "ref_deprecated"],
      advanced: {
        path: ["timerName", "groupName"],
        consumer: ["bridgeErrorHandler", "cron", "deleteJob", "fireNow", "pauseJob", "startDelayedSeconds", "stateful", "usingFixedCamelContextName"],
        consumer_advanced: ["exceptionHandler", "exchangePattern"],
        advanceds: ["jobParameters", "synchronous", "triggerParameters"],
      },
      documentation: Quartz.documentation,
    };
  }
}
Quartz.documentation = ``;
export default Quartz;
