import CamelElement from "../CamelElement";
import { Resources, StringUtil } from "../../utility";
class Process extends CamelElement {
  constructor() {
    super();
    this.scope = "Process";
    this.parent = "";
    this.inputid = ""; // 线的接入
    this.outputid = ""; // 线的出口
    this.ref = "";
    this.description = "";
    this.id = "_process1";
  }

  paint(g) {
    if (this._img == null) {
      this._img = Resources.IMG_START_NODE;
    }

    if (this.isCurrentToEdit(this)) {
      alert();
    }
    g.save();
    this.color = "#c8eb79";
    g.drawOvalBorder(this.x, this.y, this.width, this.height, 10, this.color);
    g.drawImage(this._img, this.x + 10, this.y + 5, this.icon_width / 2, this.icon_height / 2);
    g.setColor(Resources.COLOR.black);
    g.drawString("to", this.x + this.width / 3, this.y + this.height / 2);
    g.restore();
  }

  toXML() {
    let str = "";
    `<process id="${this.id}" x="${this.x}" y="${this.y}" description="${this.description}" ref="${this.ref}" scope="${this.scope}">\n <description>${this.description}</description>\n </process>\n`;
    return str;
  }

  parseXML(xmlNode) {

  }

  getPropsDesc() {
    return {
      details: ["ref", "description", "id"],
    };
  }
}

export default Process;
