import CamelElement from "../CamelElement";
import { Resources, StringUtil } from "../../utility";
class POP3 extends CamelElement {
  constructor() {
    super();
    this.scope = "POP3";
    this.hasUri = true
    this.parent = "";
    this.inputid = ""; // 线的接入
    this.outputid = ""; // 线的出口
    this.description = ""; // 描述
    this.id = "pop3"; // 名字
    this.pattern = ""; //图案
    this.ref_deprecated = ""; // 已弃用(ref)
    this.host = "host";
    this.port = "port";
    this.uri = `pop3:${this.host}:${this.port}`; // uri
    this.bridgeErrorHandler = false;
    this.copyTo = true;
    this.closeFolder = "";
    this.delete = false;
    this.disconnect = false;
    this.handleFailedMessage = false;
    this.maxMessagesPerPoll = "";
    this.mimeDecodeHeaders = false;
    this.peek = true;
    this.sendEmptyMessageWhenIdle = false;
    this.skipFailedMessage = false;
    this.unseen = false;
    this.exceptionHandler = "";
    this.exchangePattern = "";
    this.fetchSize = -1;
    this.folderName = "INBOX";
    this.mailUidGenerator = "";
    this.mapMailMessage = true;
    this.pollStrategy = "";
    this.postProcessAction = "";
    this.bcc = "";
    this.cc = "";
    this.from = "camel@localhost";
    this.replyTo = "";
    this.subject = "";
    this.to = "";
    this.javaMailSender = "";
    this.additionalJavaMailProperties = "";
    this.alternativeBodyHeader = "CamelMailAlternativeBody";
    this.attachmentsContentTransferEncodingResolver = "";
    this.binding = "";
    this.connectionTimeout = 30000;
    this.contentType = "text/plain";
    this.contentTypeResolver = "";
    this.debugMode = false;
    this.headerFilterStrategy = "";
    this.ignoreUnsupportedCharset = false;
    this.ignoreUriScheme = false;
    this.session = "";
    this.synchronous = false;
    this.useInlineAttachments = false;
    this.idempotentRepository = "";
    this.idempotentRepositoryRemoveOnCommit = true;
    this.searchTerm = "";
    this.backoffErrorThreshold = "";
    this.backoffIdleThreshold = "";
    this.backoffMultiplier = "";
    this.delay = 60000;
    this.greedy = "";
    this.initialDelay = 1000;
    this.runLoggingLevel = "TRACE";
    this.scheduledExecutorService = "";
    this.scheduler = "none";
    this.schedulerProperties = "";
    this.startScheduler = true;
    this.timeUnit = "MILLISECONDS";
    this.useFixedDelay = true;
    this.sortTeam = "";
    this.dummyTrustManager = false;
    this.password = "";
    this.sslContextParameters = "";
    this.username = "";
  }

  paint(g) {
    if (this._img == null) {
      this._img = Resources.IMG_START_NODE;
    }

    g.save();
    this.color = "#cebee1";
    g.drawOvalBorder(this.x, this.y, this.width, this.height, 10, this.color);
    g.drawImage(this._img, this.x + 10, this.y + 5, this.icon_width / 2, this.icon_height / 2);
    g.setColor(Resources.COLOR.black);
    g.drawText(this.uri, this.x + this.width / 6, this.y + this.height / 1.5);
    g.restore();
  }

  /**
   * 更新uri(两个冒号)
   * @param {原始的组件数据} intValue 
   * @param {现在要更新的值} prop 
   * @returns 
   */
   updateUri(intValue, prop) {
    let tempArr = this.getPropsDesc().advanced['path']
    return this.changeUri(intValue, this, prop, tempArr, 2);
  }

  toXML(index) {
     let str = "";
    const uriValue = StringUtil.encodeHTML(this.uri);
    if (this.outputid && !this.inputid || index == 0) {
      str += `<from id="${this.id}" x="${this.x}" y="${this.y}" uri="${uriValue}"  ref="${this.ref_deprecated}" scope="${this.scope}">\n <description>${this.description}</description>\n </from>\n`;
    } else {
      str = `<to id="${this.id}" x="${this.x}" y="${this.y}" uri="${uriValue}"   ref="${this.ref_deprecated}" scope="${this.scope}">\n  <description>${this.description}</description>\n </to>\n`;
    }
    return str;
  }

  parseXML(xmlNode) {
    
  }

  getPropsDesc() {
    return {
      details: ["uri", "description", "id", "ref_deprecated"],
      advanced: {
        path: ["host", "port"],
        consumer: [
          "bridgeErrorHandler",
          "copyTo",
          "closeFolder",
          "delete",
          "disconnect",
          "handleFailedMessage",
          "maxMessagesPerPoll",
          "mimeDecodeHeaders",
          "peek",
          "sendEmptyMessageWhenIdle",
          "skipFailedMessage",
          "unseen",
        ],
        consumer_advanced: ["exceptionHandler", "exchangePattern", "fetchSize", "folderName", "mailUidGenerator", "mapMailMessage", "pollStrategy", "postProcessAction"],
        producer: ["bcc", "cc", "from", "replyTo", "subject", "to"],
        producer_advanced: ["javaMailSender"],
        advanceds: [
          "additionalJavaMailProperties",
          "alternativeBodyHeader",
          "attachmentsContentTransferEncodingResolver",
          "binding",
          "connectionTimeout",
          "contentType",
          "contentTypeResolver",
          "debugMode",
          "headerFilterStrategy",
          "ignoreUnsupportedCharset",
          "ignoreUriScheme",
          "session",
          "synchronous",
          "useInlineAttachments",
        ],
        filter: ["idempotentRepository", "idempotentRepositoryRemoveOnCommit", "searchTerm"],
        scheduler: [
          "backoffErrorThreshold",
          "backoffIdleThreshold",
          "backoffMultiplier",
          "delay",
          "greedy",
          "initialDelay",
          "runLoggingLevel",
          "scheduledExecutorService",
          "scheduler",
          "schedulerProperties",
          "startScheduler",
          "timeUnit",
          "useFixedDelay",
        ],
        sort: ["sortTeam"],
        security: ["dummyTrustManager", "password", "sslContextParameters", "username"],
      },
      documentation: POP3.documentation,
    };
  }
}
POP3.documentation = ``;
export default POP3;
