import CamelElement from "../CamelElement";
import { Resources, StringUtil } from "../../utility";
class Netty4HTTP extends CamelElement {
  constructor() {
    super();
    this.scope = "Netty4HTTP";
    this.hasUri = true
    this.parent = "";
    this.inputid = ""; // 线的接入
    this.outputid = ""; // 线的出口
    this.description = ""; // 描述
    this.id = "netty4-http"; // 名字
    this.pattern = ""; //图案
    this.ref_deprecated = ""; // 已弃用(ref)
    this.host = "host";
    this.protocol = "protocol";
    this.path = "path";
    this.port = "port";
    this.uri = `netty4-http:${this.protocol}:${this.host}:${this.port}/${this.path}`; // uri
    this.bridgeEndpoint = false;
    this.disconnect = false;
    this.keepAlive = true;
    this.reuseAddress = true;
    this.reuseChannel = fasle;
    this.sync = true;
    this.tcpNoDelay = true;
    this.bridgeErrorHandler = false;
    this.matchOnUriPrefix = false;
    this.send503whenSuspended = true;
    this.backlog = "";
    this.bossCount = 1;
    this.bossPool = "";
    this.channelGroup = "";
    this.chunkedMaxContentLength = 1048576;
    this.compression = false;
    this.disableStreamCache = false;
    this.disconnectOnNoReply = true;
    this.exceptionHandler = "";
    this.exchangePattern = "";
    this.httpMethodRestrict = "";
    this.mapHeaders = true;
    this.maxHeaderSize = 8192;
    this.nettyServerBootstrapFactory = "";
    this.nettySharedHttpServer = "";
    this.noReplyLogLevel = "WARN";
    this.serverClosedChannelExceptionCaughtLogLevel = "DEBUG";
    this.serverExceptionCaughtLogLevel = "WARN";
    this.serverPipelineFactory = "";
    this.traceEnabled = false;
    this.urlDecodeHeaders = false;
    this.usingExecutorService = true;
    this.connectTimeout = 10000;
    this.requestTimeout = "";
    this.throwExceptionOnFailure = true;
    this.clientPipelineFactory = "";
    this.lazyChannelCreation = true;
    this.okStatusCodeRange = "200-299";
    this.producerPoolEnabled = true;
    this.producerPoolMaxActive = -1;
    this.producerPoolMaxIdle = 100;
    this.producerPoolMinEvictableIdle = 300000;
    this.useRelativePath = false;
    this.allowSerializedHeaders = false;
    this.bootstrapConfiguration = "";
    this.channelGroup = "";
    this.configuration = "";
    this.disableStreamCache = false;
    this.headerFilterStrategy = "";
    this.nativeTransport = false;
    this.nettyHttpBinding = "";
    this.options = "";
    this.receiveBufferSize = 65536;
    this.receiveBufferSizePredictor = "";
    this.sendBufferSize = 65536;
    this.synchronous = false;
    this.transferException = false;
    this.transferExchange = false;
    this.workerCount = "";
    this.workerGroup = "";
    this.decoder = "";
    this.decoders = "";
    this.encoder = "";
    this.encoders = "";
    this.enabledProtocols = "TLSv1,TLSv1.1,TLSv1.2";
    this.keyStoreFile = "";
    this.keyStoreFormat = "JKS";
    this.keyStoreResource = "";
    this.needClientAuth = false;
    this.passphrase = "";
    this.securityConfiguration = "";
    this.securityOptions = "";
    this.securityProvider = "SunX509";
    this.ssl = false;
    this.sslClientCertHeaders = false;
    this.sslContextParameters = "";
    this.sslHandler = "";
    this.trustStoreFile = "";
    this.trustStoreResource = "";
  }

  paint(g) {
    if (this._img == null) {
      this._img = Resources.IMG_START_NODE;
    }

    g.save();
    this.color = "#cebee1";
    g.drawOvalBorder(this.x, this.y, this.width, this.height, 10, this.color);
    g.drawImage(this._img, this.x + 10, this.y + 5, this.icon_width / 2, this.icon_height / 2);
    g.setColor(Resources.COLOR.black);
    g.drawText(this.uri, this.x + this.width / 6, this.y + this.height / 1.5);
    g.restore();
  }

  toXML(index) {
     let str = "";
    const uriValue = StringUtil.encodeHTML(this.uri);
    if (this.outputid && !this.inputid || index == 0) {
      str += `<from id="${this.id}" x="${this.x}" y="${this.y}" uri="${uriValue}"  ref="${this.ref_deprecated}" scope="${this.scope}">\n <description>${this.description}</description>\n </from>\n`;
    } else {
      str = `<to id="${this.id}" x="${this.x}" y="${this.y}" uri="${uriValue}"   ref="${this.ref_deprecated}" scope="${this.scope}">\n  <description>${this.description}</description>\n </to>\n`;
    }
    return str;
  }

  parseXML(xmlNode) {
    
  }

  getPropsDesc() {
    return {
      details: ["uri", "description", "id", "ref_deprecated"],
      advanced: {
        path: ["host", "protocol", "path", "port"],
        common: ["bridgeEndpoint", "disconnect", "keepAlive", "reuseAddress", "sync", "tcpNoDelay"],
        consumer: ["bridgeErrorHandler", "matchOnUriPrefix", "send503whenSuspended"],
        consumer_advanced: [
          "backlog",
          "bossCount",
          "bossPool",
          "channelGroup",
          "chunkedMaxContentLength",
          "compression",
          "disableStreamCache",
          "disconnectOnNoReply",
          "exceptionHandler",
          "exchangePattern",
          "httpMethodRestrict",
          "mapHeaders",
          "maxHeaderSize",
          "nettyServerBootstrapFactory",
          "nettySharedHttpServer",
          "noReplyLogLevel",
          "serverClosedChannelExceptionCaughtLogLevel",
          "serverExceptionCaughtLogLevel",
          "serverPipelineFactory",
          "traceEnabled",
          "urlDecodeHeaders",
        ],
        producer: ["connectTimeout", "requestTimeout", "throwExceptionOnFailure"],
        producer_advanced: ["clientPipelineFactory", "lazyChannelCreation", "okStatusCodeRange", "producerPoolEnabled", "producerPoolMaxActive", "producerPoolMaxIdle", "producerPoolMinEvictableIdle", "useRelativePath"],
        advanceds: [
          "allowSerializedHeaders",
          "bootstrapConfiguration",
          "channelGroup",
          "configuration",
          "disableStreamCache",
          "headerFilterStrategy",
          "nativeTransport",
          "nettyHttpBinding",
          "options",
          "receiveBufferSize",
          "receiveBufferSizePredictor",
          "sendBufferSize",
          "synchronous",
          "transferException",
          "transferExchange",
          "workerCount",
          "workerGroup",
        ],
        codec: ["decoder", "decoders", "encoder", "encoders"],
        security: [
          "enabledProtocols",
          "keyStoreFile",
          "keyStoreFormat",
          "keyStoreResource",
          "needClientAuth",
          "passphrase",
          "securityConfiguration",
          "securityOptions",
          "securityProvider",
          "ssl",
          "sslClientCertHeaders",
          "sslContextParameters",
          "sslHandler",
          "trustStoreFile",
          "trustStoreResource",
        ],
      },
      documentation: Netty4HTTP.documentation,
    };
  }
}
Netty4HTTP.documentation = ``;
export default Netty4HTTP;
