import CamelElement from "../CamelElement";
import { Resources, StringUtil } from "../../utility";
class Netty4 extends CamelElement {
  constructor() {
    super();
    this.scope = "Netty4";
    this.parent = "";
    this.inputid = ""; // 线的接入
    this.outputid = ""; // 线的出口
    this.description = ""; // 描述
    this.id = "netty4"; // 名字
    this.pattern = ""; //图案
    this.ref_deprecated = ""; // 已弃用(ref)
    this.host = "host";
    this.port = "port";
    this.protocol = "protocol";
    this. uri = `netty4:${this.protocol}:${this.host}:${this.port}`; // uri
    this.disconnect = false;
    this.keepAlive = true;
    this.reuseAddress = true;
    this.reuseChannel = fasle;
    this.sync = true;
    this.tcpNoDelay = true;
    this.bridgeErrorHandler = false;
    this.broadcast = false;
    this.clientMode = false;
    this.reconnect = true;
    this.reconnectInterval = 10000;
    this.backlog = "";
    this.bossCount = 1;
    this.disconnectOnNoReply = true;
    this.exchangePattern = "";
    this.exceptionHandler = "";
    this.nettyServerBootstrapFactory = "";
    this.networkInterface = "";
    this.noReplyLogLevel = "WARN";
    this.serverClosedChannelExceptionCaughtLogLevel = "DEBUG";
    this.serverExceptionCaughtLogLevel = "WARN";
    this.serverPipelineFactory = "";
    this.usingExecutorService = true;
    this.connectTimeout = 10000;
    this.requestTimeout = "";
    this.clientPipelineFactory = "";
    this.correlationManager = "";
    this.lazyChannelCreation = true;
    this.producerPoolEnabled = true;
    this.producerPoolMaxActive = -1;
    this.producerPoolMaxIdle = 100;
    this.producerPoolMinEvictableIdle = 300000;
    this.producerPoolMinIdle = "";
    this.udpConnectionlessSending = false;
    this.useChannelBuffer = false;
    this.allowSerializedHeaders = false;
    this.bootstrapConfiguration = false;
    this.channelGroup = "";
    this.nativeTransport = false;
    this.options = "";
    this.receiveBufferSize = 65536;
    this.receiveBufferSizePredictor = "";
    this.sendBufferSize = 65536;
    this.synchronous = false;
    this.transferExchange = false;
    this.udpByteArrayCodec = false;
    this.workerCount = "";
    this.workerGroup = "";
    this.allowDefaultCodec = true;
    this.autoAppendDelimiter = true;
    this.decoder = "";
    this.decoderMaxLineLength = 1024;
    this.decoders = "";
    this.delimiter = "LINE";
    this.encoder = "";
    this.encoders = "";
    this.encoding = "";
    this.textline = false;
    this.enabledProtocols = "TLSv1,TLSv1.1,TLSv1.2";
    this.keyStoreFile = "";
    this.keyStoreFormat = "JKS";
    this.keyStoreResource = "";
    this.needClientAuth = false;
    this.passphrase = "";
    this.securityProvider = "SunX509";
    this.ssl = false;
    this.sslClientCertHeaders = false;
    this.sslContextParameters = "";
    this.sslHandler = "";
    this.trustStoreFile = "";
    this.trustStoreResource = "";
  }

  paint(g) {
    if (this._img == null) {
      this._img = Resources.IMG_START_NODE;
    }

    g.save();
    this.color = "#cebee1";
    g.drawOvalBorder(this.x, this.y, this.width, this.height, 10, this.color);
    g.drawImage(this._img, this.x + 10, this.y + 5, this.icon_width / 2, this.icon_height / 2);
    g.setColor(Resources.COLOR.black);
    g.drawText(this.uri, this.x + this.width / 6, this.y + this.height / 1.5);
    g.restore();
  }

  toXML(index) {
     let str = "";
    const uriValue = StringUtil.encodeHTML(this.uri);
    if (this.outputid && !this.inputid || index == 0) {
      str += `<from id="${this.id}" x="${this.x}" y="${this.y}" uri="${uriValue}"  ref="${this.ref_deprecated}" scope="${this.scope}">\n <description>${this.description}</description>\n </from>\n`;
    } else {
      str = `<to id="${this.id}" x="${this.x}" y="${this.y}" uri="${uriValue}"   ref="${this.ref_deprecated}" scope="${this.scope}">\n  <description>${this.description}</description>\n </to>\n`;
    }
    return str;
  }

  parseXML(xmlNode) {
    
  }

  getPropsDesc() {
    return {
      details: ["uri", "description", "id", "ref_deprecated"],
      advanced: {
        path: ["host", "port", "protocol"],
        common: ["disconnect", "keepAlive", "reuseAddress", "reuseChannel", "sync", "tcpNoDelay"],
        consumer: ["bridgeErrorHandler", "broadcast", "clientMode", "reconnect", "reconnectInterval"],
        consumer_advanced: [
          "backlog",
          "bossCount",
          "disconnectOnNoReply",
          "exchangePattern",
          "exceptionHandler",
          "nettyServerBootstrapFactory",
          "networkInterface",
          "noReplyLogLevel",
          "serverClosedChannelExceptionCaughtLogLevel",
          "serverExceptionCaughtLogLevel",
          "serverPipelineFactory",
          "usingExecutorService",
        ],
        producer: ["connectTimeout", "requestTimeout"],
        producer_advanced: [
          "clientPipelineFactory",
          "lazyChannelCreation",
          "producerPoolEnabled",
          "producerPoolMaxActive",
          "producerPoolMaxIdle",
          "producerPoolMinEvictableIdle",
          "producerPoolMinIdle",
          "udpConnectionlessSending",
          "useChannelBuffer",
        ],
        advanceds: [
          "allowSerializedHeaders",
          "bootstrapConfiguration",
          "channelGroup",
          "nativeTransport",
          "options",
          "receiveBufferSize",
          "receiveBufferSizePredictor",
          "sendBufferSize",
          "synchronous",
          "transferExchange",
          "udpByteArrayCodec",
          "workerCount",
          "workerGroup",
        ],
        codec: ["allowDefaultCodec", "autoAppendDelimiter", "decoder", "decoderMaxLineLength", "decoders", "delimiter", "encoder", "encoders", "encoding", "textline"],
        security: [
          "enabledProtocols",
          "keyStoreFile",
          "keyStoreFormat",
          "keyStoreResource",
          "needClientAuth",
          "passphrase",
          "securityProvider",
          "ssl",
          "sslClientCertHeaders",
          "sslContextParameters",
          "sslHandler",
          "trustStoreFile",
          "trustStoreResource",
        ],
      },
      documentation: Netty4.documentation,
    };
  }
}
Netty4.documentation = ``;
export default Netty4;
