import CamelElement from "../CamelElement";
import { Resources } from "../../utility";
class Mina2 extends CamelElement {
  constructor() {
    super();
    this.scope = "Mina2";
    this.hasUri = true
    this.parent = "";
    this.inputid = ""; // 线的接入
    this.outputid = ""; // 线的出口
    this.description = ""; // 描述
    this.id = "language"; // 名字
    this.pattern = ""; //图案
    this.ref_deprecated = ""; // 已弃用(ref)
    this.host = "host";
    this.port = "port";
    this.protocol = "protocol";
    this.uri = `mina2:${this.host}:${this.port}:${this.protocol}`; // uri
    this.disconnect = false;
    this.minaLogger = false;
    this.sync = true;
    this.timeout = 30000;
    this.writeTimeout = 10000;
    this.bridgeErrorHandler = false;
    this.clientMode = false;
    this.disconnectOnNoReply = true;
    this.exceptionHandler = "";
    this.exchangePattern = "";
    this.noReplyLogLevel = "WARN";
    this.cachedAddress = true;
    this.lazySessionCreation = true;
    this.maximumPoolSize = 16;
    this.orderedThreadPoolExecutor = true;
    this.synchronous = false;
    this.transferExchange = false;
    this.allowDefaultCodec = TRUE;
    this.codec = "";
    this.decoderMaxLineLength = 1024;
    this.encoderMaxLineLength = -1;
    this.encoding = "";
    this.filters = "";
    this.textline = false;
    this.textlineDelimiter = "";
    this.autoStartTls = true;
    this.sslContextParameters = "";
  }

  paint(g) {
    if (this._img == null) {
      this._img = Resources.IMG_START_NODE;
    }

    g.save();
    this.color = "#cebee1";
    g.drawOvalBorder(this.x, this.y, this.width, this.height, 10, this.color);
    g.drawImage(this._img, this.x + 10, this.y + 5, this.icon_width / 2, this.icon_height / 2);
    g.setColor(Resources.COLOR.black);
    g.drawText(this.uri, this.x + this.width / 6, this.y + this.height / 1.5);
    g.restore();
  }

  toXML(index) {
    let str = "";
    if (this.outputid && !this.inputid || index == 0) {
      str += `<from id="${this.id}" x="${this.x}" y="${this.y}" uri="${this.uri}"  ref="${this.ref_deprecated}" scope="${this.scope}">\n <description>${this.description}</description>\n </from>\n`;
    } else {
      str = `<to id="${this.id}" x="${this.x}" y="${this.y}" uri="${this.uri}"   ref="${this.ref_deprecated}" scope="${this.scope}">\n  <description>${this.description}</description>\n </to>\n`;
    }
    return str;
  }

  parseXML(xmlNode) {
    
  }

  getPropsDesc() {
    return {
      details: ["uri", "description", "id", "ref_deprecated"],
      advanced: {
        path: ["host", "port", "protocol"],
        common: ["disconnect", "minaLogger", "sync", "timeout", "writeTimeout"],
        consumer: ["bridgeErrorHandler", "clientMode"],
        consumer_advanced: ["disconnectOnNoReply", "exceptionHandler", "exchangePattern", "noReplyLogLevel"],
        producer_advanced: ["cachedAddress", "lazySessionCreation"],
        advanceds: ["maximumPoolSize", "orderedThreadPoolExecutor", "synchronous", "transferExchange"],
        codec: ["allowDefaultCodec", "codec", "decoderMaxLineLength", "encoderMaxLineLength", "encoding", "filters", "textline", "textlineDelimiter"],
        security: ["autoStartTls", "sslContextParameters"],
      },
      documentation: Mina2.documentation,
    };
  }
}
Mina2.documentation = ``;
export default Mina2;
