import CamelElement from "../CamelElement";
import { Resources } from "../../utility";
class MVEL extends CamelElement {
  constructor() {
    super();
    this.scope = "MVEL";
    this.hasUri = true
    this.parent = "";
    this.inputid = ""; // 线的接入
    this.outputid = ""; // 线的出口
    this.description = ""; // 描述
    this.id = "mvel"; // 名字
    this.pattern = ""; //图案
    this.ref_deprecated = ""; // 已弃用(ref)
    this.language = "";
    this.resourceUri = "resourceUri";
    this.uri = `mvel:${this.resourceUri}`; // uri
    this.binary = false;
    this.cacheScript = false;
    this.contentCache = false;
    this.script = "";
    this.transform = true;
    this.synchronous = false;
  }

  paint(g) {
    if (this._img == null) {
      this._img = Resources.IMG_START_NODE;
    }

    g.save();
    this.color = "#cebee1";
    g.drawOvalBorder(this.x, this.y, this.width, this.height, 10, this.color);
    g.drawImage(this._img, this.x + 10, this.y + 5, this.icon_width / 2, this.icon_height / 2);
    g.setColor(Resources.COLOR.black);
    g.drawText(this.uri, this.x + this.width / 6, this.y + this.height / 1.5);
    g.restore();
  }

  /**
   * 更新uri(一个冒号)
   * @param {原始的组件数据} intValue 
   * @param {现在要更新的值} prop 
   * @returns 
   */
   updateUri(intValue, prop) {
    let tempArr = this.getPropsDesc().advanced['path']
    return this.changeUri(intValue, this, prop, tempArr, 1);
  }

  toXML(index) {
    let str = "";
    if (this.outputid && !this.inputid || index == 0) {
      str += `<from id="${this.id}" x="${this.x}" y="${this.y}" uri="${this.uri}"  ref="${this.ref_deprecated}" scope="${this.scope}">\n <description>${this.description}</description>\n </from>\n`;
    } else {
      str = `<to id="${this.id}" x="${this.x}" y="${this.y}" uri="${this.uri}"   ref="${this.ref_deprecated}" scope="${this.scope}">\n  <description>${this.description}</description>\n </to>\n`;
    }
    return str;
  }

  parseXML(xmlNode) {
    
  }

  getPropsDesc() {
    return {
      details: ["uri", "description", "id", "ref_deprecated"],
      advanced: {
        path: ["resourceUri"],
        producer: ["contentCache", "encoding"],
        advanceds: ["synchronous"],
      },
      documentation: MVEL.documentation,
    };
  }
}
MVEL.documentation = ``;
export default MVEL;
