import CamelElement from "../CamelElement";
import { Resources, StringUtil } from "../../utility";
class MQTT extends CamelElement {
  constructor() {
    super();
    this.scope = "MQTT";
    this.hasUri = true
    this.parent = "";
    this.inputid = ""; // 线的接入
    this.outputid = ""; // 线的出口
    this.uri = "language:languageName:resourceUri"; // uri
    this.description = ""; // 描述
    this.id = "mqtt"; // 名字
    this.pattern = ""; //图案
    this.ref_deprecated = ""; // 已弃用(ref)
    this.name = "name";
    this.blockingExecutor = "";
    this.byDefaultRetain = false;
    this.cleanSession = false;
    this.clientId = "";
    this.connectAttemptsMax = -1;
    this.connectWaitInSeconds = 10;
    this.disconnectWaitInSeconds = 5;
    this.dispatchQueue = "";
    this.host = "tcp://127.0.0.1:1883";
    this.keepAlive = "";
    this.localAddress = "";
    this.maxReadRate = "";
    this.maxWriteRate = "";
    this.mqttQosPropertyName = "MQTTQos";
    this.mqttRetainPropertyName = "MQTTRetain";
    this.mqttTopicPropertyName = "MQTTTopicPropertyName";
    this.publishTopicName = "camel/mqtt/test";
    this.qualityOfService = "AtLeastOnce";
    this.receiveBufferSize = 65536;
    this.reconnectAttemptsMax = -1;
    this.reconnectBackOffMultiplier = 2.0;
    this.reconnectDelay = 10;
    this.reconnectDelayMax = 30000;
    this.sendBufferSize = 65536;
    this.sendWaitInSeconds = 5;
    this.sslContext = "";
    this.subscribeTopicName = "";
    this.subscribeTopicNames = "";
    this.trafficClass = 8;
    this.version = "3.1";
    this.willMessage = "";
    this.willQos = "AtMostOnce";
    this.willRetain = "";
    this.willTopic = "";
    this.bridgeErrorHandler = false;
    this.exceptionHandler = "";
    this.exchangePattern = "";
    this.lazySessionCreation = true;
    this.synchronous = false;
  }

  paint(g) {
    if (this._img == null) {
      this._img = Resources.IMG_START_NODE;
    }

    g.save();
    this.color = "#cebee1";
    g.drawOvalBorder(this.x, this.y, this.width, this.height, 10, this.color);
    g.drawImage(this._img, this.x + 10, this.y + 5, this.icon_width / 2, this.icon_height / 2);
    g.setColor(Resources.COLOR.black);
    g.drawText(this.uri, this.x + this.width / 6, this.y + this.height / 1.5);
    g.restore();
  }

  /**
   * 更新uri(一个冒号)
   * @param {原始的组件数据} intValue 
   * @param {现在要更新的值} prop 
   * @returns 
   */
   updateUri(intValue, prop) {
    let tempArr = this.getPropsDesc().advanced['path']
    return this.changeUri(intValue, this, prop, tempArr, 1);
  }

  toXML(index) {
     let str = "";
    const uriValue = StringUtil.encodeHTML(this.uri);
    if (this.outputid && !this.inputid || index == 0) {
      str += `<from id="${this.id}" x="${this.x}" y="${this.y}" uri="${uriValue}"  ref="${this.ref_deprecated}" scope="${this.scope}">\n <description>${this.description}</description>\n </from>\n`;
    } else {
      str = `<to id="${this.id}" x="${this.x}" y="${this.y}" uri="${uriValue}"   ref="${this.ref_deprecated}" scope="${this.scope}">\n  <description>${this.description}</description>\n </to>\n`;
    }
    return str;
  }

  parseXML(xmlNode) {
    
  }

  getPropsDesc() {
    return {
      details: ["uri", "description", "id", "ref_deprecated"],
      advanced: {
        path: ["name"],
        common: [
          "blockingExecutor",
          "byDefaultRetain",
          "cleanSession",
          "clientId",
          "connectAttemptsMax",
          "connectWaitInSeconds",
          "disconnectWaitInSeconds",
          "dispatchQueue",
          "host",
          "keepAlive",
          "localAddress",
          "maxReadRate",
          "maxWriteRate",
          "mqttQosPropertyName",
          "mqttRetainPropertyName",
          "mqttTopicPropertyName",
          "publishTopicName",
          "qualityOfService",
          "receiveBufferSize",
          "reconnectAttemptsMax",
          "reconnectBackOffMultiplier",
          "reconnectDelay",
          "reconnectDelayMax",
          "sendBufferSize",
          "sendWaitInSeconds",
          "sslContext",
          "subscribeTopicName",
          "subscribeTopicNames",
          "trafficClass",
          "version",
          "willMessage",
          "willQos",
          "willRetain",
          "willTopic",
        ],
        consumer: ["bridgeErrorHandler"],
        consumer_advance: ["exceptionHandler", "exchangePattern"],
        producer_advanced: ["lazySessionCreation"],
        advanceds: ["synchronous"],
      },
      documentation: MQTT.documentation,
    };
  }
}
MQTT.documentation = ``;
export default MQTT;
