import CamelElement from "../CamelElement";
import { Resources, StringUtil } from "../../utility";
class Log extends CamelElement {
  constructor() {
    super();
    this.scope = "Log";
    this.parent = "";
    this.inputid = ""; // 线的接入
    this.outputid = ""; // 线的出口
    this.description = ""; // 描述
    this.id = "log"; // 名字
    this.pattern = ""; //图案
    this.ref_deprecated = ""; // 已弃用(ref)
    this.message = "";
    this.logName = "log";
    this.loggerRef = "";
    this.loggingLevel = "INFO";
    this.marker = "";
  }

  paint(g) {
    if (this._img == null) {
      this._img = Resources.IMG_START_NODE;
    }

    g.save();
    this.color = "#cebee1";
    g.drawOvalBorder(this.x, this.y, this.width, this.height, 10, this.color);
    g.drawImage(this._img, this.x + 10, this.y + 5, this.icon_width / 2, this.icon_height / 2);
    g.setColor(Resources.COLOR.black);
    g.drawString(this.logName, this.x + this.width / 4, this.y + this.height / 1.5);
    g.restore();
  }

  toXML(index) {
     let str = "";
    if (this.outputid && !this.inputid || index == 0) {
      str += `<from id="${this.id}" x="${this.x}" y="${this.y}"  ref="${this.ref_deprecated}" scope="${this.scope}">\n <description>${this.description}</description>\n </from>\n`;
    } else {
      str = `<to id="${this.id}" x="${this.x}" y="${this.y}"  ref="${this.ref_deprecated}" scope="${this.scope}">\n  <description>${this.description}</description>\n </to>\n`;
    }
    return str;
  }

  parseXML(xmlNode) {
    
  }

  getPropsDesc() {
    return {
      details: ["message", "description", "id", "logName", "loggerRef", "loggingLevel", "marker"],
      documentation: Log.documentation,
    };
  }
}
Log.documentation = ``;
export default Log;
