import CamelElement from "../CamelElement";
import { Resources } from "../../utility";
class JMS extends CamelElement {
  constructor() {
    super();
    this.scope = "JMS";
    this.hasUri = true
    this.parent = "";
    this.inputid = ""; // 线的接入
    this.outputid = ""; // 线的出口
    this.description = ""; // 描述
    this.id = "jms"; // 名字
    this.ref_deprecated = ""; // 已弃用(ref)
    this.destinationName = "destinationName";
    this.destinationType = "queue";
    this.uri = `imap:${this.destinationName}:${this.destinationType}`; // uri
    this.clientId = "";
    this.connectionFactory = "";
    this.disableReplyTo = false;
    this.durableSubscriptionName = "";
    this.jmsMessageType = "";
    this.testConnectionOnStartup = false;
    this.acknowledgementModeName = "AUTO_ACKNOWLEDGE";
    this.asyncConsumer = false;
    this.autoStartup = true;
    this.bridgeErrorHandler = false;
    this.cacheLevel = "";
    this.cacheLevelName = "CACHE_AUTO";
    this.concurrentConsumers = 1;
    this.maxConcurrentConsumers = "";
    this.replyTo = "";
    this.replyToDeliveryPersistent = true;
    this.selector = "";
    this.subscriptionDurable = false;
    this.subscriptionName = "";
    this.subscriptionShared = false;
    this.acceptMessagesWhileStopping = false;
    this.allowReplyManagerQuickStop = false;
    this.consumerType = "Defalut";
    this.defaultTaskExecutorType = "";
    this.eagerLoadingOfProperties = false;
    this.exceptionHandler = "";
    this.exchangePattern = "";
    this.exposeListenerSession = false;
    this.replyToSameDestinationAllowed = false;
    this.taskExecutor = "";
    this.deliveryMode = "";
    this.deliveryPersistent = true;
    this.explicitQosEnabled = false;
    this.formatDateHeadersToIso8601 = false;
    this.preserveMessageQos = false;
    this.priority = "4";
    this.replyToConcurrentConsumers = 1;
    this.replyToMaxConcurrentConsumers = "";
    this.replyToOnTimeoutMaxConcurrentConsumers = 1;
    this.replyToOverride = "";
    this.replyToType = "";
    this.requestTimeout = 20000;
    this.timeToLive = -1;
    this.allowAdditionalHeaders = "";
    this.allowNullBody = true;
    this.alwaysCopyMessage = false;
    this.correlationProperty = "";
    this.disableTimeToLive = false;
    this.forceSendOriginalMessage = false;
    this.includeSentJMSMessageID = false;
    this.replyToCacheLevelName = "";
    this.replyToDestinationSelectorName = "";
    this.streamMessageTypeEnabled = false;
    this.allowSerializedHeaders = false;
    this.asyncStartListener = false;
    this.asyncStopListener = false;
    this.destinationResolver = "";
    this.errorHandler = "";
    this.exceptionListener = "";
    this.headerFilterStrategy = "";
    this.idleConsumerLimit = 1;
    this.idleTaskExecutionLimit = 1;
    this.includeAllJMSXProperties = false;
    this.jmsKeyFormatStrategy = "";
    this.mapJmsMessage = true;
    this.maxMessagesPerTask = -1;
    this.messageConverter = "";
    this.messageCreatedStrategy = "";
    this.messageIdEnabled = true;
    this.messageListenerContainerFactory = "";
    this.messageTimestampEnabled = true;
    this.pubSubNoLocal = false;
    this.receiveTimeout = 1000;
    this.recoveryInterval = 5000;
    this.requestTimeoutCheckerInterval = 1000;
    this.synchronous = false;
    this.transferException = false;
    this.transferExchange = false;
    this.transferFault = false;
    this.useMessageIDAsCorrelationID = false;
    this.waitForProvisionCorrelationToBeUpdatedCounter = 50;
    this.waitForProvisionCorrelationToBeUpdatedThreadSleepingTime = 100;
    this.errorHandlerLogStackTrace = true;
    this.errorHandlerLoggingLevel = "WARN";
    this.password = "";
    this.username = "";
    this.transacted = false;
    this.lazyCreateTransactionManager = true;
    this.transactionManager = "";
    this.transactionName = "";
    this.transactionTimeout = -1;
  }

  paint(g) {
    if (this._img == null) {
      this._img = Resources.IMG_START_NODE;
    }

    g.save();
    this.color = "#cebee1";
    g.drawOvalBorder(this.x, this.y, this.width, this.height, 10, this.color);
    g.drawImage(this._img, this.x + 10, this.y + 5, this.icon_width / 2, this.icon_height / 2);
    g.setColor(Resources.COLOR.black);
    g.drawText(this.uri, this.x + this.width / 6, this.y + this.height / 1.5);
    g.restore();
  }

  /**
   * 更新uri(一个冒号)
   * @param {原始的组件数据} intValue 
   * @param {现在要更新的值} prop 
   * @returns 
   */
   updateUri(intValue, prop) {
    let tempArr = this.getPropsDesc().advanced['path']
    return this.changeUri(intValue, this, prop, tempArr, 1);
  }

  toXML(index) {
    let str = "";
    if (this.outputid && !this.inputid || index == 0) {
      str += `<from id="${this.id}" x="${this.x}" y="${this.y}" uri="${this.uri}"  ref="${this.ref_deprecated}" scope="${this.scope}">\n <description>${this.description}</description>\n </from>\n`;
    } else {
      str = `<to id="${this.id}" x="${this.x}" y="${this.y}" uri="${this.uri}"   ref="${this.ref_deprecated}" scope="${this.scope}">\n  <description>${this.description}</description>\n </to>\n`;
    }
    return str;
  }

  parseXML(xmlNode) {
    
  }

  getPropsDesc() {
    return {
      details: ["uri", "description", "id", "ref_deprecated"],
      advanced: {
        path: ["destinationName", "destinationType"],
        common: ["clientId", "connectionFactory", "disableReplyTo", "durableSubscriptionName", "jmsMessageType", "testConnectionOnStartup"],
        consumer: [
          "acknowledgementModeName",
          "asyncConsumer",
          "autoStartup",
          "bridgeErrorHandler",
          "cacheLevel",
          "cacheLevelName",
          "concurrentConsumers",
          "maxConcurrentConsumers",
          "replyTo",
          "replyToDeliveryPersistent",
          "selector",
          "subscriptionDurable",
          "subscriptionName",
          "subscriptionShared",
        ],
        consumer_advanced: [
          "acceptMessagesWhileStopping",
          "allowReplyManagerQuickStop",
          "consumerType",
          "defaultTaskExecutorType",
          "eagerLoadingOfProperties",
          "exceptionHandler",
          "exchangePattern",
          "exposeListenerSession",
          "replyToSameDestinationAllowed",
          "taskExecutor",
        ],
        producer: [
          "deliveryMode",
          "deliveryPersistent",
          "explicitQosEnabled",
          "formatDateHeadersToIso8601",
          "preserveMessageQos",
          "priority",
          "replyToConcurrentConsumers",
          "replyToMaxConcurrentConsumers",
          "replyToOnTimeoutMaxConcurrentConsumers",
          "replyToOverride",
          "replyToType",
          "requestTimeout",
          "timeToLive",
        ],
        producer_advanced: [
          "allowAdditionalHeaders",
          "allowNullBody",
          "alwaysCopyMessage",
          "correlationProperty",
          "disableTimeToLive",
          "forceSendOriginalMessage",
          "includeSentJMSMessageID",
          "replyToCacheLevelName",
          "replyToDestinationSelectorName",
          "streamMessageTypeEnabled",
        ],
        advanceds: [
          "allowSerializedHeaders",
          "asyncStartListener",
          "asyncStopListener",
          "destinationResolver",
          "errorHandler",
          "exceptionListener",
          "headerFilterStrategy",
          "idleConsumerLimit",
          "idleTaskExecutionLimit",
          "includeAllJMSXProperties",
          "jmsKeyFormatStrategy",
          "mapJmsMessage",
          "maxMessagesPerTask",
          "messageConverter",
          "messageCreatedStrategy",
          "messageIdEnabled",
          "messageListenerContainerFactory",
          "messageTimestampEnabled",
          "pubSubNoLocal",
          "receiveTimeout",
          "recoveryInterval",
          "requestTimeoutCheckerInterval",
          "synchronous",
          "transferException",
          "transferExchange",
          "transferFault",
          "useMessageIDAsCorrelationID",
          "waitForProvisionCorrelationToBeUpdatedCounter",
          "waitForProvisionCorrelationToBeUpdatedThreadSleepingTime",
        ],
        logging: ["errorHandlerLogStackTrace", "errorHandlerLoggingLevel"],
        security: ["password", "username"],
        transaction: ["transacted"],
        transaction_advanced: ["lazyCreateTransactionManager", "transactionManager", "transactionName", "transactionTimeout"],
      },
      documentation: JMS.documentation,
    };
  }
}
JMS.documentation = ``;
export default JMS;
