import CamelElement from "../CamelElement";
import { Resources } from "../../utility";
class JDBC extends CamelElement {
  constructor() {
    super();
    this.scope = "JDBC";
    this.hasUri = true
    this.parent = "";
    this.inputid = ""; // 线的接入
    this.outputid = ""; // 线的出口
    this.description = ""; // 描述
    this.id = "jdbc"; // 名字
    this.ref_deprecated = ""; // 已弃用(ref)
    this.dataSourceName = "dataSourceName";
    this.uri = `jdbc:${this.dataSourceName}`; // uri
    this.allowNamedParameters = true;
    this.outputClass = "";
    this.outputType = "SelectList";
    this.parameters = "";
    this.readSize = "";
    this.resetAutoCommit = true;
    this.transacted = false;
    this.useGetBytesForBlob = false;
    this.useHeadersAsParameters = false;
    this.useJDBC4ColumnNameAndLabelSemantics = true;
    this.beanRowMapper = "";
    this.prepareStatementStrategy = "";
    this.synchronous = false;
  }

  paint(g) {
    if (this._img == null) {
      this._img = Resources.IMG_START_NODE;
    }

    g.save();
    this.color = "#cebee1";
    g.drawOvalBorder(this.x, this.y, this.width, this.height, 10, this.color);
    g.drawImage(this._img, this.x + 10, this.y + 5, this.icon_width / 2, this.icon_height / 2);
    g.setColor(Resources.COLOR.black);
    g.drawText(this.uri, this.x + this.width / 6, this.y + this.height / 1.5);
    g.restore();
  }
  
  /**
   * 更新uri(一个冒号)
   * @param {原始的组件数据} intValue 
   * @param {现在要更新的值} prop 
   * @returns 
   */
   updateUri(intValue, prop) {
    let tempArr = this.getPropsDesc().advanced['path']
    return this.changeUri(intValue, this, prop, tempArr, 1);
  }

  toXML(index) {
    let str = "";
    if (this.outputid && !this.inputid || index == 0) {
      str += `<from id="${this.id}" x="${this.x}" y="${this.y}" uri="${this.uri}"  ref="${this.ref_deprecated}" scope="${this.scope}">\n <description>${this.description}</description>\n </from>\n`;
    } else {
      str = `<to id="${this.id}" x="${this.x}" y="${this.y}" uri="${this.uri}"   ref="${this.ref_deprecated}" scope="${this.scope}">\n  <description>${this.description}</description>\n </to>\n`;
    }
    return str;
  }

  parseXML(xmlNode) {
    
  }

  getPropsDesc() {
    return {
      details: ["uri", "description", "id", "pattern", "ref_deprecated"],
      advanced: {
        path: ["dataSourceName"],
        producer: ["allowNamedParameters", "outputClass", "outputType", "parameters", "readSize", "resetAutoCommit", "transacted", "useGetBytesForBlob", "useHeadersAsParameters", "useJDBC4ColumnNameAndLabelSemantics"],
        advanceds: ["beanRowMapper", "prepareStatementStrategy", "synchronous"],
      },
      documentation: JDBC.documentation,
    };
  }
}
JDBC.documentation = `<div class="chapter">
<div class="titlepage">
    <div>
        <div>
            <h2 class="title"><a name="jdbc-component"></a>JDBC Component</h2>
        </div>
    </div>
</div>
<div class="toc">
    <p><b>Table of Contents</b></p>
    <dl>
        <dt><span class="section"><a href="jdbc-component.html#_uri_format_100">URI format</a></span></dt>
        <dt><span class="section"><a href="jdbc-component.html#_options_75">Options</a></span></dt>
        <dt><span class="section"><a href="jdbc-component.html#_result_2">Result</a></span></dt>
        <dt><span class="section"><a href="jdbc-component.html#_generated_keys">Generated keys</a></span></dt>
        <dt><span class="section"><a href="jdbc-component.html#_using_named_parameters">Using named
                    parameters</a></span></dt>
        <dt><span class="section"><a href="jdbc-component.html#_samples_19">Samples</a></span></dt>
        <dt><span class="section"><a href="jdbc-component.html#_sample_polling_the_database_every_minute">Sample
                    - Polling the database every minute</a></span></dt>
        <dt><span class="section"><a
                    href="jdbc-component.html#_sample_move_data_between_data_sources_asciidoc_br">Sample - Move
                    Data Between Data Sources</a></span></dt>
        <dt><span class="section"><a href="jdbc-component.html#_see_also_61">See Also</a></span></dt>
    </dl>
</div>
<p><span class="strong"><strong>Available as of Camel version 1.2</strong></span></p>
<p>The <span class="strong"><strong>jdbc</strong></span> component enables you to access databases through JDBC,
    where
    SQL queries (SELECT) and operations (INSERT, UPDATE, etc) are sent in
    the message body. This component uses the standard JDBC API, unlike the
    <a class="link" href="sql-component.html" title="SQL Component">SQL Component</a> component, which uses
    spring-jdbc.
</p>
<p>Maven users will need to add the following dependency to their <code class="literal">pom.xml</code>
    for this component:</p>
<pre class="programlisting">&lt;dependency&gt;
&lt;groupId&gt;org.apache.camel&lt;/groupId&gt;
&lt;artifactId&gt;camel-jdbc&lt;/artifactId&gt;
&lt;version&gt;x.x.x&lt;/version&gt;
&lt;!-- use the same version as your Camel core version --&gt;
&lt;/dependency&gt;</pre>
<p>This component can only be used to define producer endpoints, which
    means that you cannot use the JDBC component in a <code class="literal">from()</code> statement.</p>
<div class="section">
    <div class="titlepage">
        <div>
            <div>
                <h2 class="title" style="clear: both"><a name="_uri_format_100"></a>URI format</h2>
            </div>
        </div>
    </div>
    <pre class="programlisting">jdbc:dataSourceName[?options]</pre>
    <p>This component only supports producer endpoints.</p>
    <p>You can append query options to the URI in the following format,
        <code class="literal">?option=value&amp;option=value&amp;&#8230;&#8203;</code>
    </p>
</div>
<div class="section">
    <div class="titlepage">
        <div>
            <div>
                <h2 class="title" style="clear: both"><a name="_options_75"></a>Options</h2>
            </div>
        </div>
    </div>
    <div class="toc">
        <p><b>Table of Contents</b></p>
        <dl>
            <dt><span class="section"><a href="jdbc-component.html#_path_parameters_1_parameters_92">Path
                        Parameters (1 parameters):</a></span></dt>
            <dt><span class="section"><a href="jdbc-component.html#_query_parameters_13_parameters_6">Query
                        Parameters (13 parameters):</a></span></dt>
        </dl>
    </div>
    <p>The JDBC component supports 2 options which are listed below.</p>
    <div class="informaltable">
        <table border="1" width="100%">
            <colgroup>
                <col width="19%" class="col_1">
                <col width="51%" class="col_2">
                <col width="10%" class="col_3">
                <col width="20%" class="col_4">
            </colgroup>
            <thead>
                <tr>
                    <th align="left" valign="top">Name</th>
                    <th align="left" valign="top">Description</th>
                    <th align="center" valign="top">Default</th>
                    <th align="left" valign="top">Type</th>
                </tr>
            </thead>
            <tbody>
                <tr>
                    <td align="left" valign="top">
                        <p><span class="strong"><strong>dataSource</strong></span> (producer)</p>
                    </td>
                    <td align="left" valign="top">
                        <p>To use the DataSource instance instead of looking up the data source by name from the
                            registry.</p>
                    </td>
                    <td align="center" valign="top">&nbsp;</td>
                    <td align="left" valign="top">
                        <p>DataSource</p>
                    </td>
                </tr>
                <tr>
                    <td align="left" valign="top">
                        <p><span class="strong"><strong>resolveProperty Placeholders</strong></span> (advanced)
                        </p>
                    </td>
                    <td align="left" valign="top">
                        <p>Whether the component should resolve property placeholders on itself when starting.
                            Only properties which are of String type can use property placeholders.</p>
                    </td>
                    <td align="center" valign="top">
                        <p>true</p>
                    </td>
                    <td align="left" valign="top">
                        <p>boolean</p>
                    </td>
                </tr>
            </tbody>
        </table>
    </div>
    <p>The JDBC endpoint is configured using URI syntax:</p>
    <pre class="screen">jdbc:dataSourceName</pre>
    <p>with the following path and query parameters:</p>
    <div class="section">
        <div class="titlepage">
            <div>
                <div>
                    <h3 class="title"><a name="_path_parameters_1_parameters_92"></a>Path Parameters (1
                        parameters):</h3>
                </div>
            </div>
        </div>
        <div class="informaltable">
            <table border="1" width="100%">
                <colgroup>
                    <col width="19%" class="col_1">
                    <col width="51%" class="col_2">
                    <col width="10%" class="col_3">
                    <col width="20%" class="col_4">
                </colgroup>
                <thead>
                    <tr>
                        <th align="left" valign="top">Name</th>
                        <th align="left" valign="top">Description</th>
                        <th align="center" valign="top">Default</th>
                        <th align="left" valign="top">Type</th>
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <td align="left" valign="top">
                            <p><span class="strong"><strong>dataSourceName</strong></span></p>
                        </td>
                        <td align="left" valign="top">
                            <p><span class="strong"><strong>Required</strong></span> Name of DataSource to
                                lookup in the Registry.</p>
                        </td>
                        <td align="center" valign="top">&nbsp;</td>
                        <td align="left" valign="top">
                            <p>String</p>
                        </td>
                    </tr>
                </tbody>
            </table>
        </div>
    </div>
    <div class="section">
        <div class="titlepage">
            <div>
                <div>
                    <h3 class="title"><a name="_query_parameters_13_parameters_6"></a>Query Parameters (13
                        parameters):</h3>
                </div>
            </div>
        </div>
        <div class="informaltable">
            <table border="1" width="100%">
                <colgroup>
                    <col width="19%" class="col_1">
                    <col width="51%" class="col_2">
                    <col width="10%" class="col_3">
                    <col width="20%" class="col_4">
                </colgroup>
                <thead>
                    <tr>
                        <th align="left" valign="top">Name</th>
                        <th align="left" valign="top">Description</th>
                        <th align="center" valign="top">Default</th>
                        <th align="left" valign="top">Type</th>
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <td align="left" valign="top">
                            <p><span class="strong"><strong>allowNamedParameters</strong></span> (producer)</p>
                        </td>
                        <td align="left" valign="top">
                            <p>Whether to allow using named parameters in the queries.</p>
                        </td>
                        <td align="center" valign="top">
                            <p>true</p>
                        </td>
                        <td align="left" valign="top">
                            <p>boolean</p>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" valign="top">
                            <p><span class="strong"><strong>outputClass</strong></span> (producer)</p>
                        </td>
                        <td align="left" valign="top">
                            <p>Specify the full package and class name to use as conversion when
                                outputType=SelectOne or SelectList.</p>
                        </td>
                        <td align="center" valign="top">&nbsp;</td>
                        <td align="left" valign="top">
                            <p>String</p>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" valign="top">
                            <p><span class="strong"><strong>outputType</strong></span> (producer)</p>
                        </td>
                        <td align="left" valign="top">
                            <p>Determines the output the producer should use.</p>
                        </td>
                        <td align="center" valign="top">
                            <p>SelectList</p>
                        </td>
                        <td align="left" valign="top">
                            <p>JdbcOutputType</p>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" valign="top">
                            <p><span class="strong"><strong>parameters</strong></span> (producer)</p>
                        </td>
                        <td align="left" valign="top">
                            <p>Optional parameters to the java.sql.Statement. For example to set maxRows,
                                fetchSize etc.</p>
                        </td>
                        <td align="center" valign="top">&nbsp;</td>
                        <td align="left" valign="top">
                            <p>Map</p>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" valign="top">
                            <p><span class="strong"><strong>readSize</strong></span> (producer)</p>
                        </td>
                        <td align="left" valign="top">
                            <p>The default maximum number of rows that can be read by a polling query. The
                                default value is 0.</p>
                        </td>
                        <td align="center" valign="top">&nbsp;</td>
                        <td align="left" valign="top">
                            <p>int</p>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" valign="top">
                            <p><span class="strong"><strong>resetAutoCommit</strong></span> (producer)</p>
                        </td>
                        <td align="left" valign="top">
                            <p>Camel will set the autoCommit on the JDBC connection to be false, commit the
                                change after executed the statement and reset the autoCommit flag of the
                                connection at the end, if the resetAutoCommit is true. If the JDBC connection
                                doesn&#8217;t support to reset the autoCommit flag, you can set the
                                resetAutoCommit flag to be false, and Camel will not try to reset the autoCommit
                                flag. When used with XA transactions you most likely need to set it to false so
                                that the transaction manager is in charge of committing this tx.</p>
                        </td>
                        <td align="center" valign="top">
                            <p>true</p>
                        </td>
                        <td align="left" valign="top">
                            <p>boolean</p>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" valign="top">
                            <p><span class="strong"><strong>transacted</strong></span> (producer)</p>
                        </td>
                        <td align="left" valign="top">
                            <p>Whether transactions are in use.</p>
                        </td>
                        <td align="center" valign="top">
                            <p>false</p>
                        </td>
                        <td align="left" valign="top">
                            <p>boolean</p>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" valign="top">
                            <p><span class="strong"><strong>useGetBytesForBlob</strong></span> (producer)</p>
                        </td>
                        <td align="left" valign="top">
                            <p>To read BLOB columns as bytes instead of string data. This may be needed for
                                certain databases such as Oracle where you must read BLOB columns as bytes.</p>
                        </td>
                        <td align="center" valign="top">
                            <p>false</p>
                        </td>
                        <td align="left" valign="top">
                            <p>boolean</p>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" valign="top">
                            <p><span class="strong"><strong>useHeadersAsParameters</strong></span> (producer)
                            </p>
                        </td>
                        <td align="left" valign="top">
                            <p>Set this option to true to use the prepareStatementStrategy with named
                                parameters. This allows to define queries with named placeholders, and use
                                headers with the dynamic values for the query placeholders.</p>
                        </td>
                        <td align="center" valign="top">
                            <p>false</p>
                        </td>
                        <td align="left" valign="top">
                            <p>boolean</p>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" valign="top">
                            <p><span class="strong"><strong>useJDBC4ColumnNameAnd LabelSemantics</strong></span>
                                (producer)</p>
                        </td>
                        <td align="left" valign="top">
                            <p>Sets whether to use JDBC 4 or JDBC 3.0 or older semantic when retrieving column
                                name. JDBC 4.0 uses columnLabel to get the column name where as JDBC 3.0 uses
                                both columnName or columnLabel. Unfortunately JDBC drivers behave differently so
                                you can use this option to work out issues around your JDBC driver if you get
                                problem using this component This option is default true.</p>
                        </td>
                        <td align="center" valign="top">
                            <p>true</p>
                        </td>
                        <td align="left" valign="top">
                            <p>boolean</p>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" valign="top">
                            <p><span class="strong"><strong>beanRowMapper</strong></span> (advanced)</p>
                        </td>
                        <td align="left" valign="top">
                            <p>To use a custom org.apache.camel.component.jdbc.BeanRowMapper when using
                                outputClass. The default implementation will lower case the row names and skip
                                underscores, and dashes. For example CUST_ID is mapped as custId.</p>
                        </td>
                        <td align="center" valign="top">&nbsp;</td>
                        <td align="left" valign="top">
                            <p>BeanRowMapper</p>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" valign="top">
                            <p><span class="strong"><strong>prepareStatementStrategy</strong></span> (advanced)
                            </p>
                        </td>
                        <td align="left" valign="top">
                            <p>Allows to plugin to use a custom
                                org.apache.camel.component.jdbc.JdbcPrepareStatementStrategy to control
                                preparation of the query and prepared statement.</p>
                        </td>
                        <td align="center" valign="top">&nbsp;</td>
                        <td align="left" valign="top">
                            <p>JdbcPrepareStatement Strategy</p>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" valign="top">
                            <p><span class="strong"><strong>synchronous</strong></span> (advanced)</p>
                        </td>
                        <td align="left" valign="top">
                            <p>Sets whether synchronous processing should be strictly used, or Camel is allowed
                                to use asynchronous processing (if supported).</p>
                        </td>
                        <td align="center" valign="top">
                            <p>false</p>
                        </td>
                        <td align="left" valign="top">
                            <p>boolean</p>
                        </td>
                    </tr>
                </tbody>
            </table>
        </div>
    </div>
</div>
<div class="section">
    <div class="titlepage">
        <div>
            <div>
                <h2 class="title" style="clear: both"><a name="_result_2"></a>Result</h2>
            </div>
        </div>
    </div>
    <div class="toc">
        <p><b>Table of Contents</b></p>
        <dl>
            <dt><span class="section"><a href="jdbc-component.html#_message_headers_25">Message
                        Headers</a></span></dt>
        </dl>
    </div>
    <p>By default the result is returned in the OUT body as an
        <code class="literal">ArrayList&lt;HashMap&lt;String, Object&gt;&gt;</code>. The <code
            class="literal">List</code> object contains the
        list of rows and the <code class="literal">Map</code> objects contain each row with the <code
            class="literal">String</code>
        key as the column name. You can use the option <code class="literal">outputType</code> to control
        the result.
    </p>
    <p><span class="strong"><strong>Note:</strong></span> This component fetches <code
            class="literal">ResultSetMetaData</code> to be able to return
        the column name as the key in the <code class="literal">Map</code>.</p>
    <div class="section">
        <div class="titlepage">
            <div>
                <div>
                    <h3 class="title"><a name="_message_headers_25"></a>Message Headers</h3>
                </div>
            </div>
        </div>
        <div class="informaltable">
            <table border="1" width="100%">
                <colgroup>
                    <col width="10%" class="col_1">
                    <col width="90%" class="col_2">
                </colgroup>
                <thead>
                    <tr>
                        <th align="left" valign="top">Header</th>
                        <th align="left" valign="top">Description</th>
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <td align="left" valign="top">
                            <p><code class="literal">CamelJdbcRowCount</code></p>
                        </td>
                        <td align="left" valign="top">
                            <p>If the query is a <code class="literal">SELECT</code>, query the row count is
                                returned in this OUT
                                header.</p>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" valign="top">
                            <p><code class="literal">CamelJdbcUpdateCount</code></p>
                        </td>
                        <td align="left" valign="top">
                            <p>If the query is an <code class="literal">UPDATE</code>, query the update count is
                                returned in this
                                OUT header.</p>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" valign="top">
                            <p><code class="literal">CamelGeneratedKeysRows</code></p>
                        </td>
                        <td align="left" valign="top">
                            <p><span class="strong"><strong>Camel 2.10:</strong></span> Rows that contains the
                                generated kets.</p>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" valign="top">
                            <p><code class="literal">CamelGeneratedKeysRowCount</code></p>
                        </td>
                        <td align="left" valign="top">
                            <p><span class="strong"><strong>Camel 2.10:</strong></span> The number of rows in
                                the header that contains generated
                                keys.</p>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" valign="top">
                            <p><code class="literal">CamelJdbcColumnNames</code></p>
                        </td>
                        <td align="left" valign="top">
                            <p><span class="strong"><strong>Camel 2.11.1:</strong></span> The column names from
                                the ResultSet as a <code class="literal">java.util.Set</code>
                                type.</p>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" valign="top">
                            <p><code class="literal">CamelJdbcParametes</code></p>
                        </td>
                        <td align="left" valign="top">
                            <p><span class="strong"><strong>Camel 2.12:</strong></span> A <code
                                    class="literal">java.util.Map</code> which has the headers to be used if
                                <code class="literal">useHeadersAsParameters</code> has been enabled.
                            </p>
                        </td>
                    </tr>
                </tbody>
            </table>
        </div>
    </div>
</div>
<div class="section">
    <div class="titlepage">
        <div>
            <div>
                <h2 class="title" style="clear: both"><a name="_generated_keys"></a>Generated keys</h2>
            </div>
        </div>
    </div>
    <p><span class="strong"><strong>Available as of Camel 2.10</strong></span></p>
    <p>If you insert data using SQL INSERT, then the RDBMS may support auto
        generated keys. You can instruct the <a class="link" href="jdbc-component.html"
            title="JDBC Component">JDBC</a> producer to
        return the generated keys in headers.
        To do that set the header <code class="literal">CamelRetrieveGeneratedKeys=true</code>. Then the
        generated keys will be provided as headers with the keys listed in the
        table above.</p>
    <p>You can see more details in this
        <a class="link"
            href="https://svn.apache.org/repos/asf/camel/trunk/components/camel-jdbc/src/test/java/org/apache/camel/component/jdbc/JdbcGeneratedKeysTest.java"
            target="_top">unit
            test</a>.
    </p>
    <p>Using generated keys does not work with together with named parameters.</p>
</div>
<div class="section">
    <div class="titlepage">
        <div>
            <div>
                <h2 class="title" style="clear: both"><a name="_using_named_parameters"></a>Using named
                    parameters</h2>
            </div>
        </div>
    </div>
    <p><span class="strong"><strong>Available as of Camel 2.12</strong></span></p>
    <p>In the given route below, we want to get all the projects from the
        projects table. Notice the SQL query has 2 named parameters, :?lic and
        :?min.
        Camel will then lookup these parameters from the message headers.
        Notice in the example above we set two headers with constant value
        for the named parameters:</p>
    <pre
        class="programlisting">  from(<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-string"><em style="color:red">"direct:projects"</em></strong>)
.setHeader(<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-string"><em style="color:red">"lic"</em></strong>, constant(<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-string"><em style="color:red">"ASF"</em></strong>))
.setHeader(<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-string"><em style="color:red">"min"</em></strong>, constant(<span xmlns="http://www.w3.org/1999/xhtml" class="hl-number">123</span>))
.setBody(<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-string"><em style="color:red">"select * from projects where license = :?lic and id &gt; :?min order by id"</em></strong>)
.to(<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-string"><em style="color:red">"jdbc:myDataSource?useHeadersAsParameters=true"</em></strong>)</pre>
    <p>You can also store the header values in a <code class="literal">java.util.Map</code> and store the
        map on the headers with the key <code class="literal">CamelJdbcParameters</code>.</p>
</div>
<div class="section">
    <div class="titlepage">
        <div>
            <div>
                <h2 class="title" style="clear: both"><a name="_samples_19"></a>Samples</h2>
            </div>
        </div>
    </div>
    <p>In the following example, we fetch the rows from the customer table.</p>
    <p>First we register our datasource in the Camel registry as <code class="literal">testdb</code>:</p>
    <p>Then we configure a route that routes to the JDBC component, so the SQL
        will be executed. Note how we refer to the <code class="literal">testdb</code> datasource that was
        bound in the previous step:</p>
    <p>Or you can create a <code class="literal">DataSource</code> in Spring like this:</p>
    <p>We create an endpoint, add the SQL query to the body of the IN message,
        and then send the exchange. The result of the query is returned in the
        OUT body:</p>
    <p>If you want to work on the rows one by one instead of the entire
        ResultSet at once you need to use the Splitter EIP
        such as:</p>
    <p>In Camel 2.13.x or older</p>
    <p>In Camel 2.14.x or newer</p>
    <pre
        class="programlisting">from(<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-string"><em style="color:red">"direct:hello"</em></strong>)
<em xmlns="http://www.w3.org/1999/xhtml" class="hl-comment" style="color: silver">// here we split the data from the testdb into new messages one by one</em>
<em xmlns="http://www.w3.org/1999/xhtml" class="hl-comment" style="color: silver">// so the mock endpoint will receive a message per row in the table</em>
<em xmlns="http://www.w3.org/1999/xhtml" class="hl-comment" style="color: silver">// the StreamList option allows to stream the result of the query without creating a List of rows</em>
<em xmlns="http://www.w3.org/1999/xhtml" class="hl-comment" style="color: silver">// and notice we also enable streaming mode on the splitter</em>
.to(<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-string"><em style="color:red">"jdbc:testdb?outputType=StreamList"</em></strong>)
.split(body()).streaming()
.to(<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-string"><em style="color:red">"mock:result"</em></strong>);</pre>
</div>
<div class="section">
    <div class="titlepage">
        <div>
            <div>
                <h2 class="title" style="clear: both"><a
                        name="_sample_polling_the_database_every_minute"></a>Sample - Polling the database every
                    minute</h2>
            </div>
        </div>
    </div>
    <p>If we want to poll a database using the JDBC component, we need to
        combine it with a polling scheduler such as the <a class="link" href="timer-component.html"
            title="Timer Component">Timer</a>
        or <a class="link" href="quartz-component.html" title="Quartz Component (deprecated)">Quartz</a> etc. In
        the following example, we retrieve
        data from the database every 60 seconds:</p>
    <pre
        class="programlisting">from(<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-string"><em style="color:red">"timer://foo?period=60000"</em></strong>).setBody(constant(<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-string"><em style="color:red">"select * from customer"</em></strong>)).to(<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-string"><em style="color:red">"jdbc:testdb"</em></strong>).to(<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-string"><em style="color:red">"activemq:queue:customers"</em></strong>);</pre>
</div>
<div class="section">
    <div class="titlepage">
        <div>
            <div>
                <h2 class="title" style="clear: both"><a
                        name="_sample_move_data_between_data_sources_asciidoc_br"></a>Sample - Move Data Between
                    Data Sources</h2>
            </div>
        </div>
    </div>
    <p>A common use case is to query for data, process it and move it to
        another data source (ETL operations). In the following example, we
        retrieve new customer records from the source table every hour,
        filter/transform them and move them to a destination table:</p>
    <pre
        class="programlisting">from(<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-string"><em style="color:red">"timer://MoveNewCustomersEveryHour?period=3600000"</em></strong>)
.setBody(constant(<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-string"><em style="color:red">"select * from customer where create_time &gt; (sysdate-1/24)"</em></strong>))
.to(<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-string"><em style="color:red">"jdbc:testdb"</em></strong>)
.split(body())
.process(<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-keyword">new</strong> MyCustomerProcessor()) <em xmlns="http://www.w3.org/1999/xhtml" class="hl-comment" style="color: silver">//filter/transform results as needed</em>
.setBody(simple(<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-string"><em style="color:red">"insert into processed_customer values('{body[ID]}','{body[NAME]}')"</em></strong>))
.to(<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-string"><em style="color:red">"jdbc:testdb"</em></strong>);</pre>
    <p>&nbsp;</p>
</div>
<div class="section">
    <div class="titlepage">
        <div>
            <div>
                <h2 class="title" style="clear: both"><a name="_see_also_61"></a>See Also</h2>
            </div>
        </div>
    </div>
    <div class="itemizedlist">
        <ul class="itemizedlist" style="list-style-type: disc; ">
            <li class="listitem">Configuring Camel</li>
            <li class="listitem">Component</li>
            <li class="listitem">Endpoint</li>
            <li class="listitem">Getting Started</li>
            <li class="listitem"><a class="link" href="sql-component.html" title="SQL Component">SQL</a></li>
        </ul>
    </div>
</div>
</div>`;
export default JDBC;
