import CamelElement from "../CamelElement";
import { Resources, StringUtil } from "../../utility";
class File extends CamelElement {
  constructor() {
    super();
    this.scope = "File";
    this.hasUri = true;
    this.parent = "";
    this.inputid = ""; // 线的接入
    this.outputid = ""; // 线的出口
    this.description = ""; // 描述
    this.id = "ftp"; // 名字
    this.pattern = ""; //图案
    this.ref_deprecated = ""; // 已弃用(ref)
    this.directoryName = "directoryName";
    this.uri = `file:${this.directoryName}`; // uri
    this.charset = "";
    this.doneFileName = "";
    this.fileName = "";
    this.bridgeErrorHandler = false;
    this.delete = false;
    this.moveFailed = "";
    this.noop = false;
    this.preMove = "";
    this.preSort = false;
    this.recursive = false;
    this.sendEmptyMessageWhenIdle = false;
    this.directoryMustExist = false;
    this.exceptionHandler = "";
    this.exchangePattern = "";
    this.extendedAttributes = "";
    this.inProgressRepository = "";
    this.localWorkDirectory = "";
    this.onCompletionExceptionHandler = "";
    this.pollStrategy = "";
    this.probeContentType = false;
    this.processStrategy = "";
    this.startingDirectoryMustExist = false;
    this.fileExist = "Override";
    this.flatten = false;
    this.jailStartingDirectory = true;
    this.moveExisting = "";
    this.tempFileName = "";
    this.tempPrefix = "";
    this.allowNullBody = false;
    this.chmod = "";
    this.disconnectOnBatchComplete = "";
    this.eagerDeleteTargetFile = true;
    this.forceWrites = true;
    this.keepLastModified = false;
    this.moveExistingFileStrategy = "";
    this.sendNoop = "";
    this.autoCreate = true;
    this.bufferSize = 131072;
    this.renameUsingCopy = true;
    this.copyAndDeleteOnRenameFail = false;
    this.synchronous = false;
    this.antExclude = "";
    this.antFilterCaseSensitive = false;
    this.antInclude = "";
    this.eagerMaxMessagesPerPoll = false;
    this.exclude = "";
    this.filter = "";
    this.filterDirectory = "";
    this.filterFile = "";
    this.idempotent = false;
    this.idempotentKey = "";
    this.idempotentRepository = "";
    this.include = "";
    this.maxDepth = 2147483647;
    this.maxMessagesPerPoll = "";
    this.minDepth = "";
    this.move = "";
    this.exclusiveReadLockStrategy = "";
    this.readLock = "none";
    this.readLockCheckInterval = 1000;
    this.readLockDeleteOrphanLockFiles = true;
    this.readLockIdempotentReleaseAsync = false;
    this.readLockIdempotentReleaseAsyncPoolSize = "";
    this.readLockIdempotentReleaseDelay = "";
    this.readLockIdempotentReleaseExecutorService = "";
    this.readLockLoggingLevel = "DEBUG";
    this.readLockMarkerFile = true;
    this.readLockMinAge = 0;
    this.readLockMinLength = 1;
    this.readLockRemoveOnCommit = false;
    this.readLockRemoveOnRollback = true;
    this.readLockTimeout = 10000;
    this.backoffErrorThreshold = "";
    this.backoffIdleThreshold = "";
    this.backoffMultiplier = "";
    this.delay = 500;
    this.greedy = false;
    this.initialDelay = 1000;
    this.runLoggingLevel = "REACE";
    this.scheduledExecutorService = "";
    this.scheduler = "none";
    this.schedulerProperties = "";
    this.startScheduler = true;
    this.timeUnit = "MILLISECONDS";
    this.useFixedDelay = true;
    this.shuffle = false;
    this.sortBy = "";
    this.sorter = "";
  }

  paint(g) {
    if (this._img == null) {
      this._img = Resources.IMG_START_NODE;
    }

    g.save();
    this.color = "#cebee1";
    g.drawOvalBorder(this.x, this.y, this.width, this.height, 10, this.color);
    g.drawImage(this._img, this.x + 10, this.y + 5, this.icon_width / 2, this.icon_height / 2);
    g.setColor(Resources.COLOR.black);
    g.drawText(this.uri, this.x + this.width / 6, this.y + this.height / 1.5);
    g.restore();
  }

  /**
   * 更新uri(一个冒号)
   * @param {原始的组件数据} intValue 
   * @param {现在要更新的值} prop 
   * @returns 
   */
   updateUri(intValue, prop) {
    let tempArr = this.getPropsDesc().advanced['path']
    return this.changeUri(intValue, this, prop, tempArr, 1);
  }

  toXML(index) {
    let str = "";
    const uriValue = StringUtil.encodeHTML(this.uri);
    if (this.outputid && !this.inputid || index == 0) {
      str += `<from id="${this.id}" x="${this.x}" y="${this.y}" uri="${uriValue}"  pattern="${this.pattern}" ref="${this.ref_deprecated}" scope="${this.scope}">\n <description>${this.description}</description>\n </from>\n`;
    } else {
      str = `<to id="${this.id}" x="${this.x}" y="${this.y}" uri="${uriValue}"  pattern="${this.pattern}"  ref="${this.ref_deprecated}" scope="${this.scope}">\n  <description>${this.description}</description>\n </to>\n`;
    }
    return str;
  }

  parseXML(xmlNode) {}

  getPropsDesc() {
    return {
      details: ["uri", "description", "id", "ref_deprecated"],
      advanced: {
        path: ["directoryName"],
        common: ["charset", "doneFileName", "fileName"],
        consumer: ["bridgeErrorHandler", "delete", "moveFailed", "noop", "preMove", "preSort", "recursive", "sendEmptyMessageWhenIdle"],
        consumer_advanced: [
          "directoryMustExist",
          "exceptionHandler",
          "exchangePattern",
          "extendedAttributes",
          "inProgressRepository",
          "localWorkDirectory",
          "onCompletionExceptionHandler",
          "pollStrategy",
          "probeContentType",
          "processStrategy",
          "startingDirectoryMustExist",
        ],
        producer: ["fileExist", "flatten", "jailStartingDirectory", "moveExisting", "tempFileName", "tempPrefix"],
        producer_advanced: ["allowNullBody", "chmod", "disconnectOnBatchComplete", "eagerDeleteTargetFile", "keepLastModified", "moveExistingFileStrategy", "sendNoop"],
        advanceds: ["autoCreate", "bufferSize", "renameUsingCopy", "copyAndDeleteOnRenameFail", "synchronous"],
        filter: [
          "antExclude",
          "antFilterCaseSensitive",
          "antInclude",
          "eagerMaxMessagesPerPoll",
          "exclude",
          "filter",
          "filterDirectory",
          "filterFile",
          "idempotent",
          "idempotentKey",
          "idempotentRepository",
          "include",
          "maxDepth",
          "maxMessagesPerPoll",
          "minDepth",
          "move",
        ],
        lock: [
          "exclusiveReadLockStrategy",
          "readLock",
          "readLockCheckInterval",
          "readLockDeleteOrphanLockFiles",
          "readLockIdempotentReleaseAsync",
          "readLockIdempotentReleaseAsyncPoolSize",
          "readLockIdempotentReleaseDelay",
          "readLockIdempotentReleaseExecutorService",
          "readLockLoggingLevel",
          "readLockMarkerFile",
          "readLockMinAge",
          "readLockMinLength",
          "readLockRemoveOnCommit",
          "readLockRemoveOnRollback",
          "readLockTimeout",
        ],
        scheduler: [
          "backoffErrorThreshold",
          "backoffIdleThreshold",
          "backoffMultiplier",
          "delay",
          "greedy",
          "initialDelay",
          "runLoggingLevel",
          "scheduledExecutorService",
          "scheduler",
          "schedulerProperties",
          "startScheduler",
          "timeUnit",
          "useFixedDelay",
        ],
        sort: ["shuffle", "sortBy", "sorter"],
      },
      documentation: File.documentation,
    };
  }
}
File.documentation = ``;
export default File;
