import CamelElement from "../CamelElement";
import { Resources } from "../../utility";
class FTP extends CamelElement {
  constructor() {
    super();
    this.scope = "FTP";
    this.hasUri = true;
    this.parent = "";
    this.inputid = ""; // 线的接入
    this.outputid = ""; // 线的出口
    this.description = ""; // 描述
    this.id = "ftp"; // 名字
    this.ref_deprecated = ""; // 已弃用(ref)
    this.host = "host";
    this.directoryName = "directoryName";
    this.port = "port";
    this.uri = `ftp:${this.host}:${this.port}/${this.directoryName}`; // uri
    this.binary = false;
    this.charset = "";
    this.disconnect = false;
    this.doneFileName = "";
    this.fileName = "";
    this.passiveMode = false;
    this.separator = "UNIX";
    this.transferLoggingIntervalSeconds = 5;
    this.transferLoggingLevel = "DEBUG";
    this.transferLoggingVerbose = false;
    this.fastExistsCheck = false;
    this.bridgeErrorHandler = false;
    this.delete = false;
    this.moveFailed = "";
    this.noop = false;
    this.preMove = "";
    this.preSort = false;
    this.recursive = false;
    this.resumeDownload = false;
    this.sendEmptyMessageWhenIdle = false;
    this.streamDownload = false;
    this.directoryMustExist = false;
    this.download = false;
    this.exceptionHandler = "";
    this.exchangePattern = "";
    this.handleDirectoryParserAbsoluteResult = false;
    this.ignoreFileNotFoundOrPermissionError = false;
    this.inProgressRepository = "";
    this.localWorkDirectory = "";
    this.onCompletionExceptionHandler = "";
    this.pollStrategy = "";
    this.processStrategy = "";
    this.receiveBufferSize = 32768;
    this.startingDirectoryMustExist = false;
    this.useList = true;
    this.fileExist = "Override";
    this.flatten = false;
    this.jailStartingDirectory = true;
    this.moveExisting = "";
    this.tempFileName = "";
    this.tempPrefix = "";
    this.allowNullBody = false;
    this.chmod = "";
    this.disconnectOnBatchComplete = false;
    this.eagerDeleteTargetFile = true;
    this.keepLastModified = false;
    this.moveExistingFileStrategy = "";
    this.sendNoop = true;
    this.activePortRange = "";
    this.autoCreate = true;
    this.bufferSize = 131072;
    this.connectTimeout = 10000;
    this.ftpClient = "";
    this.ftpClientConfig = "";
    this.ftpClientConfigParameters = "";
    this.ftpClientParameters = "";
    this.maximumReconnectAttempts = "";
    this.reconnectDelay = "";
    this.siteCommand = "";
    this.soTimeout = 300000;
    this.stepwise = true;
    this.synchronous = false;
    this.throwExceptionOnConnectFailed = false;
    this.timeout = 30000;
    this.antExclude = "";
    this.antFilterCaseSensitive = true;
    this.antInclude = "";
    this.eagerMaxMessagesPerPoll = true;
    this.exclude = "";
    this.filter = "";
    this.filterDirectory = "";
    this.filterFile = "";
    this.idempotent = false;
    this.idempotentKey = "";
    this.idempotentRepository = "";
    this.include = "";
    this.maxDepth = 2147483647;
    this.maxMessagesPerPoll = "";
    this.minDepth = "";
    this.move = "";
    this.exclusiveReadLockStrategy = "";
    this.readLock = "none";
    this.readLockCheckInterval = 1000;
    this.readLockDeleteOrphanLockFiles = true;
    this.readLockLoggingLevel = "DEBUG";
    this.readLockMarkerFile = true;
    this.readLockMinAge = "";
    this.readLockMinLength = "";
    this.readLockRemoveOnCommit = false;
    this.readLockRemoveOnRollback = true;
    this.readLockTimeout = 10000;
    this.backoffErrorThreshold = "";
    this.backoffIdleThreshold = "";
    this.backoffMultiplier = "";
    this.delay = 500;
    this.greedy = false;
    this.initialDelay = "";
    this.runLoggingLevel = "REACE";
    this.scheduledExecutorService = "";
    this.scheduler = "none";
    this.schedulerProperties = "";
    this.startScheduler = true;
    this.timeUnit = "MILLISECONDS";
    this.useFixedDelay = true;
    this.shuffle = false;
    this.sortBy = "";
    this.sorter = "";
    this.account = "";
    this.password = "";
    this.username = "";
  }

  paint(g) {
    if (this._img == null) {
      this._img = Resources.IMG_START_NODE;
    }

    g.save();
    this.color = "#cebee1";
    g.drawOvalBorder(this.x, this.y, this.width, this.height, 10, this.color);
    g.drawImage(this._img, this.x + 10, this.y + 5, this.icon_width / 2, this.icon_height / 2);
    g.setColor(Resources.COLOR.black);
    g.drawText(this.uri, this.x + this.width / 6, this.y + this.height / 1.5);
    g.restore();
  }

  /**
   * 更新uri(两个冒号+一个斜杠)
   * @param {原始的组件数据}} intValue
   * @param {现在要更新的值} prop
   * @returns
   */
  updateUri(intValue, prop) {
    let tempArr = this.getPropsDesc().advanced["path"];
    return this.changeUri(intValue, this, prop, tempArr, "2s");
  }

  toXML(index) {
    let str = "";
    if ((this.outputid && !this.inputid) || index == 0) {
      str += `<from id="${this.id}" x="${this.x}" y="${this.y}" uri="${this.uri}"  ref="${this.ref_deprecated}" scope="${this.scope}" description="${this.description}">\n <description>${this.description}</description>\n </from>\n`;
    } else {
      str = `<to id="${this.id}" x="${this.x}" y="${this.y}" uri="${this.uri}"   ref="${this.ref_deprecated}" scope="${this.scope}">\n  <description>${this.description}</description>\n </to>\n`;
    }
    return str;
  }

  parseXML(xmlNode) {}

  getPropsDesc() {
    return {
      details: ["uri", "description", "id", "ref_deprecated"],
      advanced: {
        path: ["host", "port", "directoryName"],
        common: ["binary", "charset", "disconnect", "doneFileName", "fileName", "passiveMode", "separator", "transferLoggingIntervalSeconds", "transferLoggingLevel", "transferLoggingVerbose"],
        common_advanced: ["fastExistsCheck"],
        consumer: ["bridgeErrorHandler", "delete", "moveFailed", "noop", "preMove", "preSort", "recursive", "resumeDownload", "sendEmptyMessageWhenIdle", "streamDownload"],
        consumer_advanced: [
          "directoryMustExist",
          "download",
          "exceptionHandler",
          "exchangePattern",
          "handleDirectoryParserAbsoluteResult",
          "ignoreFileNotFoundOrPermissionError",
          "inProgressRepository",
          "localWorkDirectory",
          "onCompletionExceptionHandler",
          "pollStrategy",
          "processStrategy",
          "receiveBufferSize",
          "startingDirectoryMustExist",
          "useList",
        ],
        producer: ["fileExist", "flatten", "jailStartingDirectory", "moveExisting", "tempFileName", "tempPrefix"],
        producer_advanced: ["allowNullBody", "chmod", "disconnectOnBatchComplete", "eagerDeleteTargetFile", "keepLastModified", "moveExistingFileStrategy", "sendNoop"],
        advanceds: [
          "activePortRange",
          "autoCreate",
          "bufferSize",
          "connectTimeout",
          "ftpClient",
          "ftpClientConfig",
          "ftpClientConfigParameters",
          "ftpClientParameters",
          "maximumReconnectAttempts",
          "reconnectDelay",
          "siteCommand",
          "soTimeout",
          "stepwise",
          "synchronous",
          "throwExceptionOnConnectFailed",
          "timeout",
        ],
        filter: [
          "antExclude",
          "antFilterCaseSensitive",
          "antInclude",
          "eagerMaxMessagesPerPoll",
          "exclude",
          "filter",
          "filterDirectory",
          "filterFile",
          "idempotent",
          "idempotentKey",
          "idempotentRepository",
          "include",
          "maxDepth",
          "maxMessagesPerPoll",
          "minDepth",
          "move",
        ],
        lock: [
          "exclusiveReadLockStrategy",
          "readLock",
          "readLockCheckInterval",
          "readLockDeleteOrphanLockFiles",
          "readLockLoggingLevel",
          "readLockMarkerFile",
          "readLockMinAge",
          "readLockMinLength",
          "readLockRemoveOnCommit",
          "readLockRemoveOnRollback",
          "readLockTimeout",
        ],
        scheduler: [
          "backoffErrorThreshold",
          "backoffIdleThreshold",
          "backoffMultiplier",
          "delay",
          "greedy",
          "initialDelay",
          "runLoggingLevel",
          "scheduledExecutorService",
          "scheduler",
          "schedulerProperties",
          "startScheduler",
          "timeUnit",
          "useFixedDelay",
        ],
        sort: ["shuffle", "sortBy", "sorter"],
        security: ["account", "password", "username"],
      },
      documentation: FTP.documentation,
    };
  }
}
FTP.documentation = `<div class="chapter">
<div class="titlepage">
    <div>
        <div>
            <h2 class="title"><a name="ftp-component"></a>FTP Component</h2>
        </div>
    </div>
</div>
<div class="toc">
    <p><b>Table of Contents</b></p>
    <dl>
        <dt><span class="section"><a href="ftp-component.html#_uri_format_77">URI format</a></span></dt>
        <dt><span class="section"><a href="ftp-component.html#_uri_options_25">URI Options</a></span></dt>
        <dt><span class="section"><a href="ftp-component.html#_ftps_component_default_trust_store">FTPS
                    component default trust store</a></span></dt>
        <dt><span class="section"><a href="ftp-component.html#_examples_13">Examples</a></span></dt>
        <dt><span class="section"><a href="ftp-component.html#_concurrency">Concurrency</a></span></dt>
        <dt><span class="section"><a href="ftp-component.html#_more_information">More information</a></span>
        </dt>
        <dt><span class="section"><a href="ftp-component.html#_default_when_consuming_files">Default when
                    consuming files</a></span></dt>
        <dt><span class="section"><a href="ftp-component.html#_message_headers_10">Message Headers</a></span>
        </dt>
        <dt><span class="section"><a href="ftp-component.html#_about_timeouts">About timeouts</a></span></dt>
        <dt><span class="section"><a href="ftp-component.html#_using_local_work_directory">Using Local Work
                    Directory</a></span></dt>
        <dt><span class="section"><a href="ftp-component.html#_stepwise_changing_directories">Stepwise changing
                    directories</a></span></dt>
        <dt><span class="section"><a href="ftp-component.html#_samples_17">Samples</a></span></dt>
        <dt><span class="section"><a
                    href="ftp-component.html#_filter_using_literal_org_apache_camel_component_file_genericfilefilter_literal">Filter
                    using <code
                        class="literal">org.apache.camel.component.file.GenericFileFilter</code></a></span></dt>
        <dt><span class="section"><a href="ftp-component.html#_filtering_using_ant_path_matcher_2">Filtering
                    using ANT path matcher</a></span></dt>
        <dt><span class="section"><a href="ftp-component.html#_using_a_proxy_with_sftp">Using a proxy with
                    SFTP</a></span></dt>
        <dt><span class="section"><a
                    href="ftp-component.html#_setting_preferred_sftp_authentication_method">Setting preferred
                    SFTP authentication method</a></span></dt>
        <dt><span class="section"><a
                    href="ftp-component.html#_consuming_a_single_file_using_a_fixed_name">Consuming a single
                    file using a fixed name</a></span></dt>
        <dt><span class="section"><a href="ftp-component.html#_debug_logging_2">Debug logging</a></span></dt>
        <dt><span class="section"><a href="ftp-component.html#_see_also_50">See Also</a></span></dt>
    </dl>
</div>
<p><span class="strong"><strong>Available as of Camel version 1.1</strong></span></p>
<p>This component provides access to remote file systems over the FTP and
    SFTP protocols.</p>
<p>When consuming from remote FTP server make sure you read the section titled <span
        class="emphasis"><em>Default when consuming files</em></span>
    further below for details related to consuming files.</p>
<p>Absolute path is <span class="strong"><strong>not</strong></span> supported. <span
        class="strong"><strong>Camel 2.16</strong></span> will translate absolute path to relative by trimming
    all
    leading slashes from <code class="literal">directoryname</code>. There&#8217;ll be WARN message printed
    in the logs.</p>
<p>Maven users will need to add the following dependency to their <code class="literal">pom.xml</code>
    for this component:</p>
<pre class="programlisting"><strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096">&lt;dependency&gt;</strong>
<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096">&lt;groupId&gt;</strong>org.apache.camel<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096">&lt;/groupId&gt;</strong>
<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096">&lt;artifactId&gt;</strong>camel-ftp<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096">&lt;/artifactId&gt;</strong>
<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096">&lt;version&gt;</strong>x.x.x<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096">&lt;/version&gt;</strong>See the documentation of the Apache Commons
<em xmlns="http://www.w3.org/1999/xhtml" class="hl-comment" style="color: silver">&lt;!-- use the same version as your Camel core version --&gt;</em>
<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096">&lt;/dependency&gt;</strong></pre>
<div class="section">
    <div class="titlepage">
        <div>
            <div>
                <h2 class="title" style="clear: both"><a name="_uri_format_77"></a>URI format</h2>
            </div>
        </div>
    </div>
    <pre
        class="programlisting">ftp:<em xmlns="http://www.w3.org/1999/xhtml" class="hl-comment" style="color: silver">//[username@]hostname[:port]/directoryname[?options]</em>
sftp:<em xmlns="http://www.w3.org/1999/xhtml" class="hl-comment" style="color: silver">//[username@]hostname[:port]/directoryname[?options]</em>
ftps:<em xmlns="http://www.w3.org/1999/xhtml" class="hl-comment" style="color: silver">//[username@]hostname[:port]/directoryname[?options]</em></pre>
    <p>Where <span class="strong"><strong>directoryname</strong></span> represents the underlying directory. The
        directory
        name is a relative path. Absolute path&#8217;s is <span class="strong"><strong>not</strong></span>
        supported. The
        relative path can contain nested folders, such as /inbox/us.</p>
    <p>For Camel versions before <span class="strong"><strong>Camel 2.16</strong></span>, the
        directoryName&nbsp;<span class="strong"><strong>must</strong></span> exist
        already as this component does not support the&nbsp;<code class="literal">autoCreate</code> option
        (which the file component does). The reason is that its the FTP
        administrator (FTP server) task to properly setup user accounts, and
        home directories with the right file permissions etc.</p>
    <p>For <span class="strong"><strong>Camel 2.16</strong></span>,&nbsp;<code class="literal">autoCreate</code>
        option is supported. When consumer
        starts, before polling is scheduled, there&#8217;s additional FTP operation
        performed to create the directory configured for endpoint. The default
        value for <code class="literal">autoCreate</code> is&nbsp;<code class="literal">true</code>.</p>
    <p>If no <span class="strong"><strong>username</strong></span> is provided, then <code
            class="literal">anonymous</code> login is attempted using
        no password.
        If no <span class="strong"><strong>port</strong></span> number is provided, Camel will provide default
        values
        according to the protocol (ftp = 21, sftp = 22, ftps = 2222).</p>
    <p>You can append query options to the URI in the following format,
        <code class="literal">?option=value&amp;option=value&amp;&#8230;&#8203;</code>
    </p>
    <p>This component uses two different libraries for the actual FTP work. FTP
        and FTPS uses <a class="link" href="http://commons.apache.org/net/" target="_top">Apache Commons Net</a>
        while
        SFTP uses <a class="link" href="http://www.jcraft.com/jsch/" target="_top">JCraft JSCH</a>.</p>
    <p>The FTPS component is only available in Camel 2.2 or newer.
        FTPS (also known as FTP Secure) is an extension to FTP that adds
        support for the Transport Layer Security (TLS) and the Secure Sockets
        Layer (SSL) cryptographic protocols.</p>
</div>
<div class="section">
    <div class="titlepage">
        <div>
            <div>
                <h2 class="title" style="clear: both"><a name="_uri_options_25"></a>URI Options</h2>
            </div>
        </div>
    </div>
    <div class="toc">
        <p><b>Table of Contents</b></p>
        <dl>
            <dt><span class="section"><a href="ftp-component.html#_path_parameters_3_parameters_3">Path
                        Parameters (3 parameters):</a></span></dt>
            <dt><span class="section"><a href="ftp-component.html#_query_parameters_108_parameters">Query
                        Parameters (108 parameters):</a></span></dt>
        </dl>
    </div>
    <p>The options below are exclusive for the FTP component.</p>
    <p>The FTP component has no options.</p>
    <p>The FTP endpoint is configured using URI syntax:</p>
    <pre class="screen">ftp:host:port/directoryName</pre>
    <p>with the following path and query parameters:</p>
    <div class="section">
        <div class="titlepage">
            <div>
                <div>
                    <h3 class="title"><a name="_path_parameters_3_parameters_3"></a>Path Parameters (3
                        parameters):</h3>
                </div>
            </div>
        </div>
        <div class="informaltable">
            <table border="1" width="100%">
                <colgroup>
                    <col width="19%" class="col_1">
                    <col width="51%" class="col_2">
                    <col width="10%" class="col_3">
                    <col width="20%" class="col_4">
                </colgroup>
                <thead>
                    <tr>
                        <th align="left" valign="top">Name</th>
                        <th align="left" valign="top">Description</th>
                        <th align="center" valign="top">Default</th>
                        <th align="left" valign="top">Type</th>
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <td align="left" valign="top">
                            <p><span class="strong"><strong>host</strong></span></p>
                        </td>
                        <td align="left" valign="top">
                            <p><span class="strong"><strong>Required</strong></span> Hostname of the FTP server
                            </p>
                        </td>
                        <td align="center" valign="top">&nbsp;</td>
                        <td align="left" valign="top">
                            <p>String</p>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" valign="top">
                            <p><span class="strong"><strong>port</strong></span></p>
                        </td>
                        <td align="left" valign="top">
                            <p>Port of the FTP server</p>
                        </td>
                        <td align="center" valign="top">&nbsp;</td>
                        <td align="left" valign="top">
                            <p>int</p>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" valign="top">
                            <p><span class="strong"><strong>directoryName</strong></span></p>
                        </td>
                        <td align="left" valign="top">
                            <p>The starting directory</p>
                        </td>
                        <td align="center" valign="top">&nbsp;</td>
                        <td align="left" valign="top">
                            <p>String</p>
                        </td>
                    </tr>
                </tbody>
            </table>
        </div>
    </div>
    <div class="section">
        <div class="titlepage">
            <div>
                <div>
                    <h3 class="title"><a name="_query_parameters_108_parameters"></a>Query Parameters (108
                        parameters):</h3>
                </div>
            </div>
        </div>
        <div class="informaltable">
            <table border="1" width="100%">
                <colgroup>
                    <col width="19%" class="col_1">
                    <col width="51%" class="col_2">
                    <col width="10%" class="col_3">
                    <col width="20%" class="col_4">
                </colgroup>
                <thead>
                    <tr>
                        <th align="left" valign="top">Name</th>
                        <th align="left" valign="top">Description</th>
                        <th align="center" valign="top">Default</th>
                        <th align="left" valign="top">Type</th>
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <td align="left" valign="top">
                            <p><span class="strong"><strong>binary</strong></span> (common)</p>
                        </td>
                        <td align="left" valign="top">
                            <p>Specifies the file transfer mode, BINARY or ASCII. Default is ASCII (false).</p>
                        </td>
                        <td align="center" valign="top">
                            <p>false</p>
                        </td>
                        <td align="left" valign="top">
                            <p>boolean</p>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" valign="top">
                            <p><span class="strong"><strong>charset</strong></span> (common)</p>
                        </td>
                        <td align="left" valign="top">
                            <p>This option is used to specify the encoding of the file. You can use this on the
                                consumer, to specify the encodings of the files, which allow Camel to know the
                                charset it should load the file content in case the file content is being
                                accessed. Likewise when writing a file, you can use this option to specify which
                                charset to write the file as well. Do mind that when writing the file Camel may
                                have to read the message content into memory to be able to convert the data into
                                the configured charset, so do not use this if you have big messages.</p>
                        </td>
                        <td align="center" valign="top">&nbsp;</td>
                        <td align="left" valign="top">
                            <p>String</p>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" valign="top">
                            <p><span class="strong"><strong>disconnect</strong></span> (common)</p>
                        </td>
                        <td align="left" valign="top">
                            <p>Whether or not to disconnect from remote FTP server right after use. Disconnect
                                will only disconnect the current connection to the FTP server. If you have a
                                consumer which you want to stop, then you need to stop the consumer/route
                                instead.</p>
                        </td>
                        <td align="center" valign="top">
                            <p>false</p>
                        </td>
                        <td align="left" valign="top">
                            <p>boolean</p>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" valign="top">
                            <p><span class="strong"><strong>doneFileName</strong></span> (common)</p>
                        </td>
                        <td align="left" valign="top">
                            <p>Producer: If provided, then Camel will write a 2nd done file when the original
                                file has been written. The done file will be empty. This option configures what
                                file name to use. Either you can specify a fixed name. Or you can use dynamic
                                placeholders. The done file will always be written in the same folder as the
                                original file. Consumer: If provided, Camel will only consume files if a done
                                file exists. This option configures what file name to use. Either you can
                                specify a fixed name. Or you can use dynamic placeholders.The done file is
                                always expected in the same folder as the original file. Only $file.name and
                                $file.name.noext is supported as dynamic placeholders.</p>
                        </td>
                        <td align="center" valign="top">&nbsp;</td>
                        <td align="left" valign="top">
                            <p>String</p>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" valign="top">
                            <p><span class="strong"><strong>fileName</strong></span> (common)</p>
                        </td>
                        <td align="left" valign="top">
                            <p>Use Expression such as File Language to dynamically set the filename. For
                                consumers, it&#8217;s used as a filename filter. For producers, it&#8217;s used
                                to evaluate the filename to write. If an expression is set, it take precedence
                                over the CamelFileName header. (Note: The header itself can also be an
                                Expression). The expression options support both String and Expression types. If
                                the expression is a String type, it is always evaluated using the File Language.
                                If the expression is an Expression type, the specified Expression type is used -
                                this allows you, for instance, to use OGNL expressions. For the consumer, you
                                can use it to filter filenames, so you can for instance consume today&#8217;s
                                file using the File Language syntax: mydata-$date:now:yyyyMMdd.txt. The
                                producers support the CamelOverruleFileName header which takes precedence over
                                any existing CamelFileName header; the CamelOverruleFileName is a header that is
                                used only once, and makes it easier as this avoids to temporary store
                                CamelFileName and have to restore it afterwards.</p>
                        </td>
                        <td align="center" valign="top">&nbsp;</td>
                        <td align="left" valign="top">
                            <p>String</p>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" valign="top">
                            <p><span class="strong"><strong>passiveMode</strong></span> (common)</p>
                        </td>
                        <td align="left" valign="top">
                            <p>Sets passive mode connections. Default is active mode connections.</p>
                        </td>
                        <td align="center" valign="top">
                            <p>false</p>
                        </td>
                        <td align="left" valign="top">
                            <p>boolean</p>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" valign="top">
                            <p><span class="strong"><strong>separator</strong></span> (common)</p>
                        </td>
                        <td align="left" valign="top">
                            <p>Sets the path separator to be used. UNIX = Uses unix style path separator Windows
                                = Uses windows style path separator Auto = (is default) Use existing path
                                separator in file name</p>
                        </td>
                        <td align="center" valign="top">
                            <p>UNIX</p>
                        </td>
                        <td align="left" valign="top">
                            <p>PathSeparator</p>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" valign="top">
                            <p><span class="strong"><strong>transferLoggingInterval Seconds</strong></span>
                                (common)</p>
                        </td>
                        <td align="left" valign="top">
                            <p>Configures the interval in seconds to use when logging the progress of upload and
                                download operations that are in-flight. This is used for logging progress when
                                operations takes longer time.</p>
                        </td>
                        <td align="center" valign="top">
                            <p>5</p>
                        </td>
                        <td align="left" valign="top">
                            <p>int</p>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" valign="top">
                            <p><span class="strong"><strong>transferLoggingLevel</strong></span> (common)</p>
                        </td>
                        <td align="left" valign="top">
                            <p>Configure the logging level to use when logging the progress of upload and
                                download operations.</p>
                        </td>
                        <td align="center" valign="top">
                            <p>DEBUG</p>
                        </td>
                        <td align="left" valign="top">
                            <p>LoggingLevel</p>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" valign="top">
                            <p><span class="strong"><strong>transferLoggingVerbose</strong></span> (common)</p>
                        </td>
                        <td align="left" valign="top">
                            <p>Configures whether the perform verbose (fine grained) logging of the progress of
                                upload and download operations.</p>
                        </td>
                        <td align="center" valign="top">
                            <p>false</p>
                        </td>
                        <td align="left" valign="top">
                            <p>boolean</p>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" valign="top">
                            <p><span class="strong"><strong>fastExistsCheck</strong></span> (common)</p>
                        </td>
                        <td align="left" valign="top">
                            <p>If set this option to be true, camel-ftp will use the list file directly to check
                                if the file exists. Since some FTP server may not support to list the file
                                directly, if the option is false, camel-ftp will use the old way to list the
                                directory and check if the file exists. This option also influences
                                readLock=changed to control whether it performs a fast check to update file
                                information or not. This can be used to speed up the process if the FTP server
                                has a lot of files.</p>
                        </td>
                        <td align="center" valign="top">
                            <p>false</p>
                        </td>
                        <td align="left" valign="top">
                            <p>boolean</p>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" valign="top">
                            <p><span class="strong"><strong>bridgeErrorHandler</strong></span> (consumer)</p>
                        </td>
                        <td align="left" valign="top">
                            <p>Allows for bridging the consumer to the Camel routing Error Handler, which mean
                                any exceptions occurred while the consumer is trying to pickup incoming
                                messages, or the likes, will now be processed as a message and handled by the
                                routing Error Handler. By default the consumer will use the
                                org.apache.camel.spi.ExceptionHandler to deal with exceptions, that will be
                                logged at WARN or ERROR level and ignored.</p>
                        </td>
                        <td align="center" valign="top">
                            <p>false</p>
                        </td>
                        <td align="left" valign="top">
                            <p>boolean</p>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" valign="top">
                            <p><span class="strong"><strong>delete</strong></span> (consumer)</p>
                        </td>
                        <td align="left" valign="top">
                            <p>If true, the file will be deleted after it is processed successfully.</p>
                        </td>
                        <td align="center" valign="top">
                            <p>false</p>
                        </td>
                        <td align="left" valign="top">
                            <p>boolean</p>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" valign="top">
                            <p><span class="strong"><strong>moveFailed</strong></span> (consumer)</p>
                        </td>
                        <td align="left" valign="top">
                            <p>Sets the move failure expression based on Simple language. For example, to move
                                files into a .error subdirectory use: .error. Note: When moving the files to the
                                fail location Camel will handle the error and will not pick up the file again.
                            </p>
                        </td>
                        <td align="center" valign="top">&nbsp;</td>
                        <td align="left" valign="top">
                            <p>String</p>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" valign="top">
                            <p><span class="strong"><strong>noop</strong></span> (consumer)</p>
                        </td>
                        <td align="left" valign="top">
                            <p>If true, the file is not moved or deleted in any way. This option is good for
                                readonly data, or for ETL type requirements. If noop=true, Camel will set
                                idempotent=true as well, to avoid consuming the same files over and over again.
                            </p>
                        </td>
                        <td align="center" valign="top">
                            <p>false</p>
                        </td>
                        <td align="left" valign="top">
                            <p>boolean</p>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" valign="top">
                            <p><span class="strong"><strong>preMove</strong></span> (consumer)</p>
                        </td>
                        <td align="left" valign="top">
                            <p>Expression (such as File Language) used to dynamically set the filename when
                                moving it before processing. For example to move in-progress files into the
                                order directory set this value to order.</p>
                        </td>
                        <td align="center" valign="top">&nbsp;</td>
                        <td align="left" valign="top">
                            <p>String</p>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" valign="top">
                            <p><span class="strong"><strong>preSort</strong></span> (consumer)</p>
                        </td>
                        <td align="left" valign="top">
                            <p>When pre-sort is enabled then the consumer will sort the file and directory names
                                during polling, that was retrieved from the file system. You may want to do this
                                in case you need to operate on the files in a sorted order. The pre-sort is
                                executed before the consumer starts to filter, and accept files to process by
                                Camel. This option is default=false meaning disabled.</p>
                        </td>
                        <td align="center" valign="top">
                            <p>false</p>
                        </td>
                        <td align="left" valign="top">
                            <p>boolean</p>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" valign="top">
                            <p><span class="strong"><strong>recursive</strong></span> (consumer)</p>
                        </td>
                        <td align="left" valign="top">
                            <p>If a directory, will look for files in all the sub-directories as well.</p>
                        </td>
                        <td align="center" valign="top">
                            <p>false</p>
                        </td>
                        <td align="left" valign="top">
                            <p>boolean</p>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" valign="top">
                            <p><span class="strong"><strong>resumeDownload</strong></span> (consumer)</p>
                        </td>
                        <td align="left" valign="top">
                            <p>Configures whether resume download is enabled. This must be supported by the FTP
                                server (almost all FTP servers support it). In addition the options
                                localWorkDirectory must be configured so downloaded files are stored in a local
                                directory, and the option binary must be enabled, which is required to support
                                resuming of downloads.</p>
                        </td>
                        <td align="center" valign="top">
                            <p>false</p>
                        </td>
                        <td align="left" valign="top">
                            <p>boolean</p>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" valign="top">
                            <p><span class="strong"><strong>sendEmptyMessageWhenIdle</strong></span> (consumer)
                            </p>
                        </td>
                        <td align="left" valign="top">
                            <p>If the polling consumer did not poll any files, you can enable this option to
                                send an empty message (no body) instead.</p>
                        </td>
                        <td align="center" valign="top">
                            <p>false</p>
                        </td>
                        <td align="left" valign="top">
                            <p>boolean</p>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" valign="top">
                            <p><span class="strong"><strong>streamDownload</strong></span> (consumer)</p>
                        </td>
                        <td align="left" valign="top">
                            <p>Sets the download method to use when not using a local working directory. If set
                                to true, the remote files are streamed to the route as they are read. When set
                                to false, the remote files are loaded into memory before being sent into the
                                route.</p>
                        </td>
                        <td align="center" valign="top">
                            <p>false</p>
                        </td>
                        <td align="left" valign="top">
                            <p>boolean</p>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" valign="top">
                            <p><span class="strong"><strong>directoryMustExist</strong></span> (consumer)</p>
                        </td>
                        <td align="left" valign="top">
                            <p>Similar to startingDirectoryMustExist but this applies during polling recursive
                                sub directories.</p>
                        </td>
                        <td align="center" valign="top">
                            <p>false</p>
                        </td>
                        <td align="left" valign="top">
                            <p>boolean</p>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" valign="top">
                            <p><span class="strong"><strong>download</strong></span> (consumer)</p>
                        </td>
                        <td align="left" valign="top">
                            <p>Whether the FTP consumer should download the file. If this option is set to
                                false, then the message body will be null, but the consumer will still trigger a
                                Camel Exchange that has details about the file such as file name, file size,
                                etc. It&#8217;s just that the file will not be downloaded.</p>
                        </td>
                        <td align="center" valign="top">
                            <p>false</p>
                        </td>
                        <td align="left" valign="top">
                            <p>boolean</p>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" valign="top">
                            <p><span class="strong"><strong>exceptionHandler</strong></span> (consumer)</p>
                        </td>
                        <td align="left" valign="top">
                            <p>To let the consumer use a custom ExceptionHandler. Notice if the option
                                bridgeErrorHandler is enabled then this options is not in use. By default the
                                consumer will deal with exceptions, that will be logged at WARN or ERROR level
                                and ignored.</p>
                        </td>
                        <td align="center" valign="top">&nbsp;</td>
                        <td align="left" valign="top">
                            <p>ExceptionHandler</p>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" valign="top">
                            <p><span class="strong"><strong>exchangePattern</strong></span> (consumer)</p>
                        </td>
                        <td align="left" valign="top">
                            <p>Sets the exchange pattern when the consumer creates an exchange.</p>
                        </td>
                        <td align="center" valign="top">&nbsp;</td>
                        <td align="left" valign="top">
                            <p>ExchangePattern</p>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" valign="top">
                            <p><span class="strong"><strong>handleDirectoryParser AbsoluteResult</strong></span>
                                (consumer)</p>
                        </td>
                        <td align="left" valign="top">
                            <p>Allows you to set how the consumer will handle subfolders and files in the path
                                if the directory parser results in with absolute paths The reason for this is
                                that some FTP servers may return file names with absolute paths, and if so then
                                the FTP component needs to handle this by converting the returned path into a
                                relative path.</p>
                        </td>
                        <td align="center" valign="top">
                            <p>false</p>
                        </td>
                        <td align="left" valign="top">
                            <p>boolean</p>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" valign="top">
                            <p><span class="strong"><strong>ignoreFileNotFoundOr PermissionError</strong></span>
                                (consumer)</p>
                        </td>
                        <td align="left" valign="top">
                            <p>Whether to ignore when (trying to list files in directories or when downloading a
                                file), which does not exist or due to permission error. By default when a
                                directory or file does not exists or insufficient permission, then an exception
                                is thrown. Setting this option to true allows to ignore that instead.</p>
                        </td>
                        <td align="center" valign="top">
                            <p>false</p>
                        </td>
                        <td align="left" valign="top">
                            <p>boolean</p>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" valign="top">
                            <p><span class="strong"><strong>inProgressRepository</strong></span> (consumer)</p>
                        </td>
                        <td align="left" valign="top">
                            <p>A pluggable in-progress repository org.apache.camel.spi.IdempotentRepository. The
                                in-progress repository is used to account the current in progress files being
                                consumed. By default a memory based repository is used.</p>
                        </td>
                        <td align="center" valign="top">&nbsp;</td>
                        <td align="left" valign="top">
                            <p>String&gt;</p>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" valign="top">
                            <p><span class="strong"><strong>localWorkDirectory</strong></span> (consumer)</p>
                        </td>
                        <td align="left" valign="top">
                            <p>When consuming, a local work directory can be used to store the remote file
                                content directly in local files, to avoid loading the content into memory. This
                                is beneficial, if you consume a very big remote file and thus can conserve
                                memory.</p>
                        </td>
                        <td align="center" valign="top">&nbsp;</td>
                        <td align="left" valign="top">
                            <p>String</p>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" valign="top">
                            <p><span class="strong"><strong>onCompletionException Handler</strong></span>
                                (consumer)</p>
                        </td>
                        <td align="left" valign="top">
                            <p>To use a custom org.apache.camel.spi.ExceptionHandler to handle any thrown
                                exceptions that happens during the file on completion process where the consumer
                                does either a commit or rollback. The default implementation will log any
                                exception at WARN level and ignore.</p>
                        </td>
                        <td align="center" valign="top">&nbsp;</td>
                        <td align="left" valign="top">
                            <p>ExceptionHandler</p>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" valign="top">
                            <p><span class="strong"><strong>pollStrategy</strong></span> (consumer)</p>
                        </td>
                        <td align="left" valign="top">
                            <p>A pluggable org.apache.camel.PollingConsumerPollingStrategy allowing you to
                                provide your custom implementation to control error handling usually occurred
                                during the poll operation before an Exchange have been created and being routed
                                in Camel.</p>
                        </td>
                        <td align="center" valign="top">&nbsp;</td>
                        <td align="left" valign="top">
                            <p>PollingConsumerPoll Strategy</p>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" valign="top">
                            <p><span class="strong"><strong>processStrategy</strong></span> (consumer)</p>
                        </td>
                        <td align="left" valign="top">
                            <p>A pluggable org.apache.camel.component.file.GenericFileProcessStrategy allowing
                                you to implement your own readLock option or similar. Can also be used when
                                special conditions must be met before a file can be consumed, such as a special
                                ready file exists. If this option is set then the readLock option does not
                                apply.</p>
                        </td>
                        <td align="center" valign="top">&nbsp;</td>
                        <td align="left" valign="top">
                            <p>GenericFileProcess Strategy&lt;T&gt;</p>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" valign="top">
                            <p><span class="strong"><strong>receiveBufferSize</strong></span> (consumer)</p>
                        </td>
                        <td align="left" valign="top">
                            <p>The receive (download) buffer size Used only by FTPClient</p>
                        </td>
                        <td align="center" valign="top">
                            <p>32768</p>
                        </td>
                        <td align="left" valign="top">
                            <p>int</p>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" valign="top">
                            <p><span class="strong"><strong>startingDirectoryMustExist</strong></span>
                                (consumer)</p>
                        </td>
                        <td align="left" valign="top">
                            <p>Whether the starting directory must exist. Mind that the autoCreate option is
                                default enabled, which means the starting directory is normally auto created if
                                it doesn&#8217;t exist. You can disable autoCreate and enable this to ensure the
                                starting directory must exist. Will thrown an exception if the directory
                                doesn&#8217;t exist.</p>
                        </td>
                        <td align="center" valign="top">
                            <p>false</p>
                        </td>
                        <td align="left" valign="top">
                            <p>boolean</p>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" valign="top">
                            <p><span class="strong"><strong>useList</strong></span> (consumer)</p>
                        </td>
                        <td align="left" valign="top">
                            <p>Whether to allow using LIST command when downloading a file. Default is true. In
                                some use cases you may want to download a specific file and are not allowed to
                                use the LIST command, and therefore you can set this option to false. Notice
                                when using this option, then the specific file to download does not include
                                meta-data information such as file size, timestamp, permissions etc, because
                                those information is only possible to retrieve when LIST command is in use.</p>
                        </td>
                        <td align="center" valign="top">
                            <p>true</p>
                        </td>
                        <td align="left" valign="top">
                            <p>boolean</p>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" valign="top">
                            <p><span class="strong"><strong>fileExist</strong></span> (producer)</p>
                        </td>
                        <td align="left" valign="top">
                            <p>What to do if a file already exists with the same name. Override, which is the
                                default, replaces the existing file. Append - adds content to the existing file.
                                Fail - throws a GenericFileOperationException, indicating that there is already
                                an existing file. Ignore - silently ignores the problem and does not override
                                the existing file, but assumes everything is okay. Move - option requires to use
                                the moveExisting option to be configured as well. The option
                                eagerDeleteTargetFile can be used to control what to do if an moving the file,
                                and there exists already an existing file, otherwise causing the move operation
                                to fail. The Move option will move any existing files, before writing the target
                                file. TryRename is only applicable if tempFileName option is in use. This allows
                                to try renaming the file from the temporary name to the actual name, without
                                doing any exists check. This check may be faster on some file systems and
                                especially FTP servers.</p>
                        </td>
                        <td align="center" valign="top">
                            <p>Override</p>
                        </td>
                        <td align="left" valign="top">
                            <p>GenericFileExist</p>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" valign="top">
                            <p><span class="strong"><strong>flatten</strong></span> (producer)</p>
                        </td>
                        <td align="left" valign="top">
                            <p>Flatten is used to flatten the file name path to strip any leading paths, so
                                it&#8217;s just the file name. This allows you to consume recursively into
                                sub-directories, but when you eg write the files to another directory they will
                                be written in a single directory. Setting this to true on the producer enforces
                                that any file name in CamelFileName header will be stripped for any leading
                                paths.</p>
                        </td>
                        <td align="center" valign="top">
                            <p>false</p>
                        </td>
                        <td align="left" valign="top">
                            <p>boolean</p>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" valign="top">
                            <p><span class="strong"><strong>moveExisting</strong></span> (producer)</p>
                        </td>
                        <td align="left" valign="top">
                            <p>Expression (such as File Language) used to compute file name to use when
                                fileExist=Move is configured. To move files into a backup subdirectory just
                                enter backup. This option only supports the following File Language tokens:
                                file:name, file:name.ext, file:name.noext, file:onlyname, file:onlyname.noext,
                                file:ext, and file:parent. Notice the file:parent is not supported by the FTP
                                component, as the FTP component can only move any existing files to a relative
                                directory based on current dir as base.</p>
                        </td>
                        <td align="center" valign="top">&nbsp;</td>
                        <td align="left" valign="top">
                            <p>String</p>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" valign="top">
                            <p><span class="strong"><strong>tempFileName</strong></span> (producer)</p>
                        </td>
                        <td align="left" valign="top">
                            <p>The same as tempPrefix option but offering a more fine grained control on the
                                naming of the temporary filename as it uses the File Language.</p>
                        </td>
                        <td align="center" valign="top">&nbsp;</td>
                        <td align="left" valign="top">
                            <p>String</p>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" valign="top">
                            <p><span class="strong"><strong>tempPrefix</strong></span> (producer)</p>
                        </td>
                        <td align="left" valign="top">
                            <p>This option is used to write the file using a temporary name and then, after the
                                write is complete, rename it to the real name. Can be used to identify files
                                being written and also avoid consumers (not using exclusive read locks) reading
                                in progress files. Is often used by FTP when uploading big files.</p>
                        </td>
                        <td align="center" valign="top">&nbsp;</td>
                        <td align="left" valign="top">
                            <p>String</p>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" valign="top">
                            <p><span class="strong"><strong>allowNullBody</strong></span> (producer)</p>
                        </td>
                        <td align="left" valign="top">
                            <p>Used to specify if a null body is allowed during file writing. If set to true
                                then an empty file will be created, when set to false, and attempting to send a
                                null body to the file component, a GenericFileWriteException of 'Cannot write
                                null body to file.' will be thrown. If the fileExist option is set to
                                'Override', then the file will be truncated, and if set to append the file will
                                remain unchanged.</p>
                        </td>
                        <td align="center" valign="top">
                            <p>false</p>
                        </td>
                        <td align="left" valign="top">
                            <p>boolean</p>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" valign="top">
                            <p><span class="strong"><strong>chmod</strong></span> (producer)</p>
                        </td>
                        <td align="left" valign="top">
                            <p>Allows you to set chmod on the stored file. For example chmod=640.</p>
                        </td>
                        <td align="center" valign="top">&nbsp;</td>
                        <td align="left" valign="top">
                            <p>String</p>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" valign="top">
                            <p><span class="strong"><strong>disconnectOnBatchComplete</strong></span> (producer)
                            </p>
                        </td>
                        <td align="left" valign="top">
                            <p>Whether or not to disconnect from remote FTP server right after a Batch upload is
                                complete. disconnectOnBatchComplete will only disconnect the current connection
                                to the FTP server.</p>
                        </td>
                        <td align="center" valign="top">
                            <p>false</p>
                        </td>
                        <td align="left" valign="top">
                            <p>boolean</p>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" valign="top">
                            <p><span class="strong"><strong>eagerDeleteTargetFile</strong></span> (producer)</p>
                        </td>
                        <td align="left" valign="top">
                            <p>Whether or not to eagerly delete any existing target file. This option only
                                applies when you use fileExists=Override and the tempFileName option as well.
                                You can use this to disable (set it to false) deleting the target file before
                                the temp file is written. For example you may write big files and want the
                                target file to exists during the temp file is being written. This ensure the
                                target file is only deleted until the very last moment, just before the temp
                                file is being renamed to the target filename. This option is also used to
                                control whether to delete any existing files when fileExist=Move is enabled, and
                                an existing file exists. If this option copyAndDeleteOnRenameFails false, then
                                an exception will be thrown if an existing file existed, if its true, then the
                                existing file is deleted before the move operation.</p>
                        </td>
                        <td align="center" valign="top">
                            <p>true</p>
                        </td>
                        <td align="left" valign="top">
                            <p>boolean</p>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" valign="top">
                            <p><span class="strong"><strong>keepLastModified</strong></span> (producer)</p>
                        </td>
                        <td align="left" valign="top">
                            <p>Will keep the last modified timestamp from the source file (if any). Will use the
                                Exchange.FILE_LAST_MODIFIED header to located the timestamp. This header can
                                contain either a java.util.Date or long with the timestamp. If the timestamp
                                exists and the option is enabled it will set this timestamp on the written file.
                                Note: This option only applies to the file producer. You cannot use this option
                                with any of the ftp producers.</p>
                        </td>
                        <td align="center" valign="top">
                            <p>false</p>
                        </td>
                        <td align="left" valign="top">
                            <p>boolean</p>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" valign="top">
                            <p><span class="strong"><strong>sendNoop</strong></span> (producer)</p>
                        </td>
                        <td align="left" valign="top">
                            <p>Whether to send a noop command as a pre-write check before uploading files to the
                                FTP server. This is enabled by default as a validation of the connection is
                                still valid, which allows to silently re-connect to be able to upload the file.
                                However if this causes problems, you can turn this option off.</p>
                        </td>
                        <td align="center" valign="top">
                            <p>true</p>
                        </td>
                        <td align="left" valign="top">
                            <p>boolean</p>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" valign="top">
                            <p><span class="strong"><strong>activePortRange</strong></span> (advanced)</p>
                        </td>
                        <td align="left" valign="top">
                            <p>Set the client side port range in active mode. The syntax is: minPort-maxPort
                                Both port numbers are inclusive, eg 10000-19999 to include all 1xxxx ports.</p>
                        </td>
                        <td align="center" valign="top">&nbsp;</td>
                        <td align="left" valign="top">
                            <p>String</p>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" valign="top">
                            <p><span class="strong"><strong>autoCreate</strong></span> (advanced)</p>
                        </td>
                        <td align="left" valign="top">
                            <p>Automatically create missing directories in the file&#8217;s pathname. For the
                                file consumer, that means creating the starting directory. For the file
                                producer, it means the directory the files should be written to.</p>
                        </td>
                        <td align="center" valign="top">
                            <p>true</p>
                        </td>
                        <td align="left" valign="top">
                            <p>boolean</p>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" valign="top">
                            <p><span class="strong"><strong>bufferSize</strong></span> (advanced)</p>
                        </td>
                        <td align="left" valign="top">
                            <p>Write buffer sized in bytes.</p>
                        </td>
                        <td align="center" valign="top">
                            <p>131072</p>
                        </td>
                        <td align="left" valign="top">
                            <p>int</p>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" valign="top">
                            <p><span class="strong"><strong>connectTimeout</strong></span> (advanced)</p>
                        </td>
                        <td align="left" valign="top">
                            <p>Sets the connect timeout for waiting for a connection to be established Used by
                                both FTPClient and JSCH</p>
                        </td>
                        <td align="center" valign="top">
                            <p>10000</p>
                        </td>
                        <td align="left" valign="top">
                            <p>int</p>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" valign="top">
                            <p><span class="strong"><strong>ftpClient</strong></span> (advanced)</p>
                        </td>
                        <td align="left" valign="top">
                            <p>To use a custom instance of FTPClient</p>
                        </td>
                        <td align="center" valign="top">&nbsp;</td>
                        <td align="left" valign="top">
                            <p>FTPClient</p>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" valign="top">
                            <p><span class="strong"><strong>ftpClientConfig</strong></span> (advanced)</p>
                        </td>
                        <td align="left" valign="top">
                            <p>To use a custom instance of FTPClientConfig to configure the FTP client the
                                endpoint should use.</p>
                        </td>
                        <td align="center" valign="top">&nbsp;</td>
                        <td align="left" valign="top">
                            <p>FTPClientConfig</p>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" valign="top">
                            <p><span class="strong"><strong>ftpClientConfigParameters</strong></span> (advanced)
                            </p>
                        </td>
                        <td align="left" valign="top">
                            <p>Used by FtpComponent to provide additional parameters for the FTPClientConfig</p>
                        </td>
                        <td align="center" valign="top">&nbsp;</td>
                        <td align="left" valign="top">
                            <p>Map</p>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" valign="top">
                            <p><span class="strong"><strong>ftpClientParameters</strong></span> (advanced)</p>
                        </td>
                        <td align="left" valign="top">
                            <p>Used by FtpComponent to provide additional parameters for the FTPClient</p>
                        </td>
                        <td align="center" valign="top">&nbsp;</td>
                        <td align="left" valign="top">
                            <p>Map</p>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" valign="top">
                            <p><span class="strong"><strong>maximumReconnectAttempts</strong></span> (advanced)
                            </p>
                        </td>
                        <td align="left" valign="top">
                            <p>Specifies the maximum reconnect attempts Camel performs when it tries to connect
                                to the remote FTP server. Use 0 to disable this behavior.</p>
                        </td>
                        <td align="center" valign="top">&nbsp;</td>
                        <td align="left" valign="top">
                            <p>int</p>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" valign="top">
                            <p><span class="strong"><strong>reconnectDelay</strong></span> (advanced)</p>
                        </td>
                        <td align="left" valign="top">
                            <p>Delay in millis Camel will wait before performing a reconnect attempt.</p>
                        </td>
                        <td align="center" valign="top">&nbsp;</td>
                        <td align="left" valign="top">
                            <p>long</p>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" valign="top">
                            <p><span class="strong"><strong>siteCommand</strong></span> (advanced)</p>
                        </td>
                        <td align="left" valign="top">
                            <p>Sets optional site command(s) to be executed after successful login. Multiple
                                site commands can be separated using a new line character.</p>
                        </td>
                        <td align="center" valign="top">&nbsp;</td>
                        <td align="left" valign="top">
                            <p>String</p>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" valign="top">
                            <p><span class="strong"><strong>soTimeout</strong></span> (advanced)</p>
                        </td>
                        <td align="left" valign="top">
                            <p>Sets the so timeout FTP and FTPS Only for Camel 2.4. SFTP for Camel
                                2.14.3/2.15.3/2.16 onwards. Is the SocketOptions.SO_TIMEOUT value in millis.
                                Recommended option is to set this to 300000 so as not have a hanged connection.
                                On SFTP this option is set as timeout on the JSCH Session instance.</p>
                        </td>
                        <td align="center" valign="top">
                            <p>300000</p>
                        </td>
                        <td align="left" valign="top">
                            <p>int</p>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" valign="top">
                            <p><span class="strong"><strong>stepwise</strong></span> (advanced)</p>
                        </td>
                        <td align="left" valign="top">
                            <p>Sets whether we should stepwise change directories while traversing file
                                structures when downloading files, or as well when uploading a file to a
                                directory. You can disable this if you for example are in a situation where you
                                cannot change directory on the FTP server due security reasons.</p>
                        </td>
                        <td align="center" valign="top">
                            <p>true</p>
                        </td>
                        <td align="left" valign="top">
                            <p>boolean</p>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" valign="top">
                            <p><span class="strong"><strong>synchronous</strong></span> (advanced)</p>
                        </td>
                        <td align="left" valign="top">
                            <p>Sets whether synchronous processing should be strictly used, or Camel is allowed
                                to use asynchronous processing (if supported).</p>
                        </td>
                        <td align="center" valign="top">
                            <p>false</p>
                        </td>
                        <td align="left" valign="top">
                            <p>boolean</p>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" valign="top">
                            <p><span class="strong"><strong>throwExceptionOnConnect Failed</strong></span>
                                (advanced)</p>
                        </td>
                        <td align="left" valign="top">
                            <p>Should an exception be thrown if connection failed (exhausted) By default
                                exception is not thrown and a WARN is logged. You can use this to enable
                                exception being thrown and handle the thrown exception from the
                                org.apache.camel.spi.PollingConsumerPollStrategy rollback method.</p>
                        </td>
                        <td align="center" valign="top">
                            <p>false</p>
                        </td>
                        <td align="left" valign="top">
                            <p>boolean</p>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" valign="top">
                            <p><span class="strong"><strong>timeout</strong></span> (advanced)</p>
                        </td>
                        <td align="left" valign="top">
                            <p>Sets the data timeout for waiting for reply Used only by FTPClient</p>
                        </td>
                        <td align="center" valign="top">
                            <p>30000</p>
                        </td>
                        <td align="left" valign="top">
                            <p>int</p>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" valign="top">
                            <p><span class="strong"><strong>antExclude</strong></span> (filter)</p>
                        </td>
                        <td align="left" valign="top">
                            <p>Ant style filter exclusion. If both antInclude and antExclude are used,
                                antExclude takes precedence over antInclude. Multiple exclusions may be
                                specified in comma-delimited format.</p>
                        </td>
                        <td align="center" valign="top">&nbsp;</td>
                        <td align="left" valign="top">
                            <p>String</p>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" valign="top">
                            <p><span class="strong"><strong>antFilterCaseSensitive</strong></span> (filter)</p>
                        </td>
                        <td align="left" valign="top">
                            <p>Sets case sensitive flag on ant filter</p>
                        </td>
                        <td align="center" valign="top">
                            <p>true</p>
                        </td>
                        <td align="left" valign="top">
                            <p>boolean</p>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" valign="top">
                            <p><span class="strong"><strong>antInclude</strong></span> (filter)</p>
                        </td>
                        <td align="left" valign="top">
                            <p>Ant style filter inclusion. Multiple inclusions may be specified in
                                comma-delimited format.</p>
                        </td>
                        <td align="center" valign="top">&nbsp;</td>
                        <td align="left" valign="top">
                            <p>String</p>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" valign="top">
                            <p><span class="strong"><strong>eagerMaxMessagesPerPoll</strong></span> (filter)</p>
                        </td>
                        <td align="left" valign="top">
                            <p>Allows for controlling whether the limit from maxMessagesPerPoll is eager or not.
                                If eager then the limit is during the scanning of files. Where as false would
                                scan all files, and then perform sorting. Setting this option to false allows
                                for sorting all files first, and then limit the poll. Mind that this requires a
                                higher memory usage as all file details are in memory to perform the sorting.
                            </p>
                        </td>
                        <td align="center" valign="top">
                            <p>true</p>
                        </td>
                        <td align="left" valign="top">
                            <p>boolean</p>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" valign="top">
                            <p><span class="strong"><strong>exclude</strong></span> (filter)</p>
                        </td>
                        <td align="left" valign="top">
                            <p>Is used to exclude files, if filename matches the regex pattern (matching is case
                                in-senstive). Notice if you use symbols such as plus sign and others you would
                                need to configure this using the RAW() syntax if configuring this as an endpoint
                                uri. See more details at configuring endpoint uris</p>
                        </td>
                        <td align="center" valign="top">&nbsp;</td>
                        <td align="left" valign="top">
                            <p>String</p>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" valign="top">
                            <p><span class="strong"><strong>filter</strong></span> (filter)</p>
                        </td>
                        <td align="left" valign="top">
                            <p>Pluggable filter as a org.apache.camel.component.file.GenericFileFilter class.
                                Will skip files if filter returns false in its accept() method.</p>
                        </td>
                        <td align="center" valign="top">&nbsp;</td>
                        <td align="left" valign="top">
                            <p>GenericFileFilter&lt;T&gt;</p>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" valign="top">
                            <p><span class="strong"><strong>filterDirectory</strong></span> (filter)</p>
                        </td>
                        <td align="left" valign="top">
                            <p>Filters the directory based on Simple language. For example to filter on current
                                date, you can use a simple date pattern such as $date:now:yyyMMdd</p>
                        </td>
                        <td align="center" valign="top">&nbsp;</td>
                        <td align="left" valign="top">
                            <p>String</p>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" valign="top">
                            <p><span class="strong"><strong>filterFile</strong></span> (filter)</p>
                        </td>
                        <td align="left" valign="top">
                            <p>Filters the file based on Simple language. For example to filter on file size,
                                you can use $file:size 5000</p>
                        </td>
                        <td align="center" valign="top">&nbsp;</td>
                        <td align="left" valign="top">
                            <p>String</p>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" valign="top">
                            <p><span class="strong"><strong>idempotent</strong></span> (filter)</p>
                        </td>
                        <td align="left" valign="top">
                            <p>Option to use the Idempotent Consumer EIP pattern to let Camel skip already
                                processed files. Will by default use a memory based LRUCache that holds 1000
                                entries. If noop=true then idempotent will be enabled as well to avoid consuming
                                the same files over and over again.</p>
                        </td>
                        <td align="center" valign="top">
                            <p>false</p>
                        </td>
                        <td align="left" valign="top">
                            <p>Boolean</p>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" valign="top">
                            <p><span class="strong"><strong>idempotentKey</strong></span> (filter)</p>
                        </td>
                        <td align="left" valign="top">
                            <p>To use a custom idempotent key. By default the absolute path of the file is used.
                                You can use the File Language, for example to use the file name and file size,
                                you can do: idempotentKey=$file:name-$file:size</p>
                        </td>
                        <td align="center" valign="top">&nbsp;</td>
                        <td align="left" valign="top">
                            <p>String</p>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" valign="top">
                            <p><span class="strong"><strong>idempotentRepository</strong></span> (filter)</p>
                        </td>
                        <td align="left" valign="top">
                            <p>A pluggable repository org.apache.camel.spi.IdempotentRepository which by default
                                use MemoryMessageIdRepository if none is specified and idempotent is true.</p>
                        </td>
                        <td align="center" valign="top">&nbsp;</td>
                        <td align="left" valign="top">
                            <p>String&gt;</p>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" valign="top">
                            <p><span class="strong"><strong>include</strong></span> (filter)</p>
                        </td>
                        <td align="left" valign="top">
                            <p>Is used to include files, if filename matches the regex pattern (matching is case
                                in-sensitive). Notice if you use symbols such as plus sign and others you would
                                need to configure this using the RAW() syntax if configuring this as an endpoint
                                uri. See more details at configuring endpoint uris</p>
                        </td>
                        <td align="center" valign="top">&nbsp;</td>
                        <td align="left" valign="top">
                            <p>String</p>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" valign="top">
                            <p><span class="strong"><strong>maxDepth</strong></span> (filter)</p>
                        </td>
                        <td align="left" valign="top">
                            <p>The maximum depth to traverse when recursively processing a directory.</p>
                        </td>
                        <td align="center" valign="top">
                            <p>2147483647</p>
                        </td>
                        <td align="left" valign="top">
                            <p>int</p>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" valign="top">
                            <p><span class="strong"><strong>maxMessagesPerPoll</strong></span> (filter)</p>
                        </td>
                        <td align="left" valign="top">
                            <p>To define a maximum messages to gather per poll. By default no maximum is set.
                                Can be used to set a limit of e.g. 1000 to avoid when starting up the server
                                that there are thousands of files. Set a value of 0 or negative to disabled it.
                                Notice: If this option is in use then the File and FTP components will limit
                                before any sorting. For example if you have 100000 files and use
                                maxMessagesPerPoll=500, then only the first 500 files will be picked up, and
                                then sorted. You can use the eagerMaxMessagesPerPoll option and set this to
                                false to allow to scan all files first and then sort afterwards.</p>
                        </td>
                        <td align="center" valign="top">&nbsp;</td>
                        <td align="left" valign="top">
                            <p>int</p>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" valign="top">
                            <p><span class="strong"><strong>minDepth</strong></span> (filter)</p>
                        </td>
                        <td align="left" valign="top">
                            <p>The minimum depth to start processing when recursively processing a directory.
                                Using minDepth=1 means the base directory. Using minDepth=2 means the first sub
                                directory.</p>
                        </td>
                        <td align="center" valign="top">&nbsp;</td>
                        <td align="left" valign="top">
                            <p>int</p>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" valign="top">
                            <p><span class="strong"><strong>move</strong></span> (filter)</p>
                        </td>
                        <td align="left" valign="top">
                            <p>Expression (such as Simple Language) used to dynamically set the filename when
                                moving it after processing. To move files into a .done subdirectory just enter
                                .done.</p>
                        </td>
                        <td align="center" valign="top">&nbsp;</td>
                        <td align="left" valign="top">
                            <p>String</p>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" valign="top">
                            <p><span class="strong"><strong>exclusiveReadLockStrategy</strong></span> (lock)</p>
                        </td>
                        <td align="left" valign="top">
                            <p>Pluggable read-lock as a
                                org.apache.camel.component.file.GenericFileExclusiveReadLockStrategy
                                implementation.</p>
                        </td>
                        <td align="center" valign="top">&nbsp;</td>
                        <td align="left" valign="top">
                            <p>GenericFileExclusive ReadLockStrategy&lt;T&gt;</p>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" valign="top">
                            <p><span class="strong"><strong>readLock</strong></span> (lock)</p>
                        </td>
                        <td align="left" valign="top">
                            <p>Used by consumer, to only poll the files if it has exclusive read-lock on the
                                file (i.e. the file is not in-progress or being written). Camel will wait until
                                the file lock is granted. This option provides the build in strategies: none -
                                No read lock is in use markerFile - Camel creates a marker file
                                (fileName.camelLock) and then holds a lock on it. This option is not available
                                for the FTP component changed - Changed is using file length/modification
                                timestamp to detect whether the file is currently being copied or not. Will at
                                least use 1 sec to determine this, so this option cannot consume files as fast
                                as the others, but can be more reliable as the JDK IO API cannot always
                                determine whether a file is currently being used by another process. The option
                                readLockCheckInterval can be used to set the check frequency. fileLock - is for
                                using java.nio.channels.FileLock. This option is not avail for the FTP
                                component. This approach should be avoided when accessing a remote file system
                                via a mount/share unless that file system supports distributed file locks.
                                rename - rename is for using a try to rename the file as a test if we can get
                                exclusive read-lock. idempotent - (only for file component) idempotent is for
                                using a idempotentRepository as the read-lock. This allows to use read locks
                                that supports clustering if the idempotent repository implementation supports
                                that. idempotent-changed - (only for file component) idempotent-changed is for
                                using a idempotentRepository and changed as the combined read-lock. This allows
                                to use read locks that supports clustering if the idempotent repository
                                implementation supports that. idempotent-rename - (only for file component)
                                idempotent-rename is for using a idempotentRepository and rename as the combined
                                read-lock. This allows to use read locks that supports clustering if the
                                idempotent repository implementation supports that. Notice: The various read
                                locks is not all suited to work in clustered mode, where concurrent consumers on
                                different nodes is competing for the same files on a shared file system. The
                                markerFile using a close to atomic operation to create the empty marker file,
                                but its not guaranteed to work in a cluster. The fileLock may work better but
                                then the file system need to support distributed file locks, and so on. Using
                                the idempotent read lock can support clustering if the idempotent repository
                                supports clustering, such as Hazelcast Component or Infinispan.</p>
                        </td>
                        <td align="center" valign="top">
                            <p>none</p>
                        </td>
                        <td align="left" valign="top">
                            <p>String</p>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" valign="top">
                            <p><span class="strong"><strong>readLockCheckInterval</strong></span> (lock)</p>
                        </td>
                        <td align="left" valign="top">
                            <p>Interval in millis for the read-lock, if supported by the read lock. This
                                interval is used for sleeping between attempts to acquire the read lock. For
                                example when using the changed read lock, you can set a higher interval period
                                to cater for slow writes. The default of 1 sec. may be too fast if the producer
                                is very slow writing the file. Notice: For FTP the default readLockCheckInterval
                                is 5000. The readLockTimeout value must be higher than readLockCheckInterval,
                                but a rule of thumb is to have a timeout that is at least 2 or more times higher
                                than the readLockCheckInterval. This is needed to ensure that amble time is
                                allowed for the read lock process to try to grab the lock before the timeout was
                                hit.</p>
                        </td>
                        <td align="center" valign="top">
                            <p>1000</p>
                        </td>
                        <td align="left" valign="top">
                            <p>long</p>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" valign="top">
                            <p><span class="strong"><strong>readLockDeleteOrphanLock Files</strong></span>
                                (lock)</p>
                        </td>
                        <td align="left" valign="top">
                            <p>Whether or not read lock with marker files should upon startup delete any orphan
                                read lock files, which may have been left on the file system, if Camel was not
                                properly shutdown (such as a JVM crash). If turning this option to false then
                                any orphaned lock file will cause Camel to not attempt to pickup that file, this
                                could also be due another node is concurrently reading files from the same
                                shared directory.</p>
                        </td>
                        <td align="center" valign="top">
                            <p>true</p>
                        </td>
                        <td align="left" valign="top">
                            <p>boolean</p>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" valign="top">
                            <p><span class="strong"><strong>readLockLoggingLevel</strong></span> (lock)</p>
                        </td>
                        <td align="left" valign="top">
                            <p>Logging level used when a read lock could not be acquired. By default a WARN is
                                logged. You can change this level, for example to OFF to not have any logging.
                                This option is only applicable for readLock of types: changed, fileLock,
                                idempotent, idempotent-changed, idempotent-rename, rename.</p>
                        </td>
                        <td align="center" valign="top">
                            <p>DEBUG</p>
                        </td>
                        <td align="left" valign="top">
                            <p>LoggingLevel</p>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" valign="top">
                            <p><span class="strong"><strong>readLockMarkerFile</strong></span> (lock)</p>
                        </td>
                        <td align="left" valign="top">
                            <p>Whether to use marker file with the changed, rename, or exclusive read lock
                                types. By default a marker file is used as well to guard against other processes
                                picking up the same files. This behavior can be turned off by setting this
                                option to false. For example if you do not want to write marker files to the
                                file systems by the Camel application.</p>
                        </td>
                        <td align="center" valign="top">
                            <p>true</p>
                        </td>
                        <td align="left" valign="top">
                            <p>boolean</p>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" valign="top">
                            <p><span class="strong"><strong>readLockMinAge</strong></span> (lock)</p>
                        </td>
                        <td align="left" valign="top">
                            <p>This option applied only for readLock=change. This option allows to specify a
                                minimum age the file must be before attempting to acquire the read lock. For
                                example use readLockMinAge=300s to require the file is at last 5 minutes old.
                                This can speedup the changed read lock as it will only attempt to acquire files
                                which are at least that given age.</p>
                        </td>
                        <td align="center" valign="top">
                            <p>0</p>
                        </td>
                        <td align="left" valign="top">
                            <p>long</p>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" valign="top">
                            <p><span class="strong"><strong>readLockMinLength</strong></span> (lock)</p>
                        </td>
                        <td align="left" valign="top">
                            <p>This option applied only for readLock=changed. This option allows you to
                                configure a minimum file length. By default Camel expects the file to contain
                                data, and thus the default value is 1. You can set this option to zero, to allow
                                consuming zero-length files.</p>
                        </td>
                        <td align="center" valign="top">
                            <p>1</p>
                        </td>
                        <td align="left" valign="top">
                            <p>long</p>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" valign="top">
                            <p><span class="strong"><strong>readLockRemoveOnCommit</strong></span> (lock)</p>
                        </td>
                        <td align="left" valign="top">
                            <p>This option applied only for readLock=idempotent. This option allows to specify
                                whether to remove the file name entry from the idempotent repository when
                                processing the file is succeeded and a commit happens. By default the file is
                                not removed which ensures that any race-condition do not occur so another active
                                node may attempt to grab the file. Instead the idempotent repository may support
                                eviction strategies that you can configure to evict the file name entry after X
                                minutes - this ensures no problems with race conditions.</p>
                        </td>
                        <td align="center" valign="top">
                            <p>false</p>
                        </td>
                        <td align="left" valign="top">
                            <p>boolean</p>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" valign="top">
                            <p><span class="strong"><strong>readLockRemoveOnRollback</strong></span> (lock)</p>
                        </td>
                        <td align="left" valign="top">
                            <p>This option applied only for readLock=idempotent. This option allows to specify
                                whether to remove the file name entry from the idempotent repository when
                                processing the file failed and a rollback happens. If this option is false, then
                                the file name entry is confirmed (as if the file did a commit).</p>
                        </td>
                        <td align="center" valign="top">
                            <p>true</p>
                        </td>
                        <td align="left" valign="top">
                            <p>boolean</p>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" valign="top">
                            <p><span class="strong"><strong>readLockTimeout</strong></span> (lock)</p>
                        </td>
                        <td align="left" valign="top">
                            <p>Optional timeout in millis for the read-lock, if supported by the read-lock. If
                                the read-lock could not be granted and the timeout triggered, then Camel will
                                skip the file. At next poll Camel, will try the file again, and this time maybe
                                the read-lock could be granted. Use a value of 0 or lower to indicate forever.
                                Currently fileLock, changed and rename support the timeout. Notice: For FTP the
                                default readLockTimeout value is 20000 instead of 10000. The readLockTimeout
                                value must be higher than readLockCheckInterval, but a rule of thumb is to have
                                a timeout that is at least 2 or more times higher than the
                                readLockCheckInterval. This is needed to ensure that amble time is allowed for
                                the read lock process to try to grab the lock before the timeout was hit.</p>
                        </td>
                        <td align="center" valign="top">
                            <p>10000</p>
                        </td>
                        <td align="left" valign="top">
                            <p>long</p>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" valign="top">
                            <p><span class="strong"><strong>backoffErrorThreshold</strong></span> (scheduler)
                            </p>
                        </td>
                        <td align="left" valign="top">
                            <p>The number of subsequent error polls (failed due some error) that should happen
                                before the backoffMultipler should kick-in.</p>
                        </td>
                        <td align="center" valign="top">&nbsp;</td>
                        <td align="left" valign="top">
                            <p>int</p>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" valign="top">
                            <p><span class="strong"><strong>backoffIdleThreshold</strong></span> (scheduler)</p>
                        </td>
                        <td align="left" valign="top">
                            <p>The number of subsequent idle polls that should happen before the
                                backoffMultipler should kick-in.</p>
                        </td>
                        <td align="center" valign="top">&nbsp;</td>
                        <td align="left" valign="top">
                            <p>int</p>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" valign="top">
                            <p><span class="strong"><strong>backoffMultiplier</strong></span> (scheduler)</p>
                        </td>
                        <td align="left" valign="top">
                            <p>To let the scheduled polling consumer backoff if there has been a number of
                                subsequent idles/errors in a row. The multiplier is then the number of polls
                                that will be skipped before the next actual attempt is happening again. When
                                this option is in use then backoffIdleThreshold and/or backoffErrorThreshold
                                must also be configured.</p>
                        </td>
                        <td align="center" valign="top">&nbsp;</td>
                        <td align="left" valign="top">
                            <p>int</p>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" valign="top">
                            <p><span class="strong"><strong>delay</strong></span> (scheduler)</p>
                        </td>
                        <td align="left" valign="top">
                            <p>Milliseconds before the next poll. You can also specify time values using units,
                                such as 60s (60 seconds), 5m30s (5 minutes and 30 seconds), and 1h (1 hour).</p>
                        </td>
                        <td align="center" valign="top">
                            <p>500</p>
                        </td>
                        <td align="left" valign="top">
                            <p>long</p>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" valign="top">
                            <p><span class="strong"><strong>greedy</strong></span> (scheduler)</p>
                        </td>
                        <td align="left" valign="top">
                            <p>If greedy is enabled, then the ScheduledPollConsumer will run immediately again,
                                if the previous run polled 1 or more messages.</p>
                        </td>
                        <td align="center" valign="top">
                            <p>false</p>
                        </td>
                        <td align="left" valign="top">
                            <p>boolean</p>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" valign="top">
                            <p><span class="strong"><strong>initialDelay</strong></span> (scheduler)</p>
                        </td>
                        <td align="left" valign="top">
                            <p>Milliseconds before the first poll starts. You can also specify time values using
                                units, such as 60s (60 seconds), 5m30s (5 minutes and 30 seconds), and 1h (1
                                hour).</p>
                        </td>
                        <td align="center" valign="top">
                            <p>1000</p>
                        </td>
                        <td align="left" valign="top">
                            <p>long</p>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" valign="top">
                            <p><span class="strong"><strong>runLoggingLevel</strong></span> (scheduler)</p>
                        </td>
                        <td align="left" valign="top">
                            <p>The consumer logs a start/complete log line when it polls. This option allows you
                                to configure the logging level for that.</p>
                        </td>
                        <td align="center" valign="top">
                            <p>TRACE</p>
                        </td>
                        <td align="left" valign="top">
                            <p>LoggingLevel</p>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" valign="top">
                            <p><span class="strong"><strong>scheduledExecutorService</strong></span> (scheduler)
                            </p>
                        </td>
                        <td align="left" valign="top">
                            <p>Allows for configuring a custom/shared thread pool to use for the consumer. By
                                default each consumer has its own single threaded thread pool.</p>
                        </td>
                        <td align="center" valign="top">&nbsp;</td>
                        <td align="left" valign="top">
                            <p>ScheduledExecutor Service</p>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" valign="top">
                            <p><span class="strong"><strong>scheduler</strong></span> (scheduler)</p>
                        </td>
                        <td align="left" valign="top">
                            <p>To use a cron scheduler from either camel-spring or camel-quartz2 component</p>
                        </td>
                        <td align="center" valign="top">
                            <p>none</p>
                        </td>
                        <td align="left" valign="top">
                            <p>ScheduledPollConsumer Scheduler</p>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" valign="top">
                            <p><span class="strong"><strong>schedulerProperties</strong></span> (scheduler)</p>
                        </td>
                        <td align="left" valign="top">
                            <p>To configure additional properties when using a custom scheduler or any of the
                                Quartz2, Spring based scheduler.</p>
                        </td>
                        <td align="center" valign="top">&nbsp;</td>
                        <td align="left" valign="top">
                            <p>Map</p>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" valign="top">
                            <p><span class="strong"><strong>startScheduler</strong></span> (scheduler)</p>
                        </td>
                        <td align="left" valign="top">
                            <p>Whether the scheduler should be auto started.</p>
                        </td>
                        <td align="center" valign="top">
                            <p>true</p>
                        </td>
                        <td align="left" valign="top">
                            <p>boolean</p>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" valign="top">
                            <p><span class="strong"><strong>timeUnit</strong></span> (scheduler)</p>
                        </td>
                        <td align="left" valign="top">
                            <p>Time unit for initialDelay and delay options.</p>
                        </td>
                        <td align="center" valign="top">
                            <p>MILLISECONDS</p>
                        </td>
                        <td align="left" valign="top">
                            <p>TimeUnit</p>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" valign="top">
                            <p><span class="strong"><strong>useFixedDelay</strong></span> (scheduler)</p>
                        </td>
                        <td align="left" valign="top">
                            <p>Controls if fixed delay or fixed rate is used. See ScheduledExecutorService in
                                JDK for details.</p>
                        </td>
                        <td align="center" valign="top">
                            <p>true</p>
                        </td>
                        <td align="left" valign="top">
                            <p>boolean</p>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" valign="top">
                            <p><span class="strong"><strong>shuffle</strong></span> (sort)</p>
                        </td>
                        <td align="left" valign="top">
                            <p>To shuffle the list of files (sort in random order)</p>
                        </td>
                        <td align="center" valign="top">
                            <p>false</p>
                        </td>
                        <td align="left" valign="top">
                            <p>boolean</p>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" valign="top">
                            <p><span class="strong"><strong>sortBy</strong></span> (sort)</p>
                        </td>
                        <td align="left" valign="top">
                            <p>Built-in sort by using the File Language. Supports nested sorts, so you can have
                                a sort by file name and as a 2nd group sort by modified date.</p>
                        </td>
                        <td align="center" valign="top">&nbsp;</td>
                        <td align="left" valign="top">
                            <p>String</p>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" valign="top">
                            <p><span class="strong"><strong>sorter</strong></span> (sort)</p>
                        </td>
                        <td align="left" valign="top">
                            <p>Pluggable sorter as a java.util.Comparator class.</p>
                        </td>
                        <td align="center" valign="top">&nbsp;</td>
                        <td align="left" valign="top">
                            <p>GenericFile&lt;T&gt;&gt;</p>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" valign="top">
                            <p><span class="strong"><strong>account</strong></span> (security)</p>
                        </td>
                        <td align="left" valign="top">
                            <p>Account to use for login</p>
                        </td>
                        <td align="center" valign="top">&nbsp;</td>
                        <td align="left" valign="top">
                            <p>String</p>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" valign="top">
                            <p><span class="strong"><strong>password</strong></span> (security)</p>
                        </td>
                        <td align="left" valign="top">
                            <p>Password to use for login</p>
                        </td>
                        <td align="center" valign="top">&nbsp;</td>
                        <td align="left" valign="top">
                            <p>String</p>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" valign="top">
                            <p><span class="strong"><strong>username</strong></span> (security)</p>
                        </td>
                        <td align="left" valign="top">
                            <p>Username to use for login</p>
                        </td>
                        <td align="center" valign="top">&nbsp;</td>
                        <td align="left" valign="top">
                            <p>String</p>
                        </td>
                    </tr>
                </tbody>
            </table>
        </div>
    </div>
</div>
<div class="section">
    <div class="titlepage">
        <div>
            <div>
                <h2 class="title" style="clear: both"><a name="_ftps_component_default_trust_store"></a>FTPS
                    component default trust store</h2>
            </div>
        </div>
    </div>
    <p>When using the <code class="literal">ftpClient.</code> properties related to SSL with the FTPS
        component, the trust store accept all certificates. If you only want
        trust selective certificates, you have to configure the trust store with
        the <code class="literal">ftpClient.trustStore.xxx</code> options or by configuring a custom
        <code class="literal">ftpClient</code>.
    </p>
    <p>When using <code class="literal">sslContextParameters</code>, the trust store is managed by the
        configuration of the provided SSLContextParameters instance.</p>
    <p>You can configure additional options on the <code class="literal">ftpClient</code> and
        <code class="literal">ftpClientConfig</code> from the URI directly by using the <code
            class="literal">ftpClient.</code> or
        <code class="literal">ftpClientConfig.</code> prefix.
    </p>
    <p>For example to set the <code class="literal">setDataTimeout</code> on the <code
            class="literal">FTPClient</code> to 30 seconds
        you can do:</p>
    <pre
        class="programlisting">from(<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-string"><em style="color:red">"ftp://foo@myserver?password=secret&amp;ftpClient.dataTimeout=30000"</em></strong>).to(<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-string"><em style="color:red">"bean:foo"</em></strong>);</pre>
    <p>You can mix and match and have use both prefixes, for example to
        configure date format or timezones.</p>
    <pre
        class="programlisting">from(<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-string"><em style="color:red">"ftp://foo@myserver?password=secret&amp;ftpClient.dataTimeout=30000&amp;ftpClientConfig.serverLanguageCode=fr"</em></strong>).to(<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-string"><em style="color:red">"bean:foo"</em></strong>);</pre>
    <p>You can have as many of these options as you like.</p>
    <p>See the documentation of the Apache Commons FTP FTPClientConfig for
        possible options and more details.&nbsp;And as well for Apache Commons FTP
        FTPClient.</p>
    <p>If you do not like having many and long configuration in the url you can
        refer to the <code class="literal">ftpClient</code> or <code class="literal">ftpClientConfig</code> to
        use by letting Camel
        lookup in the Registry for it.</p>
    <p>For example:</p>
    <pre class="programlisting">   &lt;bean id=<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-string"><em style="color:red">"myConfig"</em></strong> <strong xmlns="http://www.w3.org/1999/xhtml" class="hl-keyword">class</strong>=<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-string"><em style="color:red">"org.apache.commons.net.ftp.FTPClientConfig"</em></strong>&gt;
&lt;property name=<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-string"><em style="color:red">"lenientFutureDates"</em></strong> value=<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-string"><em style="color:red">"true"</em></strong>/&gt;
&lt;property name=<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-string"><em style="color:red">"serverLanguageCode"</em></strong> value=<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-string"><em style="color:red">"fr"</em></strong>/&gt;
&lt;/bean&gt;</pre>
    <p>And then let Camel lookup this bean when you use the # notation in the
        url.</p>
    <pre
        class="programlisting">from(<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-string"><em style="color:red">"ftp://foo@myserver?password=secret&amp;ftpClientConfig=#myConfig"</em></strong>).to(<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-string"><em style="color:red">"bean:foo"</em></strong>);</pre>
</div>
<div class="section">
    <div class="titlepage">
        <div>
            <div>
                <h2 class="title" style="clear: both"><a name="_examples_13"></a>Examples</h2>
            </div>
        </div>
    </div>
    <p><code
            class="literal"><a class="link" href="ftp://someone@someftpserver.com/public/upload/images/holiday2008?password=secret&amp;binary=true" target="_top">ftp://someone@someftpserver.com/public/upload/images/holiday2008?password=secret&amp;binary=true</a></code>
    </p>
    <p><code
            class="literal"><a class="link" href="ftp://someoneelse@someotherftpserver.co.uk:12049/reports/2008/password=secret&amp;binary=false" target="_top">ftp://someoneelse@someotherftpserver.co.uk:12049/reports/2008/password=secret&amp;binary=false</a></code>
        <code
            class="literal"><a class="link" href="ftp://publicftpserver.com/download" target="_top">ftp://publicftpserver.com/download</a></code>
    </p>
</div>
<div class="section">
    <div class="titlepage">
        <div>
            <div>
                <h2 class="title" style="clear: both"><a name="_concurrency"></a>Concurrency</h2>
            </div>
        </div>
    </div>
    <p>FTP Consumer does not support concurrency</p>
    <p>The FTP consumer (with the same endpoint) does not support concurrency
        (the backing FTP client is not thread safe).
        You can use multiple FTP consumers to poll from different endpoints. It
        is only a single endpoint that does not support concurrent consumers.</p>
    <p>The FTP producer does <span class="strong"><strong>not</strong></span> have this issue, it supports
        concurrency.</p>
</div>
<div class="section">
    <div class="titlepage">
        <div>
            <div>
                <h2 class="title" style="clear: both"><a name="_more_information"></a>More information</h2>
            </div>
        </div>
    </div>
    <p>This component is an extension of the File component.
        So there are more samples and details on the File
        component page.</p>
</div>
<div class="section">
    <div class="titlepage">
        <div>
            <div>
                <h2 class="title" style="clear: both"><a name="_default_when_consuming_files"></a>Default when
                    consuming files</h2>
            </div>
        </div>
    </div>
    <div class="toc">
        <p><b>Table of Contents</b></p>
        <dl>
            <dt><span class="section"><a href="ftp-component.html#_limitations">limitations</a></span></dt>
        </dl>
    </div>
    <p>The FTP consumer will by default leave the consumed
        files untouched on the remote FTP server. You have to configure it
        explicitly if you want it to delete the files or move them to another
        location. For example you can use <code class="literal">delete=true</code> to delete the files, or
        use <code class="literal">move=.done</code> to move the files into a hidden done sub directory.</p>
    <p>The regular File consumer is different as it will by
        default move files to a <code class="literal">.camel</code> sub directory. The reason Camel does
        <span class="strong"><strong>not</strong></span> do this by default for the FTP consumer is that it may
        lack
        permissions by default to be able to move or delete files.
    </p>
    <div class="section">
        <div class="titlepage">
            <div>
                <div>
                    <h3 class="title"><a name="_limitations"></a>limitations</h3>
                </div>
            </div>
        </div>
        <p>The option <span class="strong"><strong>readLock</strong></span> can be used to force Camel <span
                class="strong"><strong>not</strong></span> to consume files
            that is currently in the progress of being written. However, this option
            is turned off by default, as it requires that the user has write access.
            See the options table at File2 for more details about
            read locks.
            There are other solutions to avoid consuming files that are currently
            being written over FTP; for instance, you can write to a temporary
            destination and move the file after it has been written.</p>
        <p>When moving files using <code class="literal">move</code> or <code class="literal">preMove</code>
            option the files are
            restricted to the FTP_ROOT folder. That prevents you from moving files
            outside the FTP area. If you want to move files to another area you can
            use soft links and move files into a soft linked folder.</p>
    </div>
</div>
<div class="section">
    <div class="titlepage">
        <div>
            <div>
                <h2 class="title" style="clear: both"><a name="_message_headers_10"></a>Message Headers</h2>
            </div>
        </div>
    </div>
    <p>The following message headers can be used to affect the behavior of the
        component</p>
    <div class="informaltable">
        <table border="1" width="100%">
            <colgroup>
                <col width="50%" class="col_1">
                <col width="50%" class="col_2">
            </colgroup>
            <thead>
                <tr>
                    <th align="left" valign="top">Header</th>
                    <th align="left" valign="top">Description</th>
                </tr>
            </thead>
            <tbody>
                <tr>
                    <td align="left" valign="top">
                        <p><code class="literal">CamelFileName</code></p>
                    </td>
                    <td align="left" valign="top">
                        <p>Specifies the output file name (relative to the endpoint directory) to
                            be used for the output message when sending to the endpoint. If this is
                            not present and no expression either, then a generated message ID is
                            used as the filename instead.</p>
                    </td>
                </tr>
                <tr>
                    <td align="left" valign="top">
                        <p><code class="literal">CamelFileNameProduced</code></p>
                    </td>
                    <td align="left" valign="top">
                        <p>The actual filepath (path + name) for the output file that was written.
                            This header is set by Camel and its purpose is providing end-users the
                            name of the file that was written.</p>
                    </td>
                </tr>
                <tr>
                    <td align="left" valign="top">
                        <p><code class="literal">CamelFileIndex</code></p>
                    </td>
                    <td align="left" valign="top">
                        <p>Current index out of total number of files being consumed in this batch.</p>
                    </td>
                </tr>
                <tr>
                    <td align="left" valign="top">
                        <p><code class="literal">CamelFileSize</code></p>
                    </td>
                    <td align="left" valign="top">
                        <p>Total number of files being consumed in this batch.</p>
                    </td>
                </tr>
                <tr>
                    <td align="left" valign="top">
                        <p><code class="literal">CamelFileHost</code></p>
                    </td>
                    <td align="left" valign="top">
                        <p>The remote hostname.</p>
                    </td>
                </tr>
                <tr>
                    <td align="left" valign="top">
                        <p><code class="literal">CamelFileLocalWorkPath</code></p>
                    </td>
                    <td align="left" valign="top">
                        <p>Path to the local work file, if local work directory is used.</p>
                    </td>
                </tr>
            </tbody>
        </table>
    </div>
    <p>In addition the FTP/FTPS consumer and producer will enrich the Camel
        <code class="literal">Message</code> with the following headers
    </p>
    <div class="informaltable">
        <table border="1" width="100%">
            <colgroup>
                <col width="50%" class="col_1">
                <col width="50%" class="col_2">
            </colgroup>
            <thead>
                <tr>
                    <th align="left" valign="top">Header</th>
                    <th align="left" valign="top">Description</th>
                </tr>
            </thead>
            <tbody>
                <tr>
                    <td align="left" valign="top">
                        <p><code class="literal">CamelFtpReplyCode</code></p>
                    </td>
                    <td align="left" valign="top">
                        <p><span class="strong"><strong>Camel 2.11.1:</strong></span> The FTP client reply code
                            (the type is a integer)</p>
                    </td>
                </tr>
                <tr>
                    <td align="left" valign="top">
                        <p><code class="literal">CamelFtpReplyString</code></p>
                    </td>
                    <td align="left" valign="top">
                        <p><span class="strong"><strong>Camel 2.11.1:</strong></span> The FTP client reply
                            string</p>
                    </td>
                </tr>
            </tbody>
        </table>
    </div>
</div>
<div class="section">
    <div class="titlepage">
        <div>
            <div>
                <h2 class="title" style="clear: both"><a name="_about_timeouts"></a>About timeouts</h2>
            </div>
        </div>
    </div>
    <p>The two set of libraries (see top) has different API for setting
        timeout. You can use the <code class="literal">connectTimeout</code> option for both of them to set
        a timeout in millis to establish a network connection. An individual
        <code class="literal">soTimeout</code> can also be set on the FTP/FTPS, which corresponds to using
        <code class="literal">ftpClient.soTimeout</code>. Notice SFTP will automatically use
        <code class="literal">connectTimeout</code> as its <code class="literal">soTimeout</code>. The <code
            class="literal">timeout</code> option only applies
        for FTP/FTSP as the data timeout, which corresponds to the
        <code class="literal">ftpClient.dataTimeout</code> value. All timeout values are in millis.
    </p>
</div>
<div class="section">
    <div class="titlepage">
        <div>
            <div>
                <h2 class="title" style="clear: both"><a name="_using_local_work_directory"></a>Using Local Work
                    Directory</h2>
            </div>
        </div>
    </div>
    <p>Camel supports consuming from remote FTP servers and downloading the
        files directly into a local work directory. This avoids reading the
        entire remote file content into memory as it is streamed directly into
        the local file using <code class="literal">FileOutputStream</code>.</p>
    <p>Camel will store to a local file with the same name as the remote file,
        though with <code class="literal">.inprogress</code> as extension while the file is being
        downloaded. Afterwards, the file is renamed to remove the <code class="literal">.inprogress</code>
        suffix. And finally, when the Exchange is complete
        the local file is deleted.</p>
    <p>So if you want to download files from a remote FTP server and store it
        as files then you need to route to a file endpoint such as:</p>
    <pre
        class="programlisting">from(<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-string"><em style="color:red">"ftp://someone@someserver.com?password=secret&amp;localWorkDirectory=/tmp"</em></strong>).to(<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-string"><em style="color:red">"file://inbox"</em></strong>);</pre>
    <div class="tip" style="margin-left: 0.5in; margin-right: 0.5in;">
        <table border="0" summary="Tip">
            <tr>
                <td rowspan="2" align="center" valign="top" width="25"><img alt="[Tip]" src="imagesdb/tip.png">
                </td>
                <th align="left">Tip</th>
            </tr>
            <tr>
                <td align="left" valign="top">
                    <p>The route above is ultra efficient as it avoids reading the entire file content into
                        memory.
                        It will download the remote file directly to a local file stream.
                        The <code class="literal">java.io.File</code> handle is then used as the Exchange body.
                        The file producer leverages this fact and can work directly on the work file <code
                            class="literal">java.io.File</code> handle and perform a <code
                            class="literal">java.io.File.rename</code> to the target filename.
                        As Camel knows it&#8217;s a local work file, it can optimize and use a rename instead of
                        a file copy, as the work file is meant to be deleted anyway.</p>
                </td>
            </tr>
        </table>
    </div>
</div>
<div class="section">
    <div class="titlepage">
        <div>
            <div>
                <h2 class="title" style="clear: both"><a name="_stepwise_changing_directories"></a>Stepwise
                    changing directories</h2>
            </div>
        </div>
    </div>
    <div class="toc">
        <p><b>Table of Contents</b></p>
        <dl>
            <dt><span class="section"><a href="ftp-component.html#_using_stepwise_true_default_mode">Using
                        stepwise=true (default mode)</a></span></dt>
            <dt><span class="section"><a href="ftp-component.html#_using_stepwise_false">Using
                        stepwise=false</a></span></dt>
        </dl>
    </div>
    <p>Camel FTP can operate in two modes in terms of
        traversing directories when consuming files (eg downloading) or
        producing files (eg uploading)</p>
    <div class="itemizedlist">
        <ul class="itemizedlist" style="list-style-type: disc; ">
            <li class="listitem">stepwise</li>
            <li class="listitem">not stepwise</li>
        </ul>
    </div>
    <p>You may want to pick either one depending on your situation and security
        issues. Some Camel end users can only download files if they use
        stepwise, while others can only download if they do not. At least you
        have the choice to pick (from Camel 2.6 onwards).</p>
    <p>In Camel 2.0 - 2.5 there is only one mode and it is:</p>
    <div class="itemizedlist">
        <ul class="itemizedlist" style="list-style-type: disc; ">
            <li class="listitem">before 2.5 not stepwise</li>
            <li class="listitem">2.5 stepwise</li>
        </ul>
    </div>
    <p>From Camel 2.6 onwards there is now an option <code class="literal">stepwise</code> you can use to
        control the behavior.</p>
    <p>Note that stepwise changing of directory will in most cases only work
        when the user is confined to it&#8217;s home directory and when the home
        directory is reported as <code class="literal">"/"</code>.</p>
    <p>The difference between the two of them is best illustrated with an
        example. Suppose we have the following directory structure on the remote
        FTP server we need to traverse and download files:</p>
    <pre class="programlisting">/
/one
/one/two
/one/two/sub-a
/one/two/sub-b</pre>
    <p>And that we have a file in each of sub-a (a.txt) and sub-b (b.txt)
        folder.</p>
    <div class="section">
        <div class="titlepage">
            <div>
                <div>
                    <h3 class="title"><a name="_using_stepwise_true_default_mode"></a>Using stepwise=true
                        (default mode)</h3>
                </div>
            </div>
        </div>
        <pre class="programlisting">TYPE A
<span xmlns="http://www.w3.org/1999/xhtml" class="hl-number">200</span> Type set to A
PWD
<span xmlns="http://www.w3.org/1999/xhtml" class="hl-number">257</span> <strong xmlns="http://www.w3.org/1999/xhtml" class="hl-string"><em style="color:red">"/"</em></strong> is current directory.
CWD one
<span xmlns="http://www.w3.org/1999/xhtml" class="hl-number">250</span> CWD successful. <strong xmlns="http://www.w3.org/1999/xhtml" class="hl-string"><em style="color:red">"/one"</em></strong> is current directory.
CWD two
<span xmlns="http://www.w3.org/1999/xhtml" class="hl-number">250</span> CWD successful. <strong xmlns="http://www.w3.org/1999/xhtml" class="hl-string"><em style="color:red">"/one/two"</em></strong> is current directory.
SYST
<span xmlns="http://www.w3.org/1999/xhtml" class="hl-number">215</span> UNIX emulated by FileZilla
PORT <span xmlns="http://www.w3.org/1999/xhtml" class="hl-number">127</span>,<span xmlns="http://www.w3.org/1999/xhtml" class="hl-number">0</span>,<span xmlns="http://www.w3.org/1999/xhtml" class="hl-number">0</span>,<span xmlns="http://www.w3.org/1999/xhtml" class="hl-number">1</span>,<span xmlns="http://www.w3.org/1999/xhtml" class="hl-number">17</span>,<span xmlns="http://www.w3.org/1999/xhtml" class="hl-number">94</span>
<span xmlns="http://www.w3.org/1999/xhtml" class="hl-number">200</span> Port command successful
LIST
<span xmlns="http://www.w3.org/1999/xhtml" class="hl-number">150</span> Opening data channel <strong xmlns="http://www.w3.org/1999/xhtml" class="hl-keyword">for</strong> directory list.
<span xmlns="http://www.w3.org/1999/xhtml" class="hl-number">226</span> Transfer OK
CWD sub-a
<span xmlns="http://www.w3.org/1999/xhtml" class="hl-number">250</span> CWD successful. <strong xmlns="http://www.w3.org/1999/xhtml" class="hl-string"><em style="color:red">"/one/two/sub-a"</em></strong> is current directory.
PORT <span xmlns="http://www.w3.org/1999/xhtml" class="hl-number">127</span>,<span xmlns="http://www.w3.org/1999/xhtml" class="hl-number">0</span>,<span xmlns="http://www.w3.org/1999/xhtml" class="hl-number">0</span>,<span xmlns="http://www.w3.org/1999/xhtml" class="hl-number">1</span>,<span xmlns="http://www.w3.org/1999/xhtml" class="hl-number">17</span>,<span xmlns="http://www.w3.org/1999/xhtml" class="hl-number">95</span>
<span xmlns="http://www.w3.org/1999/xhtml" class="hl-number">200</span> Port command successful
LIST
<span xmlns="http://www.w3.org/1999/xhtml" class="hl-number">150</span> Opening data channel <strong xmlns="http://www.w3.org/1999/xhtml" class="hl-keyword">for</strong> directory list.
<span xmlns="http://www.w3.org/1999/xhtml" class="hl-number">226</span> Transfer OK
CDUP
<span xmlns="http://www.w3.org/1999/xhtml" class="hl-number">200</span> CDUP successful. <strong xmlns="http://www.w3.org/1999/xhtml" class="hl-string"><em style="color:red">"/one/two"</em></strong> is current directory.
CWD sub-b
<span xmlns="http://www.w3.org/1999/xhtml" class="hl-number">250</span> CWD successful. <strong xmlns="http://www.w3.org/1999/xhtml" class="hl-string"><em style="color:red">"/one/two/sub-b"</em></strong> is current directory.
PORT <span xmlns="http://www.w3.org/1999/xhtml" class="hl-number">127</span>,<span xmlns="http://www.w3.org/1999/xhtml" class="hl-number">0</span>,<span xmlns="http://www.w3.org/1999/xhtml" class="hl-number">0</span>,<span xmlns="http://www.w3.org/1999/xhtml" class="hl-number">1</span>,<span xmlns="http://www.w3.org/1999/xhtml" class="hl-number">17</span>,<span xmlns="http://www.w3.org/1999/xhtml" class="hl-number">96</span>
<span xmlns="http://www.w3.org/1999/xhtml" class="hl-number">200</span> Port command successful
LIST
<span xmlns="http://www.w3.org/1999/xhtml" class="hl-number">150</span> Opening data channel <strong xmlns="http://www.w3.org/1999/xhtml" class="hl-keyword">for</strong> directory list.
<span xmlns="http://www.w3.org/1999/xhtml" class="hl-number">226</span> Transfer OK
CDUP
<span xmlns="http://www.w3.org/1999/xhtml" class="hl-number">200</span> CDUP successful. <strong xmlns="http://www.w3.org/1999/xhtml" class="hl-string"><em style="color:red">"/one/two"</em></strong> is current directory.
CWD /
<span xmlns="http://www.w3.org/1999/xhtml" class="hl-number">250</span> CWD successful. <strong xmlns="http://www.w3.org/1999/xhtml" class="hl-string"><em style="color:red">"/"</em></strong> is current directory.
PWD
<span xmlns="http://www.w3.org/1999/xhtml" class="hl-number">257</span> <strong xmlns="http://www.w3.org/1999/xhtml" class="hl-string"><em style="color:red">"/"</em></strong> is current directory.
CWD one
<span xmlns="http://www.w3.org/1999/xhtml" class="hl-number">250</span> CWD successful. <strong xmlns="http://www.w3.org/1999/xhtml" class="hl-string"><em style="color:red">"/one"</em></strong> is current directory.
CWD two
<span xmlns="http://www.w3.org/1999/xhtml" class="hl-number">250</span> CWD successful. <strong xmlns="http://www.w3.org/1999/xhtml" class="hl-string"><em style="color:red">"/one/two"</em></strong> is current directory.
PORT <span xmlns="http://www.w3.org/1999/xhtml" class="hl-number">127</span>,<span xmlns="http://www.w3.org/1999/xhtml" class="hl-number">0</span>,<span xmlns="http://www.w3.org/1999/xhtml" class="hl-number">0</span>,<span xmlns="http://www.w3.org/1999/xhtml" class="hl-number">1</span>,<span xmlns="http://www.w3.org/1999/xhtml" class="hl-number">17</span>,<span xmlns="http://www.w3.org/1999/xhtml" class="hl-number">97</span>
<span xmlns="http://www.w3.org/1999/xhtml" class="hl-number">200</span> Port command successful
RETR foo.txt
<span xmlns="http://www.w3.org/1999/xhtml" class="hl-number">150</span> Opening data channel <strong xmlns="http://www.w3.org/1999/xhtml" class="hl-keyword">for</strong> file transfer.
<span xmlns="http://www.w3.org/1999/xhtml" class="hl-number">226</span> Transfer OK
CWD /
<span xmlns="http://www.w3.org/1999/xhtml" class="hl-number">250</span> CWD successful. <strong xmlns="http://www.w3.org/1999/xhtml" class="hl-string"><em style="color:red">"/"</em></strong> is current directory.
PWD
<span xmlns="http://www.w3.org/1999/xhtml" class="hl-number">257</span> <strong xmlns="http://www.w3.org/1999/xhtml" class="hl-string"><em style="color:red">"/"</em></strong> is current directory.
CWD one
<span xmlns="http://www.w3.org/1999/xhtml" class="hl-number">250</span> CWD successful. <strong xmlns="http://www.w3.org/1999/xhtml" class="hl-string"><em style="color:red">"/one"</em></strong> is current directory.
CWD two
<span xmlns="http://www.w3.org/1999/xhtml" class="hl-number">250</span> CWD successful. <strong xmlns="http://www.w3.org/1999/xhtml" class="hl-string"><em style="color:red">"/one/two"</em></strong> is current directory.
CWD sub-a
<span xmlns="http://www.w3.org/1999/xhtml" class="hl-number">250</span> CWD successful. <strong xmlns="http://www.w3.org/1999/xhtml" class="hl-string"><em style="color:red">"/one/two/sub-a"</em></strong> is current directory.
PORT <span xmlns="http://www.w3.org/1999/xhtml" class="hl-number">127</span>,<span xmlns="http://www.w3.org/1999/xhtml" class="hl-number">0</span>,<span xmlns="http://www.w3.org/1999/xhtml" class="hl-number">0</span>,<span xmlns="http://www.w3.org/1999/xhtml" class="hl-number">1</span>,<span xmlns="http://www.w3.org/1999/xhtml" class="hl-number">17</span>,<span xmlns="http://www.w3.org/1999/xhtml" class="hl-number">98</span>
<span xmlns="http://www.w3.org/1999/xhtml" class="hl-number">200</span> Port command successful
RETR a.txt
<span xmlns="http://www.w3.org/1999/xhtml" class="hl-number">150</span> Opening data channel <strong xmlns="http://www.w3.org/1999/xhtml" class="hl-keyword">for</strong> file transfer.
<span xmlns="http://www.w3.org/1999/xhtml" class="hl-number">226</span> Transfer OK
CWD /
<span xmlns="http://www.w3.org/1999/xhtml" class="hl-number">250</span> CWD successful. <strong xmlns="http://www.w3.org/1999/xhtml" class="hl-string"><em style="color:red">"/"</em></strong> is current directory.
PWD
<span xmlns="http://www.w3.org/1999/xhtml" class="hl-number">257</span> <strong xmlns="http://www.w3.org/1999/xhtml" class="hl-string"><em style="color:red">"/"</em></strong> is current directory.
CWD one
<span xmlns="http://www.w3.org/1999/xhtml" class="hl-number">250</span> CWD successful. <strong xmlns="http://www.w3.org/1999/xhtml" class="hl-string"><em style="color:red">"/one"</em></strong> is current directory.
CWD two
<span xmlns="http://www.w3.org/1999/xhtml" class="hl-number">250</span> CWD successful. <strong xmlns="http://www.w3.org/1999/xhtml" class="hl-string"><em style="color:red">"/one/two"</em></strong> is current directory.
CWD sub-b
<span xmlns="http://www.w3.org/1999/xhtml" class="hl-number">250</span> CWD successful. <strong xmlns="http://www.w3.org/1999/xhtml" class="hl-string"><em style="color:red">"/one/two/sub-b"</em></strong> is current directory.
PORT <span xmlns="http://www.w3.org/1999/xhtml" class="hl-number">127</span>,<span xmlns="http://www.w3.org/1999/xhtml" class="hl-number">0</span>,<span xmlns="http://www.w3.org/1999/xhtml" class="hl-number">0</span>,<span xmlns="http://www.w3.org/1999/xhtml" class="hl-number">1</span>,<span xmlns="http://www.w3.org/1999/xhtml" class="hl-number">17</span>,<span xmlns="http://www.w3.org/1999/xhtml" class="hl-number">99</span>
<span xmlns="http://www.w3.org/1999/xhtml" class="hl-number">200</span> Port command successful
RETR b.txt
<span xmlns="http://www.w3.org/1999/xhtml" class="hl-number">150</span> Opening data channel <strong xmlns="http://www.w3.org/1999/xhtml" class="hl-keyword">for</strong> file transfer.
<span xmlns="http://www.w3.org/1999/xhtml" class="hl-number">226</span> Transfer OK
CWD /
<span xmlns="http://www.w3.org/1999/xhtml" class="hl-number">250</span> CWD successful. <strong xmlns="http://www.w3.org/1999/xhtml" class="hl-string"><em style="color:red">"/"</em></strong> is current directory.
QUIT
<span xmlns="http://www.w3.org/1999/xhtml" class="hl-number">221</span> Goodbye
disconnected.</pre>
        <p>As you can see when stepwise is enabled, it will traverse the directory
            structure using CD xxx.</p>
    </div>
    <div class="section">
        <div class="titlepage">
            <div>
                <div>
                    <h3 class="title"><a name="_using_stepwise_false"></a>Using stepwise=false</h3>
                </div>
            </div>
        </div>
        <pre class="programlisting"><span xmlns="http://www.w3.org/1999/xhtml" class="hl-number">230</span> Logged on
TYPE A
<span xmlns="http://www.w3.org/1999/xhtml" class="hl-number">200</span> Type set to A
SYST
<span xmlns="http://www.w3.org/1999/xhtml" class="hl-number">215</span> UNIX emulated by FileZilla
PORT <span xmlns="http://www.w3.org/1999/xhtml" class="hl-number">127</span>,<span xmlns="http://www.w3.org/1999/xhtml" class="hl-number">0</span>,<span xmlns="http://www.w3.org/1999/xhtml" class="hl-number">0</span>,<span xmlns="http://www.w3.org/1999/xhtml" class="hl-number">1</span>,<span xmlns="http://www.w3.org/1999/xhtml" class="hl-number">4</span>,<span xmlns="http://www.w3.org/1999/xhtml" class="hl-number">122</span>
<span xmlns="http://www.w3.org/1999/xhtml" class="hl-number">200</span> Port command successful
LIST one/two
<span xmlns="http://www.w3.org/1999/xhtml" class="hl-number">150</span> Opening data channel <strong xmlns="http://www.w3.org/1999/xhtml" class="hl-keyword">for</strong> directory list
<span xmlns="http://www.w3.org/1999/xhtml" class="hl-number">226</span> Transfer OK
PORT <span xmlns="http://www.w3.org/1999/xhtml" class="hl-number">127</span>,<span xmlns="http://www.w3.org/1999/xhtml" class="hl-number">0</span>,<span xmlns="http://www.w3.org/1999/xhtml" class="hl-number">0</span>,<span xmlns="http://www.w3.org/1999/xhtml" class="hl-number">1</span>,<span xmlns="http://www.w3.org/1999/xhtml" class="hl-number">4</span>,<span xmlns="http://www.w3.org/1999/xhtml" class="hl-number">123</span>
<span xmlns="http://www.w3.org/1999/xhtml" class="hl-number">200</span> Port command successful
LIST one/two/sub-a
<span xmlns="http://www.w3.org/1999/xhtml" class="hl-number">150</span> Opening data channel <strong xmlns="http://www.w3.org/1999/xhtml" class="hl-keyword">for</strong> directory list
<span xmlns="http://www.w3.org/1999/xhtml" class="hl-number">226</span> Transfer OK
PORT <span xmlns="http://www.w3.org/1999/xhtml" class="hl-number">127</span>,<span xmlns="http://www.w3.org/1999/xhtml" class="hl-number">0</span>,<span xmlns="http://www.w3.org/1999/xhtml" class="hl-number">0</span>,<span xmlns="http://www.w3.org/1999/xhtml" class="hl-number">1</span>,<span xmlns="http://www.w3.org/1999/xhtml" class="hl-number">4</span>,<span xmlns="http://www.w3.org/1999/xhtml" class="hl-number">124</span>
<span xmlns="http://www.w3.org/1999/xhtml" class="hl-number">200</span> Port command successful
LIST one/two/sub-b
<span xmlns="http://www.w3.org/1999/xhtml" class="hl-number">150</span> Opening data channel <strong xmlns="http://www.w3.org/1999/xhtml" class="hl-keyword">for</strong> directory list
<span xmlns="http://www.w3.org/1999/xhtml" class="hl-number">226</span> Transfer OK
PORT <span xmlns="http://www.w3.org/1999/xhtml" class="hl-number">127</span>,<span xmlns="http://www.w3.org/1999/xhtml" class="hl-number">0</span>,<span xmlns="http://www.w3.org/1999/xhtml" class="hl-number">0</span>,<span xmlns="http://www.w3.org/1999/xhtml" class="hl-number">1</span>,<span xmlns="http://www.w3.org/1999/xhtml" class="hl-number">4</span>,<span xmlns="http://www.w3.org/1999/xhtml" class="hl-number">125</span>
<span xmlns="http://www.w3.org/1999/xhtml" class="hl-number">200</span> Port command successful
RETR one/two/foo.txt
<span xmlns="http://www.w3.org/1999/xhtml" class="hl-number">150</span> Opening data channel <strong xmlns="http://www.w3.org/1999/xhtml" class="hl-keyword">for</strong> file transfer.
<span xmlns="http://www.w3.org/1999/xhtml" class="hl-number">226</span> Transfer OK
PORT <span xmlns="http://www.w3.org/1999/xhtml" class="hl-number">127</span>,<span xmlns="http://www.w3.org/1999/xhtml" class="hl-number">0</span>,<span xmlns="http://www.w3.org/1999/xhtml" class="hl-number">0</span>,<span xmlns="http://www.w3.org/1999/xhtml" class="hl-number">1</span>,<span xmlns="http://www.w3.org/1999/xhtml" class="hl-number">4</span>,<span xmlns="http://www.w3.org/1999/xhtml" class="hl-number">126</span>
<span xmlns="http://www.w3.org/1999/xhtml" class="hl-number">200</span> Port command successful
RETR one/two/sub-a/a.txt
<span xmlns="http://www.w3.org/1999/xhtml" class="hl-number">150</span> Opening data channel <strong xmlns="http://www.w3.org/1999/xhtml" class="hl-keyword">for</strong> file transfer.
<span xmlns="http://www.w3.org/1999/xhtml" class="hl-number">226</span> Transfer OK
PORT <span xmlns="http://www.w3.org/1999/xhtml" class="hl-number">127</span>,<span xmlns="http://www.w3.org/1999/xhtml" class="hl-number">0</span>,<span xmlns="http://www.w3.org/1999/xhtml" class="hl-number">0</span>,<span xmlns="http://www.w3.org/1999/xhtml" class="hl-number">1</span>,<span xmlns="http://www.w3.org/1999/xhtml" class="hl-number">4</span>,<span xmlns="http://www.w3.org/1999/xhtml" class="hl-number">127</span>
<span xmlns="http://www.w3.org/1999/xhtml" class="hl-number">200</span> Port command successful
RETR one/two/sub-b/b.txt
<span xmlns="http://www.w3.org/1999/xhtml" class="hl-number">150</span> Opening data channel <strong xmlns="http://www.w3.org/1999/xhtml" class="hl-keyword">for</strong> file transfer.
<span xmlns="http://www.w3.org/1999/xhtml" class="hl-number">226</span> Transfer OK
QUIT
<span xmlns="http://www.w3.org/1999/xhtml" class="hl-number">221</span> Goodbye
disconnected.</pre>
        <p>As you can see when not using stepwise, there are no CD operation
            invoked at all.</p>
    </div>
</div>
<div class="section">
    <div class="titlepage">
        <div>
            <div>
                <h2 class="title" style="clear: both"><a name="_samples_17"></a>Samples</h2>
            </div>
        </div>
    </div>
    <div class="toc">
        <p><b>Table of Contents</b></p>
        <dl>
            <dt><span class="section"><a
                        href="ftp-component.html#_consuming_a_remote_ftps_server_implicit_ssl_and_client_authentication">Consuming
                        a remote FTPS server (implicit SSL) and client authentication</a></span></dt>
            <dt><span class="section"><a
                        href="ftp-component.html#_consuming_a_remote_ftps_server_explicit_tls_and_a_custom_trust_store_configuration">Consuming
                        a remote FTPS server (explicit TLS) and a custom trust store configuration</a></span>
            </dt>
        </dl>
    </div>
    <p>In the sample below we set up Camel to download all the reports from the
        FTP server once every hour (60 min) as BINARY content and store it as
        files on the local file system.</p>
    <p>And the route using Spring DSL:</p>
    <pre class="programlisting">  <strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096">&lt;route&gt;</strong>
<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096">&lt;from</strong> <span xmlns="http://www.w3.org/1999/xhtml" class="hl-attribute" style="color: #F5844C">uri</span>=<span xmlns="http://www.w3.org/1999/xhtml" class="hl-value" style="color: #993300">"ftp://scott@localhost/public/reports?password=tiger&amp;amp;binary=true&amp;amp;delay=60000"</span><strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096">/&gt;</strong>
<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096">&lt;to</strong> <span xmlns="http://www.w3.org/1999/xhtml" class="hl-attribute" style="color: #F5844C">uri</span>=<span xmlns="http://www.w3.org/1999/xhtml" class="hl-value" style="color: #993300">"file://target/test-reports"</span><strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096">/&gt;</strong>
<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096">&lt;/route&gt;</strong></pre>
    <div class="section">
        <div class="titlepage">
            <div>
                <div>
                    <h3 class="title"><a
                            name="_consuming_a_remote_ftps_server_implicit_ssl_and_client_authentication"></a>Consuming
                        a remote FTPS server (implicit SSL) and client authentication</h3>
                </div>
            </div>
        </div>
        <pre
            class="programlisting">from(<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-string"><em style="color:red">"ftps://admin@localhost:2222/public/camel?password=admin&amp;securityProtocol=SSL&amp;isImplicit=true
</em></strong>      &amp;ftpClient.keyStore.file=./src/test/resources/server.jks
&amp;ftpClient.keyStore.password=password&amp;ftpClient.keyStore.keyPassword=password<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-string"><em style="color:red">")
</em></strong>  .to(<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-string"><em style="color:red">"bean:foo"</em></strong>);</pre>
    </div>
    <div class="section">
        <div class="titlepage">
            <div>
                <div>
                    <h3 class="title"><a
                            name="_consuming_a_remote_ftps_server_explicit_tls_and_a_custom_trust_store_configuration"></a>Consuming
                        a remote FTPS server (explicit TLS) and a custom trust store configuration</h3>
                </div>
            </div>
        </div>
        <pre
            class="programlisting">from(<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-string"><em style="color:red">"ftps://admin@localhost:2222/public/camel?password=admin&amp;ftpClient.trustStore.file=./src/test/resources/server.jks&amp;ftpClient.trustStore.password=password"</em></strong>)
.to(<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-string"><em style="color:red">"bean:foo"</em></strong>);</pre>
    </div>
</div>
<div class="section">
    <div class="titlepage">
        <div>
            <div>
                <h2 class="title" style="clear: both"><a
                        name="_filter_using_literal_org_apache_camel_component_file_genericfilefilter_literal"></a>Filter
                    using <code class="literal">org.apache.camel.component.file.GenericFileFilter</code></h2>
            </div>
        </div>
    </div>
    <p>Camel supports pluggable filtering strategies. This strategy it to use
        the build in <code class="literal">org.apache.camel.component.file.GenericFileFilter</code> in
        Java. You can then configure the endpoint with such a filter to skip
        certain filters before being processed.</p>
    <p>In the sample we have built our own filter that only accepts files
        starting with report in the filename.</p>
    <p>And then we can configure our route using the <span class="strong"><strong>filter</strong></span>
        attribute to
        reference our filter (using <code class="literal">#</code> notation) that we have defined in the
        spring XML file:</p>
    <pre class="programlisting">   <em xmlns="http://www.w3.org/1999/xhtml" class="hl-comment" style="color: silver">&lt;!-- define our sorter as a plain spring bean --&gt;</em>
<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096">&lt;bean</strong> <span xmlns="http://www.w3.org/1999/xhtml" class="hl-attribute" style="color: #F5844C">id</span>=<span xmlns="http://www.w3.org/1999/xhtml" class="hl-value" style="color: #993300">"myFilter"</span> <span xmlns="http://www.w3.org/1999/xhtml" class="hl-attribute" style="color: #F5844C">class</span>=<span xmlns="http://www.w3.org/1999/xhtml" class="hl-value" style="color: #993300">"com.mycompany.MyFileFilter"</span><strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096">/&gt;</strong>

<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096">&lt;route&gt;</strong>
<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096">&lt;from</strong> <span xmlns="http://www.w3.org/1999/xhtml" class="hl-attribute" style="color: #F5844C">uri</span>=<span xmlns="http://www.w3.org/1999/xhtml" class="hl-value" style="color: #993300">"ftp://someuser@someftpserver.com?password=secret&amp;amp;filter=#myFilter"</span><strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096">/&gt;</strong>
<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096">&lt;to</strong> <span xmlns="http://www.w3.org/1999/xhtml" class="hl-attribute" style="color: #F5844C">uri</span>=<span xmlns="http://www.w3.org/1999/xhtml" class="hl-value" style="color: #993300">"bean:processInbox"</span><strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096">/&gt;</strong>
<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096">&lt;/route&gt;</strong></pre>
</div>
<div class="section">
    <div class="titlepage">
        <div>
            <div>
                <h2 class="title" style="clear: both"><a
                        name="_filtering_using_ant_path_matcher_2"></a>Filtering using ANT path matcher</h2>
            </div>
        </div>
    </div>
    <p>The ANT path matcher is a filter that is shipped out-of-the-box in the
        <span class="strong"><strong>camel-spring</strong></span> jar. So you need to depend on <span
            class="strong"><strong>camel-spring</strong></span> if you are
        using Maven.
        The reason is that we leverage Spring&#8217;s
        <a class="link"
            href="http://static.springsource.org/spring/docs/3.0.x/api/org/springframework/util/AntPathMatcher.html"
            target="_top">AntPathMatcher</a>
        to do the actual matching.
    </p>
    <p>The file paths are matched with the following rules:</p>
    <div class="itemizedlist">
        <ul class="itemizedlist" style="list-style-type: disc; ">
            <li class="listitem"><code class="literal">?</code> matches one character</li>
            <li class="listitem"><code class="literal">*</code> matches zero or more characters</li>
            <li class="listitem"><code class="literal">**</code> matches zero or more directories in a path</li>
        </ul>
    </div>
    <p>The sample below demonstrates how to use it:</p>
</div>
<div class="section">
    <div class="titlepage">
        <div>
            <div>
                <h2 class="title" style="clear: both"><a name="_using_a_proxy_with_sftp"></a>Using a proxy with
                    SFTP</h2>
            </div>
        </div>
    </div>
    <p>To use an HTTP proxy to connect to your remote host, you can configure
        your route in the following way:</p>
    <pre class="programlisting"><em xmlns="http://www.w3.org/1999/xhtml" class="hl-comment" style="color: silver">&lt;!-- define our sorter as a plain spring bean --&gt;</em>
<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096">&lt;bean</strong> <span xmlns="http://www.w3.org/1999/xhtml" class="hl-attribute" style="color: #F5844C">id</span>=<span xmlns="http://www.w3.org/1999/xhtml" class="hl-value" style="color: #993300">"proxy"</span> <span xmlns="http://www.w3.org/1999/xhtml" class="hl-attribute" style="color: #F5844C">class</span>=<span xmlns="http://www.w3.org/1999/xhtml" class="hl-value" style="color: #993300">"com.jcraft.jsch.ProxyHTTP"</span><strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096">&gt;</strong>
<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096">&lt;constructor-arg</strong> <span xmlns="http://www.w3.org/1999/xhtml" class="hl-attribute" style="color: #F5844C">value</span>=<span xmlns="http://www.w3.org/1999/xhtml" class="hl-value" style="color: #993300">"localhost"</span><strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096">/&gt;</strong>
<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096">&lt;constructor-arg</strong> <span xmlns="http://www.w3.org/1999/xhtml" class="hl-attribute" style="color: #F5844C">value</span>=<span xmlns="http://www.w3.org/1999/xhtml" class="hl-value" style="color: #993300">"7777"</span><strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096">/&gt;</strong>
<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096">&lt;/bean&gt;</strong>

<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096">&lt;route&gt;</strong>
<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096">&lt;from</strong> <span xmlns="http://www.w3.org/1999/xhtml" class="hl-attribute" style="color: #F5844C">uri</span>=<span xmlns="http://www.w3.org/1999/xhtml" class="hl-value" style="color: #993300">"sftp://localhost:9999/root?username=admin&amp;password=admin&amp;proxy=#proxy"</span><strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096">/&gt;</strong>
<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096">&lt;to</strong> <span xmlns="http://www.w3.org/1999/xhtml" class="hl-attribute" style="color: #F5844C">uri</span>=<span xmlns="http://www.w3.org/1999/xhtml" class="hl-value" style="color: #993300">"bean:processFile"</span><strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096">/&gt;</strong>
<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096">&lt;/route&gt;</strong></pre>
    <p>You can also assign a user name and password to the proxy, if necessary.
        Please consult the documentation for <code class="literal">com.jcraft.jsch.Proxy</code> to discover
        all options.</p>
</div>
<div class="section">
    <div class="titlepage">
        <div>
            <div>
                <h2 class="title" style="clear: both"><a
                        name="_setting_preferred_sftp_authentication_method"></a>Setting preferred SFTP
                    authentication method</h2>
            </div>
        </div>
    </div>
    <p>If you want to explicitly specify the list of authentication methods
        that should be used by <code class="literal">sftp</code> component, use <code
            class="literal">preferredAuthentications</code>
        option. If for example you would like Camel to attempt to authenticate
        with private/public SSH key and fallback to user/password authentication
        in the case when no public key is available, use the following route
        configuration:</p>
    <pre
        class="programlisting">from(<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-string"><em style="color:red">"sftp://localhost:9999/root?username=admin&amp;password=admin&amp;preferredAuthentications=publickey,password"</em></strong>).
to(<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-string"><em style="color:red">"bean:processFile"</em></strong>);</pre>
</div>
<div class="section">
    <div class="titlepage">
        <div>
            <div>
                <h2 class="title" style="clear: both"><a
                        name="_consuming_a_single_file_using_a_fixed_name"></a>Consuming a single file using a
                    fixed name</h2>
            </div>
        </div>
    </div>
    <p>When you want to download a single file and knows the file name, you can
        use <code class="literal">fileName=myFileName.txt</code> to tell Camel the name of the file to
        download. By default the consumer will still do a FTP LIST command to do
        a directory listing and then filter these files based on the <code class="literal">fileName</code>
        option. Though in this use-case it may be desirable to turn off the
        directory listing by setting <code class="literal">useList=false</code>. For example the user
        account used to login to the FTP server may not have permission to do a
        FTP LIST command. So you can turn off this with <code class="literal">useList=false</code>, and
        then provide the fixed name of the file to download with
        <code class="literal">fileName=myFileName.txt</code>, then the FTP consumer can still download the
        file. If the file for some reason does not exist, then Camel will by
        default throw an exception, you can turn this off and ignore this by
        setting <code class="literal">ignoreFileNotFoundOrPermissionError=true</code>.
    </p>
    <p>For example to have a Camel route that pickup a single file, and delete
        it after use you can do</p>
    <pre
        class="programlisting">from(<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-string"><em style="color:red">"ftp://admin@localhost:21/nolist/?password=admin&amp;stepwise=false&amp;useList=false&amp;ignoreFileNotFoundOrPermissionError=true&amp;fileName=report.txt&amp;delete=true"</em></strong>)
.to(<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-string"><em style="color:red">"activemq:queue:report"</em></strong>);</pre>
    <p>Notice that we have use all the options we talked above above.</p>
    <p>You can also use this with <code class="literal">ConsumerTemplate</code>. For example to download a
        single file (if it exists) and grab the file content as a String type:</p>
    <pre
        class="programlisting">String data = template.retrieveBodyNoWait(<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-string"><em style="color:red">"ftp://admin@localhost:21/nolist/?password=admin&amp;stepwise=false&amp;useList=false&amp;ignoreFileNotFoundOrPermissionError=true&amp;fileName=report.txt&amp;delete=true"</em></strong>, String.<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-keyword">class</strong>);</pre>
</div>
<div class="section">
    <div class="titlepage">
        <div>
            <div>
                <h2 class="title" style="clear: both"><a name="_debug_logging_2"></a>Debug logging</h2>
            </div>
        </div>
    </div>
    <p>This component has log level <span class="strong"><strong>TRACE</strong></span> that can be helpful if
        you have
        problems.</p>
</div>
<div class="section">
    <div class="titlepage">
        <div>
            <div>
                <h2 class="title" style="clear: both"><a name="_see_also_50"></a>See Also</h2>
            </div>
        </div>
    </div>
    <div class="itemizedlist">
        <ul class="itemizedlist" style="list-style-type: disc; ">
            <li class="listitem">Configuring Camel</li>
            <li class="listitem">Component</li>
            <li class="listitem">Endpoint</li>
            <li class="listitem">Getting Started</li>
            <li class="listitem">File2</li>
        </ul>
    </div>
</div>
</div>`;
export default FTP;
