import CamelElement from "../CamelElement";
import { Resources } from "../../utility";
class DirectVM extends CamelElement {
  constructor() {
    super();
    this.scope = "DirectVM";
    this.parent = "";
    this.inputid = ""; // 线的接入
    this.outputid = ""; // 线的出口
    this.description = ""; // 描述
    this.id = "directvm"; // 名字
    this.pattern = ""; //图案
    this.ref_deprecated = ""; // 已弃用(ref)
    this.name = "name";
    this.uri = `direct-vm:${this.name}`; // uri
    this.bridgeErrorHandler = false;
    this.exceptionHandler = "";
    this.exchangePattern = "";
    this.block = true;
    this.failIfNoConsumers = false;
    this.timeout = 30000;
    this.headerFilterStrategy = "";
    this.propagateProperties = true;
    this.synchronous = false;
  }

  paint(g) {
    if (this._img == null) {
      this._img = Resources.IMG_START_NODE;
    }

    g.save();
    this.color = "#cebee1";
    g.drawOvalBorder(this.x, this.y, this.width, this.height, 10, this.color);
    g.drawImage(this._img, this.x + 10, this.y + 5, this.icon_width / 2, this.icon_height / 2);
    g.setColor(Resources.COLOR.black);
    g.drawText(this.uri, this.x + this.width / 6, this.y + this.height / 1.5);
    g.restore();
  }

  /**
   * 更新uri(一个冒号)
   * @param {原始的组件数据}} intValue
   * @param {现在要更新的值} prop
   * @returns
   */
  updateUri(intValue, prop) {
    let tempArr = this.getPropsDesc().advanced["path"];
    return this.changeUri(intValue, this, prop, tempArr, 1);
  }

  toXML(index) {
    let str = "";
    if ((this.outputid && !this.inputid) || index == 0) {
      str += `<from id="${this.id}" x="${this.x}" y="${this.y}" uri="${this.uri}"  pattern="${this.pattern}" ref="${this.ref_deprecated}" scope="${this.scope}">\n <description>${this.description}</description>\n </from>\n`;
    } else {
      str = `<to id="${this.id}" x="${this.x}" y="${this.y}" uri="${this.uri}"  pattern="${this.pattern}"  ref="${this.ref_deprecated}" scope="${this.scope}">\n  <description>${this.description}</description>\n </to>\n`;
    }
    return str;
  }

  parseXML(xmlNode) {}

  getPropsDesc() {
    return {
      details: ["uri", "description", "id", "pattern", "ref_deprecated"],
      advanced: {
        path: ["name"],
        consumer: ["bridgeErrorHandler"],
        consumer_advanced: ["exceptionHandler", "exchangePattern"],
        producer: ["block", "failIfNoConsumers", "timeout"],
        producer_advanced: ["headerFilterStrategy"],
        advanceds: ["propagateProperties", "synchronous"],
      },
      documentation: DirectVM.documentation,
    };
  }
}
DirectVM.documentation = `<div class="chapter">
<div class="titlepage">
    <div>
        <div>
            <h2 class="title"><a name="direct-vm-component"></a>Direct VM Component</h2>
        </div>
    </div>
</div>
<div class="toc">
    <p><b>Table of Contents</b></p>
    <dl>
        <dt><span class="section"><a href="direct-vm-component.html#_uri_format_56">URI format</a></span></dt>
        <dt><span class="section"><a href="direct-vm-component.html#_options_33">Options</a></span></dt>
        <dt><span class="section"><a href="direct-vm-component.html#_samples_8">Samples</a></span></dt>
        <dt><span class="section"><a href="direct-vm-component.html#_see_also_38">See Also</a></span></dt>
    </dl>
</div>
<p><span class="strong"><strong>Available as of Camel version 2.10</strong></span></p>
<p>The <span class="strong"><strong>direct-vm:</strong></span> component provides direct, synchronous invocation
    of
    any consumers in the JVM when a producer sends a message exchange.
    This endpoint can be used to connect existing routes in the same camel
    context, as well from other camel contexts in the <span class="strong"><strong>same</strong></span> JVM.</p>
<p>This component differs from the <a class="link" href="direct-component.html"
        title="Direct Component">Direct</a> component in
    that <a class="link" href="direct-vm-component.html" title="Direct VM Component">Direct-VM</a> supports
    communication across
    CamelContext instances - so you can use this mechanism to communicate
    across web applications (provided that camel-core.jar is on the
    system/boot classpath).</p>
<p>At runtime you can swap in new consumers, by stopping the existing
    consumer(s) and start new consumers.
    But at any given time there can be at most only one active consumer for
    a given endpoint.</p>
<p>This component allows also to connect routes deployed in different OSGI
    Bundles as you can see here after. Even if they are running in different
    bundles, the camel routes will use
    the same thread. That autorises to develop applications using
    Transactions - Tx.</p>
<p><span class="inlinemediaobject"><img src="images/camel-direct-vm.png" alt="image"></span></p>
<div class="section">
    <div class="titlepage">
        <div>
            <div>
                <h2 class="title" style="clear: both"><a name="_uri_format_56"></a>URI format</h2>
            </div>
        </div>
    </div>
    <pre class="screen">direct-vm:someName</pre>
    <p>Where <span class="strong"><strong>someName</strong></span> can be any string to uniquely identify the
        endpoint</p>
</div>
<div class="section">
    <div class="titlepage">
        <div>
            <div>
                <h2 class="title" style="clear: both"><a name="_options_33"></a>Options</h2>
            </div>
        </div>
    </div>
    <div class="toc">
        <p><b>Table of Contents</b></p>
        <dl>
            <dt><span class="section"><a href="direct-vm-component.html#_path_parameters_1_parameters_45">Path
                        Parameters (1 parameters):</a></span></dt>
            <dt><span class="section"><a href="direct-vm-component.html#_query_parameters_9_parameters_2">Query
                        Parameters (9 parameters):</a></span></dt>
        </dl>
    </div>
    <p>The Direct VM component supports 5 options which are listed below.</p>
    <div class="informaltable">
        <table border="1" width="100%">
            <colgroup>
                <col width="19%" class="col_1">
                <col width="51%" class="col_2">
                <col width="10%" class="col_3">
                <col width="20%" class="col_4">
            </colgroup>
            <thead>
                <tr>
                    <th align="left" valign="top">Name</th>
                    <th align="left" valign="top">Description</th>
                    <th align="center" valign="top">Default</th>
                    <th align="left" valign="top">Type</th>
                </tr>
            </thead>
            <tbody>
                <tr>
                    <td align="left" valign="top">
                        <p><span class="strong"><strong>block</strong></span> (producer)</p>
                    </td>
                    <td align="left" valign="top">
                        <p>If sending a message to a direct endpoint which has no active consumer, then we can
                            tell the producer to block and wait for the consumer to become active.</p>
                    </td>
                    <td align="center" valign="top">
                        <p>true</p>
                    </td>
                    <td align="left" valign="top">
                        <p>boolean</p>
                    </td>
                </tr>
                <tr>
                    <td align="left" valign="top">
                        <p><span class="strong"><strong>timeout</strong></span> (producer)</p>
                    </td>
                    <td align="left" valign="top">
                        <p>The timeout value to use if block is enabled.</p>
                    </td>
                    <td align="center" valign="top">
                        <p>30000</p>
                    </td>
                    <td align="left" valign="top">
                        <p>long</p>
                    </td>
                </tr>
                <tr>
                    <td align="left" valign="top">
                        <p><span class="strong"><strong>headerFilterStrategy</strong></span> (advanced)</p>
                    </td>
                    <td align="left" valign="top">
                        <p>Sets a HeaderFilterStrategy that will only be applied on producer endpoints (on both
                            directions: request and response). Default value: none.</p>
                    </td>
                    <td align="center" valign="top">&nbsp;</td>
                    <td align="left" valign="top">
                        <p>HeaderFilterStrategy</p>
                    </td>
                </tr>
                <tr>
                    <td align="left" valign="top">
                        <p><span class="strong"><strong>propagateProperties</strong></span> (advanced)</p>
                    </td>
                    <td align="left" valign="top">
                        <p>Whether to propagate or not properties from the producer side to the consumer side,
                            and vice versa. Default value: true.</p>
                    </td>
                    <td align="center" valign="top">
                        <p>true</p>
                    </td>
                    <td align="left" valign="top">
                        <p>boolean</p>
                    </td>
                </tr>
                <tr>
                    <td align="left" valign="top">
                        <p><span class="strong"><strong>resolveProperty Placeholders</strong></span> (advanced)
                        </p>
                    </td>
                    <td align="left" valign="top">
                        <p>Whether the component should resolve property placeholders on itself when starting.
                            Only properties which are of String type can use property placeholders.</p>
                    </td>
                    <td align="center" valign="top">
                        <p>true</p>
                    </td>
                    <td align="left" valign="top">
                        <p>boolean</p>
                    </td>
                </tr>
            </tbody>
        </table>
    </div>
    <p>The Direct VM endpoint is configured using URI syntax:</p>
    <pre class="screen">direct-vm:name</pre>
    <p>with the following path and query parameters:</p>
    <div class="section">
        <div class="titlepage">
            <div>
                <div>
                    <h3 class="title"><a name="_path_parameters_1_parameters_45"></a>Path Parameters (1
                        parameters):</h3>
                </div>
            </div>
        </div>
        <div class="informaltable">
            <table border="1" width="100%">
                <colgroup>
                    <col width="19%" class="col_1">
                    <col width="51%" class="col_2">
                    <col width="10%" class="col_3">
                    <col width="20%" class="col_4">
                </colgroup>
                <thead>
                    <tr>
                        <th align="left" valign="top">Name</th>
                        <th align="left" valign="top">Description</th>
                        <th align="center" valign="top">Default</th>
                        <th align="left" valign="top">Type</th>
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <td align="left" valign="top">
                            <p><span class="strong"><strong>name</strong></span></p>
                        </td>
                        <td align="left" valign="top">
                            <p><span class="strong"><strong>Required</strong></span> Name of direct-vm endpoint
                            </p>
                        </td>
                        <td align="center" valign="top">&nbsp;</td>
                        <td align="left" valign="top">
                            <p>String</p>
                        </td>
                    </tr>
                </tbody>
            </table>
        </div>
    </div>
    <div class="section">
        <div class="titlepage">
            <div>
                <div>
                    <h3 class="title"><a name="_query_parameters_9_parameters_2"></a>Query Parameters (9
                        parameters):</h3>
                </div>
            </div>
        </div>
        <div class="informaltable">
            <table border="1" width="100%">
                <colgroup>
                    <col width="19%" class="col_1">
                    <col width="51%" class="col_2">
                    <col width="10%" class="col_3">
                    <col width="20%" class="col_4">
                </colgroup>
                <thead>
                    <tr>
                        <th align="left" valign="top">Name</th>
                        <th align="left" valign="top">Description</th>
                        <th align="center" valign="top">Default</th>
                        <th align="left" valign="top">Type</th>
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <td align="left" valign="top">
                            <p><span class="strong"><strong>bridgeErrorHandler</strong></span> (consumer)</p>
                        </td>
                        <td align="left" valign="top">
                            <p>Allows for bridging the consumer to the Camel routing Error Handler, which mean
                                any exceptions occurred while the consumer is trying to pickup incoming
                                messages, or the likes, will now be processed as a message and handled by the
                                routing Error Handler. By default the consumer will use the
                                org.apache.camel.spi.ExceptionHandler to deal with exceptions, that will be
                                logged at WARN/ERROR level and ignored.</p>
                        </td>
                        <td align="center" valign="top">
                            <p>false</p>
                        </td>
                        <td align="left" valign="top">
                            <p>boolean</p>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" valign="top">
                            <p><span class="strong"><strong>exceptionHandler</strong></span> (consumer)</p>
                        </td>
                        <td align="left" valign="top">
                            <p>To let the consumer use a custom ExceptionHandler. Notice if the option
                                bridgeErrorHandler is enabled then this options is not in use. By default the
                                consumer will deal with exceptions, that will be logged at WARN/ERROR level and
                                ignored.</p>
                        </td>
                        <td align="center" valign="top">&nbsp;</td>
                        <td align="left" valign="top">
                            <p>ExceptionHandler</p>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" valign="top">
                            <p><span class="strong"><strong>exchangePattern</strong></span> (consumer)</p>
                        </td>
                        <td align="left" valign="top">
                            <p>Sets the default exchange pattern when creating an exchange.</p>
                        </td>
                        <td align="center" valign="top">&nbsp;</td>
                        <td align="left" valign="top">
                            <p>ExchangePattern</p>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" valign="top">
                            <p><span class="strong"><strong>block</strong></span> (producer)</p>
                        </td>
                        <td align="left" valign="top">
                            <p>If sending a message to a direct endpoint which has no active consumer, then we
                                can tell the producer to block and wait for the consumer to become active.</p>
                        </td>
                        <td align="center" valign="top">
                            <p>true</p>
                        </td>
                        <td align="left" valign="top">
                            <p>boolean</p>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" valign="top">
                            <p><span class="strong"><strong>failIfNoConsumers</strong></span> (producer)</p>
                        </td>
                        <td align="left" valign="top">
                            <p>Whether the producer should fail by throwing an exception, when sending to a
                                Direct-VM endpoint with no active consumers.</p>
                        </td>
                        <td align="center" valign="top">
                            <p>false</p>
                        </td>
                        <td align="left" valign="top">
                            <p>boolean</p>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" valign="top">
                            <p><span class="strong"><strong>timeout</strong></span> (producer)</p>
                        </td>
                        <td align="left" valign="top">
                            <p>The timeout value to use if block is enabled.</p>
                        </td>
                        <td align="center" valign="top">
                            <p>30000</p>
                        </td>
                        <td align="left" valign="top">
                            <p>long</p>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" valign="top">
                            <p><span class="strong"><strong>headerFilterStrategy</strong></span> (producer)</p>
                        </td>
                        <td align="left" valign="top">
                            <p>Sets a HeaderFilterStrategy that will only be applied on producer endpoints (on
                                both directions: request and response). Default value: none.</p>
                        </td>
                        <td align="center" valign="top">&nbsp;</td>
                        <td align="left" valign="top">
                            <p>HeaderFilterStrategy</p>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" valign="top">
                            <p><span class="strong"><strong>propagateProperties</strong></span> (advanced)</p>
                        </td>
                        <td align="left" valign="top">
                            <p>Whether to propagate or not properties from the producer side to the consumer
                                side, and vice versa. Default value: true.</p>
                        </td>
                        <td align="center" valign="top">
                            <p>true</p>
                        </td>
                        <td align="left" valign="top">
                            <p>boolean</p>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" valign="top">
                            <p><span class="strong"><strong>synchronous</strong></span> (advanced)</p>
                        </td>
                        <td align="left" valign="top">
                            <p>Sets whether synchronous processing should be strictly used, or Camel is allowed
                                to use asynchronous processing (if supported).</p>
                        </td>
                        <td align="center" valign="top">
                            <p>false</p>
                        </td>
                        <td align="left" valign="top">
                            <p>boolean</p>
                        </td>
                    </tr>
                </tbody>
            </table>
        </div>
    </div>
</div>
<div class="section">
    <div class="titlepage">
        <div>
            <div>
                <h2 class="title" style="clear: both"><a name="_samples_8"></a>Samples</h2>
            </div>
        </div>
    </div>
    <p>In the route below we use the direct component to link the two routes
        together:</p>
    <pre
        class="programlisting">from(<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-string"><em style="color:red">"activemq:queue:order.in"</em></strong>)
.to(<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-string"><em style="color:red">"bean:orderServer?method=validate"</em></strong>)
.to(<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-string"><em style="color:red">"direct-vm:processOrder"</em></strong>);</pre>
    <p>And now in another CamelContext, such as another OSGi bundle</p>
    <pre
        class="programlisting">from(<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-string"><em style="color:red">"direct-vm:processOrder"</em></strong>)
.to(<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-string"><em style="color:red">"bean:orderService?method=process"</em></strong>)
.to(<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-string"><em style="color:red">"activemq:queue:order.out"</em></strong>);</pre>
    <p>And the sample using spring DSL:</p>
    <pre class="programlisting"><strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096">&lt;route&gt;</strong>
<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096">&lt;from</strong> <span xmlns="http://www.w3.org/1999/xhtml" class="hl-attribute" style="color: #F5844C">uri</span>=<span xmlns="http://www.w3.org/1999/xhtml" class="hl-value" style="color: #993300">"activemq:queue:order.in"</span><strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096">/&gt;</strong>
<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096">&lt;to</strong> <span xmlns="http://www.w3.org/1999/xhtml" class="hl-attribute" style="color: #F5844C">uri</span>=<span xmlns="http://www.w3.org/1999/xhtml" class="hl-value" style="color: #993300">"bean:orderService?method=validate"</span><strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096">/&gt;</strong>
<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096">&lt;to</strong> <span xmlns="http://www.w3.org/1999/xhtml" class="hl-attribute" style="color: #F5844C">uri</span>=<span xmlns="http://www.w3.org/1999/xhtml" class="hl-value" style="color: #993300">"direct-vm:processOrder"</span><strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096">/&gt;</strong>
<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096">&lt;/route&gt;</strong>

<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096">&lt;route&gt;</strong>
<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096">&lt;from</strong> <span xmlns="http://www.w3.org/1999/xhtml" class="hl-attribute" style="color: #F5844C">uri</span>=<span xmlns="http://www.w3.org/1999/xhtml" class="hl-value" style="color: #993300">"direct-vm:processOrder"</span><strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096">/&gt;</strong>
<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096">&lt;to</strong> <span xmlns="http://www.w3.org/1999/xhtml" class="hl-attribute" style="color: #F5844C">uri</span>=<span xmlns="http://www.w3.org/1999/xhtml" class="hl-value" style="color: #993300">"bean:orderService?method=process"</span><strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096">/&gt;</strong>
<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096">&lt;to</strong> <span xmlns="http://www.w3.org/1999/xhtml" class="hl-attribute" style="color: #F5844C">uri</span>=<span xmlns="http://www.w3.org/1999/xhtml" class="hl-value" style="color: #993300">"activemq:queue:order.out"</span><strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096">/&gt;</strong>
<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096">&lt;/route&gt;</strong></pre>
</div>
<div class="section">
    <div class="titlepage">
        <div>
            <div>
                <h2 class="title" style="clear: both"><a name="_see_also_38"></a>See Also</h2>
            </div>
        </div>
    </div>
    <div class="itemizedlist">
        <ul class="itemizedlist" style="list-style-type: disc; ">
            <li class="listitem"><a class="link" href="direct-component.html"
                    title="Direct Component">Direct</a></li>
            <li class="listitem"><a class="link" href="seda-component.html" title="SEDA Component">SEDA</a></li>
            <li class="listitem"><a class="link" href="vm-component.html" title="VM Component">VM</a></li>
        </ul>
    </div>
</div>
</div>`;
export default DirectVM;
