import CamelElement from "../CamelElement";
import { Resources } from "../../utility";
class ControlBus extends CamelElement {
  constructor() {
    super();
    this.scope = "ControlBus";
    this.hasUri = true;
    this.parent = "";
    this.inputid = ""; // 线的接入
    this.outputid = ""; // 线的出口
    this.description = ""; // 描述
    this.id = "_controlbus"; // 名字
    this.pattern = ""; //图案
    this.ref_deprecated = ""; // 已弃用(ref)
    this.command = "command";
    this.language = "language";
    this.uri = `controlbus:${this.command}:${this.language}`; // uri
    this.action = "";
    this.async = false;
    this.loggingLevel = "";
    this.restartDelay = 1000;
    this.routeId = "";
    this.synchronous = false;
  }

  paint(g) {
    if (this._img == null) {
      this._img = Resources.IMG_START_NODE;
    }

    g.save();
    this.color = "#cebee1";
    g.drawOvalBorder(this.x, this.y, this.width, this.height, 10, this.color);
    g.drawImage(this._img, this.x + 10, this.y + 5, this.icon_width / 2, this.icon_height / 2);
    g.setColor(Resources.COLOR.black);
    g.drawText(this.uri, this.x + this.width / 6, this.y + this.height / 1.5);
    g.restore();
  }

  /**
   * 更新uri(两个冒号)
   * @param {原始的组件数据} intValue
   * @param {现在要更新的值} prop
   * @returns
   */
  updateUri(intValue, prop) {
    let tempArr = this.getPropsDesc().advanced["path"];
    return this.changeUri(intValue, this, prop, tempArr, 2);
  }

  toXML(index) {
    let str = "";
    if ((this.outputid && !this.inputid) || index == 0) {
      str += `<from id="${this.id}" x="${this.x}" y="${this.y}" uri="${this.uri}"  pattern="${this.pattern}" ref="${this.ref_deprecated}" scope="${this.scope}">\n <description>${this.description}</description>\n </from>\n`;
    } else {
      str = `<to id="${this.id}" x="${this.x}" y="${this.y}" uri="${this.uri}"  pattern="${this.pattern}"  ref="${this.ref_deprecated}" scope="${this.scope}">\n  <description>${this.description}</description>\n </to>\n`;
    }
    return str;
  }

  parseXML(xmlNode) {}

  getPropsDesc() {
    return {
      details: ["uri", "description", "id", "pattern", "ref_deprecated"],
      advanced: {
        path: ["command", "language"],
        producer: ["action", "async", "loggingLevel", "restartDelay", "routeId"],
        advanceds: ["synchronous"],
      },
      documentation: ControlBus.documentation,
    };
  }
}
ControlBus.documentation = `<div class="chapter">
<div class="titlepage">
    <div>
        <div>
            <h2 class="title"><a name="controlbus-component"></a>Control Bus Component</h2>
        </div>
    </div>
</div>
<div class="toc">
    <p><b>Table of Contents</b></p>
    <dl>
        <dt><span class="section"><a href="controlbus-component.html#_controlbus_component">ControlBus
                    Component</a></span></dt>
        <dt><span class="section"><a href="controlbus-component.html#_commands">Commands</a></span></dt>
        <dt><span class="section"><a href="controlbus-component.html#_options_23">Options</a></span></dt>
        <dt><span class="section"><a href="controlbus-component.html#_using_route_command">Using route
                    command</a></span></dt>
        <dt><span class="section"><a
                    href="controlbus-component.html#ControlBus-Gettingperformancestatistics">Getting performance
                    statistics</a></span></dt>
        <dt><span class="section"><a href="controlbus-component.html#_using_simple_language">Using Simple
                    language</a></span></dt>
    </dl>
</div>
<p><span class="strong"><strong>Available as of Camel version 2.11</strong></span></p>
<p>The <a class="link" href="http://www.eaipatterns.com/ControlBus.html" target="_top">Control Bus</a> from the
    EIP patterns allows for the
    integration system to be monitored and managed from within the
    framework.</p>
<p><span class="inlinemediaobject"><img src="images/ControlBus.gif" alt="image"></span></p>
<p>Use a Control Bus to manage an enterprise integration system. The
    Control Bus uses the same messaging mechanism used by the application
    data, but uses separate channels to transmit data that is relevant to
    the management of components involved in the message flow.</p>
<p>In Camel you can manage and monitor using JMX, or
    by using a Java API from the <code class="literal">CamelContext</code>, or from the
    <code class="literal">org.apache.camel.api.management</code> package,
    or use the event notifier which has an example
    here.
</p>
<p>From Camel 2.11 onwards we have introduced a new
    <a class="link" href="controlbus-component.html" title="Control Bus Component">ControlBus Component</a> that
    allows you to
    send messages to a control bus Endpoint that reacts
    accordingly.
</p>
<div class="section">
    <div class="titlepage">
        <div>
            <div>
                <h2 class="title" style="clear: both"><a name="_controlbus_component"></a>ControlBus Component
                </h2>
            </div>
        </div>
    </div>
    <p><span class="strong"><strong>Available as of Camel 2.11</strong></span></p>
    <p>The <span class="strong"><strong>controlbus:</strong></span> component provides easy management of Camel
        applications based on the <a class="link" href="controlbus-component.html"
            title="Control Bus Component">Control Bus</a> EIP
        pattern.
        For example, by sending a message to an Endpoint
        you can control the lifecycle of routes, or gather performance
        statistics.</p>
    <pre class="screen">controlbus:command[?options]</pre>
    <p>Where <span class="strong"><strong>command</strong></span> can be any string to identify which type of
        command to
        use.</p>
</div>
<div class="section">
    <div class="titlepage">
        <div>
            <div>
                <h2 class="title" style="clear: both"><a name="_commands"></a>Commands</h2>
            </div>
        </div>
    </div>
    <div class="informaltable">
        <table border="1" width="100%">
            <colgroup>
                <col width="10%" class="col_1">
                <col width="90%" class="col_2">
            </colgroup>
            <thead>
                <tr>
                    <th align="left" valign="top">Command</th>
                    <th align="left" valign="top">Description</th>
                </tr>
            </thead>
            <tbody>
                <tr>
                    <td align="left" valign="top">
                        <p><code class="literal">route</code></p>
                    </td>
                    <td align="left" valign="top">
                        <p>To control routes using the <code class="literal">routeId</code> and <code
                                class="literal">action</code> parameter.</p>
                    </td>
                </tr>
                <tr>
                    <td align="left" valign="top">
                        <p><code class="literal">language</code></p>
                    </td>
                    <td align="left" valign="top">
                        <p>Allows you to specify a <a class="link" href="language-component.html"
                                title="Language Component">Language</a> to use for
                            evaluating the message body. If there is any result from the evaluation,
                            then the result is put in the message body.</p>
                    </td>
                </tr>
            </tbody>
        </table>
    </div>
</div>
<div class="section">
    <div class="titlepage">
        <div>
            <div>
                <h2 class="title" style="clear: both"><a name="_options_23"></a>Options</h2>
            </div>
        </div>
    </div>
    <div class="toc">
        <p><b>Table of Contents</b></p>
        <dl>
            <dt><span class="section"><a href="controlbus-component.html#_path_parameters_2_parameters_7">Path
                        Parameters (2 parameters):</a></span></dt>
            <dt><span class="section"><a href="controlbus-component.html#_query_parameters_6_parameters_2">Query
                        Parameters (6 parameters):</a></span></dt>
        </dl>
    </div>
    <p>The Control Bus component has no options.</p>
    <p>The Control Bus endpoint is configured using URI syntax:</p>
    <pre class="screen">controlbus:command:language</pre>
    <p>with the following path and query parameters:</p>
    <div class="section">
        <div class="titlepage">
            <div>
                <div>
                    <h3 class="title"><a name="_path_parameters_2_parameters_7"></a>Path Parameters (2
                        parameters):</h3>
                </div>
            </div>
        </div>
        <div class="informaltable">
            <table border="1" width="100%">
                <colgroup>
                    <col width="19%" class="col_1">
                    <col width="51%" class="col_2">
                    <col width="10%" class="col_3">
                    <col width="20%" class="col_4">
                </colgroup>
                <thead>
                    <tr>
                        <th align="left" valign="top">Name</th>
                        <th align="left" valign="top">Description</th>
                        <th align="center" valign="top">Default</th>
                        <th align="left" valign="top">Type</th>
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <td align="left" valign="top">
                            <p><span class="strong"><strong>command</strong></span></p>
                        </td>
                        <td align="left" valign="top">
                            <p><span class="strong"><strong>Required</strong></span> Command can be either route
                                or language</p>
                        </td>
                        <td align="center" valign="top">&nbsp;</td>
                        <td align="left" valign="top">
                            <p>String</p>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" valign="top">
                            <p><span class="strong"><strong>language</strong></span></p>
                        </td>
                        <td align="left" valign="top">
                            <p>Allows you to specify the name of a Language to use for evaluating the message
                                body. If there is any result from the evaluation, then the result is put in the
                                message body.</p>
                        </td>
                        <td align="center" valign="top">&nbsp;</td>
                        <td align="left" valign="top">
                            <p>Language</p>
                        </td>
                    </tr>
                </tbody>
            </table>
        </div>
    </div>
    <div class="section">
        <div class="titlepage">
            <div>
                <div>
                    <h3 class="title"><a name="_query_parameters_6_parameters_2"></a>Query Parameters (6
                        parameters):</h3>
                </div>
            </div>
        </div>
        <div class="informaltable">
            <table border="1" width="100%">
                <colgroup>
                    <col width="19%" class="col_1">
                    <col width="51%" class="col_2">
                    <col width="10%" class="col_3">
                    <col width="20%" class="col_4">
                </colgroup>
                <thead>
                    <tr>
                        <th align="left" valign="top">Name</th>
                        <th align="left" valign="top">Description</th>
                        <th align="center" valign="top">Default</th>
                        <th align="left" valign="top">Type</th>
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <td align="left" valign="top">
                            <p><span class="strong"><strong>action</strong></span> (producer)</p>
                        </td>
                        <td align="left" valign="top">
                            <p>To denote an action that can be either: start, stop, or status. To either start
                                or stop a route, or to get the status of the route as output in the message
                                body. You can use suspend and resume from Camel 2.11.1 onwards to either suspend
                                or resume a route. And from Camel 2.11.1 onwards you can use stats to get
                                performance statics returned in XML format; the routeId option can be used to
                                define which route to get the performance stats for, if routeId is not defined,
                                then you get statistics for the entire CamelContext. The restart action will
                                restart the route.</p>
                        </td>
                        <td align="center" valign="top">&nbsp;</td>
                        <td align="left" valign="top">
                            <p>String</p>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" valign="top">
                            <p><span class="strong"><strong>async</strong></span> (producer)</p>
                        </td>
                        <td align="left" valign="top">
                            <p>Whether to execute the control bus task asynchronously. Important: If this option
                                is enabled, then any result from the task is not set on the Exchange. This is
                                only possible if executing tasks synchronously.</p>
                        </td>
                        <td align="center" valign="top">
                            <p>false</p>
                        </td>
                        <td align="left" valign="top">
                            <p>boolean</p>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" valign="top">
                            <p><span class="strong"><strong>loggingLevel</strong></span> (producer)</p>
                        </td>
                        <td align="left" valign="top">
                            <p>Logging level used for logging when task is done, or if any exceptions occurred
                                during processing the task.</p>
                        </td>
                        <td align="center" valign="top">
                            <p>INFO</p>
                        </td>
                        <td align="left" valign="top">
                            <p>LoggingLevel</p>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" valign="top">
                            <p><span class="strong"><strong>restartDelay</strong></span> (producer)</p>
                        </td>
                        <td align="left" valign="top">
                            <p>The delay in millis to use when restarting a route.</p>
                        </td>
                        <td align="center" valign="top">
                            <p>1000</p>
                        </td>
                        <td align="left" valign="top">
                            <p>int</p>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" valign="top">
                            <p><span class="strong"><strong>routeId</strong></span> (producer)</p>
                        </td>
                        <td align="left" valign="top">
                            <p>To specify a route by its id. The special keyword current indicates the current
                                route.</p>
                        </td>
                        <td align="center" valign="top">&nbsp;</td>
                        <td align="left" valign="top">
                            <p>String</p>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" valign="top">
                            <p><span class="strong"><strong>synchronous</strong></span> (advanced)</p>
                        </td>
                        <td align="left" valign="top">
                            <p>Sets whether synchronous processing should be strictly used, or Camel is allowed
                                to use asynchronous processing (if supported).</p>
                        </td>
                        <td align="center" valign="top">
                            <p>false</p>
                        </td>
                        <td align="left" valign="top">
                            <p>boolean</p>
                        </td>
                    </tr>
                </tbody>
            </table>
        </div>
        <p>You can append query options to the URI in the following format,
            <code class="literal">?option=value&amp;option=value&amp;&#8230;&#8203;</code>
        </p>
    </div>
</div>
<div class="section">
    <div class="titlepage">
        <div>
            <div>
                <h2 class="title" style="clear: both"><a name="_using_route_command"></a>Using route command
                </h2>
            </div>
        </div>
    </div>
    <p>The route command allows you to do common tasks on a given route very
        easily, for example to start a route, you can send an empty message to
        this endpoint:</p>
    <pre
        class="programlisting">template.sendBody(<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-string"><em style="color:red">"controlbus:route?routeId=foo&amp;action=start"</em></strong>, null);</pre>
    <p>To get the status of the route, you can do:</p>
    <pre
        class="programlisting">String status = template.requestBody(<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-string"><em style="color:red">"controlbus:route?routeId=foo&amp;action=status"</em></strong>, null, String.<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-keyword">class</strong>);</pre>
</div>
<div class="section">
    <div class="titlepage">
        <div>
            <div>
                <h2 class="title" style="clear: both"><a
                        name="ControlBus-Gettingperformancestatistics"></a>Getting performance statistics</h2>
            </div>
        </div>
    </div>
    <p><span class="strong"><strong>Available as of Camel 2.11.1</strong></span></p>
    <p>This requires JMX to be enabled (is by default) then you can get the
        performance statics per route, or for the
        CamelContext. For example to get the statics for
        a route named foo, we can do:</p>
    <pre
        class="programlisting">String xml = template.requestBody(<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-string"><em style="color:red">"controlbus:route?routeId=foo&amp;action=stats"</em></strong>, null, String.<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-keyword">class</strong>);</pre>
    <p>The returned statics is in XML format. Its the same data you can get
        from JMX with the <code class="literal">dumpRouteStatsAsXml</code> operation on the
        <code class="literal">ManagedRouteMBean</code>.
    </p>
    <p>To get statics for the entire CamelContext you
        just omit the routeId parameter as shown below:</p>
    <pre
        class="programlisting">String xml = template.requestBody(<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-string"><em style="color:red">"controlbus:route?action=stats"</em></strong>, null, String.<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-keyword">class</strong>);</pre>
</div>
<div class="section">
    <div class="titlepage">
        <div>
            <div>
                <h2 class="title" style="clear: both"><a name="_using_simple_language"></a>Using Simple language
                </h2>
            </div>
        </div>
    </div>
    <p>You can use the <a class="link" href="simple-language.html" title="Simple Language">Simple</a> language
        with the control bus,
        for example to stop a specific route, you can send a message to the
        <code class="literal">"controlbus:language:simple"</code> endpoint containing the following
        message:
    </p>
    <pre
        class="programlisting">template.sendBody(<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-string"><em style="color:red">"controlbus:language:simple"</em></strong>, <strong xmlns="http://www.w3.org/1999/xhtml" class="hl-string"><em style="color:red">"{camelContext.stopRoute('myRoute')}"</em></strong>);</pre>
    <p>As this is a void operation, no result is returned. However, if you want
        the route status you can do:</p>
    <pre
        class="programlisting">String status = template.requestBody(<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-string"><em style="color:red">"controlbus:language:simple"</em></strong>, <strong xmlns="http://www.w3.org/1999/xhtml" class="hl-string"><em style="color:red">"{camelContext.getRouteStatus('myRoute')}"</em></strong>, String.<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-keyword">class</strong>);</pre>
    <p>It&#8217;s easier to use the <code class="literal">route</code> command to control lifecycle of
        routes. The <code class="literal">language</code> command allows you to execute a language script
        that has stronger powers such as <a class="link" href="groovy-language.html"
            title="Groovy Language">Groovy</a> or to some
        extend the <a class="link" href="simple-language.html" title="Simple Language">Simple</a> language.</p>
    <p>For example to shutdown Camel itself you can do:</p>
    <pre
        class="programlisting">template.sendBody(<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-string"><em style="color:red">"controlbus:language:simple?async=true"</em></strong>, <strong xmlns="http://www.w3.org/1999/xhtml" class="hl-string"><em style="color:red">"{camelContext.stop()}"</em></strong>);</pre>
    <p>We use <code class="literal">async=true</code> to stop Camel asynchronously as otherwise we
        would be trying to stop Camel while it was in-flight processing the
        message we sent to the control bus component.</p>
    <div class="tip" style="margin-left: 0.5in; margin-right: 0.5in;">
        <table border="0" summary="Tip">
            <tr>
                <td rowspan="2" align="center" valign="top" width="25"><img alt="[Tip]" src="imagesdb/tip.png">
                </td>
                <th align="left">Tip</th>
            </tr>
            <tr>
                <td align="left" valign="top">
                    <p>You can also use other languages such as <a class="link" href="groovy-language.html"
                            title="Groovy Language">Groovy</a>, etc.</p>
                </td>
            </tr>
        </table>
    </div>
</div>
</div>`;
export default ControlBus;
