import CamelElement from "../CamelElement";
import { Resources } from "../../utility";
class CXFRS extends CamelElement {
  constructor() {
    super();
    this.scope = "CXFRS";
    this.hasUri = true
    this.parent = "";
    this.inputid = ""; // 线的接入
    this.outputid = ""; // 线的出口
    this.description = ""; // 描述
    this.id = "_cxfrs"; // 名字
    this.pattern = ""; //图案
    this.ref_deprecated = ""; // 已弃用(ref)
    this.address = "address";
    this.beanId = "beanId";
    this.uri = `cxf:${this.beanId}:${this.address}`; // uri
    this.features = "";
    this.loggingFeatureEnabled = false;
    this.loggingSizeLimit = "";
    this.modelRef = "";
    this.providers = "";
    this.resourceClasses = "";
    this.schemaLocations = "";
    this.skipFaultLogging = false;
    this.bindingStyle = "Default";
    this.bridgeErrorHandler = false;
    this.publishedEndpointUrl = "";
    this.exceptionHandler = "";
    this.exchangePattern = "";
    this.serviceBeans = "";
    this.cookieHandler = "";
    this.hostnameVerifier = "";
    this.sslContextParameters = "";
    this.throwExceptionOnFailure = true;
    this.httpClientAPI = true;
    this.ignoreDeleteMethodMessageBody = false;
    this.maxClientCacheSize = 10;
    this.binding = "";
    this.bus = "";
    this.continuationTimeout = 30000;
    this.cxfRsEndpointConfigurer = "";
    this.defaultBus = false;
    this.headerFilterStrategy = "";
    this.performInvocation = false;
    this.propagateContexts = false;
    this.synchronous = false;
  }

  paint(g) {
    if (this._img == null) {
      this._img = Resources.IMG_START_NODE;
    }

    g.save();
    this.color = "#cebee1";
    g.drawOvalBorder(this.x, this.y, this.width, this.height, 10, this.color);
    g.drawImage(this._img, this.x + 10, this.y + 5, this.icon_width / 2, this.icon_height / 2);
    g.setColor(Resources.COLOR.black);
    g.drawText(this.uri, this.x + this.width / 6, this.y + this.height / 1.5);
    g.restore();
  }

  /**
   * 更新uri(两个冒号)
   * @param {原始的组件数据} intValue 
   * @param {现在要更新的值} prop 
   * @returns 
   */
   updateUri(intValue, prop) {
    let tempArr = this.getPropsDesc().advanced['path']
    return this.changeUri(intValue, this, prop, tempArr, 2);
  }

  toXML(index) {
    let str = "";
    if (this.outputid && !this.inputid || index == 0) {
      str += `<from id="${this.id}" x="${this.x}" y="${this.y}" uri="${this.uri}"  pattern="${this.pattern}" ref="${this.ref_deprecated}" scope="${this.scope}">\n <description>${this.description}</description>\n </from>\n`;
    } else {
      str = `<to id="${this.id}" x="${this.x}" y="${this.y}" uri="${this.uri}"  pattern="${this.pattern}"  ref="${this.ref_deprecated}" scope="${this.scope}">\n  <description>${this.description}</description>\n </to>\n`;
    }
    return str;
  }

  parseXML(xmlNode) {}

  getPropsDesc() {
    return {
      details: ["uri", "description", "id", "pattern", "ref_deprecated"],
      advanced: {
        path: ["address", "beanId"],
        common: ["features", "loggingFeatureEnabled", "loggingSizeLimit", "modelRef", "providers", "resourceClasses", "schemaLocations", "skipFaultLogging"],
        consumer: ["bindingStyle", "bridgeErrorHandler", "publishedEndpointUrl"],
        consumer_advanced: ["exceptionHandler", "exchangePattern", "serviceBeans"],
        producer: ["cookieHandler", "hostnameVerifier", "sslContextParameters", "throwExceptionOnFailure"],
        producer_advanced: ["httpClientAPI", "ignoreDeleteMethodMessageBody", "maxClientCacheSize"],
        advanceds: ["binding", "bus", "continuationTimeout", "cxfRsEndpointConfigurer", "defaultBus", "headerFilterStrategy", "performInvocation", "propagateContexts", "synchronous"],
      },
      documentation: CXFRS.documentation,
    };
  }
}
CXFRS.documentation = `<div class="chapter">
<div class="titlepage">
    <div>
        <div>
            <h2 class="title"><a name="cxfrs-component"></a>CXF-RS Component</h2>
        </div>
    </div>
</div>
<div class="toc">
    <p><b>Table of Contents</b></p>
    <dl>
        <dt><span class="section"><a href="cxfrs-component.html#_uri_format_51">URI format</a></span></dt>
        <dt><span class="section"><a href="cxfrs-component.html#_options_29">Options</a></span></dt>
        <dt><span class="section"><a
                    href="cxfrs-component.html#_how_to_configure_the_rest_endpoint_in_camel">How to configure
                    the REST endpoint in Camel</a></span></dt>
        <dt><span class="section"><a
                    href="cxfrs-component.html#_how_to_override_the_cxf_producer_address_from_message_header">How
                    to override the CXF producer address from message header</a></span></dt>
        <dt><span class="section"><a
                    href="cxfrs-component.html#_consuming_a_rest_request_simple_binding_style">Consuming a REST
                    Request - Simple Binding Style</a></span></dt>
        <dt><span class="section"><a
                    href="cxfrs-component.html#_consuming_a_rest_request_default_binding_style">Consuming a REST
                    Request - Default Binding Style</a></span></dt>
        <dt><span class="section"><a
                    href="cxfrs-component.html#_how_to_invoke_the_rest_service_through_camel_cxfrs_producer">How
                    to invoke the REST service through camel-cxfrs producer</a></span></dt>
        <dt><span class="section"><a
                    href="cxfrs-component.html#CamelTransportforCXF-WhatstheCamelTransportforCXF">What&#8217;s
                    the Camel Transport for CXF</a></span></dt>
        <dt><span class="section"><a
                    href="cxfrs-component.html#CamelTransportforCXF-IntegrateCamelintoCXFtransportlayer">Integrate
                    Camel into CXF transport layer</a></span></dt>
        <dt><span class="section"><a
                    href="cxfrs-component.html#CamelTransportforCXF-ConfigurethedestinationandconduitwithSpring">Configure
                    the destination and conduit with Spring</a></span></dt>
        <dt><span class="section"><a
                    href="cxfrs-component.html#CamelTransportforCXF-ConfigurethedestinationandconduitwithBlueprint">Configure
                    the destination and conduit with Blueprint</a></span></dt>
        <dt><span class="section"><a
                    href="cxfrs-component.html#CamelTransportforCXF-ExampleUsingCamelasaloadbalancerforCXF">Example
                    Using Camel as a load balancer for CXF</a></span></dt>
        <dt><span class="section"><a
                    href="cxfrs-component.html#CamelTransportforCXF-CompleteHowtoandExampleforattachingCameltoCXF">Complete
                    Howto and Example for attaching Camel to CXF</a></span></dt>
    </dl>
</div>
<p><span class="strong"><strong>Available as of Camel version 2.0</strong></span></p>
<p>The <span class="strong"><strong>cxfrs:</strong></span> component provides integration with
    <a class="link" href="http://cxf.apache.org" target="_top">Apache CXF</a> for connecting to JAX-RS 1.1 and
    2.0
    services hosted in CXF.
</p>
<p>When using CXF as a consumer, the <a class="link" href="cxf-bean-component.html" target="_top">CXF Bean
        Component</a> allows you to factor out how message payloads are received
    from their processing as a RESTful or SOAP web service. This has the
    potential of using a multitude of transports to consume web services.
    The bean component&#8217;s configuration is also simpler and provides the
    fastest method to implement web services using Camel and CXF.</p>
<p>Maven users will need to add the following dependency to their pom.xml
    for this component:</p>
<pre class="programlisting"><strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096">&lt;dependency&gt;</strong>
<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096">&lt;groupId&gt;</strong>org.apache.camel<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096">&lt;/groupId&gt;</strong>
<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096">&lt;artifactId&gt;</strong>camel-cxf<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096">&lt;/artifactId&gt;</strong>
<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096">&lt;version&gt;</strong>x.x.x<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096">&lt;/version&gt;</strong>  <em xmlns="http://www.w3.org/1999/xhtml" class="hl-comment" style="color: silver">&lt;!-- use the same version as your Camel core version --&gt;</em>
<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096">&lt;/dependency&gt;</strong></pre>
<div class="section">
    <div class="titlepage">
        <div>
            <div>
                <h2 class="title" style="clear: both"><a name="_uri_format_51"></a>URI format</h2>
            </div>
        </div>
    </div>
    <pre
        class="programlisting">cxfrs:<em xmlns="http://www.w3.org/1999/xhtml" class="hl-comment" style="color: silver">//address?options</em></pre>
    <p>Where <span class="strong"><strong>address</strong></span> represents the CXF endpoint&#8217;s address
    </p>
    <pre class="programlisting">cxfrs:bean:rsEndpoint</pre>
    <p>Where <span class="strong"><strong>rsEndpoint</strong></span> represents the spring bean&#8217;s name
        which presents the
        CXFRS client or server</p>
    <p>For either style above, you can append options to the URI as follows:</p>
    <pre class="programlisting">cxfrs:bean:cxfEndpoint?resourceClasses=org.apache.camel.rs.Example</pre>
</div>
<div class="section">
    <div class="titlepage">
        <div>
            <div>
                <h2 class="title" style="clear: both"><a name="_options_29"></a>Options</h2>
            </div>
        </div>
    </div>
    <div class="toc">
        <p><b>Table of Contents</b></p>
        <dl>
            <dt><span class="section"><a href="cxfrs-component.html#_path_parameters_2_parameters_10">Path
                        Parameters (2 parameters):</a></span></dt>
            <dt><span class="section"><a href="cxfrs-component.html#_query_parameters_29_parameters_2">Query
                        Parameters (29 parameters):</a></span></dt>
        </dl>
    </div>
    <p>The CXF-RS component supports 3 options which are listed below.</p>
    <div class="informaltable">
        <table border="1" width="100%">
            <colgroup>
                <col width="19%" class="col_1">
                <col width="51%" class="col_2">
                <col width="10%" class="col_3">
                <col width="20%" class="col_4">
            </colgroup>
            <thead>
                <tr>
                    <th align="left" valign="top">Name</th>
                    <th align="left" valign="top">Description</th>
                    <th align="center" valign="top">Default</th>
                    <th align="left" valign="top">Type</th>
                </tr>
            </thead>
            <tbody>
                <tr>
                    <td align="left" valign="top">
                        <p><span class="strong"><strong>useGlobalSslContext Parameters</strong></span>
                            (security)</p>
                    </td>
                    <td align="left" valign="top">
                        <p>Enable usage of global SSL context parameters.</p>
                    </td>
                    <td align="center" valign="top">
                        <p>false</p>
                    </td>
                    <td align="left" valign="top">
                        <p>boolean</p>
                    </td>
                </tr>
                <tr>
                    <td align="left" valign="top">
                        <p><span class="strong"><strong>headerFilterStrategy</strong></span> (filter)</p>
                    </td>
                    <td align="left" valign="top">
                        <p>To use a custom org.apache.camel.spi.HeaderFilterStrategy to filter header to and
                            from Camel message.</p>
                    </td>
                    <td align="center" valign="top">&nbsp;</td>
                    <td align="left" valign="top">
                        <p>HeaderFilterStrategy</p>
                    </td>
                </tr>
                <tr>
                    <td align="left" valign="top">
                        <p><span class="strong"><strong>resolveProperty Placeholders</strong></span> (advanced)
                        </p>
                    </td>
                    <td align="left" valign="top">
                        <p>Whether the component should resolve property placeholders on itself when starting.
                            Only properties which are of String type can use property placeholders.</p>
                    </td>
                    <td align="center" valign="top">
                        <p>true</p>
                    </td>
                    <td align="left" valign="top">
                        <p>boolean</p>
                    </td>
                </tr>
            </tbody>
        </table>
    </div>
    <p>The CXF-RS endpoint is configured using URI syntax:</p>
    <pre class="screen">cxfrs:beanId:address</pre>
    <p>with the following path and query parameters:</p>
    <div class="section">
        <div class="titlepage">
            <div>
                <div>
                    <h3 class="title"><a name="_path_parameters_2_parameters_10"></a>Path Parameters (2
                        parameters):</h3>
                </div>
            </div>
        </div>
        <div class="informaltable">
            <table border="1" width="100%">
                <colgroup>
                    <col width="19%" class="col_1">
                    <col width="51%" class="col_2">
                    <col width="10%" class="col_3">
                    <col width="20%" class="col_4">
                </colgroup>
                <thead>
                    <tr>
                        <th align="left" valign="top">Name</th>
                        <th align="left" valign="top">Description</th>
                        <th align="center" valign="top">Default</th>
                        <th align="left" valign="top">Type</th>
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <td align="left" valign="top">
                            <p><span class="strong"><strong>beanId</strong></span></p>
                        </td>
                        <td align="left" valign="top">
                            <p>To lookup an existing configured CxfRsEndpoint. Must used bean: as prefix.</p>
                        </td>
                        <td align="center" valign="top">&nbsp;</td>
                        <td align="left" valign="top">
                            <p>String</p>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" valign="top">
                            <p><span class="strong"><strong>address</strong></span></p>
                        </td>
                        <td align="left" valign="top">
                            <p>The service publish address.</p>
                        </td>
                        <td align="center" valign="top">&nbsp;</td>
                        <td align="left" valign="top">
                            <p>String</p>
                        </td>
                    </tr>
                </tbody>
            </table>
        </div>
    </div>
    <div class="section">
        <div class="titlepage">
            <div>
                <div>
                    <h3 class="title"><a name="_query_parameters_29_parameters_2"></a>Query Parameters (29
                        parameters):</h3>
                </div>
            </div>
        </div>
        <div class="informaltable">
            <table border="1" width="100%">
                <colgroup>
                    <col width="19%" class="col_1">
                    <col width="51%" class="col_2">
                    <col width="10%" class="col_3">
                    <col width="20%" class="col_4">
                </colgroup>
                <thead>
                    <tr>
                        <th align="left" valign="top">Name</th>
                        <th align="left" valign="top">Description</th>
                        <th align="center" valign="top">Default</th>
                        <th align="left" valign="top">Type</th>
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <td align="left" valign="top">
                            <p><span class="strong"><strong>features</strong></span> (common)</p>
                        </td>
                        <td align="left" valign="top">
                            <p>Set the feature list to the CxfRs endpoint.</p>
                        </td>
                        <td align="center" valign="top">&nbsp;</td>
                        <td align="left" valign="top">
                            <p>List</p>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" valign="top">
                            <p><span class="strong"><strong>loggingFeatureEnabled</strong></span> (common)</p>
                        </td>
                        <td align="left" valign="top">
                            <p>This option enables CXF Logging Feature which writes inbound and outbound REST
                                messages to log.</p>
                        </td>
                        <td align="center" valign="top">
                            <p>false</p>
                        </td>
                        <td align="left" valign="top">
                            <p>boolean</p>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" valign="top">
                            <p><span class="strong"><strong>loggingSizeLimit</strong></span> (common)</p>
                        </td>
                        <td align="left" valign="top">
                            <p>To limit the total size of number of bytes the logger will output when logging
                                feature has been enabled.</p>
                        </td>
                        <td align="center" valign="top">&nbsp;</td>
                        <td align="left" valign="top">
                            <p>int</p>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" valign="top">
                            <p><span class="strong"><strong>modelRef</strong></span> (common)</p>
                        </td>
                        <td align="left" valign="top">
                            <p>This option is used to specify the model file which is useful for the resource
                                class without annotation. When using this option, then the service class can be
                                omitted, to emulate document-only endpoints</p>
                        </td>
                        <td align="center" valign="top">&nbsp;</td>
                        <td align="left" valign="top">
                            <p>String</p>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" valign="top">
                            <p><span class="strong"><strong>providers</strong></span> (common)</p>
                        </td>
                        <td align="left" valign="top">
                            <p>Set custom JAX-RS provider(s) list to the CxfRs endpoint. You can specify a
                                string with a list of providers to lookup in the registy separated by comma.</p>
                        </td>
                        <td align="center" valign="top">&nbsp;</td>
                        <td align="left" valign="top">
                            <p>String</p>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" valign="top">
                            <p><span class="strong"><strong>resourceClasses</strong></span> (common)</p>
                        </td>
                        <td align="left" valign="top">
                            <p>The resource classes which you want to export as REST service. Multiple classes
                                can be separated by comma.</p>
                        </td>
                        <td align="center" valign="top">&nbsp;</td>
                        <td align="left" valign="top">
                            <p>List</p>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" valign="top">
                            <p><span class="strong"><strong>schemaLocations</strong></span> (common)</p>
                        </td>
                        <td align="left" valign="top">
                            <p>Sets the locations of the schema(s) which can be used to validate the incoming
                                XML or JAXB-driven JSON.</p>
                        </td>
                        <td align="center" valign="top">&nbsp;</td>
                        <td align="left" valign="top">
                            <p>List</p>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" valign="top">
                            <p><span class="strong"><strong>skipFaultLogging</strong></span> (common)</p>
                        </td>
                        <td align="left" valign="top">
                            <p>This option controls whether the PhaseInterceptorChain skips logging the Fault
                                that it catches.</p>
                        </td>
                        <td align="center" valign="top">
                            <p>false</p>
                        </td>
                        <td align="left" valign="top">
                            <p>boolean</p>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" valign="top">
                            <p><span class="strong"><strong>bindingStyle</strong></span> (consumer)</p>
                        </td>
                        <td align="left" valign="top">
                            <p>Sets how requests and responses will be mapped to/from Camel. Two values are
                                possible: SimpleConsumer: This binding style processes request parameters,
                                multiparts, etc. and maps them to IN headers, IN attachments and to the message
                                body. It aims to eliminate low-level processing of
                                org.apache.cxf.message.MessageContentsList. It also also adds more flexibility
                                and simplicity to the response mapping. Only available for consumers. Default:
                                The default style. For consumers this passes on a MessageContentsList to the
                                route, requiring low-level processing in the route. This is the traditional
                                binding style, which simply dumps the org.apache.cxf.message.MessageContentsList
                                coming in from the CXF stack onto the IN message body. The user is then
                                responsible for processing it according to the contract defined by the JAX-RS
                                method signature. Custom: allows you to specify a custom binding through the
                                binding option.</p>
                        </td>
                        <td align="center" valign="top">
                            <p>Default</p>
                        </td>
                        <td align="left" valign="top">
                            <p>BindingStyle</p>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" valign="top">
                            <p><span class="strong"><strong>bridgeErrorHandler</strong></span> (consumer)</p>
                        </td>
                        <td align="left" valign="top">
                            <p>Allows for bridging the consumer to the Camel routing Error Handler, which mean
                                any exceptions occurred while the consumer is trying to pickup incoming
                                messages, or the likes, will now be processed as a message and handled by the
                                routing Error Handler. By default the consumer will use the
                                org.apache.camel.spi.ExceptionHandler to deal with exceptions, that will be
                                logged at WARN or ERROR level and ignored.</p>
                        </td>
                        <td align="center" valign="top">
                            <p>false</p>
                        </td>
                        <td align="left" valign="top">
                            <p>boolean</p>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" valign="top">
                            <p><span class="strong"><strong>publishedEndpointUrl</strong></span> (consumer)</p>
                        </td>
                        <td align="left" valign="top">
                            <p>This option can override the endpointUrl that published from the WADL which can
                                be accessed with resource address url plus _wadl</p>
                        </td>
                        <td align="center" valign="top">&nbsp;</td>
                        <td align="left" valign="top">
                            <p>String</p>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" valign="top">
                            <p><span class="strong"><strong>exceptionHandler</strong></span> (consumer)</p>
                        </td>
                        <td align="left" valign="top">
                            <p>To let the consumer use a custom ExceptionHandler. Notice if the option
                                bridgeErrorHandler is enabled then this options is not in use. By default the
                                consumer will deal with exceptions, that will be logged at WARN or ERROR level
                                and ignored.</p>
                        </td>
                        <td align="center" valign="top">&nbsp;</td>
                        <td align="left" valign="top">
                            <p>ExceptionHandler</p>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" valign="top">
                            <p><span class="strong"><strong>exchangePattern</strong></span> (consumer)</p>
                        </td>
                        <td align="left" valign="top">
                            <p>Sets the exchange pattern when the consumer creates an exchange.</p>
                        </td>
                        <td align="center" valign="top">&nbsp;</td>
                        <td align="left" valign="top">
                            <p>ExchangePattern</p>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" valign="top">
                            <p><span class="strong"><strong>cookieHandler</strong></span> (producer)</p>
                        </td>
                        <td align="left" valign="top">
                            <p>Configure a cookie handler to maintain a HTTP session</p>
                        </td>
                        <td align="center" valign="top">&nbsp;</td>
                        <td align="left" valign="top">
                            <p>CookieHandler</p>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" valign="top">
                            <p><span class="strong"><strong>hostnameVerifier</strong></span> (producer)</p>
                        </td>
                        <td align="left" valign="top">
                            <p>The hostname verifier to be used. Use the notation to reference a
                                HostnameVerifier from the registry.</p>
                        </td>
                        <td align="center" valign="top">&nbsp;</td>
                        <td align="left" valign="top">
                            <p>HostnameVerifier</p>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" valign="top">
                            <p><span class="strong"><strong>sslContextParameters</strong></span> (producer)</p>
                        </td>
                        <td align="left" valign="top">
                            <p>The Camel SSL setting reference. Use the notation to reference the SSL Context.
                            </p>
                        </td>
                        <td align="center" valign="top">&nbsp;</td>
                        <td align="left" valign="top">
                            <p>SSLContextParameters</p>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" valign="top">
                            <p><span class="strong"><strong>throwExceptionOnFailure</strong></span> (producer)
                            </p>
                        </td>
                        <td align="left" valign="top">
                            <p>This option tells the CxfRsProducer to inspect return codes and will generate an
                                Exception if the return code is larger than 207.</p>
                        </td>
                        <td align="center" valign="top">
                            <p>true</p>
                        </td>
                        <td align="left" valign="top">
                            <p>boolean</p>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" valign="top">
                            <p><span class="strong"><strong>httpClientAPI</strong></span> (producer)</p>
                        </td>
                        <td align="left" valign="top">
                            <p>If it is true, the CxfRsProducer will use the HttpClientAPI to invoke the
                                service. If it is false, the CxfRsProducer will use the ProxyClientAPI to invoke
                                the service</p>
                        </td>
                        <td align="center" valign="top">
                            <p>true</p>
                        </td>
                        <td align="left" valign="top">
                            <p>boolean</p>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" valign="top">
                            <p><span class="strong"><strong>ignoreDeleteMethodMessage Body</strong></span>
                                (producer)</p>
                        </td>
                        <td align="left" valign="top">
                            <p>This option is used to tell CxfRsProducer to ignore the message body of the
                                DELETE method when using HTTP API.</p>
                        </td>
                        <td align="center" valign="top">
                            <p>false</p>
                        </td>
                        <td align="left" valign="top">
                            <p>boolean</p>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" valign="top">
                            <p><span class="strong"><strong>maxClientCacheSize</strong></span> (producer)</p>
                        </td>
                        <td align="left" valign="top">
                            <p>This option allows you to configure the maximum size of the cache. The
                                implementation caches CXF clients or ClientFactoryBean in CxfProvider and
                                CxfRsProvider.</p>
                        </td>
                        <td align="center" valign="top">
                            <p>10</p>
                        </td>
                        <td align="left" valign="top">
                            <p>int</p>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" valign="top">
                            <p><span class="strong"><strong>binding</strong></span> (advanced)</p>
                        </td>
                        <td align="left" valign="top">
                            <p>To use a custom CxfBinding to control the binding between Camel Message and CXF
                                Message.</p>
                        </td>
                        <td align="center" valign="top">&nbsp;</td>
                        <td align="left" valign="top">
                            <p>CxfRsBinding</p>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" valign="top">
                            <p><span class="strong"><strong>bus</strong></span> (advanced)</p>
                        </td>
                        <td align="left" valign="top">
                            <p>To use a custom configured CXF Bus.</p>
                        </td>
                        <td align="center" valign="top">&nbsp;</td>
                        <td align="left" valign="top">
                            <p>Bus</p>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" valign="top">
                            <p><span class="strong"><strong>continuationTimeout</strong></span> (advanced)</p>
                        </td>
                        <td align="left" valign="top">
                            <p>This option is used to set the CXF continuation timeout which could be used in
                                CxfConsumer by default when the CXF server is using Jetty or Servlet transport.
                            </p>
                        </td>
                        <td align="center" valign="top">
                            <p>30000</p>
                        </td>
                        <td align="left" valign="top">
                            <p>long</p>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" valign="top">
                            <p><span class="strong"><strong>cxfRsEndpointConfigurer</strong></span> (advanced)
                            </p>
                        </td>
                        <td align="left" valign="top">
                            <p>This option could apply the implementation of
                                org.apache.camel.component.cxf.jaxrs.CxfRsEndpointConfigurer which supports to
                                configure the CXF endpoint in programmatic way. User can configure the CXF
                                server and client by implementing configureServer/Client method of
                                CxfEndpointConfigurer.</p>
                        </td>
                        <td align="center" valign="top">&nbsp;</td>
                        <td align="left" valign="top">
                            <p>CxfRsEndpoint Configurer</p>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" valign="top">
                            <p><span class="strong"><strong>defaultBus</strong></span> (advanced)</p>
                        </td>
                        <td align="left" valign="top">
                            <p>Will set the default bus when CXF endpoint create a bus by itself</p>
                        </td>
                        <td align="center" valign="top">
                            <p>false</p>
                        </td>
                        <td align="left" valign="top">
                            <p>boolean</p>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" valign="top">
                            <p><span class="strong"><strong>headerFilterStrategy</strong></span> (advanced)</p>
                        </td>
                        <td align="left" valign="top">
                            <p>To use a custom HeaderFilterStrategy to filter header to and from Camel message.
                            </p>
                        </td>
                        <td align="center" valign="top">&nbsp;</td>
                        <td align="left" valign="top">
                            <p>HeaderFilterStrategy</p>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" valign="top">
                            <p><span class="strong"><strong>performInvocation</strong></span> (advanced)</p>
                        </td>
                        <td align="left" valign="top">
                            <p>When the option is true, Camel will perform the invocation of the resource class
                                instance and put the response object into the exchange for further processing.
                            </p>
                        </td>
                        <td align="center" valign="top">
                            <p>false</p>
                        </td>
                        <td align="left" valign="top">
                            <p>boolean</p>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" valign="top">
                            <p><span class="strong"><strong>propagateContexts</strong></span> (advanced)</p>
                        </td>
                        <td align="left" valign="top">
                            <p>When the option is true, JAXRS UriInfo, HttpHeaders, Request and SecurityContext
                                contexts will be available to custom CXFRS processors as typed Camel exchange
                                properties. These contexts can be used to analyze the current requests using
                                JAX-RS API.</p>
                        </td>
                        <td align="center" valign="top">
                            <p>false</p>
                        </td>
                        <td align="left" valign="top">
                            <p>boolean</p>
                        </td>
                    </tr>
                    <tr>
                        <td align="left" valign="top">
                            <p><span class="strong"><strong>synchronous</strong></span> (advanced)</p>
                        </td>
                        <td align="left" valign="top">
                            <p>Sets whether synchronous processing should be strictly used, or Camel is allowed
                                to use asynchronous processing (if supported).</p>
                        </td>
                        <td align="center" valign="top">
                            <p>false</p>
                        </td>
                        <td align="left" valign="top">
                            <p>boolean</p>
                        </td>
                    </tr>
                </tbody>
            </table>
        </div>
        <p>You can also configure the CXF REST endpoint through the spring
            configuration. Since there are lots of difference between the CXF REST
            client and CXF REST Server, we provide different configuration for
            them. Please check out the
            <a class="link"
                href="https://github.com/apache/camel/blob/master/components/camel-cxf/src/main/resources/schema/cxfEndpoint.xsd"
                target="_top">schema
                file</a> and <a class="link" href="http://cxf.apache.org/docs/jax-rs.html" target="_top">CXF
                JAX-RS
                documentation</a> for more information.
        </p>
    </div>
</div>
<div class="section">
    <div class="titlepage">
        <div>
            <div>
                <h2 class="title" style="clear: both"><a
                        name="_how_to_configure_the_rest_endpoint_in_camel"></a>How to configure the REST
                    endpoint in Camel</h2>
            </div>
        </div>
    </div>
    <p>In
        <a class="link"
            href="https://github.com/apache/camel/blob/master/components/camel-cxf/src/main/resources/schema/cxfEndpoint.xsd"
            target="_top">camel-cxf
            schema file</a>, there are two elements for the REST endpoint definition.
        <span class="strong"><strong>cxf:rsServer</strong></span> for REST consumer, <span
            class="strong"><strong>cxf:rsClient</strong></span> for REST producer.
        You can find a Camel REST service route configuration example here.
    </p>
</div>
<div class="section">
    <div class="titlepage">
        <div>
            <div>
                <h2 class="title" style="clear: both"><a
                        name="_how_to_override_the_cxf_producer_address_from_message_header"></a>How to override
                    the CXF producer address from message header</h2>
            </div>
        </div>
    </div>
    <p>The&nbsp;<code class="literal">camel-cxfrs</code>&nbsp;producer supports to override the services address
        by
        setting the message with the key of "CamelDestinationOverrideUrl".</p>
    <pre class="programlisting"> <em xmlns="http://www.w3.org/1999/xhtml" class="hl-comment" style="color: silver">// set up the service address from the message header to override the setting of CXF endpoint</em>
exchange.getIn().setHeader(Exchange.DESTINATION_OVERRIDE_URL, constant(getServiceAddress()));</pre>
</div>
<div class="section">
    <div class="titlepage">
        <div>
            <div>
                <h2 class="title" style="clear: both"><a
                        name="_consuming_a_rest_request_simple_binding_style"></a>Consuming a REST Request -
                    Simple Binding Style</h2>
            </div>
        </div>
    </div>
    <div class="toc">
        <p><b>Table of Contents</b></p>
        <dl>
            <dt><span class="section"><a href="cxfrs-component.html#_enabling_the_simple_binding_style">Enabling
                        the Simple Binding Style</a></span></dt>
            <dt><span class="section"><a
                        href="cxfrs-component.html#_examples_of_request_binding_with_different_method_signatures">Examples
                        of request binding with different method signatures</a></span></dt>
            <dt><span class="section"><a
                        href="cxfrs-component.html#_more_examples_of_the_simple_binding_style">More examples of
                        the Simple Binding Style</a></span></dt>
        </dl>
    </div>
    <p><span class="strong"><strong>Available as of Camel 2.11</strong></span></p>
    <p>The <code class="literal">Default</code> binding style is rather low-level, requiring the user to
        manually process the <code class="literal">MessageContentsList</code> object coming into the route.
        Thus, it tightly couples the route logic with the method signature and
        parameter indices of the JAX-RS operation. Somewhat inelegant, difficult
        and error-prone.</p>
    <p>In contrast, the <code class="literal">SimpleConsumer</code> binding style performs the following
        mappings, in order to <span class="strong"><strong>make the request data more accessible</strong></span>
        to you
        within the Camel Message:</p>
    <div class="itemizedlist">
        <ul class="itemizedlist" style="list-style-type: disc; ">
            <li class="listitem">JAX-RS Parameters (@HeaderParam, @QueryParam, etc.) are injected as IN
                message headers. The header name matches the value of the annotation.</li>
            <li class="listitem">The request entity (POJO or other type) becomes the IN message body.
                If a single entity cannot be identified in the JAX-RS method signature,
                it falls back to the original <code class="literal">MessageContentsList</code>.</li>
            <li class="listitem">Binary <code class="literal">@Multipart</code> body parts become IN message
                attachments,
                supporting <code class="literal">DataHandler</code>, <code class="literal">InputStream</code>,
                <code class="literal">DataSource</code> and CXF&#8217;s
                <code class="literal">Attachment</code> class.
            </li>
            <li class="listitem">Non-binary <code class="literal">@Multipart</code> body parts are mapped as IN
                message headers.
                The header name matches the Body Part name.</li>
        </ul>
    </div>
    <p>Additionally, the following rules apply to the <span class="strong"><strong>Response
                mapping</strong></span>:</p>
    <div class="itemizedlist">
        <ul class="itemizedlist" style="list-style-type: disc; ">
            <li class="listitem">If the message body type is different to <code
                    class="literal">javax.ws.rs.core.Response</code>
                (user-built response), a new <code class="literal">Response</code> is created and the message
                body
                is set as the entity (so long it&#8217;s not null). The response status code
                is taken from the <code class="literal">Exchange.HTTP_RESPONSE_CODE</code> header, or defaults
                to
                200 OK if not present.</li>
            <li class="listitem">If the message body type is equal to <code
                    class="literal">javax.ws.rs.core.Response</code>, it
                means that the user has built a custom response, and therefore it is
                respected and it becomes the final response.</li>
            <li class="listitem">In all cases, Camel headers permitted by custom or default
                <code class="literal">HeaderFilterStrategy</code> are added to the HTTP response.
            </li>
        </ul>
    </div>
    <div class="section">
        <div class="titlepage">
            <div>
                <div>
                    <h3 class="title"><a name="_enabling_the_simple_binding_style"></a>Enabling the Simple
                        Binding Style</h3>
                </div>
            </div>
        </div>
        <p>This binding style can be activated by setting the <code class="literal">bindingStyle</code>
            parameter in the consumer endpoint to value <code class="literal">SimpleConsumer</code>:</p>
        <pre
            class="programlisting">  from(<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-string"><em style="color:red">"cxfrs:bean:rsServer?bindingStyle=SimpleConsumer"</em></strong>)
.to(<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-string"><em style="color:red">"log:TEST?showAll=true"</em></strong>);</pre>
    </div>
    <div class="section">
        <div class="titlepage">
            <div>
                <div>
                    <h3 class="title"><a
                            name="_examples_of_request_binding_with_different_method_signatures"></a>Examples of
                        request binding with different method signatures</h3>
                </div>
            </div>
        </div>
        <p>Below is a list of method signatures along with the expected result from
            the Simple binding.</p>
        <p><span class="strong"><strong><code
                        class="literal">public Response doAction(BusinessObject request);</code></strong></span>
            Request payload is placed in IN message body, replacing the original
            MessageContentsList.</p>
        <p><span class="strong"><strong><code
                        class="literal">public Response doAction(BusinessObject request, @HeaderParam("abcd") String abcd, @QueryParam("defg") String defg);</code></strong></span>
            Request payload placed in IN message body, replacing the original
            MessageContentsList. Both request params mapped as IN message headers
            with names abcd and defg.</p>
        <p><span class="strong"><strong><code
                        class="literal">public Response doAction(@HeaderParam("abcd") String abcd, @QueryParam("defg") String defg);</code></strong></span>
            Both request params mapped as IN message headers with names abcd and
            defg. The original MessageContentsList is preserved, even though it only
            contains the 2 parameters.</p>
        <p><span class="strong"><strong><code
                        class="literal">public Response doAction(@Multipart(value="body1") BusinessObject request, @Multipart(value="body2") BusinessObject request2);</code></strong></span>
            The first parameter is transferred as a header with name body1, and the
            second one is mapped as header body2. The original MessageContentsList
            is preserved as the IN message body.</p>
        <p><span class="strong"><strong><code
                        class="literal">public Response doAction(InputStream abcd);</code></strong></span>
            The InputStream is unwrapped from the MessageContentsList and preserved
            as the IN message body.</p>
        <p><span class="strong"><strong><code
                        class="literal">public Response doAction(DataHandler abcd);</code></strong></span>
            The DataHandler is unwrapped from the MessageContentsList and preserved
            as the IN message body.</p>
    </div>
    <div class="section">
        <div class="titlepage">
            <div>
                <div>
                    <h3 class="title"><a name="_more_examples_of_the_simple_binding_style"></a>More examples of
                        the Simple Binding Style</h3>
                </div>
            </div>
        </div>
        <p>Given a JAX-RS resource class with this method:</p>
        <pre class="programlisting">    <em xmlns="http://www.w3.org/1999/xhtml"><span class="hl-annotation" style="color: gray">@POST</span></em> <em xmlns="http://www.w3.org/1999/xhtml"><span class="hl-annotation" style="color: gray">@Path("/customers/{type}")</span></em>
<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-keyword">public</strong> Response newCustomer(Customer customer, <em xmlns="http://www.w3.org/1999/xhtml"><span class="hl-annotation" style="color: gray">@PathParam("type")</span></em> String type, <em xmlns="http://www.w3.org/1999/xhtml"><span class="hl-annotation" style="color: gray">@QueryParam("active")</span></em> <em xmlns="http://www.w3.org/1999/xhtml"><span class="hl-annotation" style="color: gray">@DefaultValue("true")</span></em> <strong xmlns="http://www.w3.org/1999/xhtml" class="hl-keyword">boolean</strong> active) {
<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-keyword">return</strong> null;
}</pre>
        <p>Serviced by the following route:</p>
        <pre
            class="programlisting">    from(<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-string"><em style="color:red">"cxfrs:bean:rsServer?bindingStyle=SimpleConsumer"</em></strong>)
.recipientList(simple(<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-string"><em style="color:red">"direct:{header.operationName}"</em></strong>));

from(<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-string"><em style="color:red">"direct:newCustomer"</em></strong>)
.log(<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-string"><em style="color:red">"Request: type={header.type}, active={header.active}, customerData={body}"</em></strong>);</pre>
        <p>The following HTTP request with XML payload (given that the Customer DTO
            is JAXB-annotated):</p>
        <pre class="programlisting">POST /customers/gold?active=true

Payload:
<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096">&lt;Customer&gt;</strong>
<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096">&lt;fullName&gt;</strong>Raul Kripalani<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096">&lt;/fullName&gt;</strong>
<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096">&lt;country&gt;</strong>Spain<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096">&lt;/country&gt;</strong>
<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096">&lt;project&gt;</strong>Apache Camel<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096">&lt;/project&gt;</strong>
<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096">&lt;/Customer&gt;</strong></pre>
        <p>Will print the message:</p>
        <pre
            class="programlisting">Request: type=gold, active=true, customerData=<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096">&lt;Customer.toString()</strong> <span xmlns="http://www.w3.org/1999/xhtml" class="hl-attribute" style="color: #F5844C">representation&gt;</span></pre>
        <p>For more examples on how to process requests and write responses can be
            found
            <a class="link"
                href="https://svn.apache.org/repos/asf/camel/trunk/components/camel-cxf/src/test/java/org/apache/camel/component/cxf/jaxrs/simplebinding/"
                target="_top">here</a>.
        </p>
    </div>
</div>
<div class="section">
    <div class="titlepage">
        <div>
            <div>
                <h2 class="title" style="clear: both"><a
                        name="_consuming_a_rest_request_default_binding_style"></a>Consuming a REST Request -
                    Default Binding Style</h2>
            </div>
        </div>
    </div>
    <p>The&nbsp;<a class="link" href="http://cxf.apache.org/docs/jax-rs.html" target="_top">CXF JAXRS front
            end</a>
        implements the <a class="link" href="https://javaee.github.io/jsr311/" target="_top">JAX-RS (JSR-311)
            API</a>, so we can
        export the resources classes as a REST service. And we leverage the
        <a class="link" href="http://cxf.apache.org/docs/invokers.html" target="_top">CXF Invoker
            API</a> to turn a REST request into a normal Java object method
        invocation.
        Unlike the <a class="link" href="restlet-component.html" title="Restlet Component">Camel
            Restlet</a>&nbsp;component, you don&#8217;t need
        to specify the URI template within your endpoint, CXF takes care of the
        REST request URI to resource class method mapping according to the
        JSR-311 specification. All you need to do in Camel is delegate this
        method request to a right processor or endpoint.
    </p>
    <p>Here is an example of a CXFRS route&#8230;&#8203;</p>
    <p>And the corresponding resource class used to configure the endpoint&#8230;&#8203;</p>
    <p>INFO:*Note about resource classes*</p>
    <p>By default, JAX-RS resource classes are <span class="strong"><strong>only*used to configure JAX-RS
                properties. Methods will *not</strong></span> be executed during routing of messages to
        the endpoint. Instead, it is the responsibility of the route to do all
        processing.</p>
    <p>Note that starting from Camel 2.15 it is also sufficient to provide an
        interface only as opposed to a no-op service implementation class for
        the default mode.</p>
    <p>Starting from Camel 2.15, if a <span class="strong"><strong>performInvocation</strong></span> option is
        enabled,
        the service implementation will be invoked first, the response will be
        set on the Camel exchange and the route execution will continue as
        usual. This can be useful for integrating the existing JAX-RS implementations into Camel routes and
        for post-processing JAX-RS Responses in custom processors.</p>
</div>
<div class="section">
    <div class="titlepage">
        <div>
            <div>
                <h2 class="title" style="clear: both"><a
                        name="_how_to_invoke_the_rest_service_through_camel_cxfrs_producer"></a>How to invoke
                    the REST service through camel-cxfrs producer</h2>
            </div>
        </div>
    </div>
    <p>The&nbsp;<a class="link" href="http://cxf.apache.org/docs/jax-rs.html" target="_top">CXF JAXRS front
            end</a>
        implements
        <a class="link" href="http://cxf.apache.org/docs/jax-rs-client-api.html#JAX-RSClientAPI-Proxy-basedAPI"
            target="_top">a
            proxy-based client API</a>, with this API you can invoke the remote REST
        service through a proxy. The&nbsp;<code class="literal">camel-cxfrs</code> producer is based on this
        <a class="link" href="http://cxf.apache.org/docs/jax-rs-client-api.html#JAX-RSClientAPI-Proxy-basedAPI"
            target="_top">proxy
            API</a>.
        You just need to specify the operation name in the message header and
        prepare the parameter in the message body, the camel-cxfrs&nbsp;producer will
        generate right REST request for you.
    </p>
    <p>Here is an example:</p>
    <p>The&nbsp;<a class="link" href="http://cxf.apache.org/docs/jax-rs.html" target="_top">CXF JAXRS front
            end</a> also
        provides
        <a class="link" href="http://cxf.apache.org/docs/jax-rs-client-api.html#JAX-RSClientAPI-CXFWebClientAPI"
            target="_top">a
            http centric client API</a>.&nbsp;You can also invoke this API from
        <code class="literal">camel-cxfrs</code> producer. You need to specify the
        <a class="link"
            href="http://camel.apache.org/maven/current/camel-core/apidocs/org/apache/camel/Exchange.html#HTTP_PATH"
            target="_top">HTTP_PATH</a>
        and
        the&nbsp;<a class="link"
            href="http://camel.apache.org/maven/current/camel-core/apidocs/org/apache/camel/Exchange.html#HTTP_METHOD"
            target="_top">HTTP_METHOD</a>&nbsp;and
        let the&nbsp;producer use the http centric client API by using the URI option
        <span class="strong"><strong>httpClientAPI</strong></span> or by setting the message header
        <a class="link"
            href="http://camel.apache.org/maven/current/camel-cxf/apidocs/org/apache/camel/component/cxf/CxfConstants.html#CAMEL_CXF_RS_USING_HTTP_API"
            target="_top">CxfConstants.CAMEL_CXF_RS_USING_HTTP_API</a>.
        You can turn the response object to the type class specified with the
        message
        header&nbsp;<a class="link"
            href="http://camel.apache.org/maven/current/camel-cxf/apidocs/org/apache/camel/component/cxf/CxfConstants.html#CAMEL_CXF_RS_RESPONSE_CLASS"
            target="_top">CxfConstants.CAMEL_CXF_RS_RESPONSE_CLASS</a>.
    </p>
    <p>From Camel 2.1, we also support to specify the query parameters from
        cxfrs URI for the CXFRS http centric client.</p>
    <p>Error formatting macro: snippet: java.lang.IndexOutOfBoundsException:
        Index: 20, Size: 20</p>
    <p>To support the Dynamical routing, you can override the URI&#8217;s query
        parameters by using the <a class="link"
            href="http://camel.apache.org/maven/current/camel-cxf/apidocs/org/apache/camel/component/cxf/CxfConstants.html#CAMEL_CXF_RS_QUERY_MAP"
            target="_top">CxfConstants.CAMEL_CXF_RS_QUERY_MAP</a>
        header to set the parameter map for it.</p>
</div>
<div class="section">
    <div class="titlepage">
        <div>
            <div>
                <h2 class="title" style="clear: both"><a
                        name="CamelTransportforCXF-WhatstheCamelTransportforCXF"></a>What&#8217;s the Camel
                    Transport for CXF</h2>
            </div>
        </div>
    </div>
    <p>In CXF you offer or consume a webservice by defining its address. The
        first part of the address specifies the protocol to use. For example
        address="http://localhost:9000" in an endpoint configuration means your
        service will be offered using the http protocol on port 9000 of
        localhost. When you integrate Camel Tranport into CXF you get a new
        transport "camel". So you can specify
        address="camel://direct:MyEndpointName" to bind the CXF service address
        to a camel direct endpoint.</p>
    <p>Technically speaking Camel transport for CXF is a component which
        implements the
        <a class="link" href="http://cwiki.apache.org/CXF20DOC/cxf-architecture.html#CXFArchitecture-Transports"
            target="_top">CXF
            transport API</a> with the Camel core library. This allows you to easily
        use Camel&#8217;s routing engine and integration patterns support together
        with your CXF services.
    </p>
</div>
<div class="section">
    <div class="titlepage">
        <div>
            <div>
                <h2 class="title" style="clear: both"><a
                        name="CamelTransportforCXF-IntegrateCamelintoCXFtransportlayer"></a>Integrate Camel into
                    CXF transport layer</h2>
            </div>
        </div>
    </div>
    <div class="toc">
        <p><b>Table of Contents</b></p>
        <dl>
            <dt><span class="section"><a
                        href="cxfrs-component.html#CamelTransportforCXF-SettinguptheCamelTransportinSpring">Setting
                        up the Camel Transport in Spring</a></span></dt>
            <dt><span class="section"><a
                        href="cxfrs-component.html#CamelTransportforCXF-IntegratingtheCamelTransportinaprogrammaticway">Integrating
                        the Camel Transport in a programmatic way</a></span></dt>
        </dl>
    </div>
    <p>To include the Camel Tranport into your CXF bus you use the
        CamelTransportFactory. You can do this in Java as well as in Spring.</p>
    <div class="section">
        <div class="titlepage">
            <div>
                <div>
                    <h3 class="title"><a
                            name="CamelTransportforCXF-SettinguptheCamelTransportinSpring"></a>Setting up the
                        Camel Transport in Spring</h3>
                </div>
            </div>
        </div>
        <p>You can use the following snippet in your applicationcontext if you want
            to configure anything special. If you only want to activate the camel
            transport you do not have to do anything in your application context. As
            soon as you include the camel-cxf-transport jar (or camel-cxf.jar if
            your camel version is less than 2.7.x) in your app, cxf will scan the
            jar and load a CamelTransportFactory for you.</p>
        <pre class="programlisting"><em xmlns="http://www.w3.org/1999/xhtml" class="hl-comment" style="color: silver">&lt;!-- you don't need to specify the CamelTransportFactory configuration as it is auto load by CXF bus --&gt;</em>
<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096">&lt;bean</strong> <span xmlns="http://www.w3.org/1999/xhtml" class="hl-attribute" style="color: #F5844C">class</span>=<span xmlns="http://www.w3.org/1999/xhtml" class="hl-value" style="color: #993300">"org.apache.camel.component.cxf.transport.CamelTransportFactory"</span><strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096">&gt;</strong>
<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096">&lt;property</strong> <span xmlns="http://www.w3.org/1999/xhtml" class="hl-attribute" style="color: #F5844C">name</span>=<span xmlns="http://www.w3.org/1999/xhtml" class="hl-value" style="color: #993300">"bus"</span> <span xmlns="http://www.w3.org/1999/xhtml" class="hl-attribute" style="color: #F5844C">ref</span>=<span xmlns="http://www.w3.org/1999/xhtml" class="hl-value" style="color: #993300">"cxf"</span><strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096"> /&gt;</strong>
<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096">&lt;property</strong> <span xmlns="http://www.w3.org/1999/xhtml" class="hl-attribute" style="color: #F5844C">name</span>=<span xmlns="http://www.w3.org/1999/xhtml" class="hl-value" style="color: #993300">"camelContext"</span> <span xmlns="http://www.w3.org/1999/xhtml" class="hl-attribute" style="color: #F5844C">ref</span>=<span xmlns="http://www.w3.org/1999/xhtml" class="hl-value" style="color: #993300">"camelContext"</span><strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096"> /&gt;</strong>
<em xmlns="http://www.w3.org/1999/xhtml" class="hl-comment" style="color: silver">&lt;!-- checkException new added in Camel 2.1 and Camel 1.6.2 --&gt;</em>
<em xmlns="http://www.w3.org/1999/xhtml" class="hl-comment" style="color: silver">&lt;!-- If checkException is true , CamelDestination will check the outMessage's
exception and set it into camel exchange. You can also override this value
in CamelDestination's configuration. The default value is false.
This option should be set true when you want to leverage the camel's error
handler to deal with fault message --&gt;</em>
<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096">&lt;property</strong> <span xmlns="http://www.w3.org/1999/xhtml" class="hl-attribute" style="color: #F5844C">name</span>=<span xmlns="http://www.w3.org/1999/xhtml" class="hl-value" style="color: #993300">"checkException"</span> <span xmlns="http://www.w3.org/1999/xhtml" class="hl-attribute" style="color: #F5844C">value</span>=<span xmlns="http://www.w3.org/1999/xhtml" class="hl-value" style="color: #993300">"true"</span><strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096"> /&gt;</strong>
<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096">&lt;property</strong> <span xmlns="http://www.w3.org/1999/xhtml" class="hl-attribute" style="color: #F5844C">name</span>=<span xmlns="http://www.w3.org/1999/xhtml" class="hl-value" style="color: #993300">"transportIds"</span><strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096">&gt;</strong>
<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096">&lt;list&gt;</strong>
<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096">&lt;value&gt;</strong>http://cxf.apache.org/transports/camel<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096">&lt;/value&gt;</strong>
<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096">&lt;/list&gt;</strong>
<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096">&lt;/property&gt;</strong>
<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096">&lt;/bean&gt;</strong></pre>
    </div>
    <div class="section">
        <div class="titlepage">
            <div>
                <div>
                    <h3 class="title"><a
                            name="CamelTransportforCXF-IntegratingtheCamelTransportinaprogrammaticway"></a>Integrating
                        the Camel Transport in a programmatic way</h3>
                </div>
            </div>
        </div>
        <p>Camel transport provides a setContext method that you could use to set
            the Camel context into the transport factory. If you want this factory
            take effect, you need to register the factory into the CXF bus. Here is
            a full example for you.</p>
        <pre class="programlisting"><strong xmlns="http://www.w3.org/1999/xhtml" class="hl-keyword">import</strong> org.apache.cxf.Bus;
<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-keyword">import</strong> org.apache.cxf.BusFactory;
<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-keyword">import</strong> org.apache.cxf.transport.ConduitInitiatorManager;
<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-keyword">import</strong> org.apache.cxf.transport.DestinationFactoryManager;
...

BusFactory bf = BusFactory.newInstance();
Bus bus = bf.createBus();
CamelTransportFactory camelTransportFactory = <strong xmlns="http://www.w3.org/1999/xhtml" class="hl-keyword">new</strong> CamelTransportFactory();
<em xmlns="http://www.w3.org/1999/xhtml" class="hl-comment" style="color: silver">// set up the CamelContext which will be use by the CamelTransportFactory</em>
camelTransportFactory.setCamelContext(context)
<em xmlns="http://www.w3.org/1999/xhtml" class="hl-comment" style="color: silver">// if you are using CXF higher then 2.4.x the</em>
camelTransportFactory.setBus(bus);

<em xmlns="http://www.w3.org/1999/xhtml" class="hl-comment" style="color: silver">// if you are lower CXF, you need to register the ConduitInitiatorManager and DestinationFactoryManager like below</em>
<em xmlns="http://www.w3.org/1999/xhtml" class="hl-comment" style="color: silver">// register the conduit initiator</em>
ConduitInitiatorManager cim = bus.getExtension(ConduitInitiatorManager.<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-keyword">class</strong>);
cim.registerConduitInitiator(CamelTransportFactory.TRANSPORT_ID, camelTransportFactory);
<em xmlns="http://www.w3.org/1999/xhtml" class="hl-comment" style="color: silver">// register the destination factory</em>
DestinationFactoryManager dfm = bus.getExtension(DestinationFactoryManager.<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-keyword">class</strong>);
dfm.registerDestinationFactory(CamelTransportFactory.TRANSPORT_ID, camelTransportFactory);
<em xmlns="http://www.w3.org/1999/xhtml" class="hl-comment" style="color: silver">// set or bus as the default bus for cxf</em>
BusFactory.setDefaultBus(bus);</pre>
    </div>
</div>
<div class="section">
    <div class="titlepage">
        <div>
            <div>
                <h2 class="title" style="clear: both"><a
                        name="CamelTransportforCXF-ConfigurethedestinationandconduitwithSpring"></a>Configure
                    the destination and conduit with Spring</h2>
            </div>
        </div>
    </div>
    <div class="toc">
        <p><b>Table of Contents</b></p>
        <dl>
            <dt><span class="section"><a
                        href="cxfrs-component.html#CamelTransportforCXF-Namespace">Namespace</a></span></dt>
            <dt><span class="section"><a
                        href="cxfrs-component.html#CamelTransportforCXF-Thedestinationelement">The <code
                            class="literal">destination</code> element</a></span></dt>
            <dt><span class="section"><a href="cxfrs-component.html#CamelTransportforCXF-Theconduitelement">The
                        <code class="literal">conduit</code> element</a></span></dt>
        </dl>
    </div>
    <div class="section">
        <div class="titlepage">
            <div>
                <div>
                    <h3 class="title"><a name="CamelTransportforCXF-Namespace"></a>Namespace</h3>
                </div>
            </div>
        </div>
        <p>The elements used to configure an Camel transport endpoint are defined
            in the namespace <code
                class="literal"><a class="link" href="http://cxf.apache.org/transports/camel" target="_top">http://cxf.apache.org/transports/camel</a></code>.
            It is
            commonly referred to using the prefix <code class="literal">camel</code>. In order to use the Camel
            transport configuration elements, you will need to add the lines shown
            below to the beans element of your endpoint&#8217;s configuration file. In
            addition, you will need to add the configuration elements' namespace to
            the <code class="literal">xsi:schemaLocation</code> attribute.</p>
        <p><span class="strong"><strong>Adding the Configuration Namespace</strong></span></p>
        <pre class="programlisting">&lt;beans ...
xmlns:camel=<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-string"><em style="color:red">"http://cxf.apache.org/transports/camel
</em></strong>       ...
xsi:schemaLocation=<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-string"><em style="color:red">"...
</em></strong>                           http:<em xmlns="http://www.w3.org/1999/xhtml" class="hl-comment" style="color: silver">//cxf.apache.org/transports/camel</em>
                 http:<em xmlns="http://www.w3.org/1999/xhtml" class="hl-comment" style="color: silver">//cxf.apache.org/transports/camel.xsd</em>
                ...&gt;</pre>
    </div>
    <div class="section">
        <div class="titlepage">
            <div>
                <div>
                    <h3 class="title"><a name="CamelTransportforCXF-Thedestinationelement"></a>The <code
                            class="literal">destination</code> element</h3>
                </div>
            </div>
        </div>
        <p>You configure an Camel transport server endpoint using the
            <code class="literal">camel:destination</code> element and its children. The <code
                class="literal">camel:destination</code>
            element takes a single attribute, <code class="literal">name</code>, that specifies the WSDL port
            element that corresponds to the endpoint. The value for the <code class="literal">name</code>
            attribute takes the form <span class="emphasis"><em>portQName</em></span>.camel-destination. The
            example
            below shows the <code class="literal">camel:destination</code> element that would be used to add
            configuration for an endpoint that was specified by the WSDL fragment
            <code class="literal">&lt;port binding="widgetSOAPBinding" name="widgetSOAPPort"&gt;</code> if the
            endpoint&#8217;s target namespace was <code
                class="literal"><a class="link" href="http://widgets.widgetvendor.net" target="_top">http://widgets.widgetvendor.net</a></code>.
        </p>
        <p><span class="strong"><strong>camel:destination Element</strong></span></p>
        <pre class="programlisting">...
&lt;camel:destination name=<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-string"><em style="color:red">"{http://widgets/widgetvendor.net}widgetSOAPPort.http-destination&gt;
</em></strong>    &lt;camelContext id=<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-string"><em style="color:red">"context"</em></strong> xmlns=<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-string"><em style="color:red">"http://activemq.apache.org/camel/schema/spring"</em></strong>&gt;
&lt;route&gt;
 &lt;from uri=<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-string"><em style="color:red">"direct:EndpointC"</em></strong> /&gt;
 &lt;to uri=<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-string"><em style="color:red">"direct:EndpointD"</em></strong> /&gt;
&lt;/route&gt;
&lt;/camelContext&gt;
&lt;/camel:destination&gt;

&lt;!-- <strong xmlns="http://www.w3.org/1999/xhtml" class="hl-keyword">new</strong> added feature since Camel <span xmlns="http://www.w3.org/1999/xhtml" class="hl-number">2.11</span>.x
&lt;camel:destination name=<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-string"><em style="color:red">"{http://widgets/widgetvendor.net}widgetSOAPPort.camel-destination"</em></strong> camelContextId=<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-string"><em style="color:red">"context"</em></strong> /&gt;

...</pre>
        <p>The <code class="literal">camel:destination</code> element for Spring has a number of child
            elements that specify configuration information. They are described
            below.</p>
        <p>Element</p>
        <p>Description</p>
        <p><code class="literal">camel-spring:camelContext</code></p>
        <p>You can specify the camel context in the camel destination</p>
        <p><code class="literal">camel:camelContextRef</code></p>
        <p>The camel context id which you want inject into the camel destination</p>
    </div>
    <div class="section">
        <div class="titlepage">
            <div>
                <div>
                    <h3 class="title"><a name="CamelTransportforCXF-Theconduitelement"></a>The <code
                            class="literal">conduit</code> element</h3>
                </div>
            </div>
        </div>
        <p>You configure a Camel transport client using the <code class="literal">camel:conduit</code> element
            and its children. The <code class="literal">camel:conduit</code> element takes a single attribute,
            <code class="literal">name</code>, that specifies the WSDL port element that corresponds to the
            endpoint. The value for the <code class="literal">name</code> attribute takes the form
            <span class="emphasis"><em>portQName</em></span>.camel-conduit. For example, the code below shows
            the
            <code class="literal">camel:conduit</code> element that would be used to add configuration for an
            endpoint that was specified by the WSDL fragment
            <code class="literal">&lt;port binding="widgetSOAPBinding" name="widgetSOAPPort"&gt;</code> if the
            endpoint&#8217;s target namespace was <code
                class="literal"><a class="link" href="http://widgets.widgetvendor.net" target="_top">http://widgets.widgetvendor.net</a></code>.
        </p>
        <p><span class="strong"><strong>http-conf:conduit Element</strong></span></p>
        <pre class="programlisting">...
<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096">&lt;camelContext</strong> <span xmlns="http://www.w3.org/1999/xhtml" class="hl-attribute" style="color: #F5844C">id</span>=<span xmlns="http://www.w3.org/1999/xhtml" class="hl-value" style="color: #993300">"conduit_context"</span> <span xmlns="http://www.w3.org/1999/xhtml" class="hl-attribute" style="color: #F5844C">xmlns</span>=<span xmlns="http://www.w3.org/1999/xhtml" class="hl-value" style="color: #993300">"http://activemq.apache.org/camel/schema/spring"</span><strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096">&gt;</strong>
<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096">&lt;route&gt;</strong>
 <strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096">&lt;from</strong> <span xmlns="http://www.w3.org/1999/xhtml" class="hl-attribute" style="color: #F5844C">uri</span>=<span xmlns="http://www.w3.org/1999/xhtml" class="hl-value" style="color: #993300">"direct:EndpointA"</span><strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096"> /&gt;</strong>
 <strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096">&lt;to</strong> <span xmlns="http://www.w3.org/1999/xhtml" class="hl-attribute" style="color: #F5844C">uri</span>=<span xmlns="http://www.w3.org/1999/xhtml" class="hl-value" style="color: #993300">"direct:EndpointB"</span><strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096"> /&gt;</strong>
<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096">&lt;/route&gt;</strong>
<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096">&lt;/camelContext&gt;</strong>

<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096">&lt;camel:conduit</strong> <span xmlns="http://www.w3.org/1999/xhtml" class="hl-attribute" style="color: #F5844C">name</span>=<span xmlns="http://www.w3.org/1999/xhtml" class="hl-value" style="color: #993300">"{http://widgets/widgetvendor.net}widgetSOAPPort.camel-conduit"</span><strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096">&gt;</strong>
<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096">&lt;camel:camelContextRef&gt;</strong>conduit_context<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096">&lt;/camel:camelContextRef&gt;</strong>
<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096">&lt;/camel:conduit&gt;</strong>

<em xmlns="http://www.w3.org/1999/xhtml" class="hl-comment" style="color: silver">&lt;!-- new added feature since Camel 2.11.x
&lt;camel:conduit name="{http://widgets/widgetvendor.net}widgetSOAPPort.camel-conduit" camelContextId="conduit_context" /&gt;


&lt;camel:conduit name="*.camel-conduit"&gt;
&lt;!-- you can also using the wild card to specify the camel-conduit that you want to configure --&gt;</em>
...
<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-tag" style="color: #000096">&lt;/camel:conduit&gt;</strong>
...</pre>
        <p>The <code class="literal">camel:conduit</code> element has a number of child elements that specify
            configuration information. They are described below.</p>
        <p>Element</p>
        <p>Description</p>
        <p><code class="literal">camel-spring:camelContext</code></p>
        <p>You can specify the camel context in the camel conduit</p>
        <p><code class="literal">camel:camelContextRef</code></p>
        <p>The camel context id which you want inject into the camel conduit</p>
    </div>
</div>
<div class="section">
    <div class="titlepage">
        <div>
            <div>
                <h2 class="title" style="clear: both"><a
                        name="CamelTransportforCXF-ConfigurethedestinationandconduitwithBlueprint"></a>Configure
                    the destination and conduit with Blueprint</h2>
            </div>
        </div>
    </div>
    <p>From <span class="strong"><strong>Camel 2.11.x</strong></span>, Camel Transport supports to be configured
        with
        Blueprint.</p>
    <p>If you are using blueprint, you should use the the namespace
        <code
            class="literal"><a class="link" href="http://cxf.apache.org/transports/camel/blueprint" target="_top">http://cxf.apache.org/transports/camel/blueprint</a></code>
        and import the schema
        like the blow.
    </p>
    <p><span class="strong"><strong>Adding the Configuration Namespace for blueprint</strong></span></p>
    <pre class="programlisting">&lt;beans ...
xmlns:camel=<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-string"><em style="color:red">"http://cxf.apache.org/transports/camel/blueprint"</em></strong>
...
xsi:schemaLocation=<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-string"><em style="color:red">"...
</em></strong>                           http:<em xmlns="http://www.w3.org/1999/xhtml" class="hl-comment" style="color: silver">//cxf.apache.org/transports/camel/blueprint</em>
                 http:<em xmlns="http://www.w3.org/1999/xhtml" class="hl-comment" style="color: silver">//cxf.apache.org/schmemas/blueprint/camel.xsd</em>
                ...&gt;</pre>
    <p>In blueprint <code class="literal">camel:conduit</code> <code class="literal">camel:destination</code>
        only has one
        camelContextId attribute, they doesn&#8217;t support to specify the camel
        context in the camel destination.</p>
    <pre
        class="programlisting">  &lt;camel:conduit id=<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-string"><em style="color:red">"*.camel-conduit"</em></strong> camelContextId=<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-string"><em style="color:red">"camel1"</em></strong> /&gt;
&lt;camel:destination id=<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-string"><em style="color:red">"*.camel-destination"</em></strong> camelContextId=<strong xmlns="http://www.w3.org/1999/xhtml" class="hl-string"><em style="color:red">"camel1"</em></strong> /&gt;</pre>
</div>
<div class="section">
    <div class="titlepage">
        <div>
            <div>
                <h2 class="title" style="clear: both"><a
                        name="CamelTransportforCXF-ExampleUsingCamelasaloadbalancerforCXF"></a>Example Using
                    Camel as a load balancer for CXF</h2>
            </div>
        </div>
    </div>
    <p>This example shows how to use the camel load balancing feature in CXF.
        You need to load the configuration file in CXF and publish the endpoints
        on the address "camel://direct:EndpointA" and "camel://direct:EndpointB"</p>
</div>
<div class="section">
    <div class="titlepage">
        <div>
            <div>
                <h2 class="title" style="clear: both"><a
                        name="CamelTransportforCXF-CompleteHowtoandExampleforattachingCameltoCXF"></a>Complete
                    Howto and Example for attaching Camel to CXF</h2>
            </div>
        </div>
    </div>
    <p><a class="link" href="better-jms-transport-for-cxf-webservice-using-apache-camel.html"
            target="_top">Better
            JMS Transport for CXF Webservice using Apache Camel</a>&nbsp;</p>
</div>
</div>`;
export default CXFRS;
